-- +-------------------------------------------------+
-- © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
-- +-------------------------------------------------+
-- $Id: biblizen.sql,v 1.27 2015-05-18 09:25:37 dgoron Exp $

-- MySQL dump 10.17  Distrib 10.3.25-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: bibli
-- ------------------------------------------------------
-- Server version	10.3.25-MariaDB-0ubuntu0.20.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `abo_liste_lecture`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE abo_liste_lecture (
  num_empr int(8) unsigned NOT NULL DEFAULT 0,
  num_liste int(8) unsigned NOT NULL DEFAULT 0,
  etat int(1) unsigned NOT NULL DEFAULT 0,
  commentaire text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (num_empr,num_liste)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abo_liste_lecture`
--

LOCK TABLES abo_liste_lecture WRITE;
/*!40000 ALTER TABLE abo_liste_lecture DISABLE KEYS */;
/*!40000 ALTER TABLE abo_liste_lecture ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `abts_abts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE abts_abts (
  abt_id int(10) unsigned NOT NULL AUTO_INCREMENT,
  abt_name varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  abt_name_opac varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  base_modele_name varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  base_modele_id int(11) NOT NULL DEFAULT 0,
  num_notice int(11) NOT NULL DEFAULT 0,
  date_debut date NOT NULL DEFAULT '0000-00-00',
  date_fin date NOT NULL DEFAULT '0000-00-00',
  fournisseur int(11) NOT NULL DEFAULT 0,
  destinataire varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  cote varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  typdoc_id int(11) NOT NULL DEFAULT 0,
  exemp_auto int(11) NOT NULL DEFAULT 0,
  location_id int(11) NOT NULL DEFAULT 0,
  section_id int(11) NOT NULL DEFAULT 0,
  lender_id int(11) NOT NULL DEFAULT 0,
  statut_id int(11) NOT NULL DEFAULT 0,
  codestat_id int(11) NOT NULL DEFAULT 0,
  type_antivol int(11) NOT NULL DEFAULT 0,
  duree_abonnement int(11) NOT NULL DEFAULT 0,
  abt_numeric int(1) NOT NULL DEFAULT 0,
  prix varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  abt_status int(1) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (abt_id),
  KEY index_num_notice (num_notice),
  KEY i_date_fin (date_fin)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abts_abts`
--

LOCK TABLES abts_abts WRITE;
/*!40000 ALTER TABLE abts_abts DISABLE KEYS */;
/*!40000 ALTER TABLE abts_abts ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `abts_abts_modeles`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE abts_abts_modeles (
  modele_id int(11) NOT NULL DEFAULT 0,
  abt_id int(11) NOT NULL DEFAULT 0,
  num int(11) NOT NULL DEFAULT 0,
  vol int(11) NOT NULL DEFAULT 0,
  tome int(11) NOT NULL DEFAULT 0,
  delais int(11) NOT NULL DEFAULT 0,
  critique int(11) NOT NULL DEFAULT 0,
  num_statut_general smallint(5) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (modele_id,abt_id)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abts_abts_modeles`
--

LOCK TABLES abts_abts_modeles WRITE;
/*!40000 ALTER TABLE abts_abts_modeles DISABLE KEYS */;
/*!40000 ALTER TABLE abts_abts_modeles ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `abts_grille_abt`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE abts_grille_abt (
  id_bull int(11) NOT NULL AUTO_INCREMENT,
  num_abt int(10) unsigned NOT NULL DEFAULT 0,
  date_parution date NOT NULL DEFAULT '0000-00-00',
  modele_id int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  nombre int(11) NOT NULL DEFAULT 0,
  numero int(11) NOT NULL DEFAULT 0,
  ordre int(11) NOT NULL DEFAULT 0,
  state int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (id_bull),
  KEY num_abt (num_abt)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abts_grille_abt`
--

LOCK TABLES abts_grille_abt WRITE;
/*!40000 ALTER TABLE abts_grille_abt DISABLE KEYS */;
/*!40000 ALTER TABLE abts_grille_abt ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `abts_grille_modele`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE abts_grille_modele (
  num_modele int(10) unsigned NOT NULL DEFAULT 0,
  date_parution date NOT NULL DEFAULT '0000-00-00',
  type_serie int(11) NOT NULL DEFAULT 0,
  numero varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  nombre_recu int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (num_modele,date_parution,type_serie),
  KEY num_modele (num_modele)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abts_grille_modele`
--

LOCK TABLES abts_grille_modele WRITE;
/*!40000 ALTER TABLE abts_grille_modele DISABLE KEYS */;
/*!40000 ALTER TABLE abts_grille_modele ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `abts_modeles`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE abts_modeles (
  modele_id int(10) unsigned NOT NULL AUTO_INCREMENT,
  modele_name varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  num_notice int(10) unsigned NOT NULL DEFAULT 0,
  num_periodicite int(10) unsigned NOT NULL DEFAULT 0,
  duree_abonnement int(11) NOT NULL DEFAULT 0,
  date_debut date DEFAULT NULL,
  date_fin date DEFAULT NULL,
  days varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1111111',
  day_month varchar(31) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1111111111111111111111111111111',
  week_month varchar(6) COLLATE utf8_unicode_ci NOT NULL DEFAULT '111111',
  week_year varchar(54) COLLATE utf8_unicode_ci NOT NULL DEFAULT '111111111111111111111111111111111111111111111111111111',
  month_year varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT '111111111111',
  num_cycle int(11) NOT NULL DEFAULT 0,
  num_combien int(11) NOT NULL DEFAULT 0,
  num_increment int(11) NOT NULL DEFAULT 0,
  num_date_unite int(11) NOT NULL DEFAULT 0,
  num_increment_date int(11) NOT NULL DEFAULT 0,
  num_depart int(11) NOT NULL DEFAULT 0,
  vol_actif int(11) NOT NULL DEFAULT 0,
  vol_increment int(11) NOT NULL DEFAULT 0,
  vol_date_unite int(11) NOT NULL DEFAULT 0,
  vol_increment_numero int(11) NOT NULL DEFAULT 0,
  vol_increment_date int(11) NOT NULL DEFAULT 0,
  vol_cycle int(11) NOT NULL DEFAULT 0,
  vol_combien int(11) NOT NULL DEFAULT 0,
  vol_depart int(11) NOT NULL DEFAULT 0,
  tom_actif int(11) NOT NULL DEFAULT 0,
  tom_increment int(11) NOT NULL DEFAULT 0,
  tom_date_unite int(11) NOT NULL DEFAULT 0,
  tom_increment_numero int(11) NOT NULL DEFAULT 0,
  tom_increment_date int(11) NOT NULL DEFAULT 0,
  tom_cycle int(11) NOT NULL DEFAULT 0,
  tom_combien int(11) NOT NULL DEFAULT 0,
  tom_depart int(11) NOT NULL DEFAULT 0,
  format_aff varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  format_periode varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (modele_id),
  KEY num_notice (num_notice),
  KEY num_periodicite (num_periodicite)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abts_modeles`
--

LOCK TABLES abts_modeles WRITE;
/*!40000 ALTER TABLE abts_modeles DISABLE KEYS */;
/*!40000 ALTER TABLE abts_modeles ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `abts_periodicites`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE abts_periodicites (
  periodicite_id int(10) unsigned NOT NULL AUTO_INCREMENT,
  libelle varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  duree int(11) NOT NULL DEFAULT 0,
  unite int(11) NOT NULL DEFAULT 0,
  retard_periodicite int(4) DEFAULT 0,
  seuil_periodicite int(4) DEFAULT 0,
  consultation_duration int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (periodicite_id)
) AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abts_periodicites`
--

LOCK TABLES abts_periodicites WRITE;
/*!40000 ALTER TABLE abts_periodicites DISABLE KEYS */;
INSERT INTO abts_periodicites (periodicite_id, libelle, duree, unite, retard_periodicite, seuil_periodicite, consultation_duration) VALUES (1,'Mensuel',1,1,7,4,0);
INSERT INTO abts_periodicites (periodicite_id, libelle, duree, unite, retard_periodicite, seuil_periodicite, consultation_duration) VALUES (2,'Hebdomadaire',7,0,4,2,0);
INSERT INTO abts_periodicites (periodicite_id, libelle, duree, unite, retard_periodicite, seuil_periodicite, consultation_duration) VALUES (3,'Quotidien',1,0,3,1,0);
INSERT INTO abts_periodicites (periodicite_id, libelle, duree, unite, retard_periodicite, seuil_periodicite, consultation_duration) VALUES (4,'Trimestriel',3,1,30,15,0);
INSERT INTO abts_periodicites (periodicite_id, libelle, duree, unite, retard_periodicite, seuil_periodicite, consultation_duration) VALUES (5,'Bimestriel',2,1,30,15,0);
INSERT INTO abts_periodicites (periodicite_id, libelle, duree, unite, retard_periodicite, seuil_periodicite, consultation_duration) VALUES (6,'Annuel',1,2,365,180,0);
INSERT INTO abts_periodicites (periodicite_id, libelle, duree, unite, retard_periodicite, seuil_periodicite, consultation_duration) VALUES (7,'Quinzomadaire',14,0,14,7,0);
INSERT INTO abts_periodicites (periodicite_id, libelle, duree, unite, retard_periodicite, seuil_periodicite, consultation_duration) VALUES (8,'Semestriel',6,1,180,60,0);
/*!40000 ALTER TABLE abts_periodicites ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `abts_status`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE abts_status (
  abts_status_id int(10) unsigned NOT NULL AUTO_INCREMENT,
  abts_status_gestion_libelle varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  abts_status_opac_libelle varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  abts_status_class_html varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  abts_status_bulletinage_active tinyint(1) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (abts_status_id)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abts_status`
--

LOCK TABLES abts_status WRITE;
/*!40000 ALTER TABLE abts_status DISABLE KEYS */;
INSERT INTO abts_status (abts_status_id, abts_status_gestion_libelle, abts_status_opac_libelle, abts_status_class_html, abts_status_bulletinage_active) VALUES (1,'Statut par défaut','Statut par défaut','statutnot1',1);
/*!40000 ALTER TABLE abts_status ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acces_profiles`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE acces_profiles (
  prf_id int(2) unsigned NOT NULL AUTO_INCREMENT,
  prf_type int(1) unsigned NOT NULL DEFAULT 1,
  prf_name varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  prf_rule blob NOT NULL,
  prf_hrule text COLLATE utf8_unicode_ci NOT NULL,
  prf_used int(2) unsigned NOT NULL DEFAULT 0,
  dom_num int(2) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (prf_id),
  KEY prf_type (prf_type),
  KEY prf_name (prf_name),
  KEY dom_num (dom_num)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acces_profiles`
--

LOCK TABLES acces_profiles WRITE;
/*!40000 ALTER TABLE acces_profiles DISABLE KEYS */;
/*!40000 ALTER TABLE acces_profiles ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acces_rights`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE acces_rights (
  dom_num int(2) unsigned NOT NULL DEFAULT 0,
  usr_prf_num int(2) unsigned NOT NULL DEFAULT 0,
  res_prf_num int(2) unsigned NOT NULL DEFAULT 0,
  dom_rights int(2) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (dom_num,usr_prf_num,res_prf_num),
  KEY dom_num (dom_num),
  KEY usr_prf_num (usr_prf_num),
  KEY res_prf_num (res_prf_num)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acces_rights`
--

LOCK TABLES acces_rights WRITE;
/*!40000 ALTER TABLE acces_rights DISABLE KEYS */;
/*!40000 ALTER TABLE acces_rights ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE actes (
  id_acte int(8) unsigned NOT NULL AUTO_INCREMENT,
  date_acte date NOT NULL DEFAULT '0000-00-00',
  numero varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  type_acte int(3) unsigned NOT NULL DEFAULT 0,
  statut int(3) unsigned NOT NULL DEFAULT 0,
  date_paiement date NOT NULL DEFAULT '0000-00-00',
  num_paiement varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  num_entite int(5) unsigned NOT NULL DEFAULT 0,
  num_fournisseur int(5) unsigned NOT NULL DEFAULT 0,
  num_contact_livr int(8) unsigned NOT NULL DEFAULT 0,
  num_contact_fact int(8) unsigned NOT NULL DEFAULT 0,
  num_exercice int(8) unsigned NOT NULL DEFAULT 0,
  commentaires text COLLATE utf8_unicode_ci NOT NULL,
  reference varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  index_acte text COLLATE utf8_unicode_ci NOT NULL,
  devise varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  commentaires_i text COLLATE utf8_unicode_ci NOT NULL,
  date_valid date NOT NULL DEFAULT '0000-00-00',
  date_ech date NOT NULL DEFAULT '0000-00-00',
  nom_acte varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (id_acte),
  KEY num_fournisseur (num_fournisseur),
  KEY `date` (date_acte),
  KEY num_entite (num_entite),
  KEY numero (numero)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actes`
--

LOCK TABLES actes WRITE;
/*!40000 ALTER TABLE actes DISABLE KEYS */;
/*!40000 ALTER TABLE actes ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_session`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE admin_session (
  userid int(10) unsigned NOT NULL DEFAULT 0,
  `session` mediumblob DEFAULT NULL,
  PRIMARY KEY (userid)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_session`
--

LOCK TABLES admin_session WRITE;
/*!40000 ALTER TABLE admin_session DISABLE KEYS */;
/*!40000 ALTER TABLE admin_session ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `analysis`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE analysis (
  analysis_bulletin int(8) unsigned NOT NULL DEFAULT 0,
  analysis_notice int(8) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (analysis_bulletin,analysis_notice),
  KEY analysis_notice (analysis_notice)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `analysis`
--

LOCK TABLES analysis WRITE;
/*!40000 ALTER TABLE analysis DISABLE KEYS */;
INSERT INTO analysis (analysis_bulletin, analysis_notice) VALUES (7,125);
INSERT INTO analysis (analysis_bulletin, analysis_notice) VALUES (7,126);
INSERT INTO analysis (analysis_bulletin, analysis_notice) VALUES (8,127);
INSERT INTO analysis (analysis_bulletin, analysis_notice) VALUES (11,133);
/*!40000 ALTER TABLE analysis ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_animation_categories`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_animation_categories (
  num_animation int(11) NOT NULL,
  num_noeud int(11) NOT NULL,
  ordre_categorie int(11) DEFAULT NULL,
  PRIMARY KEY (num_animation,num_noeud)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_animation_categories`
--

LOCK TABLES anim_animation_categories WRITE;
/*!40000 ALTER TABLE anim_animation_categories DISABLE KEYS */;
/*!40000 ALTER TABLE anim_animation_categories ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_animation_custom`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_animation_custom (
  idchamp int(11) NOT NULL AUTO_INCREMENT,
  num_type int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  titre varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  datatype varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `options` text COLLATE utf8_unicode_ci DEFAULT NULL,
  multiple int(11) NOT NULL DEFAULT 0,
  obligatoire int(11) NOT NULL DEFAULT 0,
  ordre int(11) DEFAULT NULL,
  search int(1) unsigned NOT NULL DEFAULT 0,
  `export` int(1) unsigned NOT NULL DEFAULT 0,
  exclusion_obligatoire int(1) unsigned NOT NULL DEFAULT 0,
  pond int(11) NOT NULL DEFAULT 100,
  opac_sort int(11) NOT NULL DEFAULT 0,
  `comment` blob NOT NULL DEFAULT '',
  filters int(1) NOT NULL DEFAULT 0,
  custom_classement varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (idchamp)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_animation_custom`
--

LOCK TABLES anim_animation_custom WRITE;
/*!40000 ALTER TABLE anim_animation_custom DISABLE KEYS */;
/*!40000 ALTER TABLE anim_animation_custom ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_animation_custom_dates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_animation_custom_dates (
  anim_animation_custom_champ int(10) unsigned NOT NULL DEFAULT 0,
  anim_animation_custom_origine int(10) unsigned NOT NULL DEFAULT 0,
  anim_animation_custom_date_type int(11) DEFAULT NULL,
  anim_animation_custom_date_start int(11) NOT NULL DEFAULT 0,
  anim_animation_custom_date_end int(11) NOT NULL DEFAULT 0,
  anim_animation_custom_order int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (anim_animation_custom_champ,anim_animation_custom_origine,anim_animation_custom_order),
  KEY anim_animation_custom_champ (anim_animation_custom_champ),
  KEY anim_animation_custom_origine (anim_animation_custom_origine)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_animation_custom_dates`
--

LOCK TABLES anim_animation_custom_dates WRITE;
/*!40000 ALTER TABLE anim_animation_custom_dates DISABLE KEYS */;
/*!40000 ALTER TABLE anim_animation_custom_dates ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_animation_custom_lists`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_animation_custom_lists (
  anim_animation_custom_champ int(10) unsigned NOT NULL DEFAULT 0,
  anim_animation_custom_list_value varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  anim_animation_custom_list_lib varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  ordre int(11) DEFAULT NULL,
  KEY editorial_custom_champ (anim_animation_custom_champ),
  KEY editorial_champ_list_value (anim_animation_custom_champ,anim_animation_custom_list_value)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_animation_custom_lists`
--

LOCK TABLES anim_animation_custom_lists WRITE;
/*!40000 ALTER TABLE anim_animation_custom_lists DISABLE KEYS */;
/*!40000 ALTER TABLE anim_animation_custom_lists ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_animation_custom_values`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_animation_custom_values (
  anim_animation_custom_champ int(10) unsigned NOT NULL DEFAULT 0,
  anim_animation_custom_origine int(10) unsigned NOT NULL DEFAULT 0,
  anim_animation_custom_small_text varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  anim_animation_custom_text text COLLATE utf8_unicode_ci DEFAULT NULL,
  anim_animation_custom_integer int(11) DEFAULT NULL,
  anim_animation_custom_date date DEFAULT NULL,
  anim_animation_custom_float float DEFAULT NULL,
  anim_animation_custom_order int(11) NOT NULL DEFAULT 0,
  KEY anim_animation_custom_champ (anim_animation_custom_champ),
  KEY anim_animation_custom_origine (anim_animation_custom_origine),
  KEY i_encv_st (anim_animation_custom_small_text),
  KEY i_encv_t (anim_animation_custom_text(255)),
  KEY i_encv_i (anim_animation_custom_integer),
  KEY i_encv_d (anim_animation_custom_date),
  KEY i_encv_f (anim_animation_custom_float)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_animation_custom_values`
--

LOCK TABLES anim_animation_custom_values WRITE;
/*!40000 ALTER TABLE anim_animation_custom_values DISABLE KEYS */;
/*!40000 ALTER TABLE anim_animation_custom_values ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_animation_locations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_animation_locations (
  num_animation int(11) NOT NULL,
  num_location int(11) NOT NULL,
  PRIMARY KEY (num_animation,num_location)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_animation_locations`
--

LOCK TABLES anim_animation_locations WRITE;
/*!40000 ALTER TABLE anim_animation_locations DISABLE KEYS */;
/*!40000 ALTER TABLE anim_animation_locations ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_animations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_animations (
  id_animation int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `comment` text COLLATE utf8_unicode_ci DEFAULT NULL,
  description text COLLATE utf8_unicode_ci DEFAULT NULL,
  global_quota int(11) DEFAULT NULL,
  internet_quota int(11) DEFAULT NULL,
  num_status int(11) DEFAULT NULL,
  num_event int(11) DEFAULT NULL,
  num_parent int(11) DEFAULT NULL,
  expiration_delay int(11) DEFAULT NULL,
  registration_required tinyint(1) DEFAULT NULL,
  auto_registration tinyint(1) DEFAULT NULL,
  allow_waiting_list tinyint(1) DEFAULT NULL,
  num_cart int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (id_animation)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_animations`
--

LOCK TABLES anim_animations WRITE;
/*!40000 ALTER TABLE anim_animations DISABLE KEYS */;
/*!40000 ALTER TABLE anim_animations ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_events`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_events (
  id_event int(11) NOT NULL AUTO_INCREMENT,
  start_date datetime DEFAULT NULL,
  end_date datetime DEFAULT NULL,
  num_config int(11) DEFAULT NULL,
  PRIMARY KEY (id_event)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_events`
--

LOCK TABLES anim_events WRITE;
/*!40000 ALTER TABLE anim_events DISABLE KEYS */;
/*!40000 ALTER TABLE anim_events ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_mailing_list`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_mailing_list (
  id_mailing_list int(11) NOT NULL AUTO_INCREMENT,
  send_at datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  num_animation int(1) NOT NULL DEFAULT 0,
  auto_send int(1) NOT NULL DEFAULT 0,
  nb_success_mails int(11) NOT NULL DEFAULT 0,
  nb_error_mails int(11) NOT NULL DEFAULT 0,
  mailing_content blob NOT NULL,
  response_content blob NOT NULL,
  num_user int(11) NOT NULL DEFAULT 0,
  num_campaign int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (id_mailing_list)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_mailing_list`
--

LOCK TABLES anim_mailing_list WRITE;
/*!40000 ALTER TABLE anim_mailing_list DISABLE KEYS */;
/*!40000 ALTER TABLE anim_mailing_list ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_mailing_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_mailing_types (
  id_mailing_type int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  delay int(11) DEFAULT 0,
  periodicity int(1) DEFAULT 0,
  auto_send int(1) DEFAULT 0,
  num_template int(11) NOT NULL DEFAULT 0,
  campaign int(1) NOT NULL DEFAULT 0,
  num_sender int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (id_mailing_type)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_mailing_types`
--

LOCK TABLES anim_mailing_types WRITE;
/*!40000 ALTER TABLE anim_mailing_types DISABLE KEYS */;
/*!40000 ALTER TABLE anim_mailing_types ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_mailings`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_mailings (
  id_mailing int(11) NOT NULL AUTO_INCREMENT,
  num_animation int(11) NOT NULL DEFAULT 0,
  num_mailing_type int(11) NOT NULL DEFAULT 0,
  already_mail int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (id_mailing)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_mailings`
--

LOCK TABLES anim_mailings WRITE;
/*!40000 ALTER TABLE anim_mailings DISABLE KEYS */;
/*!40000 ALTER TABLE anim_mailings ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_price_type_categories`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_price_type_categories (
  num_price_type int(11) NOT NULL,
  num_noeud int(11) NOT NULL,
  ordre_categorie int(11) DEFAULT NULL,
  PRIMARY KEY (num_price_type,num_noeud)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_price_type_categories`
--

LOCK TABLES anim_price_type_categories WRITE;
/*!40000 ALTER TABLE anim_price_type_categories DISABLE KEYS */;
/*!40000 ALTER TABLE anim_price_type_categories ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_price_type_custom`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_price_type_custom (
  idchamp int(11) NOT NULL AUTO_INCREMENT,
  num_type int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  titre varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  datatype varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `options` text COLLATE utf8_unicode_ci DEFAULT NULL,
  multiple int(11) NOT NULL DEFAULT 0,
  obligatoire int(11) NOT NULL DEFAULT 0,
  ordre int(11) DEFAULT NULL,
  search int(1) unsigned NOT NULL DEFAULT 0,
  `export` int(1) unsigned NOT NULL DEFAULT 0,
  exclusion_obligatoire int(1) unsigned NOT NULL DEFAULT 0,
  pond int(11) NOT NULL DEFAULT 100,
  opac_sort int(11) NOT NULL DEFAULT 0,
  `comment` blob NOT NULL DEFAULT '',
  filters int(1) NOT NULL DEFAULT 0,
  custom_classement varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (idchamp)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_price_type_custom`
--

LOCK TABLES anim_price_type_custom WRITE;
/*!40000 ALTER TABLE anim_price_type_custom DISABLE KEYS */;
/*!40000 ALTER TABLE anim_price_type_custom ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_price_type_custom_dates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_price_type_custom_dates (
  anim_price_type_custom_champ int(10) unsigned NOT NULL DEFAULT 0,
  anim_price_type_custom_origine int(10) unsigned NOT NULL DEFAULT 0,
  anim_price_type_custom_date_type int(11) DEFAULT NULL,
  anim_price_type_custom_date_start int(11) NOT NULL DEFAULT 0,
  anim_price_type_custom_date_end int(11) NOT NULL DEFAULT 0,
  anim_price_type_custom_order int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (anim_price_type_custom_champ,anim_price_type_custom_origine,anim_price_type_custom_order),
  KEY anim_price_type_custom_champ (anim_price_type_custom_champ),
  KEY anim_price_type_custom_origine (anim_price_type_custom_origine)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_price_type_custom_dates`
--

LOCK TABLES anim_price_type_custom_dates WRITE;
/*!40000 ALTER TABLE anim_price_type_custom_dates DISABLE KEYS */;
/*!40000 ALTER TABLE anim_price_type_custom_dates ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_price_type_custom_lists`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_price_type_custom_lists (
  anim_price_type_custom_champ int(10) unsigned NOT NULL DEFAULT 0,
  anim_price_type_custom_list_value varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  anim_price_type_custom_list_lib varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  ordre int(11) DEFAULT NULL,
  KEY editorial_custom_champ (anim_price_type_custom_champ),
  KEY editorial_champ_list_value (anim_price_type_custom_champ,anim_price_type_custom_list_value)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_price_type_custom_lists`
--

LOCK TABLES anim_price_type_custom_lists WRITE;
/*!40000 ALTER TABLE anim_price_type_custom_lists DISABLE KEYS */;
/*!40000 ALTER TABLE anim_price_type_custom_lists ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_price_type_custom_values`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_price_type_custom_values (
  anim_price_type_custom_champ int(10) unsigned NOT NULL DEFAULT 0,
  anim_price_type_custom_origine int(10) unsigned NOT NULL DEFAULT 0,
  anim_price_type_custom_small_text varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  anim_price_type_custom_text text COLLATE utf8_unicode_ci DEFAULT NULL,
  anim_price_type_custom_integer int(11) DEFAULT NULL,
  anim_price_type_custom_date date DEFAULT NULL,
  anim_price_type_custom_float float DEFAULT NULL,
  anim_price_type_custom_order int(11) NOT NULL DEFAULT 0,
  KEY anim_price_type_custom_champ (anim_price_type_custom_champ),
  KEY anim_price_type_custom_origine (anim_price_type_custom_origine),
  KEY i_encv_st (anim_price_type_custom_small_text),
  KEY i_encv_t (anim_price_type_custom_text(255)),
  KEY i_encv_i (anim_price_type_custom_integer),
  KEY i_encv_d (anim_price_type_custom_date),
  KEY i_encv_f (anim_price_type_custom_float)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_price_type_custom_values`
--

LOCK TABLES anim_price_type_custom_values WRITE;
/*!40000 ALTER TABLE anim_price_type_custom_values DISABLE KEYS */;
/*!40000 ALTER TABLE anim_price_type_custom_values ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_price_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_price_types (
  id_price_type int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  default_value float(12,2) DEFAULT NULL,
  PRIMARY KEY (id_price_type)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_price_types`
--

LOCK TABLES anim_price_types WRITE;
/*!40000 ALTER TABLE anim_price_types DISABLE KEYS */;
INSERT INTO anim_price_types (id_price_type, name, default_value) VALUES (1,'Tarif par défaut',0.00);
/*!40000 ALTER TABLE anim_price_types ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_prices`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_prices (
  id_price int(11) NOT NULL AUTO_INCREMENT,
  num_animation int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` float(12,2) DEFAULT NULL,
  num_price_type int(11) DEFAULT NULL,
  PRIMARY KEY (id_price)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_prices`
--

LOCK TABLES anim_prices WRITE;
/*!40000 ALTER TABLE anim_prices DISABLE KEYS */;
/*!40000 ALTER TABLE anim_prices ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_registration_origins`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_registration_origins (
  id_registration_origin int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (id_registration_origin)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_registration_origins`
--

LOCK TABLES anim_registration_origins WRITE;
/*!40000 ALTER TABLE anim_registration_origins DISABLE KEYS */;
INSERT INTO anim_registration_origins (id_registration_origin, name) VALUES (1,'Internet');
/*!40000 ALTER TABLE anim_registration_origins ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_registration_status`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_registration_status (
  id_registration_status int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (id_registration_status)
) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_registration_status`
--

LOCK TABLES anim_registration_status WRITE;
/*!40000 ALTER TABLE anim_registration_status DISABLE KEYS */;
INSERT INTO anim_registration_status (id_registration_status, name) VALUES (1,'En attente de validation');
INSERT INTO anim_registration_status (id_registration_status, name) VALUES (2,'Validée');
INSERT INTO anim_registration_status (id_registration_status, name) VALUES (3,'Liste d\'attente');
/*!40000 ALTER TABLE anim_registration_status ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_registrations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_registrations (
  id_registration int(11) NOT NULL AUTO_INCREMENT,
  nb_registred_persons int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  email varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  phone_number varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  num_animation int(11) DEFAULT NULL,
  num_registration_status int(11) DEFAULT NULL,
  num_empr int(11) DEFAULT NULL,
  num_origin int(11) DEFAULT NULL,
  `date` datetime NOT NULL DEFAULT current_timestamp(),
  `hash` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (id_registration)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_registrations`
--

LOCK TABLES anim_registrations WRITE;
/*!40000 ALTER TABLE anim_registrations DISABLE KEYS */;
/*!40000 ALTER TABLE anim_registrations ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_registred_persons`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_registred_persons (
  id_person int(11) NOT NULL AUTO_INCREMENT,
  num_empr int(11) DEFAULT NULL,
  num_price int(11) DEFAULT NULL,
  num_registration int(11) DEFAULT NULL,
  person_name varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (id_person)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_registred_persons`
--

LOCK TABLES anim_registred_persons WRITE;
/*!40000 ALTER TABLE anim_registred_persons DISABLE KEYS */;
/*!40000 ALTER TABLE anim_registred_persons ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `anim_status`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE anim_status (
  id_status int(11) NOT NULL AUTO_INCREMENT,
  label varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  color varchar(7) COLLATE utf8_unicode_ci DEFAULT '#0D9B7A',
  PRIMARY KEY (id_status)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `anim_status`
--

LOCK TABLES anim_status WRITE;
/*!40000 ALTER TABLE anim_status DISABLE KEYS */;
INSERT INTO anim_status (id_status, label, color) VALUES (1,'Statut par défaut','#0D9B7A');
/*!40000 ALTER TABLE anim_status ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arch_emplacement`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE arch_emplacement (
  archempla_id int(8) unsigned NOT NULL AUTO_INCREMENT,
  archempla_libelle varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (archempla_id)
) AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arch_emplacement`
--

LOCK TABLES arch_emplacement WRITE;
/*!40000 ALTER TABLE arch_emplacement DISABLE KEYS */;
INSERT INTO arch_emplacement (archempla_id, archempla_libelle) VALUES (1,'Présentoir');
INSERT INTO arch_emplacement (archempla_id, archempla_libelle) VALUES (2,'Rayonnages');
INSERT INTO arch_emplacement (archempla_id, archempla_libelle) VALUES (3,'Réserve');
INSERT INTO arch_emplacement (archempla_id, archempla_libelle) VALUES (4,'En ligne');
/*!40000 ALTER TABLE arch_emplacement ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arch_statut`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE arch_statut (
  archstatut_id int(8) NOT NULL AUTO_INCREMENT,
  archstatut_gestion_libelle varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  archstatut_opac_libelle varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  archstatut_visible_opac tinyint(1) unsigned NOT NULL DEFAULT 1,
  archstatut_visible_opac_abon tinyint(1) unsigned NOT NULL DEFAULT 1,
  archstatut_visible_gestion tinyint(1) unsigned NOT NULL DEFAULT 1,
  archstatut_class_html varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (archstatut_id)
) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arch_statut`
--

LOCK TABLES arch_statut WRITE;
/*!40000 ALTER TABLE arch_statut DISABLE KEYS */;
INSERT INTO arch_statut (archstatut_id, archstatut_gestion_libelle, archstatut_opac_libelle, archstatut_visible_opac, archstatut_visible_opac_abon, archstatut_visible_gestion, archstatut_class_html) VALUES (1,'Empruntable','Empruntable',1,0,1,'statutnot1');
INSERT INTO arch_statut (archstatut_id, archstatut_gestion_libelle, archstatut_opac_libelle, archstatut_visible_opac, archstatut_visible_opac_abon, archstatut_visible_gestion, archstatut_class_html) VALUES (2,'Consultation sur place','Consultation sur place',1,0,0,'statutnot1');
INSERT INTO arch_statut (archstatut_id, archstatut_gestion_libelle, archstatut_opac_libelle, archstatut_visible_opac, archstatut_visible_opac_abon, archstatut_visible_gestion, archstatut_class_html) VALUES (3,'Texte intégral','Texte intégral',1,0,0,'');
/*!40000 ALTER TABLE arch_statut ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `arch_type`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE arch_type (
  archtype_id int(8) unsigned NOT NULL AUTO_INCREMENT,
  archtype_libelle varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (archtype_id)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `arch_type`
--

LOCK TABLES arch_type WRITE;
/*!40000 ALTER TABLE arch_type DISABLE KEYS */;
INSERT INTO arch_type (archtype_id, archtype_libelle) VALUES (1,'Imprimé');
INSERT INTO arch_type (archtype_id, archtype_libelle) VALUES (2,'Electronique');
/*!40000 ALTER TABLE arch_type ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE audit (
  type_obj int(1) NOT NULL DEFAULT 0,
  object_id int(10) unsigned NOT NULL DEFAULT 0,
  user_id int(8) unsigned NOT NULL DEFAULT 0,
  user_name varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  type_modif int(1) NOT NULL DEFAULT 1,
  quand timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  info text COLLATE utf8_unicode_ci NOT NULL,
  type_user int(1) unsigned NOT NULL DEFAULT 0,
  KEY type_obj (type_obj),
  KEY object_id (object_id),
  KEY user_id (user_id),
  KEY type_modif (type_modif)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit`
--

LOCK TABLES audit WRITE;
/*!40000 ALTER TABLE audit DISABLE KEYS */;
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,1,0,'',1,'2012-10-24 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,4,0,'',1,'2012-10-24 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,7,0,'',1,'2012-10-24 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,12,0,'',1,'2012-10-25 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,13,0,'',1,'2012-10-25 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,14,0,'',1,'2012-11-16 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,22,0,'',1,'2013-04-07 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,23,0,'',1,'2013-04-07 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,24,0,'',1,'2013-04-07 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,25,0,'',1,'2013-04-16 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,34,0,'',1,'2013-12-18 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,67,0,'',1,'2014-01-01 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,62,0,'',1,'2013-12-26 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,68,0,'',1,'2014-01-01 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,70,0,'',1,'2014-01-02 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,48,0,'',1,'2013-12-26 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,36,0,'',1,'2013-12-23 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,37,0,'',1,'2013-12-23 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,39,0,'',1,'2013-12-26 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,40,0,'',1,'2013-12-26 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,41,0,'',1,'2013-12-26 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,49,0,'',1,'2013-12-26 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,71,0,'',1,'2014-11-11 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (21,79,0,'',1,'2016-02-02 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,1,0,'',1,'2012-10-24 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,3,0,'',1,'2012-10-24 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,19,0,'',1,'2012-10-25 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,20,0,'',1,'2012-10-25 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,21,0,'',1,'2012-10-25 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,27,0,'',1,'2013-04-08 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,13,0,'',1,'2012-10-25 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,24,0,'',1,'2012-10-26 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,16,0,'',1,'2012-10-25 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,68,0,'',1,'2014-01-02 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,46,0,'',1,'2013-12-18 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,47,0,'',1,'2013-12-18 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,48,0,'',1,'2013-12-18 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,49,0,'',1,'2013-12-18 23:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,70,0,'',1,'2014-09-03 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,71,0,'',1,'2014-09-03 22:00:00','',0);
INSERT INTO audit (type_obj, object_id, user_id, user_name, type_modif, quand, info, type_user) VALUES (20,74,0,'',1,'2015-01-25 23:00:00','',0);
/*!40000 ALTER TABLE audit ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aut_link`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE aut_link (
  id_aut_link int(10) unsigned NOT NULL AUTO_INCREMENT,
  aut_link_from int(2) NOT NULL DEFAULT 0,
  aut_link_from_num int(11) NOT NULL DEFAULT 0,
  aut_link_to int(2) NOT NULL DEFAULT 0,
  aut_link_to_num int(11) NOT NULL DEFAULT 0,
  aut_link_type varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  aut_link_comment varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  aut_link_string_start_date varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  aut_link_string_end_date varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  aut_link_start_date date NOT NULL DEFAULT '0000-00-00',
  aut_link_end_date date NOT NULL DEFAULT '0000-00-00',
  aut_link_rank int(11) NOT NULL DEFAULT 0,
  aut_link_direction varchar(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  aut_link_reverse_link_num int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (id_aut_link),
  KEY i_from (aut_link_from,aut_link_from_num),
  KEY i_to (aut_link_to,aut_link_to_num),
  KEY aut_link_from (aut_link_from,aut_link_from_num,aut_link_to,aut_link_to_num,aut_link_type)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aut_link`
--

LOCK TABLES aut_link WRITE;
/*!40000 ALTER TABLE aut_link DISABLE KEYS */;
/*!40000 ALTER TABLE aut_link ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `author_custom`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE author_custom (
  idchamp int(10) unsigned NOT NULL AUTO_INCREMENT,
  num_type int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  titre varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  datatype varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `options` text COLLATE utf8_unicode_ci DEFAULT NULL,
  multiple int(11) NOT NULL DEFAULT 0,
  obligatoire int(11) NOT NULL DEFAULT 0,
  ordre int(11) DEFAULT NULL,
  search int(1) unsigned NOT NULL DEFAULT 0,
  `export` int(1) unsigned NOT NULL DEFAULT 0,
  filters int(1) unsigned NOT NULL DEFAULT 0,
  exclusion_obligatoire int(1) unsigned NOT NULL DEFAULT 0,
  pond int(11) NOT NULL DEFAULT 100,
  opac_sort int(11) NOT NULL DEFAULT 0,
  `comment` blob NOT NULL DEFAULT '',
  custom_classement varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (idchamp)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `author_custom`
--

LOCK TABLES author_custom WRITE;
/*!40000 ALTER TABLE author_custom DISABLE KEYS */;
/*!40000 ALTER TABLE author_custom ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `author_custom_dates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE author_custom_dates (
  author_custom_champ int(10) unsigned NOT NULL DEFAULT 0,
  author_custom_origine int(10) unsigned NOT NULL DEFAULT 0,
  author_custom_date_type int(11) DEFAULT NULL,
  author_custom_date_start int(11) NOT NULL DEFAULT 0,
  author_custom_date_end int(11) NOT NULL DEFAULT 0,
  author_custom_order int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (author_custom_champ,author_custom_origine,author_custom_order),
  KEY author_custom_champ (author_custom_champ),
  KEY author_custom_origine (author_custom_origine)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `author_custom_dates`
--

LOCK TABLES author_custom_dates WRITE;
/*!40000 ALTER TABLE author_custom_dates DISABLE KEYS */;
/*!40000 ALTER TABLE author_custom_dates ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `author_custom_lists`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE author_custom_lists (
  author_custom_champ int(10) unsigned NOT NULL DEFAULT 0,
  author_custom_list_value varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  author_custom_list_lib varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  ordre int(11) DEFAULT NULL,
  KEY editorial_custom_champ (author_custom_champ),
  KEY editorial_champ_list_value (author_custom_champ,author_custom_list_value)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `author_custom_lists`
--

LOCK TABLES author_custom_lists WRITE;
/*!40000 ALTER TABLE author_custom_lists DISABLE KEYS */;
/*!40000 ALTER TABLE author_custom_lists ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `author_custom_values`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE author_custom_values (
  author_custom_champ int(10) unsigned NOT NULL DEFAULT 0,
  author_custom_origine int(10) unsigned NOT NULL DEFAULT 0,
  author_custom_small_text varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  author_custom_text text COLLATE utf8_unicode_ci DEFAULT NULL,
  author_custom_integer int(11) DEFAULT NULL,
  author_custom_date date DEFAULT NULL,
  author_custom_float float DEFAULT NULL,
  author_custom_order int(11) NOT NULL DEFAULT 0,
  KEY editorial_custom_champ (author_custom_champ),
  KEY editorial_custom_origine (author_custom_origine),
  KEY i_acv_st (author_custom_small_text),
  KEY i_acv_t (author_custom_text(255)),
  KEY i_acv_i (author_custom_integer),
  KEY i_acv_d (author_custom_date),
  KEY i_acv_f (author_custom_float)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `author_custom_values`
--

LOCK TABLES author_custom_values WRITE;
/*!40000 ALTER TABLE author_custom_values DISABLE KEYS */;
/*!40000 ALTER TABLE author_custom_values ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorities`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE authorities (
  id_authority int(10) unsigned NOT NULL AUTO_INCREMENT,
  num_object int(9) unsigned NOT NULL DEFAULT 0,
  type_object int(10) unsigned NOT NULL DEFAULT 0,
  num_statut int(2) unsigned NOT NULL DEFAULT 1,
  thumbnail_url mediumblob NOT NULL,
  PRIMARY KEY (id_authority),
  UNIQUE KEY i_a_num_object_type_object (num_object,type_object),
  KEY i_a_num_statut (num_statut)
) AUTO_INCREMENT=1263 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorities`
--

LOCK TABLES authorities WRITE;
/*!40000 ALTER TABLE authorities DISABLE KEYS */;
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1,1,6,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (2,2,6,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (3,3,6,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (4,13,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (5,4,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (6,11,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (7,12,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (8,6,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (9,5,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (10,13,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (11,7,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (12,97,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (13,14,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (14,8,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (15,15,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (16,9,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (17,79,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (18,6,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (19,18,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (20,17,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (21,16,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (22,7,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (23,19,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (24,11,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (25,12,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (26,20,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (27,8,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (28,21,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (29,22,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (30,14,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (31,23,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (32,15,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (33,9,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (34,24,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (35,26,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (36,25,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (37,16,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (38,27,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (39,17,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (40,10,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (41,28,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (42,29,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (43,18,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (44,30,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (45,19,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (46,3,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (47,12,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (48,31,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (49,20,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (50,13,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (51,32,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (52,33,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (53,21,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (54,14,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (55,34,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (56,22,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (57,35,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (58,16,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (59,36,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (60,37,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (61,23,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (62,17,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (63,38,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (64,41,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (65,40,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (66,39,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (67,24,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (68,42,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (69,25,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (70,65,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (71,43,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (72,44,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (73,45,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (74,26,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (75,92,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (76,18,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (77,46,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (78,27,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (79,47,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (80,28,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (81,48,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (82,19,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (83,49,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (84,50,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (85,29,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (86,59,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (87,20,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (88,51,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (89,52,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (90,30,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (91,53,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (92,31,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (93,54,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (94,55,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (95,32,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (96,56,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (97,57,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (98,58,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (99,59,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (100,75,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (101,33,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (102,60,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (103,21,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (104,1,5,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (105,61,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (106,63,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (107,62,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (108,34,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (109,64,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (110,65,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (111,35,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (112,82,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (113,24,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (114,66,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (115,36,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (116,71,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (117,25,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (118,37,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (119,26,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (120,68,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (121,38,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (122,27,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (123,69,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (124,39,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (125,71,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (126,70,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (127,40,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (128,28,4,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (129,2,5,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (130,72,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (131,41,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (132,73,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (133,42,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (134,74,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (135,43,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (136,75,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (137,44,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (138,76,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (139,45,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (140,77,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (141,46,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (142,78,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (143,47,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (144,48,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (145,79,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (146,80,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (147,81,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (148,82,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (149,83,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (150,49,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (151,50,3,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (152,84,1,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (153,1378,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (154,1379,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (155,1380,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (156,1381,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (157,1382,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (158,1383,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (159,1384,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (160,1385,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (161,1386,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (162,1387,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (163,1388,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (164,1389,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (165,1390,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (166,1391,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (167,1392,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (168,1393,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (169,1394,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (170,1395,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (171,1396,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (172,1397,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (173,1398,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (174,1399,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (175,1400,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (176,1401,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (177,1402,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (178,1403,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (179,1404,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (180,1405,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (181,1406,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (182,1407,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (183,1408,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (184,1409,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (185,1410,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (186,1411,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (187,1412,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (188,1413,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (189,1414,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (190,1415,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (191,1416,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (192,1417,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (193,1418,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (194,1419,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (195,1420,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (196,1421,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (197,1422,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (198,1423,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (199,1424,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (200,1425,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (201,1426,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (202,1427,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (203,1428,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (204,1429,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (205,1430,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (206,1431,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (207,1432,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (208,1433,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (209,1434,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (210,1435,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (211,1436,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (212,1437,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (213,1438,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (214,1439,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (215,1440,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (216,1441,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (217,1442,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (218,1443,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (219,1444,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (220,1445,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (221,1446,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (222,1447,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (223,1448,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (224,1449,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (225,1450,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (226,1451,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (227,1452,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (228,1453,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (229,1454,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (230,1455,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (231,1456,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (232,1457,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (233,1458,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (234,1459,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (235,1460,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (236,1461,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (237,1462,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (238,1463,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (239,1464,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (240,1465,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (241,1466,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (242,1467,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (243,1468,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (244,1469,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (245,1470,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (246,1471,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (247,1472,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (248,1473,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (249,1474,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (250,1475,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (251,1476,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (252,1477,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (253,1478,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (254,1479,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (255,1480,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (256,1481,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (257,1482,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (258,1483,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (259,1484,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (260,1485,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (261,1486,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (262,1487,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (263,1488,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (264,1489,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (265,1490,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (266,1492,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (267,1493,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (268,1494,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (269,1495,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (270,1496,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (271,1497,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (272,1498,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (273,1499,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (274,1500,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (275,1501,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (276,1502,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (277,1503,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (278,1504,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (279,1505,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (280,1506,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (281,1507,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (282,1508,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (283,1509,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (284,1510,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (285,1511,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (286,1512,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (287,1513,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (288,1514,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (289,1515,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (290,1516,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (291,1517,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (292,1518,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (293,1519,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (294,1520,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (295,1521,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (296,1522,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (297,1523,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (298,1524,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (299,1525,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (300,1526,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (301,1527,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (302,1528,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (303,1529,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (304,1530,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (305,1531,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (306,1532,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (307,1533,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (308,1534,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (309,1535,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (310,1536,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (311,1537,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (312,1538,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (313,1539,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (314,1540,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (315,1541,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (316,1542,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (317,1543,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (318,1544,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (319,1545,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (320,1546,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (321,1547,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (322,1548,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (323,1549,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (324,1550,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (325,1551,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (326,1552,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (327,1553,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (328,1554,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (329,1555,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (330,1556,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (331,1557,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (332,1558,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (333,1559,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (334,1560,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (335,1561,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (336,1562,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (337,1563,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (338,1564,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (339,1565,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (340,1566,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (341,1567,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (342,1568,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (343,1569,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (344,1570,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (345,1571,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (346,1572,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (347,1573,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (348,1574,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (349,1575,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (350,1576,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (351,1577,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (352,1578,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (353,1579,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (354,1580,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (355,1581,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (356,1583,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (357,1584,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (358,1585,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (359,1586,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (360,1587,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (361,1588,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (362,1589,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (363,1590,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (364,1591,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (365,1592,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (366,1593,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (367,1594,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (368,1595,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (369,1596,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (370,1597,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (371,1598,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (372,1599,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (373,1600,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (374,1601,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (375,1602,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (376,1603,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (377,1604,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (378,1605,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (379,1606,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (380,1607,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (381,1608,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (382,1609,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (383,1610,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (384,1611,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (385,1612,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (386,1613,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (387,1614,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (388,1615,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (389,1616,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (390,1617,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (391,1618,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (392,1619,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (393,1620,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (394,1621,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (395,1622,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (396,1623,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (397,1624,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (398,1625,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (399,1626,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (400,1627,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (401,1628,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (402,1629,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (403,1630,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (404,1631,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (405,1632,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (406,1633,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (407,1634,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (408,1635,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (409,1636,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (410,1637,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (411,1638,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (412,1639,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (413,1640,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (414,1641,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (415,1642,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (416,1643,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (417,1644,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (418,1645,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (419,1646,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (420,1647,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (421,1648,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (422,1649,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (423,1650,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (424,1651,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (425,1652,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (426,1653,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (427,1654,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (428,1655,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (429,1656,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (430,1657,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (431,1658,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (432,1659,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (433,1660,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (434,1661,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (435,1662,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (436,1663,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (437,1664,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (438,1665,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (439,1666,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (440,1667,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (441,1668,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (442,1669,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (443,1670,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (444,1671,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (445,1672,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (446,1673,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (447,1674,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (448,1675,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (449,1676,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (450,1677,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (451,1678,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (452,1679,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (453,1680,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (454,1681,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (455,1682,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (456,1683,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (457,1684,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (458,1685,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (459,1686,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (460,1687,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (461,1688,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (462,1689,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (463,1690,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (464,1691,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (465,1692,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (466,1693,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (467,1694,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (468,1695,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (469,1696,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (470,1697,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (471,1698,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (472,1699,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (473,1700,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (474,1701,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (475,1702,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (476,1703,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (477,1704,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (478,1705,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (479,1706,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (480,1707,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (481,1708,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (482,1709,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (483,1710,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (484,1711,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (485,1712,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (486,1713,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (487,1714,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (488,1715,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (489,1716,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (490,1717,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (491,1718,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (492,1719,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (493,1720,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (494,1721,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (495,1722,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (496,1723,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (497,1724,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (498,1725,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (499,1726,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (500,1727,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (501,1728,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (502,1729,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (503,1730,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (504,1731,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (505,1733,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (506,1734,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (507,1735,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (508,1736,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (509,1737,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (510,1738,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (511,1739,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (512,1740,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (513,1741,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (514,1742,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (515,1743,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (516,1744,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (517,1746,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (518,1747,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (519,1748,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (520,1749,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (521,1750,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (522,1751,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (523,1752,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (524,1753,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (525,1754,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (526,1755,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (527,1756,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (528,1757,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (529,1758,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (530,1759,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (531,1760,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (532,1761,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (533,1762,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (534,1763,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (535,1764,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (536,1765,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (537,1766,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (538,1767,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (539,1768,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (540,1769,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (541,1770,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (542,1771,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (543,1772,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (544,1773,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (545,1774,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (546,1775,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (547,1776,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (548,1777,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (549,1778,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (550,1779,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (551,1780,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (552,1781,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (553,1782,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (554,1783,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (555,1784,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (556,1785,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (557,1786,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (558,1787,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (559,1788,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (560,1789,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (561,1790,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (562,1791,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (563,1792,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (564,1793,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (565,1794,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (566,1795,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (567,1796,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (568,1797,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (569,1798,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (570,1799,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (571,1800,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (572,1801,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (573,1802,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (574,1803,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (575,1804,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (576,1805,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (577,1806,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (578,1807,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (579,1808,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (580,1809,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (581,1810,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (582,1811,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (583,1812,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (584,1813,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (585,1814,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (586,1815,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (587,1816,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (588,1817,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (589,1818,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (590,1819,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (591,1820,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (592,1821,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (593,1822,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (594,1823,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (595,1824,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (596,1825,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (597,1826,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (598,1827,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (599,1828,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (600,1829,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (601,1830,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (602,1831,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (603,1832,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (604,1833,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (605,1834,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (606,1835,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (607,1836,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (608,1837,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (609,1838,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (610,1839,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (611,1840,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (612,1841,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (613,1842,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (614,1843,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (615,1844,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (616,1845,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (617,1846,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (618,1847,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (619,1848,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (620,1849,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (621,1850,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (622,1851,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (623,1852,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (624,1853,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (625,1854,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (626,1855,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (627,1856,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (628,1857,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (629,1858,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (630,1859,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (631,1860,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (632,1861,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (633,1862,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (634,1863,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (635,1864,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (636,1865,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (637,1866,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (638,1867,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (639,1868,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (640,1869,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (641,1870,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (642,1871,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (643,1872,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (644,1873,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (645,1874,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (646,1875,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (647,1876,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (648,1877,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (649,1878,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (650,1879,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (651,1880,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (652,1881,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (653,1882,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (654,1883,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (655,1884,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (656,1885,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (657,1886,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (658,1887,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (659,1888,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (660,1889,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (661,1890,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (662,1891,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (663,1892,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (664,1893,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (665,1894,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (666,1895,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (667,1896,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (668,1897,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (669,1898,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (670,1899,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (671,1900,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (672,1901,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (673,1902,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (674,1903,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (675,1904,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (676,1905,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (677,1906,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (678,1907,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (679,1908,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (680,1909,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (681,1910,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (682,1911,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (683,1912,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (684,1913,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (685,1914,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (686,1915,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (687,1916,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (688,1917,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (689,1918,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (690,1919,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (691,1920,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (692,1921,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (693,1922,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (694,1923,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (695,1924,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (696,1925,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (697,1926,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (698,1927,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (699,1928,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (700,1929,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (701,1930,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (702,1931,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (703,1932,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (704,1933,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (705,1934,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (706,1935,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (707,1936,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (708,1937,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (709,1938,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (710,1939,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (711,1940,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (712,1941,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (713,1942,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (714,1943,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (715,1944,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (716,1945,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (717,1946,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (718,1947,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (719,1948,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (720,1949,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (721,1950,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (722,1951,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (723,1952,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (724,1953,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (725,1954,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (726,1955,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (727,1956,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (728,1957,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (729,1958,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (730,1959,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (731,1960,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (732,1961,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (733,1962,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (734,1963,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (735,1964,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (736,1965,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (737,1966,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (738,1967,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (739,1968,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (740,1969,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (741,1970,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (742,1971,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (743,1972,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (744,1973,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (745,1974,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (746,1975,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (747,1976,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (748,1977,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (749,1978,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (750,1979,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (751,1980,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (752,1981,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (753,1982,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (754,1983,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (755,1984,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (756,1985,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (757,1986,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (758,1987,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (759,1988,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (760,1989,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (761,1990,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (762,1991,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (763,1992,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (764,1993,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (765,1994,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (766,1995,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (767,1996,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (768,1997,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (769,1998,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (770,1999,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (771,2000,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (772,2001,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (773,2002,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (774,2003,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (775,2004,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (776,2005,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (777,2006,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (778,2007,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (779,2008,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (780,2009,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (781,2010,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (782,2011,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (783,2012,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (784,2013,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (785,2014,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (786,2015,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (787,2016,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (788,2017,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (789,2018,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (790,2019,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (791,2020,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (792,2021,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (793,2022,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (794,2023,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (795,2024,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (796,2025,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (797,2026,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (798,2027,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (799,2028,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (800,2029,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (801,2030,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (802,2031,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (803,2032,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (804,2034,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (805,2035,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (806,2036,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (807,2037,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (808,2040,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (809,2043,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (810,2044,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (811,2045,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (812,2046,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (813,2047,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (814,2048,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (815,2049,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (816,2050,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (817,2051,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (818,2052,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (819,2053,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (820,2054,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (821,2057,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (822,2058,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (823,2059,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (824,2060,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (825,2061,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (826,2062,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (827,2063,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (828,2064,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (829,2065,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (830,2068,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (831,2071,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (832,2072,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (833,2074,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (834,2075,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (835,2076,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (836,2078,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (837,2079,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (838,2080,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (839,2081,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (840,2082,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (841,2084,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (842,2085,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (843,2086,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (844,2087,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (845,2089,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (846,2090,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (847,2093,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (848,2094,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (849,2095,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (850,2096,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (851,2097,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (852,2098,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (853,2099,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (854,2101,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (855,2102,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (856,2103,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (857,2104,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (858,2105,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (859,2106,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (860,2107,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (861,2108,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (862,2109,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (863,2110,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (864,2111,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (865,2112,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (866,2113,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (867,2116,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (868,2120,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (869,2121,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (870,2124,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (871,2125,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (872,2126,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (873,2127,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (874,2128,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (875,2129,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (876,2130,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (877,2131,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (878,2132,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (879,2135,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (880,2136,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (881,2137,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (882,2139,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (883,2140,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (884,2141,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (885,2142,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (886,2144,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (887,2146,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (888,2147,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (889,2148,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (890,2150,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (891,2152,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (892,2153,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (893,2154,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (894,2155,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (895,2156,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (896,2157,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (897,2158,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (898,2159,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (899,2160,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (900,2161,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (901,2162,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (902,2163,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (903,2164,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (904,2165,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (905,2166,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (906,2167,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (907,2168,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (908,2169,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (909,2170,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (910,2171,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (911,2172,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (912,2174,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (913,2175,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (914,2177,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (915,2179,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (916,2180,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (917,2181,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (918,2182,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (919,2183,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (920,2184,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (921,2185,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (922,2186,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (923,2191,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (924,2192,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (925,2193,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (926,2194,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (927,2196,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (928,2197,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (929,2198,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (930,2200,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (931,2201,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (932,2203,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (933,2205,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (934,2206,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (935,2207,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (936,2212,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (937,2214,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (938,2215,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (939,2216,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (940,2217,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (941,2218,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (942,2219,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (943,2220,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (944,2221,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (945,2222,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (946,2223,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (947,2224,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (948,2225,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (949,2226,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (950,2227,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (951,2228,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (952,2229,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (953,2231,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (954,2232,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (955,2233,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (956,2235,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (957,2236,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (958,2237,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (959,2239,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (960,2240,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (961,2242,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (962,2245,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (963,2246,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (964,2248,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (965,2250,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (966,2252,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (967,2253,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (968,2254,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (969,2255,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (970,2256,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (971,2257,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (972,2258,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (973,2259,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (974,2260,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (975,2261,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (976,2262,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (977,2264,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (978,2265,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (979,2266,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (980,2267,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (981,2268,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (982,2269,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (983,2270,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (984,2271,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (985,2272,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (986,2273,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (987,2274,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (988,2275,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (989,2276,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (990,2277,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (991,2278,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (992,2279,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (993,2280,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (994,2281,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (995,2282,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (996,2283,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (997,2284,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (998,2285,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (999,2286,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1000,2287,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1001,2288,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1002,2289,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1003,2290,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1004,2291,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1005,2294,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1006,2295,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1007,2297,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1008,2298,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1009,2299,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1010,2300,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1011,2302,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1012,2303,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1013,2304,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1014,2306,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1015,2308,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1016,2309,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1017,2310,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1018,2311,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1019,2312,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1020,2313,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1021,2314,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1022,2315,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1023,2316,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1024,2317,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1025,2318,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1026,2320,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1027,2321,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1028,2322,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1029,2326,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1030,2327,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1031,2328,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1032,2329,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1033,2330,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1034,2332,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1035,2335,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1036,2336,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1037,2337,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1038,2338,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1039,2339,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1040,2340,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1041,2341,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1042,2342,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1043,2343,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1044,2345,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1045,2346,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1046,2347,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1047,2348,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1048,2349,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1049,2350,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1050,2352,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1051,2353,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1052,2354,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1053,2356,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1054,2358,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1055,2359,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1056,2361,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1057,2362,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1058,2364,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1059,2366,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1060,2368,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1061,2369,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1062,2371,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1063,2372,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1064,2373,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1065,2374,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1066,2375,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1067,2376,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1068,2377,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1069,2378,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1070,2380,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1071,2381,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1072,2382,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1073,2383,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1074,2384,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1075,2385,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1076,2386,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1077,2387,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1078,2388,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1079,2391,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1080,2394,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1081,2395,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1082,2396,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1083,2397,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1084,2399,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1085,2400,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1086,2402,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1087,2403,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1088,2404,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1089,2405,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1090,2406,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1091,2407,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1092,2408,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1093,2410,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1094,2411,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1095,2412,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1096,2413,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1097,2414,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1098,2416,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1099,2418,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1100,2420,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1101,2422,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1102,2423,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1103,2424,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1104,2425,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1105,2426,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1106,2427,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1107,2428,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1108,2429,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1109,2430,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1110,2431,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1111,2432,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1112,2442,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1113,2444,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1114,2446,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1115,2447,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1116,2448,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1117,2449,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1118,2451,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1119,2452,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1120,2454,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1121,2456,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1122,2457,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1123,2458,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1124,2460,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1125,2461,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1126,2462,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1127,2463,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1128,2465,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1129,2466,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1130,2467,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1131,2469,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1132,2471,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1133,2472,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1134,2473,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1135,2475,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1136,2476,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1137,2477,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1138,2478,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1139,2479,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1140,2480,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1141,2481,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1142,2482,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1143,2483,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1144,2484,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1145,2485,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1146,2486,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1147,2487,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1148,2488,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1149,2489,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1150,2490,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1151,2491,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1152,2492,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1153,2493,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1154,2494,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1155,2495,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1156,2496,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1157,2497,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1158,2498,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1159,2499,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1160,2500,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1161,2501,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1162,2502,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1163,2503,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1164,2504,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1165,2505,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1166,2506,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1167,2507,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1168,2508,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1169,2509,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1170,2510,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1171,2511,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1172,2512,2,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1173,1,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1174,2,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1175,4,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1176,6,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1177,7,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1178,8,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1179,9,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1180,10,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1181,11,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1182,12,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1183,13,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1184,14,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1185,15,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1186,16,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1187,17,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1188,18,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1189,19,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1190,20,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1191,21,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1192,22,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1193,23,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1194,24,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1195,25,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1196,26,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1197,27,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1198,28,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1199,29,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1200,30,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1201,31,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1202,32,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1203,33,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1204,34,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1205,35,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1206,36,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1207,37,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1208,38,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1209,39,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1210,40,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1211,41,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1212,42,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1213,43,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1214,44,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1215,45,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1216,46,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1217,47,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1218,48,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1219,49,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1220,50,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1221,51,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1222,52,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1223,53,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1224,54,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1225,55,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1226,56,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1227,57,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1228,58,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1229,60,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1230,61,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1231,62,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1232,63,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1233,64,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1234,66,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1235,67,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1236,68,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1237,69,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1238,70,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1239,72,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1240,73,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1241,74,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1242,76,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1243,77,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1244,78,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1245,80,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1246,81,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1247,83,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1248,84,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1249,85,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1250,86,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1251,87,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1252,88,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1253,89,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1254,90,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1255,91,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1256,93,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1257,94,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1258,95,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1259,96,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1260,98,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1261,99,8,1,'');
INSERT INTO authorities (id_authority, num_object, type_object, num_statut, thumbnail_url) VALUES (1262,100,8,1,'');
/*!40000 ALTER TABLE authorities ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorities_caddie`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE authorities_caddie (
  idcaddie int(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  autorisations mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  autorisations_all int(1) NOT NULL DEFAULT 0,
  caddie_classement varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  acces_rapide int(11) NOT NULL DEFAULT 0,
  favorite_color varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  creation_user_name varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  creation_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (idcaddie),
  KEY caddie_type (`type`)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorities_caddie`
--

LOCK TABLES authorities_caddie WRITE;
/*!40000 ALTER TABLE authorities_caddie DISABLE KEYS */;
/*!40000 ALTER TABLE authorities_caddie ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorities_caddie_content`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE authorities_caddie_content (
  caddie_id int(8) unsigned NOT NULL DEFAULT 0,
  object_id int(10) unsigned NOT NULL DEFAULT 0,
  flag varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (caddie_id,object_id),
  KEY object_id (object_id)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorities_caddie_content`
--

LOCK TABLES authorities_caddie_content WRITE;
/*!40000 ALTER TABLE authorities_caddie_content DISABLE KEYS */;
/*!40000 ALTER TABLE authorities_caddie_content ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorities_caddie_procs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE authorities_caddie_procs (
  idproc smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'SELECT',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  requete blob NOT NULL,
  `comment` tinytext COLLATE utf8_unicode_ci NOT NULL,
  autorisations mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  autorisations_all int(1) NOT NULL DEFAULT 0,
  parameters text COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (idproc)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorities_caddie_procs`
--

LOCK TABLES authorities_caddie_procs WRITE;
/*!40000 ALTER TABLE authorities_caddie_procs DISABLE KEYS */;
/*!40000 ALTER TABLE authorities_caddie_procs ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorities_fields_global_index`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE authorities_fields_global_index (
  id_authority int(10) unsigned NOT NULL DEFAULT 0,
  `type` int(5) unsigned NOT NULL DEFAULT 0,
  code_champ int(10) NOT NULL DEFAULT 0,
  code_ss_champ int(3) NOT NULL DEFAULT 0,
  ordre int(4) NOT NULL DEFAULT 0,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  pond int(4) NOT NULL DEFAULT 100,
  lang varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  authority_num varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (id_authority,code_champ,code_ss_champ,ordre,lang),
  KEY i_value (`value`(300)),
  KEY i_id_value (id_authority,`value`(300)),
  KEY i_code_champ_code_ss_champ (code_champ,code_ss_champ),
  KEY i_id_authority (id_authority)
) DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorities_fields_global_index`
--

LOCK TABLES authorities_fields_global_index WRITE;
/*!40000 ALTER TABLE authorities_fields_global_index DISABLE KEYS */;
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (6,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (6,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (6,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (6,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (6,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (6,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (6,1,1002,0,1,'Blixen',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (6,1,1003,0,1,'Karen',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (6,1,1004,0,1,'1885-1962',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (7,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (7,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (7,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (7,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (7,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (7,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (7,1,1002,0,1,'Metzger',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (7,1,1003,0,1,'Marthe',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (10,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (10,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (10,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (10,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (10,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (10,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (10,1,1002,0,1,'Bâ',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (10,1,1003,0,1,'Amadou Hampâté',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (10,1,1004,0,1,'1901-1991',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (13,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (13,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (13,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (13,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (13,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (13,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (13,1,1002,0,1,'Zaïd',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (13,1,1003,0,1,'Nassera',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (15,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (15,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (15,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (15,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (15,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (15,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (15,1,1002,0,1,'Depardon',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (15,1,1003,0,1,'Raymond',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (15,1,1004,0,1,'1942-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (21,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (21,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (21,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (21,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (21,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (21,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (21,1,1002,0,1,'Grosléziat',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (21,1,1003,0,1,'Chantal',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (20,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (20,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (20,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (20,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (20,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (20,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (20,1,1002,0,1,'Nouhen',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (20,1,1003,0,1,'Elodie',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (20,1,1004,0,1,'1970-...',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (19,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (19,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (19,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (19,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (19,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (19,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (19,1,1002,0,1,'Mindy',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (19,1,1003,0,1,'Paul',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (19,1,1004,0,1,'1952-...',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (23,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (23,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (23,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (23,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (23,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (23,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (23,1,1002,0,1,'Dedieu',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (23,1,1003,0,1,'Thierry',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (26,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (26,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (26,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (26,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (26,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (26,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (26,1,1002,0,1,'De Boel',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (26,1,1003,0,1,'Anne-Catherine',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (26,1,1004,0,1,'1975-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (28,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (28,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (28,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (28,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (28,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (28,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (28,1,1002,0,1,'Abouet',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (28,1,1003,0,1,'Marguerite',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (28,1,1004,0,1,'1971-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (29,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (29,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (29,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (29,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (29,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (29,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (29,1,1002,0,1,'Oubrerie',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (29,1,1003,0,1,'Clément',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (29,1,1004,0,1,'1966-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (31,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (31,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (31,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (31,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (31,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (31,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (31,1,1002,0,1,'Mabanckou',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (31,1,1003,0,1,'Alain',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (31,1,1004,0,1,'1966-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (34,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (34,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (34,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (34,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (34,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (34,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (34,1,1002,0,1,'Marechera',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (34,1,1003,0,1,'Dambudzo',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (34,1,1004,0,1,'1952-1987',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (36,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (36,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (36,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (36,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (36,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (36,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (36,1,1002,0,1,'Garnier',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (36,1,1003,0,1,'Xavier',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (35,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (35,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (35,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (35,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (35,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (35,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (35,1,1002,0,1,'Evette',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (35,1,1003,0,1,'Jean-Baptiste',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (35,1,1004,0,1,'1964-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (38,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (38,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (38,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (38,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (38,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (38,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (38,1,1002,0,1,'Gravett',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (38,1,1003,0,1,'Emily',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (41,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (41,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (41,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (41,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (41,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (41,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (41,1,1002,0,1,'Gudule',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (42,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (42,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (42,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (42,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (42,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (42,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (42,1,1002,0,1,'Durual',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (42,1,1003,0,1,'Christophe',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (44,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (44,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (44,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (44,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (44,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (44,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (44,1,1002,0,1,'Heitz',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (44,1,1003,0,1,'Bruno',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (44,1,1004,0,1,'1957-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (48,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (48,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (48,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (48,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (48,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (48,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (48,1,1002,0,1,'Melot',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (48,1,1003,0,1,'Michel',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (48,1,1004,0,1,'1943-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (51,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (51,1,1001,0,1,'Collectivité',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (51,1,1001,0,2,'Corporate body',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (51,1,1001,0,3,'Entidad',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (51,1,1001,0,4,'istituzione',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (51,1,1001,0,5,'Corporate body',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (51,1,1002,0,1,'Association des bibliothécaires français',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (52,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (52,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (52,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (52,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (52,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (52,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (52,1,1002,0,1,'Alix',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (52,1,1003,0,1,'Yves',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (52,1,1004,0,1,'1953-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (55,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (55,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (55,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (55,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (55,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (55,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (55,1,1002,0,1,'Pallier',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (55,1,1003,0,1,'Denis',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (55,1,1004,0,1,'1944-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (57,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (57,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (57,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (57,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (57,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (57,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (57,1,1002,0,1,'Brisou-pellen',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (57,1,1003,0,1,'Evelyn',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (59,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (59,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (59,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (59,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (59,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (59,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (59,1,1002,0,1,'Beinhart',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (59,1,1003,0,1,'Larry',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (59,1,1004,0,1,'1947-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (60,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (60,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (60,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (60,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (60,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (60,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (60,1,1002,0,1,'Carrer',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (60,1,1003,0,1,'Patrice',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (60,1,1004,0,1,'1953-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (63,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (63,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (63,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (63,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (63,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (63,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (63,1,1002,0,1,'Mahy',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (63,1,1003,0,1,'Margaret',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (63,1,1004,0,1,'1936-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (66,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (66,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (66,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (66,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (66,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (66,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (66,1,1002,0,1,'Blake',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (66,1,1003,0,1,'Quentin',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (66,1,1004,0,1,'1932-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (65,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (65,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (65,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (65,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (65,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (65,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (65,1,1002,0,1,'Saint-Dizier',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (65,1,1003,0,1,'Marie',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (65,1,1004,0,1,'1944-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (64,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (64,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (64,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (64,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (64,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (64,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (64,1,1002,0,1,'Farré',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (64,1,1003,0,1,'Raymond',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (64,1,1004,0,1,'1941-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (68,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (68,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (68,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (68,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (68,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (68,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (68,1,1002,0,1,'Bonnet',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (68,1,1003,0,1,'Jacques',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (68,1,1004,0,1,'1949-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (71,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (71,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (71,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (71,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (71,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (71,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (71,1,1002,0,1,'Bella Ola',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (71,1,1003,0,1,'Alexandre',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (72,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (72,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (72,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (72,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (72,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (72,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (72,1,1002,0,1,'Cuvilliez',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (72,1,1003,0,1,'Joëlle',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (73,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (73,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (73,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (73,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (73,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (73,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (73,1,1002,0,1,'Tabuteau',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (73,1,1003,0,1,'Jean-Luc',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (77,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (77,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (77,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (77,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (77,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (77,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (77,1,1002,0,1,'Nantet',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (77,1,1003,0,1,'Bernard',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (77,1,1004,0,1,'1938-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (79,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (79,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (79,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (79,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (79,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (79,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (79,1,1002,0,1,'Gourounas',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (79,1,1003,0,1,'Jean',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (79,1,1004,0,1,'1965-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (81,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (81,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (81,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (81,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (81,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (81,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (81,1,1002,0,1,'Guettier',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (81,1,1003,0,1,'Bénédicte',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (81,1,1004,0,1,'1962-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (83,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (83,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (83,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (83,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (83,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (83,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (83,1,1002,0,1,'Gay-Para',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (83,1,1003,0,1,'Praline',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (83,1,1004,0,1,'1956-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (84,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (84,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (84,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (84,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (84,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (84,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (84,1,1002,0,1,'Prigent',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (84,1,1003,0,1,'Andrée',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (84,1,1004,0,1,'1963-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (88,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (88,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (88,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (88,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (88,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (88,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (88,1,1002,0,1,'Guidoux',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (88,1,1003,0,1,'Valerie',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (89,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (89,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (89,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (89,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (89,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (89,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (89,1,1002,0,1,'Corentin',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (89,1,1003,0,1,'Philippe',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (89,1,1004,0,1,'1936-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (91,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (91,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (91,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (91,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (91,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (91,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (91,1,1002,0,1,'Loubier',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (91,1,1003,0,1,'Virginie',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (93,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (93,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (93,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (93,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (93,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (93,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (93,1,1002,0,1,'Serres',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (93,1,1003,0,1,'Alain',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (93,1,1004,0,1,'1956-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (94,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (94,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (94,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (94,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (94,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (94,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (94,1,1002,0,1,'Jarrie',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (94,1,1003,0,1,'Martin',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (94,1,1004,0,1,'1953-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (96,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (96,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (96,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (96,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (96,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (96,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (96,1,1002,0,1,'Teyras',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (96,1,1003,0,1,'Emmanuelle',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (97,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (97,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (97,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (97,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (97,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (97,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (97,1,1002,0,1,'Clément',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (97,1,1003,0,1,'Marie-Christine',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (98,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (98,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (98,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (98,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (98,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (98,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (98,1,1002,0,1,'Freymann',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (98,1,1003,0,1,'Saxton',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (99,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (99,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (99,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (99,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (99,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (99,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (99,1,1002,0,1,'Elffers',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (99,1,1003,0,1,'Joost',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (102,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (102,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (102,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (102,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (102,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (102,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (102,1,1002,0,1,'Bravi',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (102,1,1003,0,1,'Soledad',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (102,1,1004,0,1,'1965-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (105,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (105,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (105,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (105,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (105,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (105,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (105,1,1002,0,1,'Bradbury',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (105,1,1003,0,1,'Ray',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (105,1,1004,0,1,'1920-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (107,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (107,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (107,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (107,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (107,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (107,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (107,1,1002,0,1,'Chambon',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (107,1,1003,0,1,'Jacques',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (107,1,1004,0,1,'1942-2003',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (106,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (106,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (106,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (106,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (106,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (106,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (106,1,1002,0,1,'Robillot',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (106,1,1003,0,1,'Henri',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (109,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (109,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (109,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (109,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (109,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (109,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (109,1,1002,0,1,'Pratchett',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (109,1,1003,0,1,'Terry',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (109,1,1004,0,1,'1948-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (110,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (110,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (110,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (110,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (110,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (110,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (110,1,1002,0,1,'Couton',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (110,1,1003,0,1,'Patrick',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (114,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (114,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (114,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (114,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (114,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (114,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (114,1,1002,0,1,'Burton',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (114,1,1003,0,1,'Tim',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (120,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (120,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (120,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (120,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (120,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (120,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (120,1,1002,0,1,'De baecque',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (120,1,1003,0,1,'Anto',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (123,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (123,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (123,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (123,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (123,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (123,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (123,1,1002,0,1,'Silloray',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (123,1,1003,0,1,'Florent',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (123,1,1004,0,1,'1971-...',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (126,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (126,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (126,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (126,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (126,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (126,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (126,1,1002,0,1,'Depp',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (126,1,1003,0,1,'Johnny',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (125,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (125,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (125,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (125,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (125,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (125,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (125,1,1002,0,1,'Ryder',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (125,1,1003,0,1,'Winona',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (130,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (130,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (130,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (130,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (130,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (130,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (130,1,1002,0,1,'Keaton',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (130,1,1003,0,1,'Mickael',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (132,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (132,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (132,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (132,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (132,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (132,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (132,1,1002,0,1,'McGregor',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (132,1,1003,0,1,'Ewan',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (134,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (134,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (134,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (134,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (134,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (134,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (134,1,1002,0,1,'Makeba',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (134,1,1003,0,1,'Miriam',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (134,1,1004,0,1,'1932-2008',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (136,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (136,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (136,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (136,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (136,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (136,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (136,1,1002,0,1,'Lo',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (136,1,1003,0,1,'Ismaël',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (136,1,1004,0,1,'1956-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (138,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (138,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (138,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (138,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (138,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (138,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (138,1,1002,0,1,'Traoré',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (138,1,1003,0,1,'Rokia',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (138,1,1004,0,1,'1974-....',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (140,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (140,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (140,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (140,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (140,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (140,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (140,1,1002,0,1,'Keita',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (140,1,1003,0,1,'Salif',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (142,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (142,1,1001,0,1,'Collectivité',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (142,1,1001,0,2,'Corporate body',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (142,1,1001,0,3,'Entidad',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (142,1,1001,0,4,'istituzione',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (142,1,1001,0,5,'Corporate body',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (142,1,1002,0,1,'Amadou & Mariam',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (145,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (145,1,1001,0,1,'Collectivité',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (145,1,1001,0,2,'Corporate body',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (145,1,1001,0,3,'Entidad',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (145,1,1001,0,4,'istituzione',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (145,1,1001,0,5,'Corporate body',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (145,1,1002,0,1,'ENSSIB',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (146,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (146,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (146,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (146,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (146,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (146,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (146,1,1002,0,1,'Bonnet',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (146,1,1003,0,1,'Jacques',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (147,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (147,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (147,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (147,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (147,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (147,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (147,1,1002,0,1,'Akkouche',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (147,1,1003,0,1,'Mouloud',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (148,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (148,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (148,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (148,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (148,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (148,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (148,1,1002,0,1,'Aïoutz',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (148,1,1003,0,1,'Renaud',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (149,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (149,1,1001,0,1,'Collectivité',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (149,1,1001,0,2,'Corporate body',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (149,1,1001,0,3,'Entidad',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (149,1,1001,0,4,'istituzione',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (149,1,1001,0,5,'Corporate body',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (149,1,1002,0,1,'Interactica',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (152,1,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (152,1,1001,0,1,'Personne physique',130,'fr_FR','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (152,1,1001,0,2,'Person',130,'en_UK','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (152,1,1001,0,3,'Persona',130,'es_ES','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (152,1,1001,0,4,'persona fisica',130,'it_IT','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (152,1,1001,0,5,'Person',130,'de_DE','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (152,1,1002,0,1,'Boulnois',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (152,1,1003,0,1,'Philippe',110,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (8,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (8,3,3001,0,1,'Seuil',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (8,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (11,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (11,3,3001,0,1,'les Éd. du Toucan',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (11,3,3005,0,1,'[Issy-les-Moulineaux]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (14,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (14,3,3001,0,1,'Hazan',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (14,3,3005,0,1,'[Vanves]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (16,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (16,3,3001,0,1,'Didier jeunesse',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (16,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (24,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (24,3,3001,0,1,'Pastel',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (24,3,3005,0,1,'[Bruxelles]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (25,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (25,3,3001,0,1,'l\'école des loisirs',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (25,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (4,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (4,3,3001,0,1,'Gallimard',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (4,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (30,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (30,3,3001,0,1,'Serpent à plumes',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (30,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (32,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (32,3,3001,0,1,'Vents d\'ailleurs',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (32,3,3005,0,1,'La Roque-d\'Anthéron',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (37,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (37,3,3001,0,1,'Kaléidoscope',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (37,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (39,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (39,3,3001,0,1,'Hachette Jeunesse',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (43,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (43,3,3001,0,1,'Circonflexe',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (43,3,3005,0,1,'[Paris]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (45,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (45,3,3001,0,1,'l\'Oeil neuf éd.',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (45,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (49,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (49,3,3001,0,1,'Éd. du Cercle de la librairie',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (49,3,3005,0,1,'[Paris]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (53,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (53,3,3001,0,1,'Presses universitaires de France',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (53,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (56,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (56,3,3001,0,1,'Casterman',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (61,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (61,3,3001,0,1,'Gallimard jeunesse',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (61,3,3005,0,1,'[Paris]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (67,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (67,3,3001,0,1,'Denoël',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (67,3,3005,0,1,'[Paris]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (69,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (69,3,3001,0,1,'Éd. First',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (69,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (74,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (74,3,3001,0,1,'Milan',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (74,3,3005,0,1,'Toulouse',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (78,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (78,3,3001,0,1,'Éd. du Rouergue',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (78,3,3005,0,1,'Rodez',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (80,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (80,3,3001,0,1,'Gallimard jeunesse - Giboulées',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (80,3,3005,0,1,'[Paris]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (85,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (85,3,3001,0,1,'Nathan',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (90,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (90,3,3001,0,1,'Éd. Lito',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (90,3,3005,0,1,'Champigny-sur-Marne',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (92,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (92,3,3001,0,1,'Rue du monde',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (92,3,3005,0,1,'[Voisins-le-Bretonneux]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (95,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (95,3,3001,0,1,'Mila éd.',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (95,3,3005,0,1,'[Paris]',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (101,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (101,3,3001,0,1,'l\'École des loisirs-Loulou & Cie',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (101,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (108,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (108,3,3001,0,1,'l\'Atalante',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (108,3,3005,0,1,'Nantes',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (111,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (111,3,3001,0,1,'10-18',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (115,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (115,3,3001,0,1,'Arola',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (118,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (118,3,3001,0,1,'Cah cinema',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (121,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (121,3,3001,0,1,'Gallimard Jeunesse Musique',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (124,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (124,3,3001,0,1,'Twentieth century Fox',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (124,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (127,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (127,3,3001,0,1,'Warner home video',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (127,3,3005,0,1,'Neuilly-sur-Seine',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (131,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (131,3,3001,0,1,'Columbia Tristar home video',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (131,3,3005,0,1,'Boulogne-Billancourt',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (133,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (133,3,3001,0,1,'Manteca',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (135,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (135,3,3001,0,1,'AZ',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (135,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (137,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (137,3,3001,0,1,'Universal music jazz France',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (139,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (139,3,3001,0,1,'Universal Polydor',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (141,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (141,3,3001,0,1,'Because music',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (141,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (143,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (143,3,3001,0,1,'Participations éditions presse',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (143,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (144,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (144,3,3001,0,1,'ENSSIB',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (144,3,3005,0,1,'Villeurbanne',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (150,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (150,3,3001,0,1,'Éd. Grains de sel',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (150,3,3005,0,1,'Lyon',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (151,3,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (151,3,3001,0,1,'Studio magazine',130,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (151,3,3005,0,1,'Paris',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (153,2,2001,1,1,'Art et culture',130,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (153,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (153,2,2007,0,1,'1377',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (154,2,2001,1,1,'Institutions et politique',130,'fr_FR','1379');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (154,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (154,2,2007,0,1,'1378',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (155,2,2001,1,1,'Jeunesse',130,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (155,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (155,2,2007,0,1,'1379',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (156,2,2001,1,1,'Sciences',130,'fr_FR','1381');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (156,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (156,2,2007,0,1,'1380',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (157,2,2001,1,1,'Sciences humaines',130,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (157,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (157,2,2007,0,1,'1381',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (158,2,2001,1,1,'Société',130,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (158,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (158,2,2007,0,1,'1382',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (159,2,2001,1,1,'Sports et loisirs',130,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (159,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (159,2,2007,0,1,'1383',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (160,2,2001,1,1,'Techniques',130,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (160,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (160,2,2007,0,1,'1384',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (161,2,2001,1,1,'Vie pratique',130,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (161,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (161,2,2007,0,1,'1385',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (162,2,2001,1,1,'Zones géographiques',130,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (162,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (162,2,2007,0,1,'1386',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (163,2,2001,1,1,'Essais',130,'fr_FR','1388');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (163,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (163,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (163,2,2007,0,1,'1387',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (163,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (164,2,2001,1,1,'Illustration',130,'fr_FR','1389');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (164,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (164,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (164,2,2007,0,1,'1388',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (164,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (165,2,2001,1,1,'Architecture',130,'fr_FR','1390');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (165,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (165,2,2006,1,1,'Architecture',100,'fr_FR','1602');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (165,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (165,2,2007,0,1,'1389',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (165,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (165,2,2006,2,1,'Architecture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (166,2,2001,1,1,'Bande dessinée',130,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (166,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (166,2,2006,1,1,'Bande dessinée',100,'fr_FR','1599');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (166,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (166,2,2007,0,1,'1390',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (166,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (166,2,2006,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (167,2,2001,1,1,'Cinéma',130,'fr_FR','1392');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (167,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (167,2,2006,1,1,'Cinéma - Télévision',100,'fr_FR','1600');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (167,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (167,2,2007,0,1,'1391',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (167,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (167,2,2006,2,1,'Cinéma - Télévision',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (168,2,2001,1,1,'Design',130,'fr_FR','1393');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (168,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (168,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (168,2,2007,0,1,'1392',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (168,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (169,2,2001,1,1,'Littérature',130,'fr_FR','1394');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (169,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (169,2,2006,1,1,'Littérature',100,'fr_FR','2166');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (169,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (169,2,2007,0,1,'1393',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (169,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (169,2,2006,2,1,'Littérature',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (170,2,2001,1,1,'Livre',130,'fr_FR','1395');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (170,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (170,2,2006,1,1,'Livre',100,'fr_FR','1596');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (170,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (170,2,2007,0,1,'1394',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (170,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (170,2,2006,2,1,'Livre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (171,2,2001,1,1,'Mobilier et objets d\'art',130,'fr_FR','1396');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (171,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (171,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (171,2,2007,0,1,'1395',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (171,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (172,2,2001,1,1,'Musées',130,'fr_FR','1397');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (172,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (172,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (172,2,2007,0,1,'1396',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (172,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (173,2,2001,1,1,'Musique',130,'fr_FR','1398');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (173,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (173,2,2006,1,1,'Musique',100,'fr_FR','1597');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (173,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (173,2,2007,0,1,'1397',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (173,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (173,2,2006,2,1,'Musique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (174,2,2001,1,1,'Peinture',130,'fr_FR','1399');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (174,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (174,2,2006,1,1,'Peinture et sculpture',100,'fr_FR','1592');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (174,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (174,2,2007,0,1,'1398',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (174,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (174,2,2006,2,1,'Peinture et sculpture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (175,2,2001,1,1,'Photographie',130,'fr_FR','1400');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (175,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (175,2,2006,1,1,'Photographie',100,'fr_FR','1601');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (175,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (175,2,2007,0,1,'1399',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (175,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (175,2,2006,2,1,'Photographie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (176,2,2001,1,1,'Sculpture',130,'fr_FR','1401');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (176,2,2004,1,1,'Art et culture',110,'fr_FR','1378');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (176,2,2006,1,1,'Peinture et sculpture',100,'fr_FR','1592');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (176,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (176,2,2007,0,1,'1400',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (176,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (176,2,2006,2,1,'Peinture et sculpture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (177,2,2001,1,1,'Architectes',130,'fr_FR','1402');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (177,2,2004,1,1,'Architecture',110,'fr_FR','1390');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (177,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (177,2,2007,0,1,'1401',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (177,2,2004,2,1,'Architecture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (178,2,2001,1,1,'Moyen-Age',130,'fr_FR','1403');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (178,2,2004,1,1,'Histoire',110,'fr_FR','1408');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (178,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (178,2,2007,0,1,'1402',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (178,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (179,2,2001,1,1,'Ecoles et styles',130,'fr_FR','1404');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (179,2,2004,1,1,'Architecture',110,'fr_FR','1390');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (179,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (179,2,2007,0,1,'1403',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (179,2,2004,2,1,'Architecture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (180,2,2001,1,1,'Edifices',130,'fr_FR','1405');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (180,2,2004,1,1,'Architecture',110,'fr_FR','1390');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (180,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (180,2,2007,0,1,'1404',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (180,2,2004,2,1,'Architecture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (181,2,2001,1,1,'Géographie',130,'fr_FR','1406');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (181,2,2004,1,1,'Architecture',110,'fr_FR','1390');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (181,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (181,2,2007,0,1,'1405',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (181,2,2004,2,1,'Architecture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (182,2,2001,1,1,'XIXème siècle',130,'fr_FR','1407');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (182,2,2004,1,1,'Histoire',110,'fr_FR','1408');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (182,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (182,2,2007,0,1,'1406',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (182,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (183,2,2001,1,1,'Histoire',130,'fr_FR','1408');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (183,2,2004,1,1,'Architecture',110,'fr_FR','1390');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (183,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (183,2,2007,0,1,'1407',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (183,2,2004,2,1,'Architecture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (184,2,2001,1,1,'XXème siècle',130,'fr_FR','1409');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (184,2,2004,1,1,'Histoire',110,'fr_FR','1408');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (184,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (184,2,2007,0,1,'1408',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (184,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (185,2,2001,1,1,'Afrique',130,'fr_FR','1410');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (185,2,2004,1,1,'Géographie',110,'fr_FR','1406');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (185,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (185,2,2007,0,1,'1409',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (185,2,2004,2,1,'Géographie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (186,2,2001,1,1,'Récit historique',130,'fr_FR','1411');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (186,2,2004,1,1,'Bande dessinée',110,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (186,2,2006,1,1,'Récit historique',100,'fr_FR','2105');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (186,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (186,2,2007,0,1,'1410',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (186,2,2004,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (186,2,2006,2,1,'Récit historique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (187,2,2001,1,1,'Heroic fantasy',130,'fr_FR','1412');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (187,2,2004,1,1,'Bande dessinée',110,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (187,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (187,2,2007,0,1,'1411',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (187,2,2004,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (188,2,2001,1,1,'Fantastique',130,'fr_FR','1413');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (188,2,2004,1,1,'Bande dessinée',110,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (188,2,2006,1,1,'Fantastique',100,'fr_FR','2106');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (188,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (188,2,2007,0,1,'1412',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (188,2,2004,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (188,2,2006,2,1,'Fantastique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (189,2,2001,1,1,'Science-fiction',130,'fr_FR','1414');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (189,2,2004,1,1,'Bande dessinée',110,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (189,2,2006,1,1,'Science-fiction',100,'fr_FR','2104');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (189,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (189,2,2007,0,1,'1413',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (189,2,2004,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (189,2,2006,2,1,'Science-fiction',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (190,2,2001,1,1,'Policier',130,'fr_FR','1415');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (190,2,2004,1,1,'Bande dessinée',110,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (190,2,2006,1,1,'Policier',100,'fr_FR','2103');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (190,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (190,2,2007,0,1,'1414',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (190,2,2004,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (190,2,2006,2,1,'Policier',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (191,2,2001,1,1,'Humour',130,'fr_FR','1416');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (191,2,2004,1,1,'Bande dessinée',110,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (191,2,2006,1,1,'Humour',100,'fr_FR','2102');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (191,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (191,2,2007,0,1,'1415',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (191,2,2004,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (191,2,2006,2,1,'Humour',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (192,2,2001,1,1,'Aventure',130,'fr_FR','1417');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (192,2,2004,1,1,'Bande dessinée',110,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (192,2,2006,1,1,'Aventure',100,'fr_FR','2101');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (192,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (192,2,2007,0,1,'1416',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (192,2,2004,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (192,2,2006,2,1,'Aventure',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (193,2,2001,1,1,'Manga',130,'fr_FR','1418');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (193,2,2004,1,1,'Bande dessinée',110,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (193,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (193,2,2007,0,1,'1417',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (193,2,2004,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (194,2,2001,1,1,'Réalité',130,'fr_FR','1419');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (194,2,2004,1,1,'Bande dessinée',110,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (194,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (194,2,2007,0,1,'1418',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (194,2,2004,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (195,2,2001,1,1,'Par genre (sélection)',130,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (195,2,2004,1,1,'Littérature',110,'fr_FR','1394');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (195,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (195,2,2007,0,1,'1419',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (195,2,2004,2,1,'Littérature',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (196,2,2001,1,1,'Antiquité grecque et romaine',130,'fr_FR','1421');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (196,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (196,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (196,2,2007,0,1,'1420',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (196,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (197,2,2001,1,1,'Moyen-Age',130,'fr_FR','1422');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (197,2,2004,1,1,'Littérature française',110,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (197,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (197,2,2007,0,1,'1421',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (197,2,2004,2,1,'Littérature française',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (198,2,2001,1,1,'Renaissance',130,'fr_FR','1423');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (198,2,2004,1,1,'Littérature française',110,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (198,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (198,2,2007,0,1,'1422',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (198,2,2004,2,1,'Littérature française',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (199,2,2001,1,1,'XVIIème siècle',130,'fr_FR','1424');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (199,2,2004,1,1,'Littérature française',110,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (199,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (199,2,2007,0,1,'1423',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (199,2,2004,2,1,'Littérature française',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (200,2,2001,1,1,'XVIIIème siècle',130,'fr_FR','1425');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (200,2,2004,1,1,'Littérature française',110,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (200,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (200,2,2007,0,1,'1424',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (200,2,2004,2,1,'Littérature française',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (201,2,2001,1,1,'De 1800 à 1849',130,'fr_FR','1426');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (201,2,2004,1,1,'Littérature française',110,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (201,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (201,2,2007,0,1,'1425',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (201,2,2004,2,1,'Littérature française',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (202,2,2001,1,1,'De 1850 à 1899',130,'fr_FR','1427');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (202,2,2004,1,1,'Littérature française',110,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (202,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (202,2,2007,0,1,'1426',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (202,2,2004,2,1,'Littérature française',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (203,2,2001,1,1,'De 1900 à 1949',130,'fr_FR','1428');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (203,2,2004,1,1,'Littérature française',110,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (203,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (203,2,2007,0,1,'1427',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (203,2,2004,2,1,'Littérature française',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (204,2,2001,1,1,'De 1950 à 1999 (sélection)',130,'fr_FR','1429');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (204,2,2004,1,1,'Littérature française',110,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (204,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (204,2,2007,0,1,'1428',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (204,2,2004,2,1,'Littérature française',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (205,2,2001,1,1,'De 2000 à aujourd\'hui (sélection)',130,'fr_FR','1430');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (205,2,2004,1,1,'Littérature française',110,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (205,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (205,2,2007,0,1,'1429',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (205,2,2004,2,1,'Littérature française',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (206,2,2001,1,1,'Roman historique',130,'fr_FR','1431');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (206,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (206,2,2006,1,1,'Roman historique',100,'fr_FR','2058');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (206,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (206,2,2007,0,1,'1430',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (206,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (206,2,2006,2,1,'Roman historique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (207,2,2001,1,1,'Récits de voyage et d\'exploration',130,'fr_FR','1432');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (207,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (207,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (207,2,2007,0,1,'1431',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (207,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (208,2,2001,1,1,'Fantastique et merveilleux',130,'fr_FR','1433');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (208,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (208,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (208,2,2007,0,1,'1432',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (208,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (209,2,2001,1,1,'Roman policier',130,'fr_FR','1434');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (209,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (209,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (209,2,2007,0,1,'1433',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (209,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (210,2,2001,1,1,'Science-fiction',130,'fr_FR','1435');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (210,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (210,2,2006,1,1,'Science-fiction',100,'fr_FR','2060');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (210,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (210,2,2007,0,1,'1434',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (210,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (210,2,2006,2,1,'Science-fiction',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (211,2,2001,1,1,'Nouvelles',130,'fr_FR','1436');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (211,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (211,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (211,2,2007,0,1,'1435',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (211,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (212,2,2001,1,1,'Littérature en miettes',130,'fr_FR','1437');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (212,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (212,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (212,2,2007,0,1,'1436',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (212,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (213,2,2001,1,1,'Distorsions',130,'fr_FR','1438');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (213,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (213,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (213,2,2007,0,1,'1437',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (213,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (214,2,2001,1,1,'Mémoires et autobiographies',130,'fr_FR','1439');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (214,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (214,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (214,2,2007,0,1,'1438',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (214,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (215,2,2001,1,1,'Journaux et carnets',130,'fr_FR','1440');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (215,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (215,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (215,2,2007,0,1,'1439',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (215,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (216,2,2001,1,1,'Correspondance',130,'fr_FR','1441');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (216,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (216,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (216,2,2007,0,1,'1440',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (216,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (217,2,2001,1,1,'Littérature asiatique',130,'fr_FR','1442');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (217,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (217,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (217,2,2007,0,1,'1441',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (217,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (218,2,2001,1,1,'L\'écrivain et son oeuvre',130,'fr_FR','1443');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (218,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (218,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (218,2,2007,0,1,'1442',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (218,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (219,2,2001,1,1,'Le livre comme miroir',130,'fr_FR','1444');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (219,2,2004,1,1,'Par genre (sélection)',110,'fr_FR','1420');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (219,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (219,2,2007,0,1,'1443',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (219,2,2004,2,1,'Par genre (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (220,2,2001,1,1,'Littérature américaine',130,'fr_FR','1445');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (220,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (220,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (220,2,2007,0,1,'1444',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (220,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (221,2,2001,1,1,'Poésie',130,'fr_FR','1446');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (221,2,2004,1,1,'Moyen-Age',110,'fr_FR','1422');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (221,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (221,2,2007,0,1,'1445',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (221,2,2004,2,1,'Moyen-Age',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (222,2,2001,1,1,'Poésie',130,'fr_FR','1447');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (222,2,2004,1,1,'Renaissance',110,'fr_FR','1423');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (222,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (222,2,2007,0,1,'1446',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (222,2,2004,2,1,'Renaissance',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (223,2,2001,1,1,'Poésie',130,'fr_FR','1448');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (223,2,2004,1,1,'XVIIème siècle',110,'fr_FR','1424');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (223,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (223,2,2007,0,1,'1447',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (223,2,2004,2,1,'XVIIème siècle',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (224,2,2001,1,1,'Poésie',130,'fr_FR','1449');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (224,2,2004,1,1,'XVIIIème siècle',110,'fr_FR','1425');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (224,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (224,2,2007,0,1,'1448',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (224,2,2004,2,1,'XVIIIème siècle',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (225,2,2001,1,1,'Poésie',130,'fr_FR','1450');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (225,2,2004,1,1,'De 1800 à 1849',110,'fr_FR','1426');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (225,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (225,2,2007,0,1,'1449',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (225,2,2004,2,1,'De 1800 à 1849',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (226,2,2001,1,1,'Poésie',130,'fr_FR','1451');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (226,2,2004,1,1,'De 1850 à 1899',110,'fr_FR','1427');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (226,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (226,2,2007,0,1,'1450',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (226,2,2004,2,1,'De 1850 à 1899',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (227,2,2001,1,1,'Poésie',130,'fr_FR','1452');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (227,2,2004,1,1,'De 1900 à 1949',110,'fr_FR','1428');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (227,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (227,2,2007,0,1,'1451',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (227,2,2004,2,1,'De 1900 à 1949',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (228,2,2001,1,1,'Poésie',130,'fr_FR','1453');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (228,2,2004,1,1,'De 1950 à 1999 (sélection)',110,'fr_FR','1429');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (228,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (228,2,2007,0,1,'1452',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (228,2,2004,2,1,'De 1950 à 1999 (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (229,2,2001,1,1,'Poésie',130,'fr_FR','1454');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (229,2,2004,1,1,'De 2000 à aujourd\'hui (sélection)',110,'fr_FR','1430');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (229,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (229,2,2007,0,1,'1453',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (229,2,2004,2,1,'De 2000 à aujourd\'hui (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (230,2,2001,1,1,'Littérature hispano-américaine',130,'fr_FR','1455');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (230,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (230,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (230,2,2007,0,1,'1454',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (230,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (231,2,2001,1,1,'Théâtre',130,'fr_FR','1456');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (231,2,2004,1,1,'Moyen-Age',110,'fr_FR','1422');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (231,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (231,2,2007,0,1,'1455',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (231,2,2004,2,1,'Moyen-Age',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (232,2,2001,1,1,'Théâtre',130,'fr_FR','1457');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (232,2,2004,1,1,'Renaissance',110,'fr_FR','1423');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (232,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (232,2,2007,0,1,'1456',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (232,2,2004,2,1,'Renaissance',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (233,2,2001,1,1,'Théâtre',130,'fr_FR','1458');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (233,2,2004,1,1,'XVIIème siècle',110,'fr_FR','1424');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (233,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (233,2,2007,0,1,'1457',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (233,2,2004,2,1,'XVIIème siècle',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (234,2,2001,1,1,'Théâtre',130,'fr_FR','1459');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (234,2,2004,1,1,'XVIIIème siècle',110,'fr_FR','1425');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (234,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (234,2,2007,0,1,'1458',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (234,2,2004,2,1,'XVIIIème siècle',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (235,2,2001,1,1,'Théâtre',130,'fr_FR','1460');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (235,2,2004,1,1,'De 1800 à 1849',110,'fr_FR','1426');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (235,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (235,2,2007,0,1,'1459',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (235,2,2004,2,1,'De 1800 à 1849',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (236,2,2001,1,1,'Théâtre',130,'fr_FR','1461');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (236,2,2004,1,1,'De 1850 à 1899',110,'fr_FR','1427');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (236,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (236,2,2007,0,1,'1460',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (236,2,2004,2,1,'De 1850 à 1899',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (237,2,2001,1,1,'Théâtre',130,'fr_FR','1462');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (237,2,2004,1,1,'De 1900 à 1949',110,'fr_FR','1428');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (237,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (237,2,2007,0,1,'1461',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (237,2,2004,2,1,'De 1900 à 1949',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (238,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','1463');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (238,2,2004,1,1,'De 1900 à 1949',110,'fr_FR','1428');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (238,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (238,2,2007,0,1,'1462',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (238,2,2004,2,1,'De 1900 à 1949',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (239,2,2001,1,1,'Théâtre',130,'fr_FR','1464');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (239,2,2004,1,1,'De 1950 à 1999 (sélection)',110,'fr_FR','1429');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (239,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (239,2,2007,0,1,'1463',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (239,2,2004,2,1,'De 1950 à 1999 (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (240,2,2001,1,1,'Théâtre',130,'fr_FR','1465');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (240,2,2004,1,1,'De 2000 à aujourd\'hui (sélection)',110,'fr_FR','1430');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (240,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (240,2,2007,0,1,'1464',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (240,2,2004,2,1,'De 2000 à aujourd\'hui (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (241,2,2001,1,1,'Littérature allemande',130,'fr_FR','1466');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (241,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (241,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (241,2,2007,0,1,'1465',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (241,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (242,2,2001,1,1,'Critique littéraire - Biographies',130,'fr_FR','1467');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (242,2,2004,1,1,'Moyen-Age',110,'fr_FR','1422');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (242,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (242,2,2007,0,1,'1466',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (242,2,2004,2,1,'Moyen-Age',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (243,2,2001,1,1,'Critique littéraire - Biographies',130,'fr_FR','1468');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (243,2,2004,1,1,'Renaissance',110,'fr_FR','1423');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (243,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (243,2,2007,0,1,'1467',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (243,2,2004,2,1,'Renaissance',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (244,2,2001,1,1,'Critique littéraire - Biographies',130,'fr_FR','1469');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (244,2,2004,1,1,'XVIIème siècle',110,'fr_FR','1424');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (244,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (244,2,2007,0,1,'1468',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (244,2,2004,2,1,'XVIIème siècle',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (245,2,2001,1,1,'Critique littéraire - Biographies',130,'fr_FR','1470');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (245,2,2004,1,1,'XVIIIème siècle',110,'fr_FR','1425');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (245,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (245,2,2007,0,1,'1469',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (245,2,2004,2,1,'XVIIIème siècle',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (246,2,2001,1,1,'Critique littéraire - Biographies',130,'fr_FR','1471');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (246,2,2004,1,1,'De 1800 à 1849',110,'fr_FR','1426');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (246,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (246,2,2007,0,1,'1470',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (246,2,2004,2,1,'De 1800 à 1849',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (247,2,2001,1,1,'Critique littéraire - Biographies',130,'fr_FR','1472');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (247,2,2004,1,1,'De 1850 à 1899',110,'fr_FR','1427');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (247,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (247,2,2007,0,1,'1471',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (247,2,2004,2,1,'De 1850 à 1899',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (248,2,2001,1,1,'Critique littéraire - Biographies',130,'fr_FR','1473');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (248,2,2004,1,1,'De 1950 à 1999 (sélection)',110,'fr_FR','1429');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (248,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (248,2,2007,0,1,'1472',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (248,2,2004,2,1,'De 1950 à 1999 (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (249,2,2001,1,1,'Critique littéraire - Biographies',130,'fr_FR','1474');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (249,2,2004,1,1,'De 1900 à 1949',110,'fr_FR','1428');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (249,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (249,2,2007,0,1,'1473',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (249,2,2004,2,1,'De 1900 à 1949',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (250,2,2001,1,1,'Critique littéraire - Biographies',130,'fr_FR','1475');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (250,2,2004,1,1,'De 2000 à aujourd\'hui (sélection)',110,'fr_FR','1430');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (250,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (250,2,2007,0,1,'1474',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (250,2,2004,2,1,'De 2000 à aujourd\'hui (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (251,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','1476');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (251,2,2004,1,1,'De 1800 à 1849',110,'fr_FR','1426');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (251,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (251,2,2007,0,1,'1475',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (251,2,2004,2,1,'De 1800 à 1849',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (252,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','1477');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (252,2,2004,1,1,'De 1850 à 1899',110,'fr_FR','1427');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (252,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (252,2,2007,0,1,'1476',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (252,2,2004,2,1,'De 1850 à 1899',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (253,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','1478');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (253,2,2004,1,1,'De 1950 à 1999 (sélection)',110,'fr_FR','1429');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (253,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (253,2,2007,0,1,'1477',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (253,2,2004,2,1,'De 1950 à 1999 (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (254,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','1479');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (254,2,2004,1,1,'De 2000 à aujourd\'hui (sélection)',110,'fr_FR','1430');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (254,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (254,2,2007,0,1,'1478',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (254,2,2004,2,1,'De 2000 à aujourd\'hui (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (255,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','1480');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (255,2,2004,1,1,'Moyen-Age',110,'fr_FR','1422');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (255,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (255,2,2007,0,1,'1479',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (255,2,2004,2,1,'Moyen-Age',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (256,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','1481');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (256,2,2004,1,1,'Renaissance',110,'fr_FR','1423');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (256,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (256,2,2007,0,1,'1480',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (256,2,2004,2,1,'Renaissance',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (257,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','1482');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (257,2,2004,1,1,'XVIIème siècle',110,'fr_FR','1424');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (257,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (257,2,2007,0,1,'1481',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (257,2,2004,2,1,'XVIIème siècle',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (258,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','1483');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (258,2,2004,1,1,'XVIIIème siècle',110,'fr_FR','1425');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (258,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (258,2,2007,0,1,'1482',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (258,2,2004,2,1,'XVIIIème siècle',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (259,2,2001,1,1,'Antiquité',130,'fr_FR','1484');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (259,2,2004,1,1,'Histoire',110,'fr_FR','2160');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (259,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (259,2,2007,0,1,'1483',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (259,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (260,2,2001,1,1,'Moyen-Age',130,'fr_FR','1485');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (260,2,2004,1,1,'Histoire',110,'fr_FR','2160');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (260,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (260,2,2007,0,1,'1484',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (260,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (261,2,2001,1,1,'Renaissance',130,'fr_FR','1486');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (261,2,2004,1,1,'Histoire',110,'fr_FR','2160');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (261,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (261,2,2007,0,1,'1485',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (261,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (262,2,2001,1,1,'XVIIème siècle',130,'fr_FR','1487');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (262,2,2004,1,1,'Histoire',110,'fr_FR','2160');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (262,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (262,2,2007,0,1,'1486',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (262,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (263,2,2001,1,1,'XVIIIème siècle',130,'fr_FR','1488');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (263,2,2004,1,1,'Histoire',110,'fr_FR','2160');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (263,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (263,2,2007,0,1,'1487',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (263,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (264,2,2001,1,1,'XIXème siècle',130,'fr_FR','1489');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (264,2,2004,1,1,'Histoire',110,'fr_FR','2160');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (264,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (264,2,2007,0,1,'1488',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (264,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (265,2,2001,1,1,'XXème siècle',130,'fr_FR','1490');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (265,2,2004,1,1,'Histoire',110,'fr_FR','2160');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (265,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (265,2,2007,0,1,'1489',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (265,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (266,2,2001,1,1,'Par sujet',130,'fr_FR','1492');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (266,2,2004,1,1,'Peinture',110,'fr_FR','1399');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (266,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (266,2,2007,0,1,'1491',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (266,2,2004,2,1,'Peinture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (267,2,2001,1,1,'Biographies',130,'fr_FR','1493');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (267,2,2004,1,1,'Institutions et politique',110,'fr_FR','1379');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (267,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (267,2,2007,0,1,'1492',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (267,2,2004,2,1,'Institutions et politique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (268,2,2001,1,1,'Essais politiques',130,'fr_FR','1494');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (268,2,2004,1,1,'Institutions et politique',110,'fr_FR','1379');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (268,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (268,2,2007,0,1,'1493',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (268,2,2004,2,1,'Institutions et politique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (269,2,2001,1,1,'France',130,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (269,2,2004,1,1,'Institutions et politique',110,'fr_FR','1379');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (269,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (269,2,2007,0,1,'1494',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (269,2,2004,2,1,'Institutions et politique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (270,2,2001,1,1,'Europe',130,'fr_FR','1496');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (270,2,2004,1,1,'Institutions et politique',110,'fr_FR','1379');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (270,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (270,2,2007,0,1,'1495',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (270,2,2004,2,1,'Institutions et politique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (271,2,2001,1,1,'Monde',130,'fr_FR','1497');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (271,2,2004,1,1,'Institutions et politique',110,'fr_FR','1379');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (271,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (271,2,2007,0,1,'1496',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (271,2,2004,2,1,'Institutions et politique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (272,2,2001,1,1,'Science politique',130,'fr_FR','1498');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (272,2,2004,1,1,'Institutions et politique',110,'fr_FR','1379');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (272,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (272,2,2007,0,1,'1497',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (272,2,2004,2,1,'Institutions et politique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (273,2,2001,1,1,'Administration',130,'fr_FR','1499');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (273,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (273,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (273,2,2007,0,1,'1498',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (273,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (274,2,2001,1,1,'Citoyenneté',130,'fr_FR','1500');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (274,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (274,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (274,2,2007,0,1,'1499',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (274,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (275,2,2001,1,1,'Président et gouvernement',130,'fr_FR','1501');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (275,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (275,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (275,2,2007,0,1,'1500',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (275,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (276,2,2001,1,1,'Parlement',130,'fr_FR','1502');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (276,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (276,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (276,2,2007,0,1,'1501',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (276,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (277,2,2001,1,1,'Justice',130,'fr_FR','1503');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (277,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (277,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (277,2,2007,0,1,'1502',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (277,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (278,2,2001,1,1,'Collectivités territoriales',130,'fr_FR','1504');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (278,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (278,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (278,2,2007,0,1,'1503',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (278,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (279,2,2001,1,1,'Défense nationale - Sécurité publique',130,'fr_FR','1505');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (279,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (279,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (279,2,2007,0,1,'1504',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (279,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (280,2,2001,1,1,'Droit',130,'fr_FR','1506');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (280,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (280,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (280,2,2007,0,1,'1505',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (280,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (281,2,2001,1,1,'Elections',130,'fr_FR','1507');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (281,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (281,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (281,2,2007,0,1,'1506',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (281,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (282,2,2001,1,1,'Fiscalité',130,'fr_FR','1508');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (282,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (282,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (282,2,2007,0,1,'1507',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (282,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (283,2,2001,1,1,'Partis politiques',130,'fr_FR','1509');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (283,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (283,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (283,2,2007,0,1,'1508',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (283,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (284,2,2001,1,1,'Protection sociale',130,'fr_FR','1510');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (284,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (284,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (284,2,2007,0,1,'1509',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (284,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (285,2,2001,1,1,'Syndicats',130,'fr_FR','1511');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (285,2,2004,1,1,'France',110,'fr_FR','1495');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (285,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (285,2,2007,0,1,'1510',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (285,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (286,2,2001,1,1,'Mondialisation',130,'fr_FR','1512');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (286,2,2004,1,1,'Monde',110,'fr_FR','1497');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (286,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (286,2,2007,0,1,'1511',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (286,2,2004,2,1,'Monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (287,2,2001,1,1,'Organisations internationales',130,'fr_FR','1513');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (287,2,2004,1,1,'Monde',110,'fr_FR','1497');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (287,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (287,2,2007,0,1,'1512',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (287,2,2004,2,1,'Monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (288,2,2001,1,1,'Relations internationales',130,'fr_FR','1514');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (288,2,2004,1,1,'Monde',110,'fr_FR','1497');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (288,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (288,2,2007,0,1,'1513',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (288,2,2004,2,1,'Monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (289,2,2001,1,1,'Animaux',130,'fr_FR','1515');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (289,2,2004,1,1,'Jeunesse',110,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (289,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (289,2,2007,0,1,'1514',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (289,2,2004,2,1,'Jeunesse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (290,2,2001,1,1,'Corps et santé',130,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (290,2,2004,1,1,'Jeunesse',110,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (290,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (290,2,2007,0,1,'1515',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (290,2,2004,2,1,'Jeunesse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (291,2,2001,1,1,'Découvrir le monde',130,'fr_FR','1517');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (291,2,2004,1,1,'Jeunesse',110,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (291,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (291,2,2007,0,1,'1516',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (291,2,2004,2,1,'Jeunesse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (292,2,2001,1,1,'Eveil et apprentissage',130,'fr_FR','1518');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (292,2,2004,1,1,'Jeunesse',110,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (292,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (292,2,2007,0,1,'1517',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (292,2,2004,2,1,'Jeunesse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (293,2,2001,1,1,'Sports et loisirs',130,'fr_FR','1519');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (293,2,2004,1,1,'Jeunesse',110,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (293,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (293,2,2007,0,1,'1518',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (293,2,2004,2,1,'Jeunesse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (294,2,2001,1,1,'Nature et environnement',130,'fr_FR','1520');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (294,2,2004,1,1,'Jeunesse',110,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (294,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (294,2,2007,0,1,'1519',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (294,2,2004,2,1,'Jeunesse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (295,2,2001,1,1,'Personnages extraordinaires et mondes imaginaires',130,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (295,2,2004,1,1,'Jeunesse',110,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (295,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (295,2,2007,0,1,'1520',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (295,2,2004,2,1,'Jeunesse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (296,2,2001,1,1,'Art et culture',130,'fr_FR','1522');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (296,2,2004,1,1,'Jeunesse',110,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (296,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (296,2,2007,0,1,'1521',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (296,2,2004,2,1,'Jeunesse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (297,2,2001,1,1,'Vivre ensemble',130,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (297,2,2004,1,1,'Jeunesse',110,'fr_FR','1380');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (297,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (297,2,2007,0,1,'1522',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (297,2,2004,2,1,'Jeunesse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (298,2,2001,1,1,'Chat',130,'fr_FR','1524');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (298,2,2004,1,1,'Mammifères',110,'fr_FR','1525');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (298,2,2005,1,1,'Chat',100,'fr_FR','1641');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (298,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (298,2,2007,0,1,'1523',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (298,2,2004,2,1,'Mammifères',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (298,2,2005,2,1,'Chat',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (299,2,2001,1,1,'Mammifères',130,'fr_FR','1525');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (299,2,2004,1,1,'Animaux',110,'fr_FR','1515');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (299,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (299,2,2007,0,1,'1524',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (299,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (300,2,2001,1,1,'Par environnement',130,'fr_FR','1526');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (300,2,2004,1,1,'Animaux',110,'fr_FR','1515');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (300,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (300,2,2007,0,1,'1525',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (300,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (301,2,2001,1,1,'Champs',130,'fr_FR','1527');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (301,2,2004,1,1,'Par environnement',110,'fr_FR','1526');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (301,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (301,2,2007,0,1,'1526',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (301,2,2004,2,1,'Par environnement',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (302,2,2001,1,1,'Forêt',130,'fr_FR','1528');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (302,2,2004,1,1,'Par environnement',110,'fr_FR','1526');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (302,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (302,2,2007,0,1,'1527',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (302,2,2004,2,1,'Par environnement',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (303,2,2001,1,1,'Montagne',130,'fr_FR','1529');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (303,2,2004,1,1,'Par environnement',110,'fr_FR','1526');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (303,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (303,2,2007,0,1,'1528',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (303,2,2004,2,1,'Par environnement',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (304,2,2001,1,1,'Jungle',130,'fr_FR','1530');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (304,2,2004,1,1,'Par environnement',110,'fr_FR','1526');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (304,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (304,2,2007,0,1,'1529',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (304,2,2004,2,1,'Par environnement',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (305,2,2001,1,1,'Poissons',130,'fr_FR','1531');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (305,2,2004,1,1,'Animaux',110,'fr_FR','1515');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (305,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (305,2,2007,0,1,'1530',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (305,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (306,2,2001,1,1,'Insectes',130,'fr_FR','1532');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (306,2,2004,1,1,'Animaux',110,'fr_FR','1515');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (306,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (306,2,2007,0,1,'1531',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (306,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (307,2,2001,1,1,'Oiseaux',130,'fr_FR','1533');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (307,2,2004,1,1,'Animaux',110,'fr_FR','1515');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (307,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (307,2,2007,0,1,'1532',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (307,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (308,2,2001,1,1,'Animaux menacés',130,'fr_FR','1534');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (308,2,2004,1,1,'Animaux',110,'fr_FR','1515');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (308,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (308,2,2007,0,1,'1533',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (308,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (309,2,2001,1,1,'Dinosaures',130,'fr_FR','1535');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (309,2,2004,1,1,'Animaux',110,'fr_FR','1515');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (309,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (309,2,2007,0,1,'1534',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (309,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (310,2,2001,1,1,'Corps',130,'fr_FR','1536');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (310,2,2004,1,1,'Corps et santé',110,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (310,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (310,2,2007,0,1,'1535',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (310,2,2004,2,1,'Corps et santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (311,2,2001,1,1,'Hygiène et santé',130,'fr_FR','1537');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (311,2,2004,1,1,'Corps et santé',110,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (311,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (311,2,2007,0,1,'1536',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (311,2,2004,2,1,'Corps et santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (312,2,2001,1,1,'Nourriture',130,'fr_FR','1538');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (312,2,2004,1,1,'Corps et santé',110,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (312,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (312,2,2007,0,1,'1537',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (312,2,2004,2,1,'Corps et santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (313,2,2001,1,1,'Vêtement et coiffure',130,'fr_FR','1539');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (313,2,2004,1,1,'Corps et santé',110,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (313,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (313,2,2007,0,1,'1538',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (313,2,2004,2,1,'Corps et santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (314,2,2001,1,1,'Avoir un bébé',130,'fr_FR','1540');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (314,2,2004,1,1,'Corps et santé',110,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (314,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (314,2,2007,0,1,'1539',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (314,2,2004,2,1,'Corps et santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (315,2,2001,1,1,'Maladie',130,'fr_FR','1541');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (315,2,2004,1,1,'Corps et santé',110,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (315,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (315,2,2007,0,1,'1540',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (315,2,2004,2,1,'Corps et santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (316,2,2001,1,1,'Handicap',130,'fr_FR','1542');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (316,2,2004,1,1,'Corps et santé',110,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (316,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (316,2,2007,0,1,'1541',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (316,2,2004,2,1,'Corps et santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (317,2,2001,1,1,'Médecin et hôpital',130,'fr_FR','1543');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (317,2,2004,1,1,'Corps et santé',110,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (317,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (317,2,2007,0,1,'1542',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (317,2,2004,2,1,'Corps et santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (318,2,2001,1,1,'Sexualité',130,'fr_FR','1544');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (318,2,2004,1,1,'Corps et santé',110,'fr_FR','1516');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (318,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (318,2,2007,0,1,'1543',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (318,2,2004,2,1,'Corps et santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (319,2,2001,1,1,'Voyage',130,'fr_FR','1545');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (319,2,2004,1,1,'Découvrir le monde',110,'fr_FR','1517');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (319,2,2006,1,1,'Retraite',100,'fr_FR','2491');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (319,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (319,2,2007,0,1,'1544',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (319,2,2004,2,1,'Découvrir le monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (319,2,2006,2,1,'Retraite',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (320,2,2001,1,1,'Transports',130,'fr_FR','1546');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (320,2,2004,1,1,'Découvrir le monde',110,'fr_FR','1517');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (320,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (320,2,2007,0,1,'1545',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (320,2,2004,2,1,'Découvrir le monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (321,2,2001,1,1,'Communiquer - S\'informer',130,'fr_FR','1547');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (321,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (321,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (321,2,2007,0,1,'1546',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (321,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (322,2,2001,1,1,'Géographie',130,'fr_FR','1548');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (322,2,2004,1,1,'Découvrir le monde',110,'fr_FR','1517');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (322,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (322,2,2007,0,1,'1547',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (322,2,2004,2,1,'Découvrir le monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (323,2,2001,1,1,'Préhistoire',130,'fr_FR','1549');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (323,2,2004,1,1,'Découvrir le monde',110,'fr_FR','1517');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (323,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (323,2,2007,0,1,'1548',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (323,2,2004,2,1,'Découvrir le monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (324,2,2001,1,1,'Amérique',130,'fr_FR','1550');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (324,2,2004,1,1,'Histoire',110,'fr_FR','1551');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (324,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (324,2,2007,0,1,'1549',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (324,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (325,2,2001,1,1,'Histoire',130,'fr_FR','1551');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (325,2,2004,1,1,'Découvrir le monde',110,'fr_FR','1517');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (325,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (325,2,2007,0,1,'1550',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (325,2,2004,2,1,'Découvrir le monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (326,2,2001,1,1,'Science et expériences',130,'fr_FR','1552');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (326,2,2004,1,1,'Découvrir le monde',110,'fr_FR','1517');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (326,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (326,2,2007,0,1,'1551',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (326,2,2004,2,1,'Découvrir le monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (327,2,2001,1,1,'Espace - Planètes',130,'fr_FR','1553');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (327,2,2004,1,1,'Découvrir le monde',110,'fr_FR','1517');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (327,2,2006,1,1,'Astronomie',100,'fr_FR','1612');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (327,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (327,2,2007,0,1,'1552',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (327,2,2004,2,1,'Découvrir le monde',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (327,2,2006,2,1,'Astronomie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (328,2,2001,1,1,'Premiers acquis',130,'fr_FR','1554');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (328,2,2004,1,1,'Eveil et apprentissage',110,'fr_FR','1518');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (328,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (328,2,2007,0,1,'1553',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (328,2,2004,2,1,'Eveil et apprentissage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (329,2,2001,1,1,'Autour du langage',130,'fr_FR','1555');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (329,2,2004,1,1,'Eveil et apprentissage',110,'fr_FR','1518');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (329,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (329,2,2007,0,1,'1554',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (329,2,2004,2,1,'Eveil et apprentissage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (330,2,2001,1,1,'Vers l\'autonomie',130,'fr_FR','1556');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (330,2,2004,1,1,'Eveil et apprentissage',110,'fr_FR','1518');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (330,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (330,2,2007,0,1,'1555',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (330,2,2004,2,1,'Eveil et apprentissage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (331,2,2001,1,1,'Langues étrangères',130,'fr_FR','1557');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (331,2,2004,1,1,'Eveil et apprentissage',110,'fr_FR','1518');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (331,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (331,2,2007,0,1,'1556',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (331,2,2004,2,1,'Eveil et apprentissage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (332,2,2001,1,1,'Informatique',130,'fr_FR','1558');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (332,2,2004,1,1,'Eveil et apprentissage',110,'fr_FR','1518');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (332,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (332,2,2007,0,1,'1557',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (332,2,2004,2,1,'Eveil et apprentissage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (333,2,2001,1,1,'Activités manuelles',130,'fr_FR','1559');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (333,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1519');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (333,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (333,2,2007,0,1,'1558',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (333,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (334,2,2001,1,1,'Cuisine',130,'fr_FR','1560');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (334,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1519');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (334,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (334,2,2007,0,1,'1559',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (334,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (335,2,2001,1,1,'Jardinage',130,'fr_FR','1561');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (335,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1519');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (335,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (335,2,2007,0,1,'1560',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (335,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (336,2,2001,1,1,'Sport',130,'fr_FR','1562');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (336,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1519');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (336,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (336,2,2007,0,1,'1561',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (336,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (337,2,2001,1,1,'Jeux et jouets',130,'fr_FR','1563');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (337,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1519');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (337,2,2006,1,1,'Echecs',100,'fr_FR','2493');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (337,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (337,2,2007,0,1,'1562',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (337,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (337,2,2006,2,1,'Echecs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (338,2,2001,1,1,'Déguisements',130,'fr_FR','1564');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (338,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1519');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (338,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (338,2,2007,0,1,'1563',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (338,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (339,2,2001,1,1,'Dessin et peinture',130,'fr_FR','1565');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (339,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1519');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (339,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (339,2,2007,0,1,'1564',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (339,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (340,2,2001,1,1,'Enigmes et devinettes',130,'fr_FR','1566');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (340,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1519');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (340,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (340,2,2007,0,1,'1565',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (340,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (341,2,2001,1,1,'Adjectif',130,'fr_FR','1567');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (341,2,2004,1,1,'Autour du langage',110,'fr_FR','1555');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (341,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (341,2,2007,0,1,'1566',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (341,2,2004,2,1,'Autour du langage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (342,2,2001,1,1,'Campagne',130,'fr_FR','1568');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (342,2,2004,1,1,'Paysage',110,'fr_FR','2167');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (342,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (342,2,2007,0,1,'1567',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (342,2,2004,2,1,'Paysage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (343,2,2001,1,1,'Montagne',130,'fr_FR','1569');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (343,2,2004,1,1,'Paysage',110,'fr_FR','2167');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (343,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (343,2,2007,0,1,'1568',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (343,2,2004,2,1,'Paysage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (344,2,2001,1,1,'Forêt',130,'fr_FR','1570');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (344,2,2004,1,1,'Paysage',110,'fr_FR','2167');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (344,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (344,2,2007,0,1,'1569',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (344,2,2004,2,1,'Paysage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (345,2,2001,1,1,'Mer et océan',130,'fr_FR','1571');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (345,2,2004,1,1,'Paysage',110,'fr_FR','2167');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (345,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (345,2,2007,0,1,'1570',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (345,2,2004,2,1,'Paysage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (346,2,2001,1,1,'Désert',130,'fr_FR','1572');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (346,2,2004,1,1,'Paysage',110,'fr_FR','2167');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (346,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (346,2,2007,0,1,'1571',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (346,2,2004,2,1,'Paysage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (347,2,2001,1,1,'Ville',130,'fr_FR','1573');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (347,2,2004,1,1,'Paysage',110,'fr_FR','2167');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (347,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (347,2,2007,0,1,'1572',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (347,2,2004,2,1,'Paysage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (348,2,2001,1,1,'Air',130,'fr_FR','1574');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (348,2,2004,1,1,'Eléments',110,'fr_FR','2168');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (348,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (348,2,2007,0,1,'1573',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (348,2,2004,2,1,'Eléments',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (349,2,2001,1,1,'Eau',130,'fr_FR','1575');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (349,2,2004,1,1,'Eléments',110,'fr_FR','2168');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (349,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (349,2,2007,0,1,'1574',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (349,2,2004,2,1,'Eléments',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (350,2,2001,1,1,'Feu',130,'fr_FR','1576');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (350,2,2004,1,1,'Eléments',110,'fr_FR','2168');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (350,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (350,2,2007,0,1,'1575',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (350,2,2004,2,1,'Eléments',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (351,2,2001,1,1,'Saisons',130,'fr_FR','1577');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (351,2,2004,1,1,'Nature et environnement',110,'fr_FR','1520');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (351,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (351,2,2007,0,1,'1576',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (351,2,2004,2,1,'Nature et environnement',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (352,2,2001,1,1,'Arbres',130,'fr_FR','1578');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (352,2,2004,1,1,'Nature et environnement',110,'fr_FR','1520');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (352,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (352,2,2007,0,1,'1577',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (352,2,2004,2,1,'Nature et environnement',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (353,2,2001,1,1,'Fleurs',130,'fr_FR','1579');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (353,2,2004,1,1,'Nature et environnement',110,'fr_FR','1520');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (353,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (353,2,2007,0,1,'1578',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (353,2,2004,2,1,'Nature et environnement',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (354,2,2001,1,1,'Météo',130,'fr_FR','1580');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (354,2,2004,1,1,'Nature et environnement',110,'fr_FR','1520');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (354,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (354,2,2007,0,1,'1579',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (354,2,2004,2,1,'Nature et environnement',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (355,2,2001,1,1,'Protéger l\'environnement',130,'fr_FR','1581');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (355,2,2004,1,1,'Nature et environnement',110,'fr_FR','1520');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (355,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (355,2,2007,0,1,'1580',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (355,2,2004,2,1,'Nature et environnement',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (356,2,2001,1,1,'Sorcière',130,'fr_FR','1583');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (356,2,2004,1,1,'Personnages extraordinaires et mondes imaginaires',110,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (356,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (356,2,2007,0,1,'1582',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (356,2,2004,2,1,'Personnages extraordinaires et mondes imaginaires',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (357,2,2001,1,1,'Monstre et dragon',130,'fr_FR','1584');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (357,2,2004,1,1,'Personnages extraordinaires et mondes imaginaires',110,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (357,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (357,2,2007,0,1,'1583',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (357,2,2004,2,1,'Personnages extraordinaires et mondes imaginaires',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (358,2,2001,1,1,'Prince, princesse, roi et reine',130,'fr_FR','1585');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (358,2,2004,1,1,'Personnages extraordinaires et mondes imaginaires',110,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (358,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (358,2,2007,0,1,'1584',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (358,2,2004,2,1,'Personnages extraordinaires et mondes imaginaires',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (359,2,2001,1,1,'Ogre',130,'fr_FR','1586');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (359,2,2004,1,1,'Personnages extraordinaires et mondes imaginaires',110,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (359,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (359,2,2007,0,1,'1585',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (359,2,2004,2,1,'Personnages extraordinaires et mondes imaginaires',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (360,2,2001,1,1,'Nain et géant',130,'fr_FR','1587');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (360,2,2004,1,1,'Personnages extraordinaires et mondes imaginaires',110,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (360,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (360,2,2007,0,1,'1586',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (360,2,2004,2,1,'Personnages extraordinaires et mondes imaginaires',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (361,2,2001,1,1,'Fantôme',130,'fr_FR','1588');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (361,2,2004,1,1,'Personnages extraordinaires et mondes imaginaires',110,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (361,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (361,2,2007,0,1,'1587',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (361,2,2004,2,1,'Personnages extraordinaires et mondes imaginaires',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (362,2,2001,1,1,'Pirate et corsaire',130,'fr_FR','1589');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (362,2,2004,1,1,'Personnages extraordinaires et mondes imaginaires',110,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (362,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (362,2,2007,0,1,'1588',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (362,2,2004,2,1,'Personnages extraordinaires et mondes imaginaires',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (363,2,2001,1,1,'Extra-terrestre',130,'fr_FR','1590');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (363,2,2004,1,1,'Personnages extraordinaires et mondes imaginaires',110,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (363,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (363,2,2007,0,1,'1589',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (363,2,2004,2,1,'Personnages extraordinaires et mondes imaginaires',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (364,2,2001,1,1,'Monde imaginaire',130,'fr_FR','1591');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (364,2,2004,1,1,'Personnages extraordinaires et mondes imaginaires',110,'fr_FR','1521');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (364,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (364,2,2007,0,1,'1590',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (364,2,2004,2,1,'Personnages extraordinaires et mondes imaginaires',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (365,2,2001,1,1,'Peinture et sculpture',130,'fr_FR','1592');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (365,2,2004,1,1,'Art et culture',110,'fr_FR','1522');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (365,2,2006,1,1,'Peinture',100,'fr_FR','1399');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (365,2,2006,1,2,'Sculpture',100,'fr_FR','1401');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (365,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (365,2,2007,0,1,'1591',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (365,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (365,2,2006,2,1,'Peinture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (365,2,2006,2,2,'Sculpture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (366,2,2001,1,1,'Roman',130,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (366,2,2004,1,1,'Littérature',110,'fr_FR','2166');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (366,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (366,2,2007,0,1,'1592',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (366,2,2004,2,1,'Littérature',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (367,2,2001,1,1,'Théâtre',130,'fr_FR','1594');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (367,2,2004,1,1,'Littérature',110,'fr_FR','2166');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (367,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (367,2,2007,0,1,'1593',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (367,2,2004,2,1,'Littérature',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (368,2,2001,1,1,'Poésie',130,'fr_FR','1595');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (368,2,2004,1,1,'Littérature',110,'fr_FR','2166');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (368,2,2006,1,1,'Poésie',100,'fr_FR','2479');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (368,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (368,2,2007,0,1,'1594',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (368,2,2004,2,1,'Littérature',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (368,2,2006,2,1,'Poésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (369,2,2001,1,1,'Livre',130,'fr_FR','1596');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (369,2,2004,1,1,'Art et culture',110,'fr_FR','1522');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (369,2,2006,1,1,'Livre',100,'fr_FR','1395');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (369,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (369,2,2007,0,1,'1595',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (369,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (369,2,2006,2,1,'Livre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (370,2,2001,1,1,'Musique',130,'fr_FR','1597');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (370,2,2004,1,1,'Art et culture',110,'fr_FR','1522');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (370,2,2006,1,1,'Musique',100,'fr_FR','1398');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (370,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (370,2,2007,0,1,'1596',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (370,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (370,2,2006,2,1,'Musique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (371,2,2001,1,1,'Danse',130,'fr_FR','1598');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (371,2,2004,1,1,'Art et culture',110,'fr_FR','1522');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (371,2,2006,1,1,'Danse',100,'fr_FR','2200');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (371,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (371,2,2007,0,1,'1597',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (371,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (371,2,2006,2,1,'Danse',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (372,2,2001,1,1,'Bande dessinée',130,'fr_FR','1599');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (372,2,2004,1,1,'Art et culture',110,'fr_FR','1522');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (372,2,2006,1,1,'Bande dessinée',100,'fr_FR','1391');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (372,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (372,2,2007,0,1,'1598',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (372,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (372,2,2006,2,1,'Bande dessinée',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (373,2,2001,1,1,'Cinéma - Télévision',130,'fr_FR','1600');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (373,2,2004,1,1,'Art et culture',110,'fr_FR','1522');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (373,2,2006,1,1,'Cinéma',100,'fr_FR','1392');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (373,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (373,2,2007,0,1,'1599',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (373,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (373,2,2006,2,1,'Cinéma',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (374,2,2001,1,1,'Photographie',130,'fr_FR','1601');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (374,2,2004,1,1,'Art et culture',110,'fr_FR','1522');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (374,2,2006,1,1,'Photographie',100,'fr_FR','1400');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (374,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (374,2,2007,0,1,'1600',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (374,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (374,2,2006,2,1,'Photographie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (375,2,2001,1,1,'Architecture',130,'fr_FR','1602');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (375,2,2004,1,1,'Art et culture',110,'fr_FR','1522');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (375,2,2006,1,1,'Architecture',100,'fr_FR','1390');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (375,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (375,2,2007,0,1,'1601',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (375,2,2004,2,1,'Art et culture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (375,2,2006,2,1,'Architecture',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (376,2,2001,1,1,'En famille',130,'fr_FR','1603');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (376,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (376,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (376,2,2007,0,1,'1602',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (376,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (377,2,2001,1,1,'A l\'école et au collège',130,'fr_FR','1604');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (377,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (377,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (377,2,2007,0,1,'1603',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (377,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (378,2,2001,1,1,'En société',130,'fr_FR','1605');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (378,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (378,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (378,2,2007,0,1,'1604',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (378,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (379,2,2001,1,1,'Amour et sentiments',130,'fr_FR','1606');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (379,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (379,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (379,2,2007,0,1,'1605',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (379,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (380,2,2001,1,1,'Enfants',130,'fr_FR','1607');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (380,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (380,2,2006,1,1,'Jouet',100,'fr_FR','2407');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (380,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (380,2,2007,0,1,'1606',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (380,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (380,2,2006,2,1,'Jouet',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (381,2,2001,1,1,'Fêtes',130,'fr_FR','1608');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (381,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (381,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (381,2,2007,0,1,'1607',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (381,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (382,2,2001,1,1,'Métiers',130,'fr_FR','1609');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (382,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (382,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (382,2,2007,0,1,'1608',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (382,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (383,2,2001,1,1,'Religion',130,'fr_FR','1610');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (383,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (383,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (383,2,2007,0,1,'1609',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (383,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (384,2,2001,1,1,'C\'est compliqué',130,'fr_FR','1611');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (384,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1523');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (384,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (384,2,2007,0,1,'1610',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (384,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (385,2,2001,1,1,'Astronomie',130,'fr_FR','1612');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (385,2,2004,1,1,'Sciences',110,'fr_FR','1381');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (385,2,2006,1,1,'Espace - Planètes',100,'fr_FR','1553');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (385,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (385,2,2007,0,1,'1611',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (385,2,2004,2,1,'Sciences',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (385,2,2006,2,1,'Espace - Planètes',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (386,2,2001,1,1,'Plantes',130,'fr_FR','1613');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (386,2,2004,1,1,'Sciences de la vie',110,'fr_FR','2022');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (386,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (386,2,2007,0,1,'1612',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (386,2,2004,2,1,'Sciences de la vie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (387,2,2001,1,1,'Chimie',130,'fr_FR','1614');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (387,2,2004,1,1,'Sciences',110,'fr_FR','1381');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (387,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (387,2,2007,0,1,'1613',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (387,2,2004,2,1,'Sciences',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (388,2,2001,1,1,'Ecologie',130,'fr_FR','1615');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (388,2,2004,1,1,'Sciences de la vie',110,'fr_FR','2022');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (388,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (388,2,2007,0,1,'1614',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (388,2,2004,2,1,'Sciences de la vie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (389,2,2001,1,1,'Génétique et évolution',130,'fr_FR','1616');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (389,2,2004,1,1,'Sciences de la vie',110,'fr_FR','2022');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (389,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (389,2,2007,0,1,'1615',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (389,2,2004,2,1,'Sciences de la vie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (390,2,2001,1,1,'Mathématiques',130,'fr_FR','1617');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (390,2,2004,1,1,'Sciences',110,'fr_FR','1381');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (390,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (390,2,2007,0,1,'1616',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (390,2,2004,2,1,'Sciences',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (391,2,2001,1,1,'Physique',130,'fr_FR','1618');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (391,2,2004,1,1,'Sciences',110,'fr_FR','1381');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (391,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (391,2,2007,0,1,'1617',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (391,2,2004,2,1,'Sciences',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (392,2,2001,1,1,'Préhistoire',130,'fr_FR','1619');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (392,2,2004,1,1,'Sciences',110,'fr_FR','1381');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (392,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (392,2,2007,0,1,'1618',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (392,2,2004,2,1,'Sciences',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (393,2,2001,1,1,'Terre',130,'fr_FR','1620');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (393,2,2004,1,1,'Sciences',110,'fr_FR','1381');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (393,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (393,2,2007,0,1,'1619',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (393,2,2004,2,1,'Sciences',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (394,2,2001,1,1,'Animaux',130,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (394,2,2004,1,1,'Sciences de la vie',110,'fr_FR','2022');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (394,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (394,2,2007,0,1,'1620',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (394,2,2004,2,1,'Sciences de la vie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (395,2,2001,1,1,'Structure',130,'fr_FR','1622');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (395,2,2004,1,1,'Terre',110,'fr_FR','1620');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (395,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (395,2,2007,0,1,'1621',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (395,2,2004,2,1,'Terre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (396,2,2001,1,1,'Climatologie',130,'fr_FR','1623');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (396,2,2004,1,1,'Terre',110,'fr_FR','1620');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (396,2,2006,1,1,'Antarctique',100,'fr_FR','1795');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (396,2,2006,1,2,'Arctique',100,'fr_FR','1796');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (396,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (396,2,2007,0,1,'1622',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (396,2,2004,2,1,'Terre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (396,2,2006,2,1,'Antarctique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (396,2,2006,2,2,'Arctique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (397,2,2001,1,1,'Météorologie',130,'fr_FR','1624');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (397,2,2004,1,1,'Terre',110,'fr_FR','1620');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (397,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (397,2,2007,0,1,'1623',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (397,2,2004,2,1,'Terre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (398,2,2001,1,1,'Océanographie - Hydrologie',130,'fr_FR','1625');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (398,2,2004,1,1,'Terre',110,'fr_FR','1620');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (398,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (398,2,2007,0,1,'1624',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (398,2,2004,2,1,'Terre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (399,2,2001,1,1,'Continents et relief',130,'fr_FR','1626');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (399,2,2004,1,1,'Terre',110,'fr_FR','1620');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (399,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (399,2,2007,0,1,'1625',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (399,2,2004,2,1,'Terre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (400,2,2001,1,1,'Roches et minéraux',130,'fr_FR','1627');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (400,2,2004,1,1,'Terre',110,'fr_FR','1620');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (400,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (400,2,2007,0,1,'1626',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (400,2,2004,2,1,'Terre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (401,2,2001,1,1,'Volcans',130,'fr_FR','1628');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (401,2,2004,1,1,'Terre',110,'fr_FR','1620');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (401,2,2006,1,1,'Auvergne',100,'fr_FR','1737');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (401,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (401,2,2007,0,1,'1627',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (401,2,2004,2,1,'Terre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (401,2,2006,2,1,'Auvergne',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (402,2,2001,1,1,'Micro-organismes',130,'fr_FR','1629');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (402,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (402,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (402,2,2007,0,1,'1628',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (402,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (403,2,2001,1,1,'Invertébrés',130,'fr_FR','1630');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (403,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (403,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (403,2,2007,0,1,'1629',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (403,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (404,2,2001,1,1,'Mollusques',130,'fr_FR','1631');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (404,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (404,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (404,2,2007,0,1,'1630',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (404,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (405,2,2001,1,1,'Crustacés',130,'fr_FR','1632');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (405,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (405,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (405,2,2007,0,1,'1631',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (405,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (406,2,2001,1,1,'Insectes',130,'fr_FR','1633');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (406,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (406,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (406,2,2007,0,1,'1632',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (406,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (407,2,2001,1,1,'Arachnides',130,'fr_FR','1634');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (407,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (407,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (407,2,2007,0,1,'1633',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (407,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (408,2,2001,1,1,'Poissons',130,'fr_FR','1635');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (408,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (408,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (408,2,2007,0,1,'1634',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (408,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (409,2,2001,1,1,'Batraciens',130,'fr_FR','1636');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (409,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (409,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (409,2,2007,0,1,'1635',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (409,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (410,2,2001,1,1,'Reptiles',130,'fr_FR','1637');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (410,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (410,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (410,2,2007,0,1,'1636',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (410,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (411,2,2001,1,1,'Oiseaux',130,'fr_FR','1638');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (411,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (411,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (411,2,2007,0,1,'1637',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (411,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (412,2,2001,1,1,'Mammifères',130,'fr_FR','1639');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (412,2,2004,1,1,'Animaux',110,'fr_FR','1621');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (412,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (412,2,2007,0,1,'1638',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (412,2,2004,2,1,'Animaux',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (413,2,2001,1,1,'Marsupiaux',130,'fr_FR','1640');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (413,2,2004,1,1,'Mammifères',110,'fr_FR','1639');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (413,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (413,2,2007,0,1,'1639',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (413,2,2004,2,1,'Mammifères',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (414,2,2001,1,1,'Chat',130,'fr_FR','1641');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (414,2,2004,1,1,'Félins',110,'fr_FR','1644');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (414,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (414,2,2007,0,1,'1640',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (414,2,2004,2,1,'Félins',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (415,2,2001,1,1,'Primates',130,'fr_FR','1642');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (415,2,2004,1,1,'Mammifères',110,'fr_FR','1639');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (415,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (415,2,2007,0,1,'1641',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (415,2,2004,2,1,'Mammifères',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (416,2,2001,1,1,'Chien',130,'fr_FR','1643');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (416,2,2004,1,1,'Canidés',110,'fr_FR','2141');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (416,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (416,2,2007,0,1,'1642',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (416,2,2004,2,1,'Canidés',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (417,2,2001,1,1,'Félins',130,'fr_FR','1644');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (417,2,2004,1,1,'Mammifères',110,'fr_FR','1639');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (417,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (417,2,2007,0,1,'1643',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (417,2,2004,2,1,'Mammifères',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (418,2,2001,1,1,'Rongeurs',130,'fr_FR','1645');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (418,2,2004,1,1,'Mammifères',110,'fr_FR','1639');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (418,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (418,2,2007,0,1,'1644',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (418,2,2004,2,1,'Mammifères',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (419,2,2001,1,1,'Archéologie',130,'fr_FR','1646');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (419,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (419,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (419,2,2007,0,1,'1645',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (419,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (420,2,2001,1,1,'Communication et Information',130,'fr_FR','1647');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (420,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (420,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (420,2,2007,0,1,'1646',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (420,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (421,2,2001,1,1,'Economie',130,'fr_FR','1648');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (421,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (421,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (421,2,2007,0,1,'1647',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (421,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (422,2,2001,1,1,'Démographie',130,'fr_FR','1649');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (422,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (422,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (422,2,2007,0,1,'1648',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (422,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (423,2,2001,1,1,'Géographie',130,'fr_FR','1650');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (423,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (423,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (423,2,2007,0,1,'1649',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (423,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (424,2,2001,1,1,'Histoire',130,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (424,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (424,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (424,2,2007,0,1,'1650',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (424,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (425,2,2001,1,1,'Langues - Linguistique',130,'fr_FR','1652');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (425,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (425,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (425,2,2007,0,1,'1651',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (425,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (426,2,2001,1,1,'Médecine',130,'fr_FR','1653');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (426,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (426,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (426,2,2007,0,1,'1652',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (426,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (427,2,2001,1,1,'Philosophie',130,'fr_FR','1654');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (427,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (427,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (427,2,2007,0,1,'1653',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (427,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (428,2,2001,1,1,'Psychologie - Psychanalyse',130,'fr_FR','1655');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (428,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (428,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (428,2,2007,0,1,'1654',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (428,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (429,2,2001,1,1,'Sociologie',130,'fr_FR','1656');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (429,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (429,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (429,2,2007,0,1,'1655',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (429,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (430,2,2001,1,1,'Ethnologie',130,'fr_FR','1657');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (430,2,2004,1,1,'Sciences humaines',110,'fr_FR','1382');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (430,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (430,2,2007,0,1,'1656',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (430,2,2004,2,1,'Sciences humaines',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (431,2,2001,1,1,'Bibliothéconomie',130,'fr_FR','1658');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (431,2,2004,1,1,'Communication et Information',110,'fr_FR','1647');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (431,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (431,2,2007,0,1,'1657',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (431,2,2004,2,1,'Communication et Information',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (432,2,2001,1,1,'Société de l\'information',130,'fr_FR','1659');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (432,2,2004,1,1,'Communication et Information',110,'fr_FR','1647');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (432,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (432,2,2007,0,1,'1658',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (432,2,2004,2,1,'Communication et Information',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (433,2,2001,1,1,'Journalisme',130,'fr_FR','1660');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (433,2,2004,1,1,'Communication et Information',110,'fr_FR','1647');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (433,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (433,2,2007,0,1,'1659',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (433,2,2004,2,1,'Communication et Information',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (434,2,2001,1,1,'Edition',130,'fr_FR','1661');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (434,2,2004,1,1,'Communication et Information',110,'fr_FR','1647');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (434,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (434,2,2007,0,1,'1660',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (434,2,2004,2,1,'Communication et Information',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (435,2,2001,1,1,'Communication',130,'fr_FR','1662');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (435,2,2004,1,1,'Communication et Information',110,'fr_FR','1647');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (435,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (435,2,2007,0,1,'1661',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (435,2,2004,2,1,'Communication et Information',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (436,2,2001,1,1,'Antiquité et mondes anciens',130,'fr_FR','1663');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (436,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (436,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (436,2,2007,0,1,'1662',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (436,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (437,2,2001,1,1,'Moyen-Age',130,'fr_FR','1664');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (437,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (437,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (437,2,2007,0,1,'1663',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (437,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (438,2,2001,1,1,'Renaissance',130,'fr_FR','1665');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (438,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (438,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (438,2,2007,0,1,'1664',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (438,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (439,2,2001,1,1,'XVIIème siècle (De 1600 à 1699)',130,'fr_FR','1666');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (439,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (439,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (439,2,2007,0,1,'1665',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (439,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (440,2,2001,1,1,'XVIIIème siècle (De 1700 à 1799)',130,'fr_FR','1667');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (440,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (440,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (440,2,2007,0,1,'1666',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (440,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (441,2,2001,1,1,'XIXème siècle (De 1800 à 1899)',130,'fr_FR','1668');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (441,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (441,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (441,2,2007,0,1,'1667',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (441,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (442,2,2001,1,1,'De 1900 à 1914',130,'fr_FR','1669');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (442,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (442,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (442,2,2007,0,1,'1668',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (442,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (443,2,2001,1,1,'Première Guerre Mondiale (1914-1918)',130,'fr_FR','1670');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (443,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (443,2,2006,1,1,'Guerres mondiales',100,'fr_FR','2494');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (443,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (443,2,2007,0,1,'1669',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (443,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (443,2,2006,2,1,'Guerres mondiales',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (444,2,2001,1,1,'Entre-deux guerres (1919-1938)',130,'fr_FR','1671');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (444,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (444,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (444,2,2007,0,1,'1670',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (444,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (445,2,2001,1,1,'Deuxième Guerre Mondiale (1939-1945)',130,'fr_FR','1672');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (445,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (445,2,2006,1,1,'Guerres mondiales',100,'fr_FR','2494');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (445,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (445,2,2007,0,1,'1671',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (445,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (445,2,2006,2,1,'Guerres mondiales',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (446,2,2001,1,1,'De 1946 à 1999',130,'fr_FR','1673');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (446,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (446,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (446,2,2007,0,1,'1672',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (446,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (447,2,2001,1,1,'Depuis 2000',130,'fr_FR','1674');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (447,2,2004,1,1,'Histoire',110,'fr_FR','1651');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (447,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (447,2,2007,0,1,'1673',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (447,2,2004,2,1,'Histoire',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (448,2,2001,1,1,'Métaphysique',130,'fr_FR','1675');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (448,2,2004,1,1,'Philosophie',110,'fr_FR','1654');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (448,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (448,2,2007,0,1,'1674',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (448,2,2004,2,1,'Philosophie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (449,2,2001,1,1,'Epistémologie',130,'fr_FR','1676');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (449,2,2004,1,1,'Philosophie',110,'fr_FR','1654');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (449,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (449,2,2007,0,1,'1675',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (449,2,2004,2,1,'Philosophie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (450,2,2001,1,1,'Philosophie antique',130,'fr_FR','1677');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (450,2,2004,1,1,'Philosophie',110,'fr_FR','1654');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (450,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (450,2,2007,0,1,'1676',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (450,2,2004,2,1,'Philosophie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (451,2,2001,1,1,'Philosophie médiévale',130,'fr_FR','1678');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (451,2,2004,1,1,'Philosophie',110,'fr_FR','1654');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (451,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (451,2,2007,0,1,'1677',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (451,2,2004,2,1,'Philosophie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (452,2,2001,1,1,'Philosophie orientale',130,'fr_FR','1679');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (452,2,2004,1,1,'Philosophie',110,'fr_FR','1654');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (452,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (452,2,2007,0,1,'1678',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (452,2,2004,2,1,'Philosophie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (453,2,2001,1,1,'Philosophie occidentale moderne',130,'fr_FR','1680');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (453,2,2004,1,1,'Philosophie',110,'fr_FR','1654');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (453,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (453,2,2007,0,1,'1679',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (453,2,2004,2,1,'Philosophie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (454,2,2001,1,1,'Amour',130,'fr_FR','1681');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (454,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1684');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (454,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (454,2,2007,0,1,'1680',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (454,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (455,2,2001,1,1,'De l\'enfant à l\'âge adulte',130,'fr_FR','1682');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (455,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (455,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (455,2,2007,0,1,'1681',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (455,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (456,2,2001,1,1,'Problèmes et débats de société',130,'fr_FR','1683');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (456,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (456,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (456,2,2007,0,1,'1682',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (456,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (457,2,2001,1,1,'Vivre ensemble',130,'fr_FR','1684');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (457,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (457,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (457,2,2007,0,1,'1683',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (457,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (458,2,2001,1,1,'Criminalité',130,'fr_FR','1685');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (458,2,2004,1,1,'Problèmes et débats de société',110,'fr_FR','1683');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (458,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (458,2,2007,0,1,'1684',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (458,2,2004,2,1,'Problèmes et débats de société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (459,2,2001,1,1,'Emploi',130,'fr_FR','1686');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (459,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (459,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (459,2,2007,0,1,'1685',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (459,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (460,2,2001,1,1,'Enseignement et Formation',130,'fr_FR','1687');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (460,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (460,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (460,2,2007,0,1,'1686',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (460,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (461,2,2001,1,1,'Couple',130,'fr_FR','1688');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (461,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1684');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (461,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (461,2,2007,0,1,'1687',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (461,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (462,2,2001,1,1,'Famille',130,'fr_FR','1689');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (462,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1684');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (462,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (462,2,2007,0,1,'1688',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (462,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (463,2,2001,1,1,'Environnement',130,'fr_FR','1690');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (463,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (463,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (463,2,2007,0,1,'1689',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (463,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (464,2,2001,1,1,'Handicap',130,'fr_FR','1691');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (464,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1684');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (464,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (464,2,2007,0,1,'1690',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (464,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (465,2,2001,1,1,'Illettrisme',130,'fr_FR','1692');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (465,2,2004,1,1,'Problèmes et débats de société',110,'fr_FR','1683');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (465,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (465,2,2007,0,1,'1691',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (465,2,2004,2,1,'Problèmes et débats de société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (466,2,2001,1,1,'Migrations',130,'fr_FR','1693');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (466,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (466,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (466,2,2007,0,1,'1692',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (466,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (467,2,2001,1,1,'Mode et Costume',130,'fr_FR','1694');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (467,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (467,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (467,2,2007,0,1,'1693',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (467,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (468,2,2001,1,1,'Urbanisme',130,'fr_FR','1695');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (468,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (468,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (468,2,2007,0,1,'1694',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (468,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (469,2,2001,1,1,'Religion',130,'fr_FR','1696');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (469,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (469,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (469,2,2007,0,1,'1695',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (469,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (470,2,2001,1,1,'Esotérisme',130,'fr_FR','1697');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (470,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (470,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (470,2,2007,0,1,'1696',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (470,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (471,2,2001,1,1,'Sexualité',130,'fr_FR','1698');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (471,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1684');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (471,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (471,2,2007,0,1,'1697',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (471,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (472,2,2001,1,1,'Solidarité et Action sociale',130,'fr_FR','1699');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (472,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1684');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (472,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (472,2,2007,0,1,'1698',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (472,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (473,2,2001,1,1,'Logement',130,'fr_FR','1700');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (473,2,2004,1,1,'Société',110,'fr_FR','1383');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (473,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (473,2,2007,0,1,'1699',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (473,2,2004,2,1,'Société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (474,2,2001,1,1,'Vie associative',130,'fr_FR','1701');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (474,2,2004,1,1,'Vivre ensemble',110,'fr_FR','1684');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (474,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (474,2,2007,0,1,'1700',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (474,2,2004,2,1,'Vivre ensemble',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (475,2,2001,1,1,'Enfants',130,'fr_FR','1702');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (475,2,2004,1,1,'De l\'enfant à l\'âge adulte',110,'fr_FR','1682');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (475,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (475,2,2007,0,1,'1701',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (475,2,2004,2,1,'De l\'enfant à l\'âge adulte',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (476,2,2001,1,1,'Jeunes',130,'fr_FR','1703');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (476,2,2004,1,1,'De l\'enfant à l\'âge adulte',110,'fr_FR','1682');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (476,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (476,2,2007,0,1,'1702',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (476,2,2004,2,1,'De l\'enfant à l\'âge adulte',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (477,2,2001,1,1,'Femmes',130,'fr_FR','1704');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (477,2,2004,1,1,'De l\'enfant à l\'âge adulte',110,'fr_FR','1682');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (477,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (477,2,2007,0,1,'1703',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (477,2,2004,2,1,'De l\'enfant à l\'âge adulte',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (478,2,2001,1,1,'Hommes',130,'fr_FR','1705');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (478,2,2004,1,1,'De l\'enfant à l\'âge adulte',110,'fr_FR','1682');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (478,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (478,2,2007,0,1,'1704',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (478,2,2004,2,1,'De l\'enfant à l\'âge adulte',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (479,2,2001,1,1,'Troisième âge',130,'fr_FR','1706');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (479,2,2004,1,1,'De l\'enfant à l\'âge adulte',110,'fr_FR','1682');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (479,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (479,2,2007,0,1,'1705',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (479,2,2004,2,1,'De l\'enfant à l\'âge adulte',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (480,2,2001,1,1,'Conseil et Orientation',130,'fr_FR','1707');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (480,2,2004,1,1,'Enseignement et Formation',110,'fr_FR','1687');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (480,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (480,2,2007,0,1,'1706',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (480,2,2004,2,1,'Enseignement et Formation',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (481,2,2001,1,1,'Enseignement primaire',130,'fr_FR','1708');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (481,2,2004,1,1,'Enseignement et Formation',110,'fr_FR','1687');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (481,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (481,2,2007,0,1,'1707',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (481,2,2004,2,1,'Enseignement et Formation',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (482,2,2001,1,1,'Enseignement secondaire',130,'fr_FR','1709');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (482,2,2004,1,1,'Enseignement et Formation',110,'fr_FR','1687');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (482,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (482,2,2007,0,1,'1708',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (482,2,2004,2,1,'Enseignement et Formation',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (483,2,2001,1,1,'Enseignement supérieur',130,'fr_FR','1710');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (483,2,2004,1,1,'Enseignement et Formation',110,'fr_FR','1687');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (483,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (483,2,2007,0,1,'1709',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (483,2,2004,2,1,'Enseignement et Formation',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (484,2,2001,1,1,'Examens et Concours',130,'fr_FR','1711');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (484,2,2004,1,1,'Enseignement et Formation',110,'fr_FR','1687');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (484,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (484,2,2007,0,1,'1710',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (484,2,2004,2,1,'Enseignement et Formation',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (485,2,2001,1,1,'Pédagogie',130,'fr_FR','1712');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (485,2,2004,1,1,'Enseignement et Formation',110,'fr_FR','1687');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (485,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (485,2,2007,0,1,'1711',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (485,2,2004,2,1,'Enseignement et Formation',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (486,2,2001,1,1,'Problèmes et Débats',130,'fr_FR','1713');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (486,2,2004,1,1,'Enseignement et Formation',110,'fr_FR','1687');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (486,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (486,2,2007,0,1,'1712',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (486,2,2004,2,1,'Enseignement et Formation',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (487,2,2001,1,1,'Drogue',130,'fr_FR','1714');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (487,2,2004,1,1,'Problèmes et débats de société',110,'fr_FR','1683');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (487,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (487,2,2007,0,1,'1713',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (487,2,2004,2,1,'Problèmes et débats de société',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (488,2,2001,1,1,'Bible',130,'fr_FR','1715');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (488,2,2004,1,1,'Religion',110,'fr_FR','1696');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (488,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (488,2,2007,0,1,'1714',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (488,2,2004,2,1,'Religion',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (489,2,2001,1,1,'Christianisme',130,'fr_FR','1716');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (489,2,2004,1,1,'Religion',110,'fr_FR','1696');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (489,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (489,2,2007,0,1,'1715',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (489,2,2004,2,1,'Religion',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (490,2,2001,1,1,'Sectes',130,'fr_FR','1717');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (490,2,2004,1,1,'Religion',110,'fr_FR','1696');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (490,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (490,2,2007,0,1,'1716',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (490,2,2004,2,1,'Religion',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (491,2,2001,1,1,'Bouddhisme',130,'fr_FR','1718');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (491,2,2004,1,1,'Religion',110,'fr_FR','1696');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (491,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (491,2,2007,0,1,'1717',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (491,2,2004,2,1,'Religion',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (492,2,2001,1,1,'Hindouisme',130,'fr_FR','1719');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (492,2,2004,1,1,'Religion',110,'fr_FR','1696');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (492,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (492,2,2007,0,1,'1718',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (492,2,2004,2,1,'Religion',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (493,2,2001,1,1,'Judaîsme',130,'fr_FR','1720');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (493,2,2004,1,1,'Religion',110,'fr_FR','1696');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (493,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (493,2,2007,0,1,'1719',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (493,2,2004,2,1,'Religion',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (494,2,2001,1,1,'Islam',130,'fr_FR','1721');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (494,2,2004,1,1,'Religion',110,'fr_FR','1696');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (494,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (494,2,2007,0,1,'1720',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (494,2,2004,2,1,'Religion',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (495,2,2001,1,1,'Autres mouvements religieux',130,'fr_FR','1722');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (495,2,2004,1,1,'Religion',110,'fr_FR','1696');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (495,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (495,2,2007,0,1,'1721',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (495,2,2004,2,1,'Religion',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (496,2,2001,1,1,'Artisanat',130,'fr_FR','1723');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (496,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (496,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (496,2,2007,0,1,'1722',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (496,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (497,2,2001,1,1,'Arts plastiques',130,'fr_FR','1724');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (497,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (497,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (497,2,2007,0,1,'1723',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (497,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (498,2,2001,1,1,'Chasse et pêche',130,'fr_FR','1725');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (498,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (498,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (498,2,2007,0,1,'1724',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (498,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (499,2,2001,1,1,'Collections',130,'fr_FR','1726');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (499,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (499,2,2006,1,1,'Retraite',100,'fr_FR','2491');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (499,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (499,2,2007,0,1,'1725',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (499,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (499,2,2006,2,1,'Retraite',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (500,2,2001,1,1,'Jardin',130,'fr_FR','1727');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (500,2,2004,1,1,'Jardinage',110,'fr_FR','2203');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (500,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (500,2,2007,0,1,'1726',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (500,2,2004,2,1,'Jardinage',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (501,2,2001,1,1,'Généalogie',130,'fr_FR','1728');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (501,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (501,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (501,2,2007,0,1,'1727',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (501,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (502,2,2001,1,1,'Jeux et Jouets',130,'fr_FR','1729');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (502,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (502,2,2006,1,1,'Temps libre',100,'fr_FR','2496');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (502,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (502,2,2007,0,1,'1728',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (502,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (502,2,2006,2,1,'Temps libre',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (503,2,2001,1,1,'Photographie',130,'fr_FR','1730');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (503,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (503,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (503,2,2007,0,1,'1729',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (503,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (504,2,2001,1,1,'Sports',130,'fr_FR','1731');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (504,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (504,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (504,2,2007,0,1,'1730',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (504,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (505,2,2001,1,1,'Véhicules',130,'fr_FR','1733');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (505,2,2004,1,1,'Sports et loisirs',110,'fr_FR','1384');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (505,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (505,2,2007,0,1,'1732',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (505,2,2004,2,1,'Sports et loisirs',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (506,2,2001,1,1,'Régions',130,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (506,2,2004,1,1,'France',110,'fr_FR','1917');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (506,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (506,2,2007,0,1,'1733',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (506,2,2004,2,1,'France',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (507,2,2001,1,1,'Alsace',130,'fr_FR','1735');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (507,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (507,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (507,2,2007,0,1,'1734',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (507,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (508,2,2001,1,1,'Aquitaine',130,'fr_FR','1736');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (508,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (508,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (508,2,2007,0,1,'1735',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (508,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (509,2,2001,1,1,'Auvergne',130,'fr_FR','1737');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (509,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (509,2,2006,1,1,'Volcans',100,'fr_FR','1628');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (509,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (509,2,2007,0,1,'1736',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (509,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (509,2,2006,2,1,'Volcans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (510,2,2001,1,1,'Bourgogne',130,'fr_FR','1738');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (510,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (510,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (510,2,2007,0,1,'1737',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (510,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (511,2,2001,1,1,'Bretagne',130,'fr_FR','1739');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (511,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (511,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (511,2,2007,0,1,'1738',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (511,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (512,2,2001,1,1,'Centre',130,'fr_FR','1740');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (512,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (512,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (512,2,2007,0,1,'1739',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (512,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (513,2,2001,1,1,'Champagne-Ardenne',130,'fr_FR','1741');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (513,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (513,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (513,2,2007,0,1,'1740',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (513,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (514,2,2001,1,1,'Corse',130,'fr_FR','1742');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (514,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (514,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (514,2,2007,0,1,'1741',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (514,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (515,2,2001,1,1,'Franche-Comté',130,'fr_FR','1743');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (515,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (515,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (515,2,2007,0,1,'1742',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (515,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (516,2,2001,1,1,'Ile-de-France',130,'fr_FR','1744');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (516,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (516,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (516,2,2007,0,1,'1743',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (516,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (517,2,2001,1,1,'Languedoc-Roussillon',130,'fr_FR','1746');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (517,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (517,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (517,2,2007,0,1,'1745',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (517,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (518,2,2001,1,1,'Limousin',130,'fr_FR','1747');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (518,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (518,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (518,2,2007,0,1,'1746',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (518,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (519,2,2001,1,1,'Pays de la Loire',130,'fr_FR','1748');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (519,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (519,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (519,2,2007,0,1,'1747',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (519,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (520,2,2001,1,1,'Lorraine',130,'fr_FR','1749');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (520,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (520,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (520,2,2007,0,1,'1748',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (520,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (521,2,2001,1,1,'Midi-Pyrénées',130,'fr_FR','1750');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (521,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (521,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (521,2,2007,0,1,'1749',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (521,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (522,2,2001,1,1,'Nord-Pas-de-Calais',130,'fr_FR','1751');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (522,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (522,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (522,2,2007,0,1,'1750',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (522,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (523,2,2001,1,1,'Normandie (Haute-)',130,'fr_FR','1752');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (523,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (523,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (523,2,2007,0,1,'1751',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (523,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (524,2,2001,1,1,'Normandie (Basse-)',130,'fr_FR','1753');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (524,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (524,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (524,2,2007,0,1,'1752',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (524,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (525,2,2001,1,1,'Picardie',130,'fr_FR','1754');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (525,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (525,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (525,2,2007,0,1,'1753',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (525,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (526,2,2001,1,1,'Poitou-Charentes',130,'fr_FR','1755');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (526,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (526,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (526,2,2007,0,1,'1754',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (526,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (527,2,2001,1,1,'Provence-Alpes-Côte d\'Azur',130,'fr_FR','1756');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (527,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (527,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (527,2,2007,0,1,'1755',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (527,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (528,2,2001,1,1,'Rhône-Alpes',130,'fr_FR','1757');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (528,2,2004,1,1,'Régions',110,'fr_FR','1734');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (528,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (528,2,2007,0,1,'1756',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (528,2,2004,2,1,'Régions',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (529,2,2001,1,1,'Agriculture - Elevage',130,'fr_FR','1758');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (529,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (529,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (529,2,2007,0,1,'1757',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (529,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (530,2,2001,1,1,'Agroalimentaire',130,'fr_FR','1759');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (530,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (530,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (530,2,2007,0,1,'1758',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (530,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (531,2,2001,1,1,'Aviation - Aéronautique',130,'fr_FR','1760');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (531,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (531,2,2006,1,1,'Avion',100,'fr_FR','2280');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (531,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (531,2,2007,0,1,'1759',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (531,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (531,2,2006,2,1,'Avion',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (532,2,2001,1,1,'Bâtiment et Travaux publics',130,'fr_FR','1761');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (532,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (532,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (532,2,2007,0,1,'1760',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (532,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (533,2,2001,1,1,'Energie',130,'fr_FR','1762');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (533,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (533,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (533,2,2007,0,1,'1761',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (533,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (534,2,2001,1,1,'Espace - Astronautique',130,'fr_FR','1763');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (534,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (534,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (534,2,2007,0,1,'1762',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (534,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (535,2,2001,1,1,'Industries diverses',130,'fr_FR','1764');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (535,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (535,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (535,2,2007,0,1,'1763',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (535,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (536,2,2001,1,1,'Informatique',130,'fr_FR','1765');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (536,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (536,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (536,2,2007,0,1,'1764',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (536,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (537,2,2001,1,1,'Navigation',130,'fr_FR','1766');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (537,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (537,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (537,2,2007,0,1,'1765',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (537,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (538,2,2001,1,1,'Inventions',130,'fr_FR','1767');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (538,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (538,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (538,2,2007,0,1,'1766',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (538,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (539,2,2001,1,1,'Robots - Vie artificielle',130,'fr_FR','1768');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (539,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (539,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (539,2,2007,0,1,'1767',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (539,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (540,2,2001,1,1,'Télécommunications',130,'fr_FR','1769');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (540,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (540,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (540,2,2007,0,1,'1768',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (540,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (541,2,2001,1,1,'Transports',130,'fr_FR','1770');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (541,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (541,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (541,2,2007,0,1,'1769',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (541,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (542,2,2001,1,1,'Commerce',130,'fr_FR','1771');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (542,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (542,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (542,2,2007,0,1,'1770',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (542,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (543,2,2001,1,1,'Gestion de l\'entreprise',130,'fr_FR','1772');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (543,2,2004,1,1,'Techniques',110,'fr_FR','1385');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (543,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (543,2,2007,0,1,'1771',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (543,2,2004,2,1,'Techniques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (544,2,2001,1,1,'Programmation',130,'fr_FR','1773');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (544,2,2004,1,1,'Informatique',110,'fr_FR','1765');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (544,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (544,2,2007,0,1,'1772',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (544,2,2004,2,1,'Informatique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (545,2,2001,1,1,'Bases de données',130,'fr_FR','1774');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (545,2,2004,1,1,'Informatique',110,'fr_FR','1765');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (545,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (545,2,2007,0,1,'1773',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (545,2,2004,2,1,'Informatique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (546,2,2001,1,1,'Logiciels',130,'fr_FR','1775');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (546,2,2004,1,1,'Informatique',110,'fr_FR','1765');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (546,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (546,2,2007,0,1,'1774',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (546,2,2004,2,1,'Informatique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (547,2,2001,1,1,'Réseaux',130,'fr_FR','1776');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (547,2,2004,1,1,'Informatique',110,'fr_FR','1765');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (547,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (547,2,2007,0,1,'1775',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (547,2,2004,2,1,'Informatique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (548,2,2001,1,1,'Internet',130,'fr_FR','1777');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (548,2,2004,1,1,'Informatique',110,'fr_FR','1765');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (548,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (548,2,2007,0,1,'1776',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (548,2,2004,2,1,'Informatique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (549,2,2001,1,1,'Animaux domestiques',130,'fr_FR','1778');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (549,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (549,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (549,2,2007,0,1,'1777',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (549,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (550,2,2001,1,1,'Bricolage',130,'fr_FR','1779');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (550,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (550,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (550,2,2007,0,1,'1778',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (550,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (551,2,2001,1,1,'Cuisine',130,'fr_FR','1780');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (551,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (551,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (551,2,2007,0,1,'1779',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (551,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (552,2,2001,1,1,'Développement personnel',130,'fr_FR','1781');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (552,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (552,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (552,2,2007,0,1,'1780',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (552,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (553,2,2001,1,1,'Droit pratique',130,'fr_FR','1782');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (553,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (553,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (553,2,2007,0,1,'1781',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (553,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (554,2,2001,1,1,'Ecologie pratique',130,'fr_FR','1783');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (554,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (554,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (554,2,2007,0,1,'1782',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (554,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (555,2,2001,1,1,'Maison et Décoration',130,'fr_FR','1784');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (555,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (555,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (555,2,2007,0,1,'1783',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (555,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (556,2,2001,1,1,'Puériculture',130,'fr_FR','1785');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (556,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (556,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (556,2,2007,0,1,'1784',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (556,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (557,2,2001,1,1,'Parents et Enfants',130,'fr_FR','1786');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (557,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (557,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (557,2,2007,0,1,'1785',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (557,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (558,2,2001,1,1,'Santé',130,'fr_FR','1787');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (558,2,2004,1,1,'Vie pratique',110,'fr_FR','1386');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (558,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (558,2,2007,0,1,'1786',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (558,2,2004,2,1,'Vie pratique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (559,2,2001,1,1,'Afrique',130,'fr_FR','1788');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (559,2,2004,1,1,'Zones géographiques',110,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (559,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (559,2,2007,0,1,'1787',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (559,2,2004,2,1,'Zones géographiques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (560,2,2001,1,1,'Amérique du Nord',130,'fr_FR','1789');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (560,2,2004,1,1,'Zones géographiques',110,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (560,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (560,2,2007,0,1,'1788',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (560,2,2004,2,1,'Zones géographiques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (561,2,2001,1,1,'Amérique centrale',130,'fr_FR','1790');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (561,2,2004,1,1,'Zones géographiques',110,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (561,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (561,2,2007,0,1,'1789',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (561,2,2004,2,1,'Zones géographiques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (562,2,2001,1,1,'Amérique du Sud',130,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (562,2,2004,1,1,'Zones géographiques',110,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (562,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (562,2,2007,0,1,'1790',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (562,2,2004,2,1,'Zones géographiques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (563,2,2001,1,1,'Europe',130,'fr_FR','1792');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (563,2,2004,1,1,'Zones géographiques',110,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (563,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (563,2,2007,0,1,'1791',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (563,2,2004,2,1,'Zones géographiques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (564,2,2001,1,1,'Asie',130,'fr_FR','1793');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (564,2,2004,1,1,'Zones géographiques',110,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (564,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (564,2,2007,0,1,'1792',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (564,2,2004,2,1,'Zones géographiques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (565,2,2001,1,1,'Océanie',130,'fr_FR','1794');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (565,2,2004,1,1,'Zones géographiques',110,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (565,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (565,2,2007,0,1,'1793',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (565,2,2004,2,1,'Zones géographiques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (566,2,2001,1,1,'Antarctique',130,'fr_FR','1795');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (566,2,2004,1,1,'Zones géographiques',110,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (566,2,2006,1,1,'Climatologie',100,'fr_FR','1623');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (566,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (566,2,2007,0,1,'1794',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (566,2,2004,2,1,'Zones géographiques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (566,2,2006,2,1,'Climatologie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (567,2,2001,1,1,'Arctique',130,'fr_FR','1796');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (567,2,2004,1,1,'Zones géographiques',110,'fr_FR','1387');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (567,2,2006,1,1,'Climatologie',100,'fr_FR','1623');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (567,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (567,2,2007,0,1,'1795',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (567,2,2004,2,1,'Zones géographiques',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (567,2,2006,2,1,'Climatologie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (568,2,2001,1,1,'Afrique du Nord',130,'fr_FR','1797');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (568,2,2004,1,1,'Afrique',110,'fr_FR','1788');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (568,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (568,2,2007,0,1,'1796',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (568,2,2004,2,1,'Afrique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (569,2,2001,1,1,'Afrique de l\'Ouest',130,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (569,2,2004,1,1,'Afrique',110,'fr_FR','1788');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (569,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (569,2,2007,0,1,'1797',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (569,2,2004,2,1,'Afrique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (570,2,2001,1,1,'Afrique centrale',130,'fr_FR','1799');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (570,2,2004,1,1,'Afrique',110,'fr_FR','1788');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (570,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (570,2,2007,0,1,'1798',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (570,2,2004,2,1,'Afrique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (571,2,2001,1,1,'Afrique de l\'Est',130,'fr_FR','1800');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (571,2,2004,1,1,'Afrique',110,'fr_FR','1788');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (571,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (571,2,2007,0,1,'1799',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (571,2,2004,2,1,'Afrique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (572,2,2001,1,1,'Afrique équatoriale',130,'fr_FR','1801');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (572,2,2004,1,1,'Afrique',110,'fr_FR','1788');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (572,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (572,2,2007,0,1,'1800',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (572,2,2004,2,1,'Afrique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (573,2,2001,1,1,'Afrique du Sud',130,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (573,2,2004,1,1,'Afrique',110,'fr_FR','1788');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (573,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (573,2,2007,0,1,'1801',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (573,2,2004,2,1,'Afrique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (574,2,2001,1,1,'Iles de l\'océan indien',130,'fr_FR','1803');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (574,2,2004,1,1,'Afrique',110,'fr_FR','1788');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (574,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (574,2,2007,0,1,'1802',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (574,2,2004,2,1,'Afrique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (575,2,2001,1,1,'Alaska',130,'fr_FR','1804');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (575,2,2004,1,1,'Amérique du Nord',110,'fr_FR','1789');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (575,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (575,2,2007,0,1,'1803',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (575,2,2004,2,1,'Amérique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (576,2,2001,1,1,'Canada',130,'fr_FR','1805');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (576,2,2004,1,1,'Amérique du Nord',110,'fr_FR','1789');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (576,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (576,2,2007,0,1,'1804',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (576,2,2004,2,1,'Amérique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (577,2,2001,1,1,'Saint-Pierre-et-Miquelon',130,'fr_FR','1806');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (577,2,2004,1,1,'Amérique du Nord',110,'fr_FR','1789');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (577,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (577,2,2007,0,1,'1805',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (577,2,2004,2,1,'Amérique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (578,2,2001,1,1,'Groenland',130,'fr_FR','1807');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (578,2,2004,1,1,'Amérique du Nord',110,'fr_FR','1789');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (578,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (578,2,2007,0,1,'1806',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (578,2,2004,2,1,'Amérique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (579,2,2001,1,1,'Etats-Unis',130,'fr_FR','1808');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (579,2,2004,1,1,'Amérique du Nord',110,'fr_FR','1789');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (579,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (579,2,2007,0,1,'1807',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (579,2,2004,2,1,'Amérique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (580,2,2001,1,1,'Bermudes',130,'fr_FR','1809');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (580,2,2004,1,1,'Amérique du Nord',110,'fr_FR','1789');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (580,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (580,2,2007,0,1,'1808',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (580,2,2004,2,1,'Amérique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (581,2,2001,1,1,'Mexique',130,'fr_FR','1810');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (581,2,2004,1,1,'Amérique du Nord',110,'fr_FR','1789');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (581,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (581,2,2007,0,1,'1809',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (581,2,2004,2,1,'Amérique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (582,2,2001,1,1,'Belize',130,'fr_FR','1811');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (582,2,2004,1,1,'Amérique centrale',110,'fr_FR','1790');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (582,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (582,2,2007,0,1,'1810',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (582,2,2004,2,1,'Amérique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (583,2,2001,1,1,'Guatemala',130,'fr_FR','1812');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (583,2,2004,1,1,'Amérique centrale',110,'fr_FR','1790');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (583,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (583,2,2007,0,1,'1811',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (583,2,2004,2,1,'Amérique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (584,2,2001,1,1,'Salvador',130,'fr_FR','1813');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (584,2,2004,1,1,'Amérique centrale',110,'fr_FR','1790');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (584,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (584,2,2007,0,1,'1812',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (584,2,2004,2,1,'Amérique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (585,2,2001,1,1,'Honduras',130,'fr_FR','1814');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (585,2,2004,1,1,'Amérique centrale',110,'fr_FR','1790');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (585,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (585,2,2007,0,1,'1813',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (585,2,2004,2,1,'Amérique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (586,2,2001,1,1,'Nicaragua',130,'fr_FR','1815');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (586,2,2004,1,1,'Amérique centrale',110,'fr_FR','1790');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (586,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (586,2,2007,0,1,'1814',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (586,2,2004,2,1,'Amérique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (587,2,2001,1,1,'Costa Rica',130,'fr_FR','1816');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (587,2,2004,1,1,'Amérique centrale',110,'fr_FR','1790');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (587,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (587,2,2007,0,1,'1815',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (587,2,2004,2,1,'Amérique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (588,2,2001,1,1,'Panama',130,'fr_FR','1817');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (588,2,2004,1,1,'Amérique centrale',110,'fr_FR','1790');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (588,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (588,2,2007,0,1,'1816',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (588,2,2004,2,1,'Amérique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (589,2,2001,1,1,'Antilles',130,'fr_FR','1818');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (589,2,2004,1,1,'Amérique centrale',110,'fr_FR','1790');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (589,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (589,2,2007,0,1,'1817',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (589,2,2004,2,1,'Amérique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (590,2,2001,1,1,'Colombie',130,'fr_FR','1819');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (590,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (590,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (590,2,2007,0,1,'1818',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (590,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (591,2,2001,1,1,'Vénézuela',130,'fr_FR','1820');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (591,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (591,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (591,2,2007,0,1,'1819',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (591,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (592,2,2001,1,1,'Guyana',130,'fr_FR','1821');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (592,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (592,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (592,2,2007,0,1,'1820',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (592,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (593,2,2001,1,1,'Surinam',130,'fr_FR','1822');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (593,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (593,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (593,2,2007,0,1,'1821',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (593,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (594,2,2001,1,1,'Guyane française',130,'fr_FR','1823');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (594,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (594,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (594,2,2007,0,1,'1822',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (594,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (595,2,2001,1,1,'Equateur',130,'fr_FR','1824');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (595,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (595,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (595,2,2007,0,1,'1823',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (595,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (596,2,2001,1,1,'Pérou',130,'fr_FR','1825');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (596,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (596,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (596,2,2007,0,1,'1824',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (596,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (597,2,2001,1,1,'Brésil',130,'fr_FR','1826');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (597,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (597,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (597,2,2007,0,1,'1825',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (597,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (598,2,2001,1,1,'Bolivie',130,'fr_FR','1827');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (598,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (598,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (598,2,2007,0,1,'1826',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (598,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (599,2,2001,1,1,'Chili',130,'fr_FR','1828');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (599,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (599,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (599,2,2007,0,1,'1827',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (599,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (600,2,2001,1,1,'Paraguay',130,'fr_FR','1829');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (600,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (600,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (600,2,2007,0,1,'1828',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (600,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (601,2,2001,1,1,'Argentine',130,'fr_FR','1830');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (601,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (601,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (601,2,2007,0,1,'1829',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (601,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (602,2,2001,1,1,'Uruguay',130,'fr_FR','1831');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (602,2,2004,1,1,'Amérique du Sud',110,'fr_FR','1791');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (602,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (602,2,2007,0,1,'1830',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (602,2,2004,2,1,'Amérique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (603,2,2001,1,1,'Europe du Nord',130,'fr_FR','1832');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (603,2,2004,1,1,'Europe',110,'fr_FR','1792');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (603,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (603,2,2007,0,1,'1831',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (603,2,2004,2,1,'Europe',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (604,2,2001,1,1,'Europe de l\'Ouest',130,'fr_FR','1833');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (604,2,2004,1,1,'Europe',110,'fr_FR','1792');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (604,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (604,2,2007,0,1,'1832',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (604,2,2004,2,1,'Europe',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (605,2,2001,1,1,'Europe centrale',130,'fr_FR','1834');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (605,2,2004,1,1,'Europe',110,'fr_FR','1792');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (605,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (605,2,2007,0,1,'1833',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (605,2,2004,2,1,'Europe',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (606,2,2001,1,1,'Europe de l\'Est',130,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (606,2,2004,1,1,'Europe',110,'fr_FR','1792');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (606,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (606,2,2007,0,1,'1834',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (606,2,2004,2,1,'Europe',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (607,2,2001,1,1,'Europe du Sud',130,'fr_FR','1836');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (607,2,2004,1,1,'Europe',110,'fr_FR','1792');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (607,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (607,2,2007,0,1,'1835',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (607,2,2004,2,1,'Europe',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (608,2,2001,1,1,'Balkans',130,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (608,2,2004,1,1,'Europe',110,'fr_FR','1792');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (608,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (608,2,2007,0,1,'1836',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (608,2,2004,2,1,'Europe',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (609,2,2001,1,1,'Moyen-Orient',130,'fr_FR','1838');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (609,2,2004,1,1,'Asie',110,'fr_FR','1793');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (609,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (609,2,2007,0,1,'1837',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (609,2,2004,2,1,'Asie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (610,2,2001,1,1,'Transcaucasie',130,'fr_FR','1839');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (610,2,2004,1,1,'Asie',110,'fr_FR','1793');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (610,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (610,2,2007,0,1,'1838',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (610,2,2004,2,1,'Asie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (611,2,2001,1,1,'Asie centrale',130,'fr_FR','1840');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (611,2,2004,1,1,'Asie',110,'fr_FR','1793');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (611,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (611,2,2007,0,1,'1839',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (611,2,2004,2,1,'Asie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (612,2,2001,1,1,'Asie de l\'Est',130,'fr_FR','1841');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (612,2,2004,1,1,'Asie',110,'fr_FR','1793');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (612,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (612,2,2007,0,1,'1840',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (612,2,2004,2,1,'Asie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (613,2,2001,1,1,'Asie du Sud',130,'fr_FR','1842');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (613,2,2004,1,1,'Asie',110,'fr_FR','1793');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (613,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (613,2,2007,0,1,'1841',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (613,2,2004,2,1,'Asie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (614,2,2001,1,1,'Asie du Sud-Est',130,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (614,2,2004,1,1,'Asie',110,'fr_FR','1793');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (614,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (614,2,2007,0,1,'1842',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (614,2,2004,2,1,'Asie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (615,2,2001,1,1,'Australie',130,'fr_FR','1844');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (615,2,2004,1,1,'Océanie',110,'fr_FR','1794');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (615,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (615,2,2007,0,1,'1843',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (615,2,2004,2,1,'Océanie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (616,2,2001,1,1,'Mélanésie',130,'fr_FR','1845');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (616,2,2004,1,1,'Océanie',110,'fr_FR','1794');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (616,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (616,2,2007,0,1,'1844',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (616,2,2004,2,1,'Océanie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (617,2,2001,1,1,'Micronésie',130,'fr_FR','1846');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (617,2,2004,1,1,'Océanie',110,'fr_FR','1794');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (617,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (617,2,2007,0,1,'1845',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (617,2,2004,2,1,'Océanie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (618,2,2001,1,1,'Polynésie',130,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (618,2,2004,1,1,'Océanie',110,'fr_FR','1794');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (618,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (618,2,2007,0,1,'1846',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (618,2,2004,2,1,'Océanie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (619,2,2001,1,1,'Maroc',130,'fr_FR','1848');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (619,2,2004,1,1,'Afrique du Nord',110,'fr_FR','1797');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (619,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (619,2,2007,0,1,'1847',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (619,2,2004,2,1,'Afrique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (620,2,2001,1,1,'Tunisie',130,'fr_FR','1849');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (620,2,2004,1,1,'Afrique du Nord',110,'fr_FR','1797');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (620,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (620,2,2007,0,1,'1848',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (620,2,2004,2,1,'Afrique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (621,2,2001,1,1,'Algérie',130,'fr_FR','1850');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (621,2,2004,1,1,'Afrique du Nord',110,'fr_FR','1797');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (621,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (621,2,2007,0,1,'1849',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (621,2,2004,2,1,'Afrique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (622,2,2001,1,1,'Libye',130,'fr_FR','1851');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (622,2,2004,1,1,'Afrique du Nord',110,'fr_FR','1797');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (622,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (622,2,2007,0,1,'1850',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (622,2,2004,2,1,'Afrique du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (623,2,2001,1,1,'Sierra Leone',130,'fr_FR','1852');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (623,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (623,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (623,2,2007,0,1,'1851',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (623,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (624,2,2001,1,1,'Mauritanie',130,'fr_FR','1853');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (624,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (624,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (624,2,2007,0,1,'1852',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (624,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (625,2,2001,1,1,'Mali',130,'fr_FR','1854');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (625,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (625,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (625,2,2007,0,1,'1853',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (625,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (626,2,2001,1,1,'Sénégal',130,'fr_FR','1855');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (626,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (626,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (626,2,2007,0,1,'1854',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (626,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (627,2,2001,1,1,'Guin',130,'fr_FR','1856');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (627,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (627,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (627,2,2007,0,1,'1855',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (627,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (628,2,2001,1,1,'Côte d\'Ivoire',130,'fr_FR','1857');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (628,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (628,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (628,2,2007,0,1,'1856',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (628,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (629,2,2001,1,1,'Gambie',130,'fr_FR','1858');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (629,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (629,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (629,2,2007,0,1,'1857',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (629,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (630,2,2001,1,1,'Guinée-Bissau',130,'fr_FR','1859');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (630,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (630,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (630,2,2007,0,1,'1858',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (630,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (631,2,2001,1,1,'Liberia',130,'fr_FR','1860');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (631,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (631,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (631,2,2007,0,1,'1859',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (631,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (632,2,2001,1,1,'Burkina Faso',130,'fr_FR','1861');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (632,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (632,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (632,2,2007,0,1,'1860',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (632,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (633,2,2001,1,1,'Ghana',130,'fr_FR','1862');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (633,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (633,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (633,2,2007,0,1,'1861',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (633,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (634,2,2001,1,1,'Togo',130,'fr_FR','1863');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (634,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (634,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (634,2,2007,0,1,'1862',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (634,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (635,2,2001,1,1,'Bénin',130,'fr_FR','1864');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (635,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (635,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (635,2,2007,0,1,'1863',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (635,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (636,2,2001,1,1,'Iles du Cap-Vert',130,'fr_FR','1865');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (636,2,2004,1,1,'Afrique de l\'Ouest',110,'fr_FR','1798');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (636,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (636,2,2007,0,1,'1864',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (636,2,2004,2,1,'Afrique de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (637,2,2001,1,1,'Tchad',130,'fr_FR','1866');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (637,2,2004,1,1,'Afrique centrale',110,'fr_FR','1799');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (637,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (637,2,2007,0,1,'1865',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (637,2,2004,2,1,'Afrique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (638,2,2001,1,1,'Niger',130,'fr_FR','1867');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (638,2,2004,1,1,'Afrique centrale',110,'fr_FR','1799');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (638,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (638,2,2007,0,1,'1866',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (638,2,2004,2,1,'Afrique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (639,2,2001,1,1,'Nigeria',130,'fr_FR','1868');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (639,2,2004,1,1,'Afrique centrale',110,'fr_FR','1799');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (639,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (639,2,2007,0,1,'1867',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (639,2,2004,2,1,'Afrique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (640,2,2001,1,1,'Cameroun',130,'fr_FR','1869');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (640,2,2004,1,1,'Afrique centrale',110,'fr_FR','1799');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (640,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (640,2,2007,0,1,'1868',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (640,2,2004,2,1,'Afrique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (641,2,2001,1,1,'Centrafricaine (République)',130,'fr_FR','1870');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (641,2,2004,1,1,'Afrique centrale',110,'fr_FR','1799');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (641,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (641,2,2007,0,1,'1869',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (641,2,2004,2,1,'Afrique centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (642,2,2001,1,1,'Soudan',130,'fr_FR','1871');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (642,2,2004,1,1,'Afrique de l\'Est',110,'fr_FR','1800');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (642,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (642,2,2007,0,1,'1870',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (642,2,2004,2,1,'Afrique de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (643,2,2001,1,1,'Erythrée',130,'fr_FR','1872');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (643,2,2004,1,1,'Afrique de l\'Est',110,'fr_FR','1800');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (643,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (643,2,2007,0,1,'1871',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (643,2,2004,2,1,'Afrique de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (644,2,2001,1,1,'Ethiopie',130,'fr_FR','1873');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (644,2,2004,1,1,'Afrique de l\'Est',110,'fr_FR','1800');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (644,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (644,2,2007,0,1,'1872',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (644,2,2004,2,1,'Afrique de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (645,2,2001,1,1,'Somalie',130,'fr_FR','1874');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (645,2,2004,1,1,'Afrique de l\'Est',110,'fr_FR','1800');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (645,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (645,2,2007,0,1,'1873',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (645,2,2004,2,1,'Afrique de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (646,2,2001,1,1,'Kenya',130,'fr_FR','1875');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (646,2,2004,1,1,'Afrique de l\'Est',110,'fr_FR','1800');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (646,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (646,2,2007,0,1,'1874',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (646,2,2004,2,1,'Afrique de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (647,2,2001,1,1,'Tanzanie',130,'fr_FR','1876');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (647,2,2004,1,1,'Afrique de l\'Est',110,'fr_FR','1800');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (647,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (647,2,2007,0,1,'1875',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (647,2,2004,2,1,'Afrique de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (648,2,2001,1,1,'Djibouti',130,'fr_FR','1877');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (648,2,2004,1,1,'Afrique de l\'Est',110,'fr_FR','1800');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (648,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (648,2,2007,0,1,'1876',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (648,2,2004,2,1,'Afrique de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (649,2,2001,1,1,'Ouganda',130,'fr_FR','1878');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (649,2,2004,1,1,'Afrique de l\'Est',110,'fr_FR','1800');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (649,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (649,2,2007,0,1,'1877',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (649,2,2004,2,1,'Afrique de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (650,2,2001,1,1,'Congo',130,'fr_FR','1879');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (650,2,2004,1,1,'Afrique équatoriale',110,'fr_FR','1801');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (650,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (650,2,2007,0,1,'1878',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (650,2,2004,2,1,'Afrique équatoriale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (651,2,2001,1,1,'Congo (République démocratique du)',130,'fr_FR','1880');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (651,2,2004,1,1,'Afrique équatoriale',110,'fr_FR','1801');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (651,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (651,2,2007,0,1,'1879',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (651,2,2004,2,1,'Afrique équatoriale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (652,2,2001,1,1,'Gabon',130,'fr_FR','1881');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (652,2,2004,1,1,'Afrique équatoriale',110,'fr_FR','1801');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (652,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (652,2,2007,0,1,'1880',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (652,2,2004,2,1,'Afrique équatoriale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (653,2,2001,1,1,'Guinée équatoriale',130,'fr_FR','1882');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (653,2,2004,1,1,'Afrique équatoriale',110,'fr_FR','1801');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (653,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (653,2,2007,0,1,'1881',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (653,2,2004,2,1,'Afrique équatoriale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (654,2,2001,1,1,'Sao Tomé et Principe',130,'fr_FR','1883');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (654,2,2004,1,1,'Afrique équatoriale',110,'fr_FR','1801');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (654,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (654,2,2007,0,1,'1882',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (654,2,2004,2,1,'Afrique équatoriale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (655,2,2001,1,1,'Rwanda',130,'fr_FR','1884');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (655,2,2004,1,1,'Afrique équatoriale',110,'fr_FR','1801');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (655,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (655,2,2007,0,1,'1883',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (655,2,2004,2,1,'Afrique équatoriale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (656,2,2001,1,1,'Burundi',130,'fr_FR','1885');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (656,2,2004,1,1,'Afrique équatoriale',110,'fr_FR','1801');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (656,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (656,2,2007,0,1,'1884',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (656,2,2004,2,1,'Afrique équatoriale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (657,2,2001,1,1,'Angola',130,'fr_FR','1886');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (657,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (657,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (657,2,2007,0,1,'1885',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (657,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (658,2,2001,1,1,'Zambie',130,'fr_FR','1887');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (658,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (658,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (658,2,2007,0,1,'1886',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (658,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (659,2,2001,1,1,'Zimbabwe',130,'fr_FR','1888');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (659,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (659,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (659,2,2007,0,1,'1887',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (659,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (660,2,2001,1,1,'Botswana',130,'fr_FR','1889');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (660,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (660,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (660,2,2007,0,1,'1888',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (660,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (661,2,2001,1,1,'Afrique du Sud',130,'fr_FR','1890');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (661,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (661,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (661,2,2007,0,1,'1889',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (661,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (662,2,2001,1,1,'Swaziland',130,'fr_FR','1891');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (662,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (662,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (662,2,2007,0,1,'1890',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (662,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (663,2,2001,1,1,'Lesotho',130,'fr_FR','1892');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (663,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (663,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (663,2,2007,0,1,'1891',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (663,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (664,2,2001,1,1,'Namibie',130,'fr_FR','1893');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (664,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (664,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (664,2,2007,0,1,'1892',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (664,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (665,2,2001,1,1,'Mozambique',130,'fr_FR','1894');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (665,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (665,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (665,2,2007,0,1,'1893',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (665,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (666,2,2001,1,1,'Malawi',130,'fr_FR','1895');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (666,2,2004,1,1,'Afrique du Sud',110,'fr_FR','1802');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (666,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (666,2,2007,0,1,'1894',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (666,2,2004,2,1,'Afrique du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (667,2,2001,1,1,'Seychelles',130,'fr_FR','1896');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (667,2,2004,1,1,'Iles de l\'océan indien',110,'fr_FR','1803');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (667,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (667,2,2007,0,1,'1895',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (667,2,2004,2,1,'Iles de l\'océan indien',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (668,2,2001,1,1,'Ile Maurice',130,'fr_FR','1897');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (668,2,2004,1,1,'Iles de l\'océan indien',110,'fr_FR','1803');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (668,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (668,2,2007,0,1,'1896',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (668,2,2004,2,1,'Iles de l\'océan indien',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (669,2,2001,1,1,'Réunion',130,'fr_FR','1898');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (669,2,2004,1,1,'Iles de l\'océan indien',110,'fr_FR','1803');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (669,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (669,2,2007,0,1,'1897',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (669,2,2004,2,1,'Iles de l\'océan indien',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (670,2,2001,1,1,'Madagascar',130,'fr_FR','1899');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (670,2,2004,1,1,'Iles de l\'océan indien',110,'fr_FR','1803');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (670,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (670,2,2007,0,1,'1898',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (670,2,2004,2,1,'Iles de l\'océan indien',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (671,2,2001,1,1,'Comores',130,'fr_FR','1900');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (671,2,2004,1,1,'Iles de l\'océan indien',110,'fr_FR','1803');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (671,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (671,2,2007,0,1,'1899',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (671,2,2004,2,1,'Iles de l\'océan indien',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (672,2,2001,1,1,'Mayotte',130,'fr_FR','1901');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (672,2,2004,1,1,'Iles de l\'océan indien',110,'fr_FR','1803');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (672,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (672,2,2007,0,1,'1900',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (672,2,2004,2,1,'Iles de l\'océan indien',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (673,2,2001,1,1,'Bahamas',130,'fr_FR','1902');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (673,2,2004,1,1,'Antilles',110,'fr_FR','1818');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (673,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (673,2,2007,0,1,'1901',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (673,2,2004,2,1,'Antilles',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (674,2,2001,1,1,'Cuba',130,'fr_FR','1903');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (674,2,2004,1,1,'Antilles',110,'fr_FR','1818');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (674,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (674,2,2007,0,1,'1902',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (674,2,2004,2,1,'Antilles',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (675,2,2001,1,1,'Jamaïque',130,'fr_FR','1904');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (675,2,2004,1,1,'Antilles',110,'fr_FR','1818');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (675,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (675,2,2007,0,1,'1903',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (675,2,2004,2,1,'Antilles',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (676,2,2001,1,1,'Haïti',130,'fr_FR','1905');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (676,2,2004,1,1,'Antilles',110,'fr_FR','1818');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (676,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (676,2,2007,0,1,'1904',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (676,2,2004,2,1,'Antilles',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (677,2,2001,1,1,'Dominicaine (République)',130,'fr_FR','1906');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (677,2,2004,1,1,'Antilles',110,'fr_FR','1818');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (677,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (677,2,2007,0,1,'1905',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (677,2,2004,2,1,'Antilles',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (678,2,2001,1,1,'Porto Rico',130,'fr_FR','1907');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (678,2,2004,1,1,'Antilles',110,'fr_FR','1818');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (678,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (678,2,2007,0,1,'1906',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (678,2,2004,2,1,'Antilles',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (679,2,2001,1,1,'Guadeloupe',130,'fr_FR','1908');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (679,2,2004,1,1,'Antilles',110,'fr_FR','1818');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (679,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (679,2,2007,0,1,'1907',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (679,2,2004,2,1,'Antilles',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (680,2,2001,1,1,'Martinique',130,'fr_FR','1909');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (680,2,2004,1,1,'Antilles',110,'fr_FR','1818');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (680,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (680,2,2007,0,1,'1908',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (680,2,2004,2,1,'Antilles',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (681,2,2001,1,1,'Islande',130,'fr_FR','1910');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (681,2,2004,1,1,'Europe du Nord',110,'fr_FR','1832');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (681,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (681,2,2007,0,1,'1909',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (681,2,2004,2,1,'Europe du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (682,2,2001,1,1,'Norvège',130,'fr_FR','1911');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (682,2,2004,1,1,'Europe du Nord',110,'fr_FR','1832');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (682,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (682,2,2007,0,1,'1910',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (682,2,2004,2,1,'Europe du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (683,2,2001,1,1,'Suède',130,'fr_FR','1912');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (683,2,2004,1,1,'Europe du Nord',110,'fr_FR','1832');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (683,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (683,2,2007,0,1,'1911',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (683,2,2004,2,1,'Europe du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (684,2,2001,1,1,'Finlande',130,'fr_FR','1913');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (684,2,2004,1,1,'Europe du Nord',110,'fr_FR','1832');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (684,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (684,2,2007,0,1,'1912',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (684,2,2004,2,1,'Europe du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (685,2,2001,1,1,'Danemark',130,'fr_FR','1914');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (685,2,2004,1,1,'Europe du Nord',110,'fr_FR','1832');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (685,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (685,2,2007,0,1,'1913',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (685,2,2004,2,1,'Europe du Nord',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (686,2,2001,1,1,'Irlande',130,'fr_FR','1915');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (686,2,2004,1,1,'Europe de l\'Ouest',110,'fr_FR','1833');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (686,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (686,2,2007,0,1,'1914',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (686,2,2004,2,1,'Europe de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (687,2,2001,1,1,'Grande-Bretagne',130,'fr_FR','1916');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (687,2,2004,1,1,'Europe de l\'Ouest',110,'fr_FR','1833');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (687,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (687,2,2007,0,1,'1915',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (687,2,2004,2,1,'Europe de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (688,2,2001,1,1,'France',130,'fr_FR','1917');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (688,2,2004,1,1,'Europe de l\'Ouest',110,'fr_FR','1833');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (688,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (688,2,2007,0,1,'1916',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (688,2,2004,2,1,'Europe de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (689,2,2001,1,1,'Pays-Bas',130,'fr_FR','1918');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (689,2,2004,1,1,'Europe de l\'Ouest',110,'fr_FR','1833');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (689,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (689,2,2007,0,1,'1917',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (689,2,2004,2,1,'Europe de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (690,2,2001,1,1,'Belgique',130,'fr_FR','1919');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (690,2,2004,1,1,'Europe de l\'Ouest',110,'fr_FR','1833');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (690,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (690,2,2007,0,1,'1918',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (690,2,2004,2,1,'Europe de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (691,2,2001,1,1,'Luxembourg',130,'fr_FR','1920');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (691,2,2004,1,1,'Europe de l\'Ouest',110,'fr_FR','1833');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (691,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (691,2,2007,0,1,'1919',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (691,2,2004,2,1,'Europe de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (692,2,2001,1,1,'Suisse',130,'fr_FR','1921');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (692,2,2004,1,1,'Europe de l\'Ouest',110,'fr_FR','1833');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (692,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (692,2,2007,0,1,'1920',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (692,2,2004,2,1,'Europe de l\'Ouest',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (693,2,2001,1,1,'Allemagne',130,'fr_FR','1922');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (693,2,2004,1,1,'Europe centrale',110,'fr_FR','1834');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (693,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (693,2,2007,0,1,'1921',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (693,2,2004,2,1,'Europe centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (694,2,2001,1,1,'Tchèque (République)',130,'fr_FR','1923');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (694,2,2004,1,1,'Europe centrale',110,'fr_FR','1834');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (694,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (694,2,2007,0,1,'1922',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (694,2,2004,2,1,'Europe centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (695,2,2001,1,1,'Slovaquie',130,'fr_FR','1924');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (695,2,2004,1,1,'Europe centrale',110,'fr_FR','1834');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (695,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (695,2,2007,0,1,'1923',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (695,2,2004,2,1,'Europe centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (696,2,2001,1,1,'Autriche',130,'fr_FR','1925');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (696,2,2004,1,1,'Europe centrale',110,'fr_FR','1834');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (696,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (696,2,2007,0,1,'1924',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (696,2,2004,2,1,'Europe centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (697,2,2001,1,1,'Hongrie',130,'fr_FR','1926');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (697,2,2004,1,1,'Europe centrale',110,'fr_FR','1834');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (697,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (697,2,2007,0,1,'1925',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (697,2,2004,2,1,'Europe centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (698,2,2001,1,1,'Pologne',130,'fr_FR','1927');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (698,2,2004,1,1,'Europe de l\'Est',110,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (698,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (698,2,2007,0,1,'1926',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (698,2,2004,2,1,'Europe de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (699,2,2001,1,1,'Estonie',130,'fr_FR','1928');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (699,2,2004,1,1,'Europe de l\'Est',110,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (699,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (699,2,2007,0,1,'1927',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (699,2,2004,2,1,'Europe de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (700,2,2001,1,1,'Lettonie',130,'fr_FR','1929');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (700,2,2004,1,1,'Europe de l\'Est',110,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (700,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (700,2,2007,0,1,'1928',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (700,2,2004,2,1,'Europe de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (701,2,2001,1,1,'Lituanie',130,'fr_FR','1930');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (701,2,2004,1,1,'Europe de l\'Est',110,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (701,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (701,2,2007,0,1,'1929',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (701,2,2004,2,1,'Europe de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (702,2,2001,1,1,'Biélorussie',130,'fr_FR','1931');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (702,2,2004,1,1,'Europe de l\'Est',110,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (702,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (702,2,2007,0,1,'1930',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (702,2,2004,2,1,'Europe de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (703,2,2001,1,1,'Ukraine',130,'fr_FR','1932');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (703,2,2004,1,1,'Europe de l\'Est',110,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (703,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (703,2,2007,0,1,'1931',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (703,2,2004,2,1,'Europe de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (704,2,2001,1,1,'Moldavie',130,'fr_FR','1933');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (704,2,2004,1,1,'Europe de l\'Est',110,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (704,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (704,2,2007,0,1,'1932',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (704,2,2004,2,1,'Europe de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (705,2,2001,1,1,'Roumanie',130,'fr_FR','1934');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (705,2,2004,1,1,'Europe de l\'Est',110,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (705,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (705,2,2007,0,1,'1933',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (705,2,2004,2,1,'Europe de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (706,2,2001,1,1,'Portugal',130,'fr_FR','1935');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (706,2,2004,1,1,'Europe du Sud',110,'fr_FR','1836');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (706,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (706,2,2007,0,1,'1934',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (706,2,2004,2,1,'Europe du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (707,2,2001,1,1,'Espagne',130,'fr_FR','1936');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (707,2,2004,1,1,'Europe du Sud',110,'fr_FR','1836');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (707,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (707,2,2007,0,1,'1935',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (707,2,2004,2,1,'Europe du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (708,2,2001,1,1,'Italie',130,'fr_FR','1937');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (708,2,2004,1,1,'Europe du Sud',110,'fr_FR','1836');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (708,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (708,2,2007,0,1,'1936',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (708,2,2004,2,1,'Europe du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (709,2,2001,1,1,'Malte',130,'fr_FR','1938');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (709,2,2004,1,1,'Europe du Sud',110,'fr_FR','1836');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (709,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (709,2,2007,0,1,'1937',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (709,2,2004,2,1,'Europe du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (710,2,2001,1,1,'Slovénie',130,'fr_FR','1939');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (710,2,2004,1,1,'Balkans',110,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (710,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (710,2,2007,0,1,'1938',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (710,2,2004,2,1,'Balkans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (711,2,2001,1,1,'Croatie',130,'fr_FR','1940');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (711,2,2004,1,1,'Balkans',110,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (711,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (711,2,2007,0,1,'1939',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (711,2,2004,2,1,'Balkans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (712,2,2001,1,1,'Bosnie-Herzégovine',130,'fr_FR','1941');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (712,2,2004,1,1,'Balkans',110,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (712,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (712,2,2007,0,1,'1940',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (712,2,2004,2,1,'Balkans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (713,2,2001,1,1,'Macédoine',130,'fr_FR','1942');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (713,2,2004,1,1,'Balkans',110,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (713,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (713,2,2007,0,1,'1941',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (713,2,2004,2,1,'Balkans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (714,2,2001,1,1,'Albanie',130,'fr_FR','1943');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (714,2,2004,1,1,'Balkans',110,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (714,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (714,2,2007,0,1,'1942',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (714,2,2004,2,1,'Balkans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (715,2,2001,1,1,'Grèce',130,'fr_FR','1944');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (715,2,2004,1,1,'Balkans',110,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (715,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (715,2,2007,0,1,'1943',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (715,2,2004,2,1,'Balkans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (716,2,2001,1,1,'Bulgarie',130,'fr_FR','1945');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (716,2,2004,1,1,'Balkans',110,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (716,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (716,2,2007,0,1,'1944',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (716,2,2004,2,1,'Balkans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (717,2,2001,1,1,'Serbie',130,'fr_FR','1946');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (717,2,2004,1,1,'Balkans',110,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (717,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (717,2,2007,0,1,'1945',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (717,2,2004,2,1,'Balkans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (718,2,2001,1,1,'Monténégro',130,'fr_FR','1947');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (718,2,2004,1,1,'Balkans',110,'fr_FR','1837');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (718,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (718,2,2007,0,1,'1946',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (718,2,2004,2,1,'Balkans',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (719,2,2001,1,1,'Proche-Orient',130,'fr_FR','1948');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (719,2,2004,1,1,'Moyen-Orient',110,'fr_FR','1838');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (719,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (719,2,2007,0,1,'1947',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (719,2,2004,2,1,'Moyen-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (720,2,2001,1,1,'Jordanie',130,'fr_FR','1949');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (720,2,2004,1,1,'Moyen-Orient',110,'fr_FR','1838');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (720,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (720,2,2007,0,1,'1948',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (720,2,2004,2,1,'Moyen-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (721,2,2001,1,1,'Irak',130,'fr_FR','1950');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (721,2,2004,1,1,'Moyen-Orient',110,'fr_FR','1838');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (721,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (721,2,2007,0,1,'1949',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (721,2,2004,2,1,'Moyen-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (722,2,2001,1,1,'Arabie',130,'fr_FR','1951');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (722,2,2004,1,1,'Moyen-Orient',110,'fr_FR','1838');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (722,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (722,2,2007,0,1,'1950',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (722,2,2004,2,1,'Moyen-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (723,2,2001,1,1,'Chypre',130,'fr_FR','1952');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (723,2,2004,1,1,'Proche-Orient',110,'fr_FR','1948');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (723,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (723,2,2007,0,1,'1951',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (723,2,2004,2,1,'Proche-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (724,2,2001,1,1,'Egypte',130,'fr_FR','1953');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (724,2,2004,1,1,'Proche-Orient',110,'fr_FR','1948');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (724,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (724,2,2007,0,1,'1952',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (724,2,2004,2,1,'Proche-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (725,2,2001,1,1,'Israël',130,'fr_FR','1954');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (725,2,2004,1,1,'Proche-Orient',110,'fr_FR','1948');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (725,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (725,2,2007,0,1,'1953',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (725,2,2004,2,1,'Proche-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (726,2,2001,1,1,'Liban',130,'fr_FR','1955');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (726,2,2004,1,1,'Proche-Orient',110,'fr_FR','1948');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (726,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (726,2,2007,0,1,'1954',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (726,2,2004,2,1,'Proche-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (727,2,2001,1,1,'Syrie',130,'fr_FR','1956');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (727,2,2004,1,1,'Proche-Orient',110,'fr_FR','1948');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (727,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (727,2,2007,0,1,'1955',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (727,2,2004,2,1,'Proche-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (728,2,2001,1,1,'Palestine (Territoires autonomes de)',130,'fr_FR','1957');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (728,2,2004,1,1,'Proche-Orient',110,'fr_FR','1948');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (728,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (728,2,2007,0,1,'1956',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (728,2,2004,2,1,'Proche-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (729,2,2001,1,1,'Turquie',130,'fr_FR','1958');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (729,2,2004,1,1,'Proche-Orient',110,'fr_FR','1948');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (729,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (729,2,2007,0,1,'1957',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (729,2,2004,2,1,'Proche-Orient',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (730,2,2001,1,1,'Arabie saoudite',130,'fr_FR','1959');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (730,2,2004,1,1,'Arabie',110,'fr_FR','1951');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (730,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (730,2,2007,0,1,'1958',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (730,2,2004,2,1,'Arabie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (731,2,2001,1,1,'Bahrein',130,'fr_FR','1960');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (731,2,2004,1,1,'Arabie',110,'fr_FR','1951');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (731,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (731,2,2007,0,1,'1959',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (731,2,2004,2,1,'Arabie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (732,2,2001,1,1,'Emirats arabes unis',130,'fr_FR','1961');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (732,2,2004,1,1,'Arabie',110,'fr_FR','1951');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (732,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (732,2,2007,0,1,'1960',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (732,2,2004,2,1,'Arabie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (733,2,2001,1,1,'Koweït',130,'fr_FR','1962');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (733,2,2004,1,1,'Arabie',110,'fr_FR','1951');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (733,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (733,2,2007,0,1,'1961',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (733,2,2004,2,1,'Arabie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (734,2,2001,1,1,'Oman',130,'fr_FR','1963');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (734,2,2004,1,1,'Arabie',110,'fr_FR','1951');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (734,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (734,2,2007,0,1,'1962',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (734,2,2004,2,1,'Arabie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (735,2,2001,1,1,'Qatar',130,'fr_FR','1964');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (735,2,2004,1,1,'Arabie',110,'fr_FR','1951');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (735,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (735,2,2007,0,1,'1963',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (735,2,2004,2,1,'Arabie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (736,2,2001,1,1,'Yémen',130,'fr_FR','1965');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (736,2,2004,1,1,'Arabie',110,'fr_FR','1951');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (736,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (736,2,2007,0,1,'1964',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (736,2,2004,2,1,'Arabie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (737,2,2001,1,1,'Géorgie',130,'fr_FR','1966');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (737,2,2004,1,1,'Transcaucasie',110,'fr_FR','1839');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (737,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (737,2,2007,0,1,'1965',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (737,2,2004,2,1,'Transcaucasie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (738,2,2001,1,1,'Arménie',130,'fr_FR','1967');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (738,2,2004,1,1,'Transcaucasie',110,'fr_FR','1839');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (738,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (738,2,2007,0,1,'1966',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (738,2,2004,2,1,'Transcaucasie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (739,2,2001,1,1,'Azerbaïdjan',130,'fr_FR','1968');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (739,2,2004,1,1,'Transcaucasie',110,'fr_FR','1839');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (739,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (739,2,2007,0,1,'1967',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (739,2,2004,2,1,'Transcaucasie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (740,2,2001,1,1,'Russie (Fédération de)',130,'fr_FR','1969');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (740,2,2004,1,1,'Europe de l\'Est',110,'fr_FR','1835');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (740,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (740,2,2007,0,1,'1968',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (740,2,2004,2,1,'Europe de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (741,2,2001,1,1,'Kazakhstan',130,'fr_FR','1970');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (741,2,2004,1,1,'Asie centrale',110,'fr_FR','1840');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (741,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (741,2,2007,0,1,'1969',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (741,2,2004,2,1,'Asie centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (742,2,2001,1,1,'Ouzbékistan',130,'fr_FR','1971');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (742,2,2004,1,1,'Asie centrale',110,'fr_FR','1840');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (742,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (742,2,2007,0,1,'1970',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (742,2,2004,2,1,'Asie centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (743,2,2001,1,1,'Kirghizistan',130,'fr_FR','1972');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (743,2,2004,1,1,'Asie centrale',110,'fr_FR','1840');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (743,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (743,2,2007,0,1,'1971',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (743,2,2004,2,1,'Asie centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (744,2,2001,1,1,'Turkménistan',130,'fr_FR','1973');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (744,2,2004,1,1,'Asie centrale',110,'fr_FR','1840');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (744,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (744,2,2007,0,1,'1972',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (744,2,2004,2,1,'Asie centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (745,2,2001,1,1,'Tadjikistan',130,'fr_FR','1974');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (745,2,2004,1,1,'Asie centrale',110,'fr_FR','1840');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (745,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (745,2,2007,0,1,'1973',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (745,2,2004,2,1,'Asie centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (746,2,2001,1,1,'Iran',130,'fr_FR','1975');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (746,2,2004,1,1,'Asie centrale',110,'fr_FR','1840');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (746,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (746,2,2007,0,1,'1974',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (746,2,2004,2,1,'Asie centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (747,2,2001,1,1,'Afghanistan',130,'fr_FR','1976');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (747,2,2004,1,1,'Asie centrale',110,'fr_FR','1840');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (747,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (747,2,2007,0,1,'1975',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (747,2,2004,2,1,'Asie centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (748,2,2001,1,1,'Pakistan',130,'fr_FR','1977');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (748,2,2004,1,1,'Asie centrale',110,'fr_FR','1840');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (748,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (748,2,2007,0,1,'1976',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (748,2,2004,2,1,'Asie centrale',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (749,2,2001,1,1,'Mongolie',130,'fr_FR','1978');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (749,2,2004,1,1,'Asie de l\'Est',110,'fr_FR','1841');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (749,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (749,2,2007,0,1,'1977',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (749,2,2004,2,1,'Asie de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (750,2,2001,1,1,'Corée du Nord',130,'fr_FR','1979');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (750,2,2004,1,1,'Asie de l\'Est',110,'fr_FR','1841');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (750,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (750,2,2007,0,1,'1978',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (750,2,2004,2,1,'Asie de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (751,2,2001,1,1,'Corée du Sud',130,'fr_FR','1980');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (751,2,2004,1,1,'Asie de l\'Est',110,'fr_FR','1841');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (751,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (751,2,2007,0,1,'1979',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (751,2,2004,2,1,'Asie de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (752,2,2001,1,1,'Japon',130,'fr_FR','1981');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (752,2,2004,1,1,'Asie de l\'Est',110,'fr_FR','1841');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (752,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (752,2,2007,0,1,'1980',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (752,2,2004,2,1,'Asie de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (753,2,2001,1,1,'Chine',130,'fr_FR','1982');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (753,2,2004,1,1,'Asie de l\'Est',110,'fr_FR','1841');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (753,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (753,2,2007,0,1,'1981',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (753,2,2004,2,1,'Asie de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (754,2,2001,1,1,'TaÏwan',130,'fr_FR','1983');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (754,2,2004,1,1,'Asie de l\'Est',110,'fr_FR','1841');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (754,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (754,2,2007,0,1,'1982',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (754,2,2004,2,1,'Asie de l\'Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (755,2,2001,1,1,'Inde',130,'fr_FR','1984');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (755,2,2004,1,1,'Asie du Sud',110,'fr_FR','1842');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (755,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (755,2,2007,0,1,'1983',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (755,2,2004,2,1,'Asie du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (756,2,2001,1,1,'Népal',130,'fr_FR','1985');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (756,2,2004,1,1,'Asie du Sud',110,'fr_FR','1842');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (756,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (756,2,2007,0,1,'1984',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (756,2,2004,2,1,'Asie du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (757,2,2001,1,1,'Bhoutan',130,'fr_FR','1986');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (757,2,2004,1,1,'Asie du Sud',110,'fr_FR','1842');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (757,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (757,2,2007,0,1,'1985',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (757,2,2004,2,1,'Asie du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (758,2,2001,1,1,'Bangladesh',130,'fr_FR','1987');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (758,2,2004,1,1,'Asie du Sud',110,'fr_FR','1842');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (758,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (758,2,2007,0,1,'1986',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (758,2,2004,2,1,'Asie du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (759,2,2001,1,1,'Sri Lanka',130,'fr_FR','1988');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (759,2,2004,1,1,'Asie du Sud',110,'fr_FR','1842');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (759,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (759,2,2007,0,1,'1987',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (759,2,2004,2,1,'Asie du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (760,2,2001,1,1,'Maldives',130,'fr_FR','1989');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (760,2,2004,1,1,'Asie du Sud',110,'fr_FR','1842');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (760,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (760,2,2007,0,1,'1988',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (760,2,2004,2,1,'Asie du Sud',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (761,2,2001,1,1,'Birmanie',130,'fr_FR','1990');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (761,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (761,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (761,2,2007,0,1,'1989',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (761,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (762,2,2001,1,1,'Brunei',130,'fr_FR','1991');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (762,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (762,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (762,2,2007,0,1,'1990',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (762,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (763,2,2001,1,1,'Cambodge',130,'fr_FR','1992');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (763,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (763,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (763,2,2007,0,1,'1991',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (763,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (764,2,2001,1,1,'Indonésie',130,'fr_FR','1993');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (764,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (764,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (764,2,2007,0,1,'1992',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (764,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (765,2,2001,1,1,'Laos',130,'fr_FR','1994');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (765,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (765,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (765,2,2007,0,1,'1993',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (765,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (766,2,2001,1,1,'Malaisie',130,'fr_FR','1995');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (766,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (766,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (766,2,2007,0,1,'1994',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (766,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (767,2,2001,1,1,'Philippines',130,'fr_FR','1996');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (767,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (767,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (767,2,2007,0,1,'1995',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (767,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (768,2,2001,1,1,'Singapour',130,'fr_FR','1997');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (768,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (768,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (768,2,2007,0,1,'1996',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (768,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (769,2,2001,1,1,'Thaïlande',130,'fr_FR','1998');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (769,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (769,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (769,2,2007,0,1,'1997',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (769,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (770,2,2001,1,1,'Viêt-Nam',130,'fr_FR','1999');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (770,2,2004,1,1,'Asie du Sud-Est',110,'fr_FR','1843');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (770,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (770,2,2007,0,1,'1998',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (770,2,2004,2,1,'Asie du Sud-Est',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (771,2,2001,1,1,'Papouasie-Nouvelle-Guinée',130,'fr_FR','2000');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (771,2,2004,1,1,'Mélanésie',110,'fr_FR','1845');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (771,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (771,2,2007,0,1,'1999',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (771,2,2004,2,1,'Mélanésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (772,2,2001,1,1,'Nouvelle-Calédonie',130,'fr_FR','2001');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (772,2,2004,1,1,'Mélanésie',110,'fr_FR','1845');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (772,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (772,2,2007,0,1,'2000',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (772,2,2004,2,1,'Mélanésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (773,2,2001,1,1,'Vanuatu',130,'fr_FR','2002');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (773,2,2004,1,1,'Mélanésie',110,'fr_FR','1845');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (773,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (773,2,2007,0,1,'2001',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (773,2,2004,2,1,'Mélanésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (774,2,2001,1,1,'Iles Fidji',130,'fr_FR','2003');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (774,2,2004,1,1,'Mélanésie',110,'fr_FR','1845');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (774,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (774,2,2007,0,1,'2002',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (774,2,2004,2,1,'Mélanésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (775,2,2001,1,1,'Iles Salomon',130,'fr_FR','2004');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (775,2,2004,1,1,'Mélanésie',110,'fr_FR','1845');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (775,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (775,2,2007,0,1,'2003',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (775,2,2004,2,1,'Mélanésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (776,2,2001,1,1,'Bismarck (archipel)',130,'fr_FR','2005');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (776,2,2004,1,1,'Mélanésie',110,'fr_FR','1845');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (776,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (776,2,2007,0,1,'2004',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (776,2,2004,2,1,'Mélanésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (777,2,2001,1,1,'Carolines',130,'fr_FR','2006');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (777,2,2004,1,1,'Micronésie',110,'fr_FR','1846');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (777,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (777,2,2007,0,1,'2005',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (777,2,2004,2,1,'Micronésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (778,2,2001,1,1,'Kiribati',130,'fr_FR','2007');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (778,2,2004,1,1,'Micronésie',110,'fr_FR','1846');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (778,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (778,2,2007,0,1,'2006',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (778,2,2004,2,1,'Micronésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (779,2,2001,1,1,'Mariannes',130,'fr_FR','2008');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (779,2,2004,1,1,'Micronésie',110,'fr_FR','1846');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (779,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (779,2,2007,0,1,'2007',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (779,2,2004,2,1,'Micronésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (780,2,2001,1,1,'Marshall',130,'fr_FR','2009');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (780,2,2004,1,1,'Micronésie',110,'fr_FR','1846');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (780,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (780,2,2007,0,1,'2008',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (780,2,2004,2,1,'Micronésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (781,2,2001,1,1,'Palau',130,'fr_FR','2010');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (781,2,2004,1,1,'Micronésie',110,'fr_FR','1846');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (781,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (781,2,2007,0,1,'2009',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (781,2,2004,2,1,'Micronésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (782,2,2001,1,1,'Nouvelle-Zélande',130,'fr_FR','2011');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (782,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (782,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (782,2,2007,0,1,'2010',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (782,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (783,2,2001,1,1,'Tonga',130,'fr_FR','2012');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (783,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (783,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (783,2,2007,0,1,'2011',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (783,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (784,2,2001,1,1,'Wallis-et-Futuna',130,'fr_FR','2013');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (784,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (784,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (784,2,2007,0,1,'2012',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (784,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (785,2,2001,1,1,'Nauru',130,'fr_FR','2014');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (785,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (785,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (785,2,2007,0,1,'2013',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (785,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (786,2,2001,1,1,'Tuvalu',130,'fr_FR','2015');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (786,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (786,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (786,2,2007,0,1,'2014',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (786,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (787,2,2001,1,1,'Samoa occidentales',130,'fr_FR','2016');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (787,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (787,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (787,2,2007,0,1,'2015',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (787,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (788,2,2001,1,1,'Hawaii',130,'fr_FR','2017');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (788,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (788,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (788,2,2007,0,1,'2016',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (788,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (789,2,2001,1,1,'Samoa orientales',130,'fr_FR','2018');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (789,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (789,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (789,2,2007,0,1,'2017',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (789,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (790,2,2001,1,1,'Iles Cook',130,'fr_FR','2019');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (790,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (790,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (790,2,2007,0,1,'2018',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (790,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (791,2,2001,1,1,'Polynésie française',130,'fr_FR','2020');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (791,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (791,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (791,2,2007,0,1,'2019',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (791,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (792,2,2001,1,1,'Ile de Pâques',130,'fr_FR','2021');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (792,2,2004,1,1,'Polynésie',110,'fr_FR','1847');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (792,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (792,2,2007,0,1,'2020',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (792,2,2004,2,1,'Polynésie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (793,2,2001,1,1,'Sciences de la vie',130,'fr_FR','2022');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (793,2,2004,1,1,'Sciences',110,'fr_FR','1381');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (793,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (793,2,2007,0,1,'2021',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (793,2,2004,2,1,'Sciences',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (794,2,2001,1,1,'Hommes',130,'fr_FR','2023');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (794,2,2004,1,1,'Sexualité',110,'fr_FR','1698');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (794,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (794,2,2007,0,1,'2022',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (794,2,2004,2,1,'Sexualité',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (795,2,2001,1,1,'Hommes',130,'fr_FR','2024');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (795,2,2004,1,1,'Santé',110,'fr_FR','1787');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (795,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (795,2,2007,0,1,'2023',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (795,2,2004,2,1,'Santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (796,2,2001,1,1,'Femmes',130,'fr_FR','2025');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (796,2,2004,1,1,'Sexualité',110,'fr_FR','1698');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (796,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (796,2,2007,0,1,'2024',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (796,2,2004,2,1,'Sexualité',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (797,2,2001,1,1,'Femmes',130,'fr_FR','2026');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (797,2,2004,1,1,'Santé',110,'fr_FR','1787');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (797,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (797,2,2007,0,1,'2025',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (797,2,2004,2,1,'Santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (798,2,2001,1,1,'Homosexualité',130,'fr_FR','2027');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (798,2,2004,1,1,'Sexualité',110,'fr_FR','1698');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (798,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (798,2,2007,0,1,'2026',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (798,2,2004,2,1,'Sexualité',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (799,2,2001,1,1,'Sommeil',130,'fr_FR','2028');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (799,2,2004,1,1,'Santé',110,'fr_FR','1787');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (799,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (799,2,2007,0,1,'2027',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (799,2,2004,2,1,'Santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (800,2,2001,1,1,'Avocat',130,'fr_FR','2029');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (800,2,2004,1,1,'Justice',110,'fr_FR','1503');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (800,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (800,2,2007,0,1,'2028',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (800,2,2004,2,1,'Justice',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (801,2,2001,1,1,'Maladie mentale',130,'fr_FR','2030');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (801,2,2004,1,1,'Psychiatrie',110,'fr_FR','2032');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (801,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (801,2,2007,0,1,'2029',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (801,2,2004,2,1,'Psychiatrie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (802,2,2001,1,1,'Autisme',130,'fr_FR','2031');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (802,2,2004,1,1,'Psychiatrie',110,'fr_FR','2032');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (802,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (802,2,2007,0,1,'2030',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (802,2,2004,2,1,'Psychiatrie',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (803,2,2001,1,1,'Psychiatrie',130,'fr_FR','2032');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (803,2,2004,1,1,'Médecine',110,'fr_FR','1653');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (803,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (803,2,2007,0,1,'2031',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (803,2,2004,2,1,'Médecine',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (804,2,2001,1,1,'Formes et tailles',130,'fr_FR','2034');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (804,2,2004,1,1,'Premiers acquis',110,'fr_FR','1554');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (804,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (804,2,2007,0,1,'2033',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (804,2,2004,2,1,'Premiers acquis',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (805,2,2001,1,1,'Littérature de Méditerranée orientale et Maghreb',130,'fr_FR','2035');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (805,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (805,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (805,2,2007,0,1,'2034',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (805,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (806,2,2001,1,1,'Littérature anglaise',130,'fr_FR','2036');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (806,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (806,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (806,2,2007,0,1,'2035',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (806,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (807,2,2001,1,1,'Angoisse',130,'fr_FR','2037');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (807,2,2004,1,1,'Santé',110,'fr_FR','1787');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (807,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (807,2,2007,0,1,'2036',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (807,2,2004,2,1,'Santé',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (808,2,2001,1,1,'Roller',130,'fr_FR','2040');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (808,2,2004,1,1,'Sports',110,'fr_FR','1731');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (808,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (808,2,2007,0,1,'2039',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (808,2,2004,2,1,'Sports',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (809,2,2001,1,1,'Fauteuil roulant',130,'fr_FR','2043');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (809,2,2004,1,1,'Handicap',110,'fr_FR','1691');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (809,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (809,2,2007,0,1,'2042',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (809,2,2004,2,1,'Handicap',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (810,2,2001,1,1,'Essai et récit',130,'fr_FR','2044');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (810,2,2004,1,1,'XVIIème siècle',110,'fr_FR','1424');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (810,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (810,2,2007,0,1,'2043',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (810,2,2004,2,1,'XVIIème siècle',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (811,2,2001,1,1,'Littérature française',130,'fr_FR','2045');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (811,2,2004,1,1,'Littérature',110,'fr_FR','1394');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (811,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (811,2,2007,0,1,'2044',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (811,2,2004,2,1,'Littérature',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (812,2,2001,1,1,'Littérature étrangère (sélection)',130,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (812,2,2004,1,1,'Littérature',110,'fr_FR','1394');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (812,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (812,2,2007,0,1,'2045',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (812,2,2004,2,1,'Littérature',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (813,2,2001,1,1,'Littérature espagnole',130,'fr_FR','2047');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (813,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (813,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (813,2,2007,0,1,'2046',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (813,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (814,2,2001,1,1,'Littérature d\'Europe centrale',130,'fr_FR','2048');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (814,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (814,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (814,2,2007,0,1,'2047',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (814,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (815,2,2001,1,1,'Littérature italienne',130,'fr_FR','2049');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (815,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (815,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (815,2,2007,0,1,'2048',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (815,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (816,2,2001,1,1,'Littérature lusitanienne (Portugal, Brésil)',130,'fr_FR','2050');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (816,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (816,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (816,2,2007,0,1,'2049',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (816,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (817,2,2001,1,1,'Littérature nordique',130,'fr_FR','2051');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (817,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (817,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (817,2,2007,0,1,'2050',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (817,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (818,2,2001,1,1,'Littérature russe',130,'fr_FR','2052');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (818,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (818,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (818,2,2007,0,1,'2051',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (818,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (819,2,2001,1,1,'Littérature d\'Afrique noire',130,'fr_FR','2053');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (819,2,2004,1,1,'Littérature étrangère (sélection)',110,'fr_FR','2046');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (819,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (819,2,2007,0,1,'2052',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (819,2,2004,2,1,'Littérature étrangère (sélection)',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (820,2,2001,1,1,'Poésie',130,'fr_FR','2054');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (820,2,2004,1,1,'Littérature italienne',110,'fr_FR','2049');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (820,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (820,2,2007,0,1,'2053',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (820,2,2004,2,1,'Littérature italienne',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (821,2,2001,1,1,'Aventure',130,'fr_FR','2057');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (821,2,2004,1,1,'Roman',110,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (821,2,2006,1,1,'Roman d\'aventure',100,'fr_FR','2112');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (821,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (821,2,2007,0,1,'2056',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (821,2,2004,2,1,'Roman',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (821,2,2006,2,1,'Roman d\'aventure',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (822,2,2001,1,1,'Roman historique',130,'fr_FR','2058');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (822,2,2004,1,1,'Roman',110,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (822,2,2006,1,1,'Roman historique',100,'fr_FR','1431');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (822,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (822,2,2007,0,1,'2057',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (822,2,2004,2,1,'Roman',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (822,2,2006,2,1,'Roman historique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (823,2,2001,1,1,'Amour',130,'fr_FR','2059');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (823,2,2004,1,1,'Roman',110,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (823,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (823,2,2007,0,1,'2058',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (823,2,2004,2,1,'Roman',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (824,2,2001,1,1,'Science-fiction',130,'fr_FR','2060');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (824,2,2004,1,1,'Roman',110,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (824,2,2006,1,1,'Science-fiction',100,'fr_FR','1435');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (824,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (824,2,2007,0,1,'2059',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (824,2,2004,2,1,'Roman',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (824,2,2006,2,1,'Science-fiction',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (825,2,2001,1,1,'Humour',130,'fr_FR','2061');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (825,2,2004,1,1,'Roman',110,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (825,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (825,2,2007,0,1,'2060',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (825,2,2004,2,1,'Roman',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (826,2,2001,1,1,'Policier',130,'fr_FR','2062');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (826,2,2004,1,1,'Roman',110,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (826,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (826,2,2007,0,1,'2061',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (826,2,2004,2,1,'Roman',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (827,2,2001,1,1,'Horreur',130,'fr_FR','2063');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (827,2,2004,1,1,'Roman',110,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (827,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (827,2,2007,0,1,'2062',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (827,2,2004,2,1,'Roman',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (828,2,2001,1,1,'Fantastique',130,'fr_FR','2064');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (828,2,2004,1,1,'Roman',110,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (828,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (828,2,2007,0,1,'2063',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (828,2,2004,2,1,'Roman',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (829,2,2001,1,1,'Vie quotidienne',130,'fr_FR','2065');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (829,2,2004,1,1,'Roman',110,'fr_FR','1593');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (829,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (829,2,2007,0,1,'2064',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (829,2,2004,2,1,'Roman',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (830,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','2068');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (830,2,2004,1,1,'Littérature hispano-américaine',110,'fr_FR','1455');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (830,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (830,2,2007,0,1,'2067',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (830,2,2004,2,1,'Littérature hispano-américaine',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (831,2,2001,1,1,'Chiffres',130,'fr_FR','2071');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (831,2,2004,1,1,'Premiers acquis',110,'fr_FR','1554');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (831,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (831,2,2007,0,1,'2070',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (831,2,2004,2,1,'Premiers acquis',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (832,2,2001,1,1,'Alphabet',130,'fr_FR','2072');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (832,2,2004,1,1,'Premiers acquis',110,'fr_FR','1554');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (832,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (832,2,2007,0,1,'2071',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (832,2,2004,2,1,'Premiers acquis',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (833,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','2074');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (833,2,2004,1,1,'Littérature nordique',110,'fr_FR','2051');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (833,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (833,2,2007,0,1,'2073',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (833,2,2004,2,1,'Littérature nordique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (834,2,2001,1,1,'Anglais',130,'fr_FR','2075');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (834,2,2004,1,1,'Langues - Linguistique',110,'fr_FR','1652');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (834,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (834,2,2007,0,1,'2074',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (834,2,2004,2,1,'Langues - Linguistique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (835,2,2001,1,1,'Café',130,'fr_FR','2076');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (835,2,2004,1,1,'Aliments',110,'fr_FR','2125');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (835,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (835,2,2007,0,1,'2075',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (835,2,2004,2,1,'Aliments',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (836,2,2001,1,1,'Roman et nouvelle',130,'fr_FR','2078');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (836,2,2004,1,1,'Littérature asiatique',110,'fr_FR','1442');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (836,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (836,2,2007,0,1,'2077',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (836,2,2004,2,1,'Littérature asiatique',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (837,2,2001,1,1,'Mayas',130,'fr_FR','2079');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (837,2,2004,1,1,'Civilisations précolombiennes',110,'fr_FR','2082');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (837,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (837,2,2007,0,1,'2078',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (837,2,2004,2,1,'Civilisations précolombiennes',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (838,2,2001,1,1,'Incas',130,'fr_FR','2080');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (838,2,2004,1,1,'Civilisations précolombiennes',110,'fr_FR','2082');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (838,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (838,2,2007,0,1,'2079',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (838,2,2004,2,1,'Civilisations précolombiennes',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (839,2,2001,1,1,'Aztèques',130,'fr_FR','2081');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (839,2,2004,1,1,'Civilisations précolombiennes',110,'fr_FR','2082');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (839,2,1,1,1,'Statut par défaut',100,'','1');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (839,2,2007,0,1,'2080',100,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (839,2,2004,2,1,'Civilisations précolombiennes',0,'','0');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (840,2,2001,1,1,'Civilisations précolombiennes',130,'fr_FR','2082');
INSERT INTO authorities_fields_global_index (id_authority, type, code_champ, code_ss_champ, ordre, value, pond, lang, authority_num) VALUES (840