<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_display_record_analysis.class.php,v 1.1.2.3 2025/11/05 15:17:33 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

// dfinition de la classe d'affichage des articles en liste pour selecteur
class selector_display_record_analysis extends selector_display_record {

    public $typ_lig = 5; //type de ligne
    
	public $parent_title = '';
	public $parent_numero = '';
	public $parent_date = '';
	public $parent_date_date = '';
	public $parent_aff_date_date = '';
	public $in_bull = '';		//lien bulletin renvoye

	// rcupration des valeurs en table
	public function getData() {
		global $msg;

		$q = "SELECT * FROM notices WHERE notice_id='".$this->notice_id."' ";
		$r = pmb_mysql_query($q);
		if(pmb_mysql_num_rows($r)) {
			$this->notice = pmb_mysql_fetch_object($r);
		}
		// rcupration des donnes du bulletin et de la notice apparente
		$requete = "SELECT b.tit1,c.*,date_format(date_date, '".$msg["format_date"]."') as aff_date_date ";
		$requete.= "from analysis a, notices b, bulletins c ";
		$requete.= "WHERE a.analysis_notice=".$this->notice_id." ";
		$requete.= "AND c.bulletin_id=a.analysis_bulletin ";
		$requete .= "AND c.bulletin_notice=b.notice_id ";
		$requete.= "LIMIT 1";
		$myQuery = pmb_mysql_query($requete);
		if (pmb_mysql_num_rows($myQuery)) {
			$parent = pmb_mysql_fetch_object($myQuery);
			$this->parent_title = $parent->tit1;
			$this->parent_numero = $parent->bulletin_numero;
			$this->parent_date = $parent->mention_date;
			$this->parent_date_date = $parent->date_date;
			$this->parent_aff_date_date = $parent->aff_date_date;
		}
	}

	// creation header
	public function doHeader() {
		global $charset;
		global $pmb_notice_reduit_format;

		//gen. statut
		if ($this->notice->statut) {
			$rqt_st = "SELECT class_html , gestion_libelle FROM notice_statut WHERE id_notice_statut='".$this->notice->statut."' ";
			$res_st = pmb_mysql_query($rqt_st);
			$class_html = " class='".pmb_mysql_result($res_st, 0, 0)."' ";
			$txt = pmb_mysql_result($res_st, 0, 1);
		} else {
			$class_html = " class='statutnot1' " ;
			$txt = '' ;
		}
		if ($this->notice->commentaire_gestion) {
		    if ($txt) {
		        $txt .= ":\r\n".$this->notice->commentaire_gestion;
		    } else {
		        $txt = $this->notice->commentaire_gestion;
		    }
		}
		if ($txt) {
			$statut = "<small><span $class_html style='margin-right: 3px;'><a href=# onmouseover=\"z=document.getElementById('zoom_statut".$this->notice_id."'); z.style.display=''; \" onmouseout=\"z=document.getElementById('zoom_statut".$this->notice_id."'); z.style.display='none'; \"><img src='".get_url_icon('spacer.gif')."' width='10' height='10' /></a></span></small>";
			$statut .= "<div id='zoom_statut".$this->notice_id."' style='border: solid 2px #555555; background-color: #FFFFFF; position: absolute; display:none; z-index: 2000;'><b>".nl2br(htmlentities($txt,ENT_QUOTES, $charset))."</b></div>" ;
		} else {
		    $statut = "<small><span $class_html style='margin-right: 3px;'><img src='".get_url_icon('spacer.gif')."' width='10' height='10' /></span></small>";
		}
		$this->statut = $statut;

		$this->tit1 = $this->notice->tit1;
		$this->header.= $this->tit1;

		//aff. auteur1
		$aut1_libelle = array() ;
		$lib_auteur='';
		$as = array_search ("0", $this->responsabilites["responsabilites"]);
		if ($as!== FALSE && $as!== NULL) {
			$auteur_0 = $this->responsabilites["auteurs"][$as] ;
			$auteur = new auteur($auteur_0["id"]);
			if ($auteur->get_isbd()) {
				$lib_auteur=$auteur->get_isbd();
			}
		} else {
			$as = array_keys ($this->responsabilites["responsabilites"], "1" );
			for ($i = 0 ; $i < count($as) ; $i++) {
				$indice = $as[$i] ;
				$auteur_1 = $this->responsabilites["auteurs"][$indice];
				$auteur = new auteur($auteur_1["id"]);
				$aut1_libelle[]= $auteur->get_isbd();
			}
			$auteurs_liste = implode ("; ",$aut1_libelle) ;
			if ($auteurs_liste) {
				$this->header .= ' / '. $auteurs_liste;
				$lib_auteur=$auteurs_liste;
			}
		}
		if ($lib_auteur!='') {
			$this->header .= ' / '. $lib_auteur;
		}

		//renvoi lien bulletin
		$this->in_bull= "in ".$this->parent_title." (".$this->parent_numero." ".($this->parent_date?$this->parent_date:$this->parent_aff_date_date).")";

		$this->header=$this->header." <i>".$this->in_bull."</i> ";

		//aff. annee
		switch ($pmb_notice_reduit_format) {
			case '1':
				if ($this->notice->year != '') $this->header.=' ('.htmlentities($this->notice->year, ENT_QUOTES, $charset).')';
				break;
			case "2":
				if ($this->notice->year != '') $this->header.=' ('.htmlentities($this->notice->year, ENT_QUOTES, $charset).')';
				if ($this->notice->code != '') $this->header.=' / '.htmlentities($this->notice->code, ENT_QUOTES, $charset);
				break;
			default :
				break;
		}

		//renvoi titre
		$this->titre = $this->tit1;

		//renv. auteur1
		$this->auteur1=$lib_auteur;

		//renv. prix
		$this->prix=$this->notice->prix;

	}

	// creation contenu
	public function doContent() {
		global $tdoc;
		global $fonction_auteur;

		//mention titre
		$this->isbd = $this->titre;
		if($this->notice->tit4) $this->isbd .= "&nbsp;: ".$this->notice->tit4;
		if($this->notice->tit2) $this->isbd .= "&nbsp;; ".$this->notice->tit2;
		$this->isbd .= ' ['.$tdoc->table[$this->notice->typdoc].']';
		//mention responsabilit
		$mention_resp = array() ;
		$as = array_search ("0", $this->responsabilites["responsabilites"]);
		if ($as!== FALSE && $as!== NULL) {
			$auteur_0 = $this->responsabilites["auteurs"][$as] ;
			$auteur = new auteur($auteur_0["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_0["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_0["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$as = array_keys ($this->responsabilites["responsabilites"], "1" );
		for ($i = 0 ; $i < count($as) ; $i++) {
			$indice = $as[$i] ;
			$auteur_1 = $this->responsabilites["auteurs"][$indice] ;
			$auteur = new auteur($auteur_1["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_1["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_1["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$as = array_keys ($this->responsabilites["responsabilites"], "2" ) ;
		for ($i = 0 ; $i < count($as) ; $i++) {
			$indice = $as[$i] ;
			$auteur_2 = $this->responsabilites["auteurs"][$indice] ;
			$auteur = new auteur($auteur_2["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_2["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_2["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$libelle_mention_resp = implode ("; ",$mention_resp) ;
		if($libelle_mention_resp) {
			$this->isbd .= "&nbsp;/ $libelle_mention_resp" ;
		}

		// zone de la collation
		if($this->notice->npages) {
			$collation = $this->notice->npages;
			if($collation) {
			    $this->isbd .= ".&nbsp;-&nbsp;$collation";
			}
		}
		$this->isbd .= '.';

		//prix
		if($this->notice->prix) {
			$zoneNote = $this->notice->prix;
			if($zoneNote) {
			    $this->isbd .= "<br /><br />$zoneNote.";
			}
		}
	}
	
	public function getNomActe() {
	    $nom_acte = $this->titre;
	    if ($this->auteur1 != '') {
	        $nom_acte .= "<br />".$this->auteur1;
	    }
	    if ($this->in_bull != '') {
	        $nom_acte .= "<br />".$this->in_bull;
	    }
	    return $nom_acte;
	}
}
