<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_display_bulletin.class.php,v 1.1.2.3 2025/11/05 15:17:33 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

//dfinition de la classe d'affichage des bulletins en liste pour selecteur
class selector_display_bulletin extends selector_display {

	public $bulletin_id=0;
	public $bulletin = '';
	public $nb_expl=0;

	public $typ_lig = 2; //type de ligne
	public $titre = '';				//titre renvoye
	public $editeur1 = '';				//editeur 1 renvoye
	public $numero = '';				//numero renvoye
	public $aff_date = '';				//date renvoyee

	//constructeur
	public function __construct($id, $base_url, $form_checker='') {
	    parent::__construct($id, $base_url, $form_checker);
	    $this->bulletin_id=intval($id);
	}

	// rcupration des valeurs en table
	public function getData() {
	    global $msg;
	    
	    $q = "SELECT notices.tit1, notices.ed1_id, notices.code, bulletins.*, date_format(bulletins.date_date, '".$msg['format_date']."') as aff_date_date FROM bulletins join notices on bulletin_notice=notice_id WHERE bulletin_id='".$this->bulletin_id."' ";
	    $r = pmb_mysql_query($q);
	    if(pmb_mysql_num_rows($r)) {
	        $this->bulletin = pmb_mysql_fetch_object($r);
	    }
	    $q = "select count(*) from exemplaires where expl_bulletin='".$this->bulletin_id."' ";
	    $r = pmb_mysql_query($q);
	    $this->nb_expl = pmb_mysql_result($r,0,0);
	    
	    $this->titre = $this->bulletin->tit1;
	    if ($this->bulletin->ed1_id) {
	        $ed1= new editeur($this->bulletin->ed1_id);
	        $this->editeur1 = $ed1->get_isbd();
	    }
	    if ($this->bulletin->bulletin_numero!=='') {
	        $this->numero = $this->bulletin->bulletin_numero;
	    }
	    if ($this->bulletin->libelle_periode) {
	        $this->aff_date = "(".$this->bulletin->libelle_periode.")";
	    }
	    if ($this->bulletin->date_date!='0000-00-00') {
	        $this->aff_date.= " [".$this->bulletin->aff_date_date."]";
	    }
	    if ($this->bulletin->bulletin_cb!='') {
	        $this->code = $this->bulletin->bulletin_cb;
	    }
	}
	
	// creation header
	public function doHeader() {
	    global $charset;
	    
	    $aff = $this->titre;
	    if($this->numero) {
	        $aff.= '. '.$this->numero;
	    }
	    $aff.= ' '.$this->aff_date;
	    
	    $aff = htmlentities($aff, ENT_QUOTES, $charset);
	    if ($this->action) {
	        $aff= str_replace('!!display!!', "<b>$aff</b>", $this->action);
	    }
	    if(trim($this->form_checker)){
	        $this->result = "<span class='acq_sel_display_middle'>".$this->getCheckbox().$aff."</span>";
	    }else{
	        $this->result = $aff;
	    }
	}
	
	public function finalize() {
	    if ($this->action) {
	        if (count($this->action_values)) {
	            foreach($this->action_values as $v) {
	                $this->result = str_replace("!!$v!!", addslashes($this->$v), $this->result);
	            }
	        }
	    }
	}
	
	public function getNomActe() {
	    $nom_acte = $this->titre;
	    if ($this->numero != '') {
	        $nom_acte .= "<br />".$this->numero;
	    }
	    if ($this->aff_date != '') {
	        $nom_acte .= $this->aff_date;
	    }
	    if ($this->editeur1 != '') {
	        $nom_acte .= "<br />".$this->editeur1;
	    }
	    return $nom_acte;
	}
}
