<?php

// +-------------------------------------------------+
//  2002-2010 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: affichage.class.php,v 1.17.2.1.6.1 2025/09/19 11:59:43 dbellamy Exp $

class affichage
{
    //document numerique a afficher
    public $doc;

    //classe driver de la visionneuse
    public $driver;

    //parametres eventuels
    public $params;

    public $allowedFunction = array();

    public $message;

    //tableau des infos a afficher
    public $toDisplay = array();

    //tableau decrivant les parametres de la classe
    public $tabParam = array();

    //tableau des parametres de la classe
    public $parameters = array();

    public function __construct($doc)
    {
        $this->doc = $doc;
        $this->driver = $doc->driver;
        $this->params = $doc->params;
    }

    public function fetchDisplay()
    {
        global $charset;

        //le titre
        $this->toDisplay["titre"] = $this->doc->titre;
        //le pdf
        //$this->toDisplay["doc"] = "<iframe src='".$visionneuse_path."/pdf.php?id=".$this->doc->id."' width='".$this->params["maxX"]."' height='".$this->params["maxY"]."'></iframe>";
        $url_doc = $this->driver->getDocumentUrl($this->doc->id);
        if (strpos($this->doc->path, "http") === 0) {
            $url_doc = $this->doc->path;
        }
        $this->toDisplay["doc"] = "<iframe title='" . htmlentities($this->doc->titre, ENT_QUOTES, $charset) . "' name='docnum' id='docnum' src='" . $url_doc . "' width='" . $this->driver->getParam("maxX") . "' height='" . $this->driver->getParam("maxY") . "'></iframe>";
        $this->toDisplay["doc"] .= "
		<script>
			window.onload = checkSize;
			function checkSize(){
				var iframe= document.getElementById('docnum');
				if (isNaN(iframe.width) || iframe.width/getFrameWidth() <= 0.9 || iframe.width/getFrameWidth() >= 1){
					iframe.width = '90%';
					iframe.height = ((getFrameHeight()-40-80)*0.9)+'px';
				}
			}
		</script>";
        //la description
        $this->toDisplay["desc"] = $this->doc->desc;
        //toPost
        return $this->toDisplay;
    }


    //excution de l'appel AJAX
    public function exec($method)
    {
        if ($this->checkAllowedFunction($method)) {
            $this->{$method}();
        } else {
            print "forbidden";
        }
        return false;
    }

    public function checkAllowedFunction($method)
    {
        return in_array($method, $this->allowedFunction);
    }

    public function setMessage($message)
    {
        $this->message = $message;
    }
}
