<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: user_error.inc.php,v 1.1.2.4 2025/10/02 13:24:04 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) {
    die("no access");
}

global $class_path;
require_once($class_path."/notification.class.php");

/**
 * fonctions d'affichage des messages d'erreur
 *
 * @param string $error_message
 * @return void
 */
function error_form_message($error_message)
{
    echo "<script>alert(\"$error_message\"); history.go(-1);</script>";
    exit();
}

/**
 * Affiche un message d'erreur
 *  Attention : Les balises HTML sont autorisees, penses a mettre des htmlentities
 *
 * @param string $error_title Titre de l'erreur (non utilise)
 * @param string $error_message Message d'erreur (Attention : les balises HTML sont autorisees)
 * @param int $back_button Afficher le bouton "retour"
 * @param string $ret_adr URL de retour sinon "history.go(-1)" est fait par defaut
 * @param bool $return_html Retourne le code html
 * @return void|string
 */
function error_message($error_title, $error_message, $back_button = 0, $ret_adr = '', $return_html = false)
{
    //$html = "<br />";
    $notification = new notification('error', $error_message);
    if ($back_button) {
        $notification->add_back_action($ret_adr);
    }
    $html = $notification->render();
    if ($return_html) {
        return $html;
    } else {
        echo $html;
    }
}

/**
 * Affiche un message d'erreur
 *
 * @param string $error_title titre du message
 * @param string $error_message texte du message
 * @param integer $back_button flag pour affichage du bouton (TRUE=oui ; FALSE=non)
 * @param string $ret_adr adresse de retour. si non prcis : $default_ret_adr est utilis
 * @param string $ret_url adresse de retour
 * @return string
 */
function return_error_message($error_title, $error_message, $back_button = 0, $ret_adr = '', $ret_url = '')
{
    global $msg;
    global $current_module ;

    $default_ret_adr = './index.php';
    
    //$retour = "<br />";
    $notification = new notification('error', $error_message);
    $retour = $notification->render();

    if ($back_button) {
        if (!$ret_adr) {
            $ret_adr = $default_ret_adr;
        }

        if (strpos($ret_url, "?")) {
            $extract_url = explode("?", $ret_url);
            $items = explode("&", $extract_url[1]);
            if (is_array($items)) {
                foreach ($items as $i => $item) {
                    $item = explode("=", $item);
                    switch ($item[0]) {
                        case "action":
                        case "act":
                            $items[$i] = $item[0]."=";
                            break;
                        default:
                            $items[$i] = $item[0]."=".$item[1];
                            break;
                    }
                }
                $extract_url[1] = implode("&", $items);
            }
            $ret_url = implode("?", $extract_url);
        }
        if (strpos($ret_url, 'ajax.php') !== false) {
            $ret_url = $_SERVER['HTTP_REFERER'];
        }
        $retour .= "
			<div class='row'>
				<form class='form-$current_module' name='dummy' method=\"post\" action=\"".urldecode($ret_adr)."\">
				<input type=hidden name=ret_url value=\"".addslashes($ret_url)."\">
				<input type='submit' name='ok' class='bouton' value=' $msg[11] ' >
				</form>
				<script type='text/javascript'>
					document.forms['dummy'].elements['ok'].focus();
					if (typeof unload_off === 'function') {
						unload_off();
					}
				</script>
				</div>
				";
    }
    return $retour ;
}

/**
 * Affiche un message d'erreur
 *
 * @param string $error_title titre du message
 * @param string $error_message texte du message
 * @param integer $back_button flag pour affichage du bouton (TRUE=oui ; FALSE=non)
 * @return void
 */
function error_message_history($error_title, $error_message, $back_button = 0)
{
// 	print "<br />";
    $notification = new notification('error', $error_message);
    print $notification->render();
    
    if($back_button) {
        $notification->add_back_action();
        print "<div class='row' id='error_message_history_button'>".$notification->render_actions()."</div>";
    }
}
