<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: search.class.php,v 1.1.2.2.2.4 2026/02/11 14:20:46 tsamson Exp $

use Pmb\AI\Library\Source\Semantic;
use Pmb\AI\Orm\AISettingsOrm;

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

class ai_search_ask
{
    public $id;
    public $n_ligne;
    public $params;

    public const IS_RESPONSIVE = true;

    /**
     * Recherche parente
     *
     * @var search
     */
    public $search;

    /**
     * Source
     *
     * @var Semantic|null
     */
    public $source = null;

    /**
     * Constructeur
     *
     * @param mixed $id
     * @param mixed $n_ligne
     * @param mixed $params
     * @param search $search
     */
    public function __construct($id, $n_ligne, $params, &$search)
    {
        $this->id = $id;
        $this->n_ligne = $n_ligne;
        $this->params = $params;
        $this->search = &$search;
    }

    /**
     * Fonction de rcupration des oprateurs disponibles pour ce champ spcial
     * (renvoie un tableau d'oprateurs)
     *
     * @return array Oprateurs disponibles
     */
    public function get_op()
    {
        $operators = array();
        if ($_SESSION["nb_queries"] != 0) {
            $operators["EQ"] = "=";
        }
        return $operators;
    }

    /**
     * Retourne de la valeur de saisie
     *
     * @return string
     */
    protected function get_value()
    {
        $valeur_ = $this->get_field_name();
        global ${$valeur_};

        $value = ${$valeur_} ?? null;
        return is_string($value) ? stripslashes($value) : '';
    }

    /**
     * Retourne le nom du champ
     *
     * @return string
     */
    protected function get_field_name()
    {
        return "field_{$this->n_ligne}_s_{$this->id}";
    }

    /**
     * Fonction de rcupration de l'affichage de la saisie du critre
     *
     * @return string Chaine html
     */
    public function get_input_box()
    {
        $template = <<<HTML
        <span class="search_value">
            <input type="text" name="%s" value="%s" class="ext_search_txt">
        </span>
        HTML;

        return sprintf($template, $this->get_field_name(), $this->get_value());
    }

    /**
     * Retourne le champ cach
     *
     * @return string Chaine html
     */
    public function get_hidden_input_box()
    {
        $template = <<<HTML
            <input type="hidden" name="%s" value="%s">
        HTML;

        return sprintf($template, $this->get_field_name(), $this->get_value());
    }

    /**
     * Fonction de vrification du champ saisi ou slectionn
     *
     * @param int $valeur Champ saisi ou slectionn
     * @return boolean true si vide
     */
    public function is_empty($valeur)
    {
        return empty(trim($valeur));
    }

    /**
     * Retourne la source
     *
     * @return Semantic|null
     */
    protected function get_source()
    {
        if ($this->source === null) {
            $aiSettings = AISettingsOrm::fetchActiveAiSettings();
            if (!empty($aiSettings)) {
                $this->source = new Semantic($aiSettings);
            }
        }
        return $this->source;
    }

    public function make_human_query()
    {

        $value = $this->get_value();

        return [
            $value
        ];
    }

    public function make_search()
    {
        $table_name = "ai_search_" . md5(microtime(true));
        $query = "CREATE TEMPORARY TABLE IF NOT EXISTS ".$table_name." (
            notice_id int(11) NOT NULL,
            pert decimal(16,1) default 1
        ) ENGINE=".$this->search->current_engine;
        pmb_mysql_query($query);

        $query = "ALTER TABLE ".$table_name." ADD INDEX notice_id (notice_id)";
        pmb_mysql_query($query);

        $user_query = $this->get_value();
        if ($this->is_empty($user_query)) {
            return $table_name;
        }

        $result = $this->get_source()?->search($user_query);
        if (empty($result) || $result['object'] === Semantic::OBJECT_RETRY_AFTER) {
            return $table_name;
        }

        $recordsId = [];
        $query = "INSERT INTO ".$table_name." (notice_id, pert) VALUES ";
        $values = [];

        foreach ($result['data'] as $object) {

            switch ($object['object_type']) {
                case TYPE_EXPLNUM:
                    $id = $this->getNoticeIdByExplnum($object['object_id']);
                    if (!empty($id) && !in_array($id, $recordsId)) {
                        $values[] = "(" . $id . ", " . $object['score'] . ")";
                    }
                    break;

                case TYPE_NOTICE:
                    if (!in_array($object['object_id'], $recordsId)) {
                        $values[] = "(" . $object['object_id'] . ", " . $object['score'] . ")";
                    }
                    break;

            }
        }

        if (!empty($values)) {
            $query .= implode(', ', $values);
            pmb_mysql_query($query);
        }

        return $table_name;
    }

    /**
     * Get Notice Id By Explnum
     *
     * @param integer $explnumId
     * @return int
     */
    protected function getNoticeIdByExplnum(int $explnumId)
    {
        $query = "SELECT explnum_notice FROM explnum WHERE explnum_id = " . intval($explnumId);
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            return intval(pmb_mysql_result($result, 0, 0));
        }
        return 0;
    }

    /**
     * formulaire responsive
     *
     * @return string
     */
    public function get_input_box_responsive()
    {
        global $charset;
        //Rcupration de la valeur de saisie
        $valeur_ = "field_".$this->n_ligne."_s_".$this->id;
        global ${$valeur_};
        if (json_validate(stripslashes(${$valeur_}))) {
            $valeur = json_decode(stripslashes(${$valeur_}));
        } else {
            $valeur = ${$valeur_};
        }
        $user_query = "<span class='search_value'><input type='text' name='field_".$this->n_ligne."_s_".$this->id."' value='".htmlentities($valeur[0], ENT_QUOTES, $charset)."' /></span>";
        return $user_query;
    }
    
    /**
     * test de la visibilite en fonction du parametre ai_active
     * @return boolean
     */
    public static function check_visibility() {
        global $ai_active;
        if($ai_active) {
            return true;
        } else {
            return false;
        }
    }
}
