<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: search.class.php,v 1.1.6.1.2.4 2026/02/11 14:20:46 tsamson Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

use Pmb\AI\Models\AiSessionSemanticModel;

class ai_search
{
    public $id;
    public $n_ligne;
    public $params;

    public const IS_RESPONSIVE = true;


    /**
     * Recherche parente
     *
     * @var search
     */
    public $search;

    /**
     * Constructeur
     *
     * @param mixed $id
     * @param mixed $n_ligne
     * @param mixed $params
     * @param search $search
     */
    public function __construct($id, $n_ligne, $params, &$search)
    {
        $this->id = $id;
        $this->n_ligne = $n_ligne;
        $this->params = $params;
        $this->search = &$search;
    }

    /**
     * Fonction de rcupration des oprateurs disponibles pour ce champ spcial
     * (renvoie un tableau d'oprateurs)
     *
     * @return array Oprateurs disponibles
     */
    public function get_op()
    {
        $operators = array();
        if ($_SESSION["nb_queries"] != 0) {
            $operators["EQ"] = "=";
        }
        return $operators;
    }

    /**
     * Retourne de la valeur de saisie
     *
     * @return string
     */
    protected function get_value()
    {
        $valeur_ = $this->get_field_name();
        global ${$valeur_};

        $fields = ${$valeur_};
        $value = $fields[0] ?? null;
        return is_string($value) ? $value : '';
    }

    /**
     * Retourne le nom du champ
     *
     * @return string
     */
    protected function get_field_name()
    {
        return "field_{$this->n_ligne}_s_{$this->id}";
    }

    /**
     * Fonction de rcupration de l'affichage de la saisie du critre
     *
     * @return string Chaine html
     */
    public function get_input_box()
    {
        global $msg;

        $template = '<label for="%s">%s</label>';
        $template .= '<select name="%s" id="%s">%s</select>';

        $options = '';
        $option_format = '<option value="%s" %s>%s</option>';
        $option_opt_format = '<optgroup label="%s">%s</optgroup>';
        foreach (AiSessionSemanticModel::findAll() as $ai_session_semantic) {

            $options_template = '';
            foreach ($ai_session_semantic->aiSessionSemantiqueQuestions as $index => $question) {
                $option_value = "{$ai_session_semantic->idAiSessionSemantique}_{$index}";
                $selected = ($option_value == $this->get_value()) ? 'selected' : '';
                $options_template .= sprintf($option_format, $option_value, $selected, $question);
            }

            $options .= sprintf($option_opt_format, $ai_session_semantic->aiSessionSemantiqueName, $options_template);
        }

        return sprintf(
            $template,
            $this->get_field_name(),
            $msg['ai_search_criteria_rmc'],
            $this->get_field_name() . "[]",
            $this->get_field_name(),
            $options
        );
    }

    /**
     * Fonction de vrification du champ saisi ou slectionn
     *
     * @param int $valeur Champ saisi ou slectionn
     * @return boolean true si vide
     */
    public function is_empty($valeur)
    {
        return empty($valeur) && AiSessionSemanticModel::exist($valeur);
    }

    public function make_human_query()
    {
        global $msg;

        $value = $this->get_value();
        $values = explode('_', $value);
        $values = array_map('intval', $values);

        $idAiSessionSemantique = $values[0];
        $indexQuestion = $values[1];

        if (!AiSessionSemanticModel::exist($idAiSessionSemantique)) {
            return "";
        }

        $ai_session_semantic = new AiSessionSemanticModel($idAiSessionSemantique);
        if (empty($ai_session_semantic->aiSessionSemantiqueQuestions[$indexQuestion])) {
            return "";
        }

        return [
            sprintf(
                $msg['ai_search_human_query'],
                $ai_session_semantic->aiSessionSemantiqueQuestions[$indexQuestion]
            )
        ];
    }

    public function make_search()
    {

        $value = $this->get_value();
        $values = explode('_', $value);
        $values = array_map('intval', $values);

        $idAiSessionSemantique = $values[0];
        $indexQuestion = $values[1];

        if (!AiSessionSemanticModel::exist($idAiSessionSemantique)) {
            return "";
        }

        $ai_session_semantic = new AiSessionSemanticModel($idAiSessionSemantique);
        if (
            empty($ai_session_semantic->aiSessionSemantiqueQuestions[$indexQuestion]) ||
            empty($ai_session_semantic->aiSessionSemantiqueNumObjects[$indexQuestion])
        ) {
            return "";
        }

        $result = $ai_session_semantic->aiSessionSemantiqueNumObjects[$indexQuestion];

        $table_name = "ai_search_" . md5(microtime(true));
        $query = "CREATE TEMPORARY TABLE IF NOT EXISTS ".$table_name." (
            notice_id int(11) NOT NULL,
            pert decimal(16,1) default 1
        ) ENGINE=".$this->search->current_engine;
        pmb_mysql_query($query);

        $query = "ALTER TABLE ".$table_name." ADD INDEX notice_id (notice_id)";
        pmb_mysql_query($query);

        $recordsId = [];
        $query = "INSERT INTO ".$table_name." (notice_id, pert) VALUES ";
        $values = [];

        foreach ($result as $object) {

            switch ($object['object_type']) {
                case TYPE_EXPLNUM:
                    $id = $this->getNoticeIdByExplnum($object['object_id']);
                    if (!empty($id) && !in_array($id, $recordsId)) {
                        $values[] = "(" . $id . ", " . $object['score'] . ")";
                    }
                    break;

                case TYPE_NOTICE:
                    if (!in_array($object['object_id'], $recordsId)) {
                        $values[] = "(" . $object['object_id'] . ", " . $object['score'] . ")";
                    }
                    break;

            }
        }

        if (!empty($values)) {
            $query .= implode(', ', $values);
            pmb_mysql_query($query);
        }

        return $table_name;
    }

    /**
     * Get Notice Id By Explnum
     *
     * @param integer $explnumId
     * @return int
     */
    protected function getNoticeIdByExplnum(int $explnumId)
    {
        $query = "SELECT explnum_notice FROM explnum WHERE explnum_id = " . intval($explnumId);
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            return intval(pmb_mysql_result($result, 0, 0));
        }
        return 0;
    }

    /**
     * formulaire responsive
     *
     * @return string
     */
    public function get_input_box_responsive()
    {
        global $msg;


        //Rcupration de la valeur de saisie
		$valeur_ = "field_" . $this->n_ligne . "_s_" . $this->id;
		global ${$valeur_};
		$valeur = ${$valeur_};
		if (json_validate(stripslashes($valeur))) {
			$valeur = json_decode(stripslashes($valeur));
		}

        $template = '<select class="rmc_special_field" name="%s" id="%s">%s</select>';

        $options = '';
        $option_format = '<option value="%s" %s>%s</option>';
        $option_opt_format = '<optgroup label="%s">%s</optgroup>';
        foreach (AiSessionSemanticModel::findAll() as $ai_session_semantic) {

            $options_template = '';
            foreach ($ai_session_semantic->aiSessionSemantiqueQuestions as $index => $question) {
                $option_value = "{$ai_session_semantic->idAiSessionSemantique}_{$index}";
                $selected = ($option_value == $valeur) ? 'selected' : '';
                $options_template .= sprintf($option_format, $option_value, $selected, $question);
            }

            $options .= sprintf($option_opt_format, $ai_session_semantic->aiSessionSemantiqueName, $options_template);
        }

        return sprintf(
            $template,
            $this->get_field_name() . "[]",
            $this->get_field_name(),
            $options
        );
    }
    
    /**
     * test de la visibilite en fonction du parametre ai_active
     * @return boolean
     */
    public static function check_visibility() {
        global $ai_active;
        if($ai_active) {
            return true;
        } else {
            return false;
        }
    }
}
