<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: rdf_entities_converter_category.class.php,v 1.4.12.1 2025/06/27 14:20:46 rtigero Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

global $class_path;

require_once $class_path . '/rdf_entities_conversion/rdf_entities_converter_authority.class.php';

class rdf_entities_converter_category extends rdf_entities_converter_authority
{

    public static $table_name = 'noeuds';

    public static $table_key = 'id_noeud';

    protected $ppersos_prefix = 'categ';

    protected $type_constant = TYPE_CATEGORY;

    protected $aut_table_constant = AUT_TABLE_CATEGORIES;

    protected function init_map_fields()
    {
        $this->map_fields = array_merge(parent::init_map_fields(), array(
            // 'id_noeud' => 'http://www.pmbservices.fr/ontology#identifier',
            'num_thesaurus' => 'http://www.pmbservices.fr/ontology#has_thesaurus',
            'autorite' => 'http://www.pmbservices.fr/ontology#authority_number'
        ));
        return $this->map_fields;
    }

    protected function init_foreign_fields()
    {
        $this->foreign_fields = array_merge(parent::init_foreign_fields(), array(
            'num_parent' => array(
                'type' => 'category',
                'property' => 'http://www.pmbservices.fr/ontology#parent_category'
            ),
            'num_renvoi_voir' => array(
                'type' => 'category',
                'property' => 'http://www.pmbservices.fr/ontology#category_see'
            )
        ));
        return $this->foreign_fields;
    }

    protected function init_special_fields()
    {
        $this->special_fields = array_merge(parent::init_special_fields(), array(
            'http://www.pmbservices.fr/ontology#thumbnail_url' => array(
                "method" => array(
                    $this,
                    "get_thumbnail_url"
                ),
                "arguments" => array(
                    $this->aut_table_constant
                )
            ),
            'http://www.pmbservices.fr/ontology#label' => array(
                "method" => array(
                    $this,
                    "getLabel"
                ),
                "arguments" => array()
            )
        ));

        return $this->special_fields;
    }

    protected function init_linked_entities()
    {
        $this->linked_entities = array_merge(parent::init_linked_entities(), array(
            'http://www.pmbservices.fr/ontology#has_concept' => array(
                'type' => 'concept',
                'table' => 'index_concept',
                'reference_field_name' => 'num_object',
                'external_field_name' => 'num_concept',
                'other_fields' => array(
                    'type_object' => TYPE_CATEGORY
                )
            ),
            'http://www.pmbservices.fr/ontology#category_see_also' => array(
                'type' => 'category',
                'table' => 'voir_aussi',
                'reference_field_name' => 'num_noeud_orig',
                'external_field_name' => 'num_noeud_dest',
                'other_fields' => array(
                    'langue' => 'fr_FR'
                ),
            )
        ));
        return $this->linked_entities;
    }

    public function get_assertions()
    {
        if (! isset($this->assertions)) {
            $this->assertions = array();

            if (empty($this->uri)) {
                $this->init_uri();
            }
            $subject = $this->uri;
            $query = "SELECT " . static::$table_name . ".*, parent.autorite as parent_autorite FROM " . static::$table_name . " ";
            $query .= "LEFT JOIN " . static::$table_name . " as parent on " . static::$table_name . ".num_parent = parent.id_noeud ";
            $query .= " WHERE " . static::$table_name . "." . static::$table_key . " = " . $this->entity_id;
            $result = pmb_mysql_query($query);
            $row = pmb_mysql_fetch_assoc($result);
            pmb_mysql_free_result($result);
            $this->init_map_fields();
            foreach ($this->map_fields as $key => $property) {
                if (isset($row[$key])) {
                    $this->assertions[] = new onto_assertion($subject, $property, $row[$key], 'http://www.w3.org/2000/01/rdf-schema#Literal', array(
                        'type' => 'literal'
                    ));
                    // $this->assertions[$this->prefix_rdf.$this->entity_type."#".$this->entity_id][$property] = $row[$key];
                }
            }
            $this->init_foreign_fields();
            foreach ($this->foreign_fields as $key => $property) {

                // On ignore le parent si c'est le noeud TOP du thesaurus
                $ignore_parent = false;
                if (($key == 'num_parent') && ('TOP' == $row['parent_autorite'])) {
                    $ignore_parent = true;
                }
                if (isset($row[$key]) && ! $ignore_parent) {
                    $object_properties = $this->get_object_properties($row[$key], $property['type']);
                    $value = "";
                    if (! empty($row[$key])) {
                        $value = $row[$key];
                    }
                    $this->assertions[] = new onto_assertion($subject, $property['property'], $value, $this->prefix_rdf . "#" . $property['type'], $object_properties);
                }
            }
            $this->get_assertions_from_linked_entities();
            $this->get_assertions_from_special_fields();

            if ($this->ppersos_prefix) {
                $onto_parametres_perso = new onto_parametres_perso($this->ppersos_prefix);
                $assertions = $onto_parametres_perso->get_assertions_for_rdf($this->entity_id, $subject);
                if (count($assertions)) {
                    $this->assertions = array_merge($this->assertions, $assertions);
                }
            }
        }
        return $this->assertions;
    }

	/**
     * Recupere le label de la categorie dans la langue par defaut du thesaurus
     * @return false | [onto_assertion]
     */
    protected function getLabel()
    {
        if(empty($this->entity_id) ){
            return false;
        }
        $label = '';
        $query = "select libelle_categorie from categories join thesaurus on num_thesaurus=id_thesaurus and langue=langue_defaut where num_noeud=" . $this->entity_id;
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            $label = pmb_mysql_result($result, 0, 0);
        }
        return new onto_assertion(
            $this->uri,
            "http://www.pmbservices.fr/ontology#label",
            $label,
            "http://www.w3.org/2000/01/rdf-schema#Literal",
            array('type'=>"literal")
        );
    }
}
