<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_groups.class.php,v 1.1.2.2 2025/11/28 08:06:00 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_groups {
	protected $type = 'notices';
	protected $data = [];
	
	protected static $instances = [];
	
	public function __construct($type='notices'){
	    $this->type = $type;
		$this->fetch_data();
	}
	
	protected function fetch_data() {
	    $this->data = [];
	    $query = "SELECT id_group, group_title FROM custom_fields_groups WHERE group_type = '".addslashes($this->type)."' ORDER BY group_title";
	    $result = pmb_mysql_query($query);
	    if (pmb_mysql_num_rows($result)) {
	        while ($row = pmb_mysql_fetch_object($result)) {
	            $this->data[] = new custom_fields_group($row->id_group);
	        }
	    }
	}
	
	/**
	 * Recherche du groupe associe au champ perso
	 * @param integer $id_field
	 * @return object|NULL
	 */
	public function find_group($id_field) {
	    $id_field = intval($id_field);
	    if (!empty($this->data)) {
	        foreach ($this->data as $custom_fields_group) {
	            $fields = $custom_fields_group->get_fields();
	            if (!empty($fields) && is_countable($fields) && in_array($id_field, $fields)) {
	                return $custom_fields_group;
	            }
	        }
	    }
	    return null;
	}
	/**
	 * Mise a jour des groupes de champs a partir d'un champ personnalise
	 * @param integer $id_field
	 * @param integer $id_group
	 */
	public function update_parametres_perso($id_field, $id_group) {
	    $id_field = intval($id_field);
	    if (!empty($this->data)) {
	        foreach ($this->data as $custom_fields_group) {
	            if ($id_group == $custom_fields_group->get_id()) {
	                $custom_fields_group->add_field($id_field);
	            } else {
	                $custom_fields_group->remove_field($id_field);
	            }
	            $custom_fields_group->save();
	        }
	    }
	}
	
	public function get_type(){
	    return $this->type;
	}
	
	public function get_data(){
	    return $this->data;
	}
		
	public function set_type($type) {
		$this->type = $type;
	}
	
	public static function get_instance($type='notices') {
	    if (!isset(static::$instances[$type])) {
	        static::$instances[$type] = new custom_fields_groups($type);
	    }
	    return static::$instances[$type];
	}
}

