<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_text_i18n.class.php,v 1.2.8.1 2025/11/18 14:19:11 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_text_i18n extends custom_fields {
	
    protected static $type = 'text_i18n';
    
    protected static function get_chk_values($name) {
        global ${$name};
        global ${$name}, ${$name."_langs"};
        $val=${$name};
        $langs = (${$name."_langs"});
        $final_value = array();
        if (isset($val) && is_array($val)) {
            foreach ($val as $key => $value) {
                if ($value) {
                    $final_value[] = $value."|||".($langs[$key] ? $langs[$key] : '');
                }
            }
        }
        return $final_value;
    }
    
    public static function val($field, $value) {
        global $pmb_perso_sep;
        
        $langue_doc = get_langue_doc();
        $value=format_output($field,$value);
        if (!$value) {
            $value=array();
        }
        $formatted_values = array();
        foreach ($value as $val) {
            $exploded_val = explode("|||", $val);
            $formatted_values[] = $exploded_val[0]." ".($exploded_val[1] ? "(".$langue_doc[$exploded_val[1]].")" : '');
        }
        
        if(!isset($field["OPTIONS"][0]["ISHTML"][0]["value"])) {
            $field["OPTIONS"][0]["ISHTML"][0]["value"] = '';
        }
        if($field["OPTIONS"][0]["ISHTML"][0]["value"]){
            return array("ishtml" => true, "value"=>implode($pmb_perso_sep,$formatted_values), "withoutHTML" =>implode($pmb_perso_sep,$formatted_values));
        }else{
            return implode($pmb_perso_sep,$formatted_values);
        }
    }
    
    protected static function get_js_function_add($field) {
        global $charset, $base_path;
        
        $langue_doc = get_langue_doc();
        $options=$field['OPTIONS'][0];
        if(isset($options['DEFAULT_LANG'][0]['value']) && $options['DEFAULT_LANG'][0]['value']) {
            $default_lang = $options['DEFAULT_LANG'][0]['value'];
        } else {
            $default_lang = "";
        }
        return "<script>
			function add_custom_text_i18n_(field_id, field_name, field_size, field_maxlen) {
		        var count = document.getElementById('customfield_text_i18n_'+field_id).value;
				var text = document.createElement('input');
				text.setAttribute('id', field_name + '_' + count);
		        text.setAttribute('name',field_name+'[' + count + ']');
		        text.setAttribute('type','text');
		        text.setAttribute('value','');
		        text.setAttribute('size',field_size);
		        text.setAttribute('maxlength',field_maxlen);
                
				var lang = document.createElement('input');
				lang.setAttribute('id', field_name + '_lang_' + count);
				lang.setAttribute('class', 'saisie-10emr');
				lang.setAttribute('type', 'text');
				lang.setAttribute('value', \"".($default_lang ? htmlentities($langue_doc[$default_lang],ENT_QUOTES,$charset) : '')."\");
				lang.setAttribute('autfield', field_name + '_lang_code_' + count);
				lang.setAttribute('completion', 'langue');
				lang.setAttribute('autocomplete', 'off');
				    
				var select = document.createElement('input');
				select.setAttribute('class', 'bouton');
				select.setAttribute('type', 'button');
				select.setAttribute('value', '...');
				select.addEventListener('click', function(){
					openPopUp('".$base_path."/select.php?what=lang&caller='+this.form.name+'&p1=' + field_name + '_lang_code_' + count + '&p2=' + field_name + '_lang_' + count, 'select_lang', 500, 400, -2, -2, 'scrollbars=yes, toolbar=no, dependent=yes, resizable=yes');
				}, false);
					    
				var del = document.createElement('input');
				del.setAttribute('class', 'bouton');
				del.setAttribute('type', 'button');
				del.setAttribute('value', 'X');
				del.addEventListener('click', function(){
					document.getElementById(field_name + '_lang_' + count).value=''; document.getElementById(field_name + '_lang_code_' + count).value='';
				}, false);
					    
				var lang_code = document.createElement('input');
				lang_code.setAttribute('id', field_name + '_lang_code_' + count);
				lang_code.setAttribute('type', 'hidden');
				lang_code.setAttribute('value', \"".$default_lang."\");
				lang_code.setAttribute('name', field_name + '_langs[' + count + ']');
					
		        space=document.createElement('br');
					    
				document.getElementById('spaceformorecustomfieldtexti18n_'+field_id).appendChild(text);
				document.getElementById('spaceformorecustomfieldtexti18n_'+field_id).appendChild(lang);
				document.getElementById('spaceformorecustomfieldtexti18n_'+field_id).appendChild(select);
				document.getElementById('spaceformorecustomfieldtexti18n_'+field_id).appendChild(del);
				document.getElementById('spaceformorecustomfieldtexti18n_'+field_id).appendChild(lang_code);
				document.getElementById('spaceformorecustomfieldtexti18n_'+field_id).appendChild(space);
					    
				document.getElementById('customfield_text_i18n_'+field_id).value = document.getElementById('customfield_text_i18n_'+field_id).value * 1 + 1;
				ajax_pack_element(lang);
			}
		</script>";
    }
    
    protected static function get_event_button_add($field) {
        $options=$field['OPTIONS'][0];
        return 'add_custom_text_i18n_(\''.$field['ID'].'\', \''.addslashes($field['NAME']).'\','.addslashes($options['SIZE'][0]['value']).','.addslashes($options['MAXSIZE'][0]['value']).')';
    }
    
    public static function get_aff_values($field) {
        $options=$field['OPTIONS'][0];
        $values=$field['VALUES'];
        if (!$values) {
            if(isset($options['DEFAULT_LANG'][0]['value']) && $options['DEFAULT_LANG'][0]['value']) {
                $values = array("|||".$options['DEFAULT_LANG'][0]['value']);
            } else {
                $values = array("");
            }
        }
        return $values;
    }
    
    public static function get_display_value($field, $indice, $value) {
        global $base_path, $charset;
        
        $langue_doc = get_langue_doc();
        $options=$field['OPTIONS'][0];
        $exploded_value = explode("|||", $value);
        $display = "<input id=\"".$field['NAME']."_".$indice."\" type=\"text\" size=\"".$options['SIZE'][0]['value']."\" maxlength=\"".$options['MAXSIZE'][0]['value']."\" name=\"".$field['NAME']."[".$indice."]\" data-form-name='".$field["NAME"]."_' value=\"".htmlentities($exploded_value[0],ENT_QUOTES,$charset)."\">";
        $display .= "<input id=\"".$field['NAME']."_lang_".$indice."\" class=\"saisie-10emr\" type=\"text\" value=\"".(isset($exploded_value[1]) && $exploded_value[1] ? htmlentities($langue_doc[$exploded_value[1]],ENT_QUOTES,$charset) : '')."\" autfield=\"".$field['NAME']."_lang_code_".$indice."\" completion=\"langue\" autocomplete=\"off\" data-form-name='".$field["NAME"]."_lang_' >";
        $display .= "<input class=\"bouton\" type=\"button\" value=\"...\" onClick=\"openPopUp('".$base_path."/select.php?what=lang&caller='+this.form.name+'&p1=".$field['NAME']."_lang_code_".$indice."&p2=".$field['NAME']."_lang_".$indice."', 'select_lang', 500, 400, -2, -2, 'scrollbars=yes, toolbar=no, dependent=yes, resizable=yes')\">";
        $display .= "<input class=\"bouton\" type=\"button\" onclick=\"this.form.".$field['NAME']."_lang_".$indice.".value=''; this.form.".$field['NAME']."_lang_code_".$indice.".value=''; \" value=\"X\">";
        $display .= "<input id=\"".$field['NAME']."_lang_code_".$indice."\" data-form-name='".$field["NAME"]."_lang_code_' type=\"hidden\" value=\"".(isset($exploded_value[1]) && $exploded_value[1] ? htmlentities($exploded_value[1], ENT_QUOTES, $charset) : '')."\" name=\"".$field['NAME']."_langs[".$indice."]\">";
        return $display;
    }
    
    public static function get_block_dnd($field, $indice, $html, $value='') {
        $exploded_value = explode("|||", $value);
        return parent::get_block_dnd($field, $indice, $html, $exploded_value[0]);
    }
    
    public static function aff_search($field,&$check_scripts,$varname) {
        global $charset;
        global $msg;
        global $base_path;
        
        $langue_doc = get_langue_doc();
        $options=$field['OPTIONS'][0];
        $values=$field['VALUES'];
        if(!is_array($values)) {
            $values = array(
                'text' => '',
                'lang' => ''
            );
        }
        $ret="<input id=\"".$varname."\" type=\"text\" size=\"".$options['SIZE'][0]['value']."\" name=\"".$varname."[0][text]\" value=\"".htmlentities($values[0]['text'],ENT_QUOTES,$charset)."\">";
        $ret.="<input id=\"".$varname."_lang\" class=\"saisie-10emr\" type=\"text\" value=\"".($values[0]['lang'] ? htmlentities($langue_doc[$values[0]['lang']],ENT_QUOTES,$charset) : '')."\" autfield=\"".$varname."_lang_code\" completion=\"langue\" autocomplete=\"off\" >";
        $ret.="<input class=\"bouton\" type=\"button\" value=\"".$msg['parcourir']."\" onClick=\"openPopUp('".$base_path."/select.php?what=lang&caller='+this.form.name+'&p1=".$varname."_lang_code&p2=".$varname."_lang', 'select_lang', 500, 400, -2, -2, 'scrollbars=yes, toolbar=no, dependent=yes, resizable=yes')\">";
        $ret.="<input class=\"bouton\" type=\"button\" onclick=\"this.form.".$varname."_lang.value=''; this.form.".$varname."_lang_code.value=''; \" value=\"".$msg['raz']."\">";
        $ret.="<input id=\"".$varname."_lang_code\" type=\"hidden\" value=\"".($values[0]['lang'] ? htmlentities($values[0]['lang'], ENT_QUOTES, $charset) : '')."\" name=\"".$varname."[0][lang]\">";
        return $ret;
    }
}