<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_comment.class.php,v 1.2.4.1.4.2 2025/11/26 14:08:06 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_comment extends custom_fields {
	
    protected static $type = 'comment';
    
    public static function val($field, $value) {
        global $pmb_perso_sep;
        
        $value=format_output($field,$value);
        if (!$value) {
            $value=array();
        }
        
        if(!isset($field["OPTIONS"][0]["ISHTML"][0]["value"])) {
            $field["OPTIONS"][0]["ISHTML"][0]["value"] = '';
        }
        if($field["OPTIONS"][0]["ISHTML"][0]["value"]) {
            return array("ishtml" => true, "value"=>implode($pmb_perso_sep,$value), "withoutHTML" =>implode($pmb_perso_sep,$value));
        }else{
            return implode($pmb_perso_sep,$value);
        }
    }
    
    protected static function get_js_function_add($field) {
        return "<script>
            function add_custom_comment_(field_id, field_name, field_rows, field_cols, field_maxsize) {
				document.getElementById('customfield_comment_'+field_id).value = document.getElementById('customfield_comment_'+field_id).value * 1 + 1;
				count = document.getElementById('customfield_comment_'+field_id).value;
				
				var node_dnd_id = get_custom_dnd_on_add('spaceformorecustomfieldcomment_'+field_id, 'customfield_comment_'+field_name, (count-1));
				var	buttonAdd = document.getElementById('button_add_' + field_name + '_' + field_id);
				
				f_aut0 = document.createElement('textarea');
				f_aut0.setAttribute('name',field_name+'[]');
				f_aut0.setAttribute('id',field_name+'_'+cpt);
				f_aut0.setAttribute('cols',field_cols);
				f_aut0.setAttribute('rows',field_rows);
				f_aut0.setAttribute('maxlength',field_maxsize);
				f_aut0.setAttribute('wrap','virtual');
				
				space=document.createElement('br');
				
				document.getElementById(node_dnd_id).appendChild(f_aut0);
				if (buttonAdd) document.getElementById(node_dnd_id).appendChild(buttonAdd);
				document.getElementById(node_dnd_id).appendChild(space);
				cpt++;
			}
			</script>";
    }

    public static function get_aff_values($field) {
        $values = $field['VALUES'];
        
        if (is_string($values)) {
            $values = [$values];
        }
        if (!isset($values[0])) {
            $values[0] = '';
        }
        return $values;
    }
    
    protected static function get_event_button_add($field) {
        $options=$field['OPTIONS'][0];
        return 'add_custom_comment_(\''.$field['ID'].'\', \''.addslashes($field['NAME']).'\','.$options['ROWS'][0]['value'].','.$options['COLS'][0]['value'].','.$options['MAXSIZE'][0]['value'].')';
    }
    
    public static function get_display_value($field, $indice, $value) {
        global $charset;
        
        $options=$field['OPTIONS'][0];
        return "<textarea id=\"".$field['NAME']."\" cols=\"".$options['COLS'][0]['value']."\"  rows=\"".$options['ROWS'][0]['value']."\" maxlength=\"".$options['MAXSIZE'][0]['value']."\" name=\"".$field['NAME']."[]\" wrap=virtual>".htmlentities($value,ENT_QUOTES,$charset)."</textarea>";
    }
    
    public static function aff($field,&$check_scripts) {
        $ret = '';
        $options = $field['OPTIONS'][0];
        $values = static::get_aff_values($field);
        $ret = "";
        if (isset($options['REPEATABLE'][0]['value']) && $options['REPEATABLE'][0]['value']) {
            $ret.="<script>var cpt = ".count($values).";</script>";
        }
        $ret .= parent::aff($field, $check_scripts);
        return $ret;
    }
    
    public static function aff_search($field,&$check_scripts,$varname) {
        global $charset;
        
        $options=$field['OPTIONS'][0];
        $values = static::get_aff_values($field);
        $ret="<textarea id=\"".$varname."\" cols=\"".$options['COLS'][0]['value']."\"  rows=\"".$options['ROWS'][0]['value']."\" name=\"".$varname."[]\" wrap=virtual>".htmlentities($values[0],ENT_QUOTES,$charset)."</textarea>";
        return $ret;
    }
    
    public static function get_formatted_label_aff_filter($label) {
        return cutlongwords($label);
    }
    
    public static function get_rgaa_label($field, $varname) {
        return $varname;
    }
}