<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: isidoreapi.class.php,v 1.5.12.1.2.2 2025/11/28 15:26:11 rtigero Exp $

global $class_path;
require_once($class_path."/curl.class.php");

class isidoreapi extends connector {

    protected $api_url = 'https://api.isidore.science';

    /**
     *
     * {@inheritDoc}
     * @see connector::get_id()
     */
    public function get_id()
    {
        return "isidoreapi";
    }

    //Formulaire des proprits gnrales
    public function source_get_property_form($source_id) {
        global $charset;
        $params=$this->get_source_params($source_id);
        //Affichage du formulaire en fonction de $this->parameters
        $url='';
        $limit = '';
        if ($params["PARAMETERS"]) {
            $vars = unserialize($params["PARAMETERS"]);
            $url=$vars['url'];
            $limit=$vars['limit'];
            if(array_key_exists('isidore_hal_domains', $vars)) {
                $isidore_hal_domains=$vars['isidore_hal_domains'];
            }
            if(array_key_exists('isidore_doc_types', $vars)) {
                $isidore_doc_types=$vars['isidore_doc_types'];
            }
        }
        if(empty($url)) {
            $url = $this->api_url;
        }
        $form="<div class='row'>
                <div class='colonne3'>
                        <label for='url'>".$this->msg["isidoreapi_url"]."</label>
                </div>
                <div class='colonne_suite'>
                        <input type='text' name='url' id='url' class='saisie-120em' value='".htmlentities($url,ENT_QUOTES,$charset)."'/>
                </div>
        </div>
        <div class='row'>
                <div class='colonne3'>
                        <label for='url'>".$this->msg["isidoreapi_limit"]."</label>
                </div>
                <div class='colonne_suite'>
                        <input type='text' name='limit' id='limit' class='saisie-60em' value='".htmlentities($limit,ENT_QUOTES,$charset)."'/>
                </div>
        </div>";
        if (!isset($isidore_hal_domains)) {
    		$isidore_hal_domains = '';
    	}
    	if (!isset($isidore_doc_types)) {
    		$isidore_doc_types = array();
    	}

    	$curl = new Curl();
    	$curl->timeout = 60;
    	$curl->set_option('CURLOPT_SSL_VERIFYPEER',false);


    	$response = $curl->get($this->make_get($url, ['facet' => 'discipline', "output" => "json"]));
		$json_content = encoding_normalize::json_decode($response->body, true);

		$hal_domains = $json_content['response']['replies']['facets']['facet']['node'];

    	$response = $curl->get($this->make_get($url, ['facet' => 'type', "output" => "json"]));
		$json_content = encoding_normalize::json_decode($response->body, true);

		$doc_types = $json_content['response']['replies']['facets']['facet']['node'];

    	$form.= "
		<div class='row'>
			<div class='colonne3'>
				<label for='isidore_hal_domains'>".$this->msg["isidore_hal_domains"]."</label>
			</div>
			<div class='colonne_suite'>
				<select name='isidore_hal_domains'>";

    	if (!empty($hal_domains) && is_countable($hal_domains)) {
        	for ($i = 0; $i < count($hal_domains); $i++) {
        		$form.= "
        				<option value='".$hal_domains[$i]['@key']."' ".(($hal_domains[$i]['@key'] == $isidore_hal_domains) ? "selected='selected'" : "").">".htmlentities($hal_domains[$i]['label']['$'], ENT_QUOTES, $charset)." ".sprintf($this->msg['isidore_nb_items'], $hal_domains[$i]['@items'])."</option>";
        	}
    	}
    	$form.= "
				</select>
			</div>
		</div>
		<div class='row'>
			<div class='colonne3'>
				<label for='isidore_doc_types'>".$this->msg["isidore_doc_types"]."</label>
			</div>
			<div class='colonne_suite'>
				<select name='isidore_doc_types[]' multiple='multiple' size='".(is_countable($doc_types) && count($doc_types) <= 30 ? count($doc_types) : 30)."'>";

    	if (!empty($doc_types) && is_countable($doc_types)) {
        	for ($i = 0; $i < count($doc_types); $i++) {
        		$form.= "
        				<option value='".$doc_types[$i]['@key']."' ".(in_array($doc_types[$i]['@key'], $isidore_doc_types) ? "selected='selected'" : "").">".htmlentities($doc_types[$i]['label']['$'], ENT_QUOTES, $charset)."</option>";
        	}
    	}

    	$form.= "
				</select>
			</div>
		</div>";
        $form.="
                <div class='row'></div>
                ";
        return $form;
    }

    public function make_serialized_source_properties($source_id) {
        global $url,$limit,$isidore_hal_domains,$isidore_doc_types;
        $this->sources[$source_id]["PARAMETERS"]=serialize(['url'=>$url,'limit'=>$limit,'isidore_hal_domains'=>$isidore_hal_domains,'isidore_doc_types'=>$isidore_doc_types]);
    }

    //Rcupration  des prorits globales par dfaut du connecteur (timeout, retry, repository, parameters)
    public function fetch_default_global_values() {
        parent::fetch_default_global_values();
        $this->repository=2;
    }

    private function checkArray($value) {
        if (is_array($value))
            $val=$value[0];
            else $val=$value;
            if (is_object($val)) {
                if ($val->{"$"}) $val=$val->{"$"}; else $val="?";
            }
            return $val;
    }

    public function rec_record($record,$source_id,$search_id,$url) {
        //Initialisation
        $ref="";
        $ufield="";
        $usubfield="";
        $field_order=0;
        $subfield_order=0;
        $value="";
        $date_import=date("Y-m-d H:i:s",time());

        $params=$this->get_source_params($source_id);

        $ref = md5($record->{"@uri"});

        //Si conservation des anciennes notices, on regarde si elle existe
        if (!$this->del_old) {
            $ref_exists = $this->has_ref($source_id, $ref);
        }
        //Si pas de conservation des anciennes notices, on supprime
        if ($this->del_old) {
            $this->delete_from_entrepot($source_id, $ref);
            $this->delete_from_external_count($source_id, $ref);
        }
        $ref_exists = false;
        //Si pas de conservation ou reference inexistante
        if ( ($this->del_old) ||  ( (!$this->del_old) && (!$ref_exists) ) ) {
            //Insertion de l'entete
            $n_header["rs"]="*";
            $n_header["ru"]="*";
            $n_header["el"]="*";
            $n_header["bl"]="m";
            $n_header["hl"]="0";
            $n_header["dt"]="a";

            //Rcupration d'un ID
            $recid = $this->insert_into_external_count($source_id, $ref);

            foreach($n_header as $hc=>$code) {
                $this->insert_header_into_entrepot($source_id, $ref, $date_import, $hc, $code, $recid, $search_id);
            }

            foreach($record->isidore as $key=>$value) {
                switch ($key) {
                    case "title":
                        $ufield="200";
                        $usubfield="a";
                        $val=$this->checkArray($value);
                        break;
                    case "date":
                        $ufield="210";
                        $usubfield="d";
                        $val=$this->checkArray($value->{"@origin"});
                        if (preg_match("/[0-9]{4}/",$val,$m)) {
                            $val=$m[0];
                        } else $val="";
                        break;
                    case "abstract":
                        $ufield="327";
                        $usubfield="a";
                        $val=$this->checkArray($value);
                        if (is_object($val) && $val->{"$"}) {
                            $val=$val->{"$"};
                        }
                        break;
                    case "types":
                        $ufield="900";
                        $usubfield="a";
                        $val="Doctrine";
                        //$val=$this->checkArray($value->type);
                        break;
                    case "url":
                        $ufield="856";
                        $usubfield="u";
                        $val=$this->checkArray($value);
                        break;
                    case "enrichedCreators":
                        $ufield="700";
                        $usubfield="a";
                        $creator=$this->checkArray($value->creator);
                        $val=$this->checkArray($creator->{"@origin"});
                        break;
                    case "coverages":
                        $ufield="215";
                        $usubfield="a";
                        $val=$this->checkArray($value->coverage);
                        break;
                }
                $field_order=0;
                /*if (!is_object($val))
                 print($source_id." ".$ref." ".$date_import." ".$ufield." ".$usubfield." ".$field_order." 0 ".$val." ".$recid." ".$search_id).PHP_EOL;
                 else {
                 print($source_id." ".$ref." ".$date_import." ".$ufield." ".$usubfield." ".$field_order." 0 ".$recid." ".$search_id).PHP_EOL;
                 print_r($val);
                 }*/
                $this->insert_content_into_entrepot($source_id, $ref, $date_import, $ufield, $usubfield, $field_order, 0, $val, $recid, $search_id);
            }
            //$this->insert_content_into_entrepot($source_id, $ref, $date_import, "900", "a", 0, 0, 'Isidore', $recid, $search_id);
            $this->insert_content_into_entrepot($source_id, $ref, $date_import, "801", "b", 0, 0, $params["NAME"], $recid, $search_id);
            $this->rec_isbd_record($source_id, $ref, $recid);
            $this->n_recu++;
        }
    }

    public function make_get($url,$criterias) {
        $get = $url . "/resource/search?";
        $first = true;
        foreach ($criterias as $param => $value) {
            if(is_array($value)) {
                foreach ($value as $v) {
                    $get .= (! $first ? "&" : "") . $param . "=" . rawurlencode($v);
                    if ($first) {
                        $first = ! $first;
                    }
                }
            } else {
                $get .= (! $first ? "&" : "") . $param . "=" . rawurlencode($value);
                if ($first) {
                    $first = ! $first;
                }
            }
        }
        return $get;
    }

    //Fonction de recherche
    public function search($source_id,$query,$search_id) {
        $params=$this->get_source_params($source_id);
        $params_source=unserialize($params["PARAMETERS"]);

        $url=$params_source['url'];
        $limit=intval($params_source['limit']);
        if(array_key_exists('isidore_hal_domains', $params_source)) {
            $isidore_hal_domains = $params_source['isidore_hal_domains'];
        }
        if(array_key_exists('isidore_doc_types', $params_source)) {
            $isidore_doc_types = $params_source['isidore_doc_types'];
        }

        if (!$limit) $limit=100;

        foreach($query as $amterm) {
            switch ($amterm->ufield) {
                case 'XXX':
                    $criterias['q']=rawurlencode($amterm->values[0]);
                    break;
                case '461$t':
                    $criterias['collection']=rawurlencode($amterm->fieldvar['trevue_id'][0]);
                    break;
                case '7XX':
                    $criterias['author']=rawurlencode($amterm->fieldvar['auteur_id'][0]);
                    break;
                case '210$d':
                    $criterias['date']=rawurlencode(substr($amterm->values[0],strlen($amterm->values[0])-4,4));
                    break;
                case '200$a':
                    $criterias['q']=rawurlencode($amterm->values[0]);
                    break;
                default:
                    break;
            }
        }
        if (!count($criterias)) return;
        $criterias['output']='json';
        if(!isset($isidore_hal_domains)) {
            //Le droit par dfaut parce que pourquoi pas ?
            $isidore_hal_domains = 'http://aurehal.archives-ouvertes.fr/subject/shs.droit';
        }
        if(!isset($isidore_doc_types)) {
            $isidore_doc_types = '';
        }
        $criterias['discipline']= $isidore_hal_domains;
        $criterias['type']= $isidore_doc_types;
        $criterias['replies']=200;
        $criterias['sort']="relevance";
        //Requte CURL au webservice...
        $get=$this->make_get($url,$criterias);

        //Appel Curl
        $curl =  new Curl();
        $result = $curl->get($get);
        if ($result) {
            $result=encoding_normalize::json_decode($result);
            $page=0;
            $red=0;
            $result=$result->response->replies->content->reply;
            if (!is_array($result)) $result=[$result];
            while ($red<=$limit) {
                for ($i=0; $i<count($result); $i++) {
                    $elt=$result[$i];
                    if ($elt) {
                        $this->rec_record($elt,$source_id,$search_id,$url);
                    }
                    $red++;
                    if ($red>$limit) break;
                }
                if ($red>=$limit) break;
                    $page++;
                    $criterias['page']=$page;
                    $get=$this->make_get($url,$criterias);
                    unset($result);
                    $result = $curl->get($get);
                    if ($result) {
                        $result=encoding_normalize::json_decode($result);
                        $result=$result->response->replies->content->reply;
                        if(!isset($result) || !is_array($result)) {
                            break;
                        }
                }
            }
        }
    }
}
