<?php
// +-------------------------------------------------+
// | 2002-2007 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: pmbesCMS.class.php,v 1.1.2.2 2025/10/30 13:23:25 rtigero Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path, $include_path;
require_once($class_path . "/external_services.class.php");
require_once("$include_path/mysql_connect.inc.php");

class pmbesCMS extends external_services_api_class
{
	public function __construct($external_services, $group_name, &$proxy_parent)
	{
		parent::__construct($external_services, $group_name, $proxy_parent);
	}

	public function listArticles($articles_ids)
	{
		$result = array();
		foreach ($articles_ids as $article_id) {
			$result[] = $this->formatArticle(new cms_article($article_id));
		}
		return $result;
	}

	public function getSectionArticles($section_id)
	{
		$result = array();
		$section = new cms_section($section_id);
		$children = $section->get_articles(false);
		foreach ($children as $article) {
			$result[] = $article->id;
		}
		return $result;
	}

	public function getSectionSections($section_id)
	{
		$result = array();
		$section = new cms_section($section_id);
		$children = $section->get_children(false);
		foreach ($children as $section) {
			$result[] = $section->id;
		}
		return $result;
	}

	public function listSections($sections_ids)
	{
		$result = array();
		foreach ($sections_ids as $section_id) {
			$result[] = $this->formatSection(new cms_section($section_id));
		}
		return $result;
	}

	protected function formatSection(cms_section $section)
	{
		$logo = "";
		if ($section->logo) {
			$logo = $section->logo->get_vign_url();
		}
		return array(
			'id_section' => $section->id,
			'section_title' => encoding_normalize::utf8_normalize($section->title),
			'section_resume' => encoding_normalize::utf8_normalize($section->resume),
			'section_contenu' => encoding_normalize::utf8_normalize($section->get_detail()),
			'section_logo' => $logo,
		);
	}

	protected function formatArticle(cms_article $article)
	{
		$logo = "";
		if ($article->logo) {
			$logo = $article->logo->get_vign_url();
		}
		return array(
			'id_article' => $article->id,
			'article_title' => encoding_normalize::utf8_normalize($article->title),
			'article_resume' => encoding_normalize::utf8_normalize($article->resume),
			'article_contenu' => encoding_normalize::utf8_normalize($article->contenu),
			'article_logo' => $logo,
		);
	}
}
