#!/usr/bin/php
<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: check_sign_integrity.php,v 1.1.2.2 2026/02/02 12:50:12 rtigero Exp $

if (php_sapi_name() != 'cli') {
    die("This script must be run from the command line.\n");
}


$base_path = __DIR__ . '/../';
$base_noheader = 1;
$base_nocheck = 1;
$base_nobody = 1;
$base_nosession = 1;

$_SERVER['REQUEST_URI'] = '';

require_once $base_path . '/includes/init.inc.php';

global $msg, $lang, $pmb_digital_signature_activate;


//On inclut les messages pour viter les warnings dans les inclusions de fichiers qui utilisent $msg
$messages = new XMLlist("$include_path/messages/$lang.xml", 0);
$messages->analyser();
$msg = $messages->table;

if ($pmb_digital_signature_activate == 0) {
    die($msg["check_sign_signature_disabled"]);
}

use Pmb\Digitalsignature\Library\CheckSignatures;

$arguments = array_slice($argv, 1);
$logLocation = "";
$signature_id = 0;

for ($i = 0; $i < count($arguments); $i++) {
    switch ($arguments[$i]) {
        case "-l":
        case "--log":
            if (isset($arguments[$i + 1]) && is_dir($arguments[$i + 1])) {
                $logLocation = $arguments[$i + 1];
            }
            break;
        case "-s":
        case "--signature":
            if (isset($arguments[$i + 1])) {
                $signature_id = $arguments[$i + 1];
            }
            break;
        default:
            break;
    }
}

$checkSignatures = new CheckSignatures();
$checkSignatures->checkSignatures(intval($signature_id));
$nbSignaturesVerified = $checkSignatures->getNbSignaturesVerified();

$line = sprintf($msg["check_sign_nb_check"], $nbSignaturesVerified) . "\n";

if (!empty($logLocation)) {
    $logfile = $logLocation . DIRECTORY_SEPARATOR . "check_sign_integrity_" . date("Y-m-d_H-i-s") . ".log";
    file_put_contents($logfile, $line . PHP_EOL, FILE_APPEND);
} else {
    echo $line;
}


if ($checkSignatures->hasErrors()) {
    $errors = $checkSignatures->getErrors();

    if (! empty($logLocation)) {
        file_put_contents($logfile, $msg["check_sign_errors_detected"] . "\n", FILE_APPEND);
    } else {
        echo $msg["check_sign_errors_detected"] . "\n";
    }

    foreach ($errors as $error) {
        $line = "(explnum_id : {$error['docnumId']}) {$error['name']} => {$error['error']}";
        if (! empty($logLocation)) {
            file_put_contents($logfile, $line . PHP_EOL, FILE_APPEND);
        } else {
            echo $line . PHP_EOL;
        }
    }
}
