<?php

// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_common_selector_all_diffusions.class.php,v 1.2.2.2 2025/09/02 12:38:29 jparis Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

use Pmb\DSI\Orm\DiffusionOrm;

class cms_module_common_selector_all_diffusions extends cms_module_common_selector
{
	/*
	 * Retourne les diffusions
	 */
	public function get_value()
	{
		$result = [];
		$diffusions = DiffusionOrm::finds([
			"settings" => [
				"value" => "%\"opacVisibility\":true%",
				"operator" => "LIKE",
				"inter" => "AND"
			]
		]);
		foreach ($diffusions as $diffusion) {
			if (!$this->checkDiffusionOpacFilters($diffusion)) {
				continue;
			}

			$result[] = $diffusion->id_diffusion;
		}

		return $result;
	}

	private function checkDiffusionOpacFilters($diffusion): bool
	{
		$settings = $diffusion->settings;
		if (is_string($settings)) {
			$settings = json_decode($diffusion->settings);
		}

		if (!empty($settings->opacVisibilityCateg)) {
			return false;
		}

		if (!empty($settings->opacVisibilityGroups)) {
			return false;
		}

		return true;
	}
}