<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: searcher_animations.class.php,v 1.1.2.1 2025/09/12 08:05:53 qvarin Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

global $class_path;
require_once("$class_path/searcher/searcher_generic.class.php");

class searcher_animations extends searcher_generic
{
    // tableau contenant les documents numriques associs  la recherche
    public $object_table = "";

    public function __construct($user_query)
    {
        parent::__construct($user_query);
        $this->object_table = "anim_animations";
        $this->object_key = "id_animation";
        $this->object_index_key = "id_animation";
        $this->object_words_table = "anim_animations_words_global_index";
        $this->object_fields_table = "anim_animations_fields_global_index";
    }

    protected function _get_search_type()
    {
        return "animations";
    }

    protected function get_full_results_query()
    {
        return 'select id_animation as id_animation from anim_animations ';
    }

    protected function _get_sign($sorted = false)
    {
        global $data;

        $sign = parent::_get_sign($sorted);
        $sign .= md5(http_build_query([
            'dateStart' => $data->searchFields->dateStart,
            'dateEnd' => $data->searchFields->dateEnd,
            'inputSearchExactDate' => $data->searchFields->inputSearchExactDate,
            'status' => implode(',', $data->filter->status),
            'locations' => implode(',', $data->filter->locations),
            'types' => implode(',', $data->filter->types),
            'communication_type' => implode(',', $data->filter->communication_type),
        ]));
        return $sign;
    }

    public function get_raw_query()
    {
        $this->_analyse();
        return $this->_get_search_query();
    }

    public function get_pert_result($query = false)
    {
        $pert = '';
        if ($this->get_result()) {
            $pert = $this->_get_pert($query);
        } else {
            $this->table_tempo = $this->get_temporary_table_name();
            $pert = $this->get_full_query();
            pmb_mysql_query("create temporary table {$this->table_tempo} {$pert}");
        }
        if ($query) {
            return $pert;
        }
        return $this->table_tempo;
    }

    public function get_full_query()
    {
        if ($this->user_query === "*") {
            return 'select id_animation as ' . $this->object_key . ', 100 as pert from anim_animations';
        }
        if ($this->get_nb_results()) {
            $query = $this->_get_pert(true);
        } else {
            $query = "select " . $this->object_key . ", 100 as pert from anim_animations where " . $this->object_key . " = 0";
        }
        return $query;
    }
}
