<?php
// +-------------------------------------------------+
//  2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: readers_ai_storage_controller.class.php,v 1.0 2024/11/07

use Pmb\AI\Models\AiSharedListDocnumModel;

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path."/readers/readers_edition_controller.class.php");

/**
 * Contrleur pour la gestion de l'affichage de l'espace de stockage IA des lecteurs
 * Hrite du contrleur d'dition des lecteurs
 * Point d'entre : edit.php?categ=empr&sub=ai_storage
 */
class readers_ai_storage_controller extends readers_edition_controller {

	// Classe UI  utiliser pour afficher la liste des lecteurs avec leur espace de stockage
	protected static $list_ui_class_name = 'list_readers_ai_storage_ui';

	/**
	 * Retourne une instance de la classe UI de liste avec les configurations appropries
	 *
	 * @param array $filters Filtres  appliquer
	 * @param array $pager Configuration de la pagination
	 * @param array $applied_sort Configuration du tri
	 * @return list_readers_ai_storage_ui Instance de la liste UI
	 */
	protected static function get_list_ui_instance($filters=array(), $pager=array(), $applied_sort=array()) {
		// Cration et retour d'une instance de la classe UI de liste
		// Les filtres et la configuration sont grs par la classe parent et la classe UI elle-mme
		return new static::$list_ui_class_name($filters, $pager, $applied_sort);
	}

	/**
	 * Traite les actions spcifiques du contrleur (suppression des fichiers IA)
	 * Appel aprs l'affichage de la liste
	 *
	 * @param int $id ID du lecteur (non utilis pour les actions de slection)
	 */
	public static function proceed($id=0) {
		global $action;
		global $readers_ai_storage_ui_selected_objects;

		// Appel de la mthode parente pour traiter les actions standards
		parent::proceed($id);
		// Traitement de l'action de suppression des fichiers
		if(isset($action) && $action == 'delete_storage_files') {
			// Rcupration des IDs slectionns depuis la SESSION
			$selected_objects = $readers_ai_storage_ui_selected_objects;
			if(count($selected_objects) > 0) {
				static::delete_storage_files($selected_objects);
			}
		}
	}

	/**
	 * Supprime tous les fichiers IA d'une liste de lecteurs
	 * Supprime les fichiers du disque ET de la base de donnes
	 *
	 * @param array $selected_ids Liste des IDs des lecteurs slectionns
	 */
	protected static function delete_storage_files($selected_ids) {
		// Traitement de chaque lecteur slectionn
		foreach($selected_ids as $id_empr) {
			AiSharedListDocnumModel::deleteByReaderId($id_empr);
		}

		print "<script>location.href='edit.php?categ=empr&sub=ai_storage';</script>";
	}
}
