<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: rdf_entities_converter_linked_authority.class.php,v 1.4.8.1 2025/06/27 14:20:43 rtigero Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

global $class_path;

require_once $class_path . '/rdf_entities_conversion/rdf_entities_converter.class.php';

class rdf_entities_converter_linked_authority extends rdf_entities_converter
{

    public static $table_name = 'aut_link';

    public static $table_key = 'aut_link_from_num';

    private $authority_type;

    private $authority_id;

    public $abstract_entity = true;

    public function __construct($entity_id, $entity_type, $uri = "", $depth = 1, $store = null)
    {
        $this->entity_id = $entity_id;
        if (strpos($entity_id, "_") !== false) {
            $explode_id = explode('_', $entity_id);
            $this->authority_type = intval($explode_id[0]);
            $this->authority_id = intval($explode_id[1]);
        } else {
            $this->init_authority_properties();
        }
        $this->entity_type = $entity_type;
        if (! is_numeric($depth)) {
            $this->depth = - 1;
        }
        if (! empty($store)) {
            $this->store = $store;
        }
        $this->uri = $uri;
        if (empty($this->uri)) {
            $this->init_uri();
        }
    }

    private function init_authority_properties()
    {
        if (is_numeric($this->entity_id)) {
            $query = "
                SELECT aut_link_to, aut_link_to_num
                FROM aut_link
                WHERE id_aut_link = " . $this->entity_id;
            $result = pmb_mysql_query($query);
            if (pmb_mysql_num_rows($result)) {
                $row = pmb_mysql_fetch_assoc($result);
                $this->authority_type = intval($row["aut_link_to"]);
                $this->authority_id = intval($row["aut_link_to_num"]);
            }
        }
    }

    protected function init_map_fields()
    {
        $this->map_fields = array_merge(parent::init_map_fields(), array(
            'id_aut_link' => 'http://www.pmbservices.fr/ontology#identifier',
            'aut_link_type' => 'http://www.pmbservices.fr/ontology#relation_type_authority'
        ));
        return $this->map_fields;
    }

    protected function init_special_fields()
    {
        $this->special_fields = array_merge(parent::init_special_fields(), array(
            'http://www.pmbservices.fr/ontology#has_authority' => array(
                "method" => array(
                    $this,
                    "get_assertions_from_authority"
                ),
                "arguments" => array()
            ),
            'http://www.pmbservices.fr/ontology#relation_type_authority' => array(
                "method" => array(
                    $this,
                    "get_relation_type_authority"
                ),
                "arguments" => array()
            )
        ));
        return $this->special_fields;
    }

    public function get_assertions_from_authority()
    {
        $type = $this->get_string_from_type_object($this->authority_type);
        // $subject = $this->get_uri_from_pmb_identifer($this->entity_id, $this->entity_type);
        $subject = $this->uri;
        $object = $this->get_uri_from_pmb_identifer($this->authority_id, $type);
        $object_type = $this->get_object_type_from_type($type);
        $object_properties = $this->get_object_properties($this->authority_id, $type);
        $converted = rdf_entities_converter_controller::$converted_entities;
        if (array_key_exists($type, $converted) && is_array($converted[$type]) && ! in_array($this->authority_id, $converted[$type])) {
            $object_properties['object_assertions'] = rdf_entities_converter_controller::convert($this->authority_id, $type, $object, $this->depth, $this->store);
        }
        $assertion = new onto_assertion($subject, "http://www.pmbservices.fr/ontology#has_authority", $object, $object_type, $object_properties);
        return $assertion;
    }

    public function get_relation_type_authority()
    {
        // $subject = $this->get_uri_from_pmb_identifer($this->entity_id, $this->entity_type);
        $subject = $this->uri;
        $query = "
            SELECT aut_link_type
            FROM aut_link
            WHERE aut_link_to_num = " . $this->authority_id . "
            AND aut_link_to = " . $this->authority_type;
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            $row = pmb_mysql_fetch_array($result);
        }
        $assertion = new onto_assertion($subject, "http://www.pmbservices.fr/ontology#relation_type_authority", $row[0], 'http://www.w3.org/2000/01/rdf-schema#Literal', array(
            'type' => 'literal'
        ));
        return $assertion;
    }

    private function get_string_from_type_object($type_object)
    {
        switch ($type_object) {
            case AUT_TABLE_AUTHORS:
                return 'author';
            case AUT_TABLE_CATEG:
                return 'category';
            case AUT_TABLE_PUBLISHERS:
                return 'publisher';
            case AUT_TABLE_COLLECTIONS:
                return 'collection';
            case AUT_TABLE_SUB_COLLECTIONS:
                return 'subcollection';
            case AUT_TABLE_SERIES:
                return 'serie';
            case AUT_TABLE_TITRES_UNIFORMES:
                return 'work';
            case AUT_TABLE_INDEXINT:
                return 'indexint';
            case AUT_TABLE_CONCEPT:
                return 'concept';
            case AUT_TABLE_AUTHPERSO:
                return 'authperso';
            default:
                break;
        }
        if(intval($type_object) > 1000) {
            return "authperso_" . $type_object - 1000;
        }
        return "";
    }

    public static function get_entity_isbd($id, $type)
    {
        $isbd = parent::get_entity_isbd($id, $type);
        $isbd = sprintf(static::get_prefixe_entity($type, $id), $isbd);
        return $isbd;
    }

    private static function get_prefixe_entity($type_object, $id = '')
    {
        global $msg;
        switch ($type_object) {
            case 'author':
            case (string) AUT_TABLE_AUTHORS:
                return $msg['aut_link_author'];
            case 'category':
            case (string) AUT_TABLE_CATEG:
                return $msg['aut_link_categ'];
            case 'publisher':
            case (string) AUT_TABLE_PUBLISHERS:
                return $msg['aut_link_publisher'];
            case 'collection':
            case (string) AUT_TABLE_COLLECTIONS:
                return $msg['aut_link_coll'];
            case 'subcollection':
            case (string) AUT_TABLE_SUB_COLLECTIONS:
                return $msg['aut_link_subcoll'];
            case 'serie':
            case (string) AUT_TABLE_SERIES:
                return $msg['aut_link_serie'];
            case 'work':
            case (string) AUT_TABLE_TITRES_UNIFORMES:
                return $msg['aut_link_tu'];
            case 'indexint':
            case (string) AUT_TABLE_INDEXINT:
                return $msg['aut_link_indexint'];
            case 'concept':
            case (string) AUT_TABLE_CONCEPT:
                return $msg['aut_link_concept'];
            case 'authperso':
            case (string) AUT_TABLE_AUTHPERSO:
                $authperso = new authperso($id - 1000);
                if(! array_key_exists('name', $authperso->info)) {
                    return '%1s';
                }
                return '[' . $authperso->info['name'] . '] %1s';
            default:
                return '%1s';
        }
    }
}

