<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: interface_admin_perso_form.class.php,v 1.1.2.4 2025/10/14 14:26:51 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class interface_admin_perso_form extends interface_admin_form {
	
	protected function get_submit_action() {
	    if ($this->object_id) {
	        return $this->get_url_base()."&action=update&id=".$this->object_id;
	    } else {
	        return $this->get_url_base()."&action=create&id=".$this->object_id;
	    }
	}
	
	protected function get_delete_action() {
	    //Passage des 2 variables en GET pour gerer la retrocompatibilite de la suppression depuis le controleur
		return $this->get_url_base()."&action=delete&idchamp=".$this->object_id."&id=".$this->object_id;
	}
	
	public function get_display($ajax = false) {
	    global $current_module;
	    
	    if (!$this->has_rights('edition')) {
	        return $this->get_display_no_access();
	    }
	    
	    //Methode derivee pour le nom du formulaire uniquement ..
	    //A cause du bouton uniquement a premiere vue
	    $display = "
		<form class='form-".$current_module."' id='".$this->name."' name='formulaire'  method='post' action=\"".$this->get_submit_action()."\" ".(!empty($this->enctype) ? "enctype='".$this->enctype."'" : "").">
			".$this->get_display_label()."
			<div class='form-contenu'>
				".$this->get_display_content_form()."
			</div>
			<div class='row'>
				".$this->get_display_actions()."
			</div>
		<div class='row'></div>
		</form>";
	    if(isset($this->table_name) && $this->table_name) {
	        $translation = new translation($this->object_id, $this->table_name);
	        $display .= $translation->connect($this->name);
	    }
	    $display .= $this->get_js_script();
	    if(isset($this->field_focus) && $this->field_focus) {
	        $display .= "<script type='text/javascript'>document.forms['".$this->name."'].elements['".$this->field_focus."'].focus();</script>";
	    }
	    return $display;
	}
	
	protected function get_js_script() {
	    return "
		<script src='javascript/ajax.js'></script>
		<script type='text/javascript'>
			ajax_parse_dom();
		</script>
		".parent::get_js_script();
	}
}