<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_resolve.class.php,v 1.2.8.1 2025/11/18 14:19:11 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_resolve extends custom_fields {
	
    protected static $type = 'resolve';
    
	protected static function get_chk_values($name) {
        global ${$name};
        $val = ${$name};
        $value = array();
        if (isset($val['id'])) {
            $nb_vals = count($val['id']);
            for ($i = 0; $i < $nb_vals; $i++) {
                if ($val['id'][$i] != "") {
                    $value[] = $val['id'][$i]."|".$val['resolve'][$i];
                }
            }
        }
        return $value;
    }
    
    public static function val($field, $value) {
        global $charset,$pmb_perso_sep;
        
        $without="";
        $options=$field['OPTIONS'][0];
        $values=format_output($field,$value);
        $ret = "";
        for ($i=0;$i<count($values);$i++){
            $val = explode("|",$values[$i]);
            if(count($val)>1){
                $id =$val[0];
                foreach ($options['RESOLVE'] as $res){
                    if($res['ID'] == $val[1]){
                        $label = $res['LABEL'];
                        $url= $res['value'];
                        break;
                    }
                }
                $link = str_replace("!!id!!",$id,$url);
                if( $ret != "") $ret.= " / ";
                $ret.= htmlentities($label,ENT_QUOTES,$charset)." : $id <a href='$link' target='_blank'><img class='center' src='".get_url_icon("globe.gif")."' alt='$link' title='link'/></a>";
                if($without)$without.=$pmb_perso_sep;
                $without.=$link;
            }else{
                if($without)$without.=$pmb_perso_sep;
                $without.=implode($pmb_perso_sep,$value);
            }
        }
        return array("ishtml" => true, "value"=>$ret,"withoutHTML"=> $without);
    }
    
    protected static function get_js_function_add($field) {
        $options=$field['OPTIONS'][0];
        $ret = "<script>
			function add_custom_resolve_(field_id, field_name, field_size, field_maxlen) {
				document.getElementById('customfield_resolve_'+field_id).value = document.getElementById('customfield_resolve_'+field_id).value * 1 + 1;
		        count = document.getElementById('customfield_resolve_'+field_id).value;
            
				var node_dnd_id = get_custom_dnd_on_add('spaceformorecustomfieldresolve_'+field_id, 'customfield_resolve_'+field_name, (count-1));
				var buttonAdd = document.getElementById('button_add_' + field_name + '_' + field_id);
            
				f_aut0 = document.createElement('input');
		        f_aut0.setAttribute('name',field_name+'[id][]');
		        f_aut0.setAttribute('id',field_name+(count-1));
		        f_aut0.setAttribute('type','text');
		        f_aut0.setAttribute('size',field_size);
		        f_aut0.setAttribute('maxlen',field_size);
		        f_aut0.setAttribute('value','');
		        space=document.createElement('br');
				var select = document.createElement('select');
				select.setAttribute('name',field_name+'[resolve][]');
				select.setAttribute('id',field_name+'_select'+(count-1));
				";
        foreach($options['RESOLVE'] as $elem){
            $ret.="
				var option = document.createElement('option');
				option.setAttribute('value','".$elem['ID']."');
				var text = document.createTextNode('".$elem['LABEL']."');
				option.appendChild(text);
				select.appendChild(option);
";
        }
        $ret.="
				document.getElementById(node_dnd_id).appendChild(f_aut0);
				document.getElementById(node_dnd_id).appendChild(document.createTextNode(' '));
				document.getElementById(node_dnd_id).appendChild(select);
				if (buttonAdd) document.getElementById(node_dnd_id).appendChild(buttonAdd);
				document.getElementById(node_dnd_id).appendChild(space);
			}
		</script>";
        return $ret;
    }
    
    protected static function get_event_button_add($field) {
        $options=$field['OPTIONS'][0];
        if(!isset($options['MAXSIZE'][0]['value'])) $options['MAXSIZE'][0]['value'] = '';
        return 'add_custom_resolve_(\''.$field["ID"].'\', \''.addslashes($field['NAME']).'\', \''.addslashes($options['SIZE'][0]['value']).'\', \''.addslashes($options['MAXSIZE'][0]['value']).'\')';
    }
    
    public static function get_aff_values($field) {
        return ($field['VALUES'] ? $field['VALUES'] : array("|"));
    }
    
    public static function get_display_value($field, $indice, $value) {
        global $charset;
        
        $options=$field['OPTIONS'][0];
        $avalues = explode("|",$value);
        $display = "<input id='".$field['NAME']."$indice' type='text' size='".$options['SIZE'][0]['value']."' name='".$field['NAME']."[id][]' data-form-name='".$field['NAME']."' value='".htmlentities($avalues[0],ENT_QUOTES,$charset)."'>";
        $display .= "&nbsp;<select id='".$field['NAME']."_select$indice'  name='".$field['NAME']."[resolve][]' data-form-name='".$field['NAME']."_select' >";
        foreach($options['RESOLVE'] as $elem){
            $display .= "
			<option value='".$elem['ID']."' ".($avalues[1] == $elem['ID'] ? "selected=selected":"").">".htmlentities($elem['LABEL'],ENT_QUOTES,$charset)."</option>";
        }
        $display .= "</select>";
        return $display;
    }
    
    public static function get_block_dnd($field, $indice, $html, $value='') {
        $exploded_value = explode("|",$value);
        return parent::get_block_dnd($field, $indice, $html, $exploded_value[0]);
    }
    
    public static function aff_search($field,&$check_scripts,$varname) {
        global $charset;
        
        $options=$field['OPTIONS'][0];
        $values=$field['VALUES'];
        if(!isset($values[0])) {
            $values[0] = '';
        }
        $ret="<input id='".$varname."' type='text' size='".$options['SIZE'][0]['value']."' name='".$varname."[]' value='".htmlentities($values[0],ENT_QUOTES,$charset)."'>";
        return $ret;
    }
}