<?php
// +-------------------------------------------------+
// | 2002-2007 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: abts_abonnement.class.php,v 1.1.2.5 2026/01/13 09:26:21 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path, $include_path;
require_once($include_path."/templates/abts_abonnements.tpl.php");
require_once($class_path."/serial_display.class.php");
require_once($include_path."/abts_func.inc.php");
require_once($include_path."/misc.inc.php");
require_once($class_path."/abts_pointage.class.php");
require_once($class_path."/serialcirc_diff.class.php");
require_once($class_path."/serialcirc.class.php");
require_once($class_path."/abts_status.class.php");
require_once($class_path.'/translation.class.php');

class abts_abonnement {
    public $abt_id; //Numro du modle
    public $abt_name; //Nom du modle
    public $abt_name_opac; //Nom OPAC du modle
    public $base_modele_name;//
    public $base_modele_id;//
    public $num_notice; //numro de la notice lie
    public $duree_abonnement; //Dure de l'abonnement
    public $date_debut; //Date de dbut de validit du modle
    public $date_fin; //Date de fin de validit du modle
    public $fournisseur;// id du fournisseur
    public $destinataire;
    public $error; //Erreur
    public $error_message; //Message d'erreur
    public $abt_numeric=0;
    public $cote;
    public $typdoc_id;
    public $exemp_auto;
    public $location_id;
    public $section_id;
    public $lender_id;
    public $statut_id;
    public $codestat_id;
    public $prix;
    public $type_antivol;
    public $abt_status;
    public $expl_custom_fields = [];
    public $modele_list_dates = [];
    
    public function __construct($abt_id="") {
        $this->abt_id = intval($abt_id);
        $this->getData();
    }
    
    public function getData() {
        $this->abt_name = '';
        $this->abt_name_opac = '';
        $this->num_notice = '';
        $this->base_modele_name = '';
        $this->base_modele_id = '';
        $this->num_notice = ''; //numro de la notice lie
        $this->duree_abonnement = ''; //Dure de l'abonnement
        $this->date_debut = ''; //Date de dbut de validit du modle
        $this->date_fin = ''; //Date de fin de validit du modle
        $this->fournisseur = '';// id du fournisseur
        $this->destinataire = '';
        $this->cote = '';
        $this->typdoc_id = '';
        $this->exemp_auto = '';
        $this->location_id = '';
        $this->section_id = '';
        $this->lender_id = '';
        $this->statut_id = '';
        $this->codestat_id = '';
        $this->type_antivol = '';
        $this->abt_numeric = '';
        $this->prix = '';
        $this->abt_status = '';
        $this->expl_custom_fields = [];
        if ($this->abt_id) {
            $requete="select * from abts_abts where abt_id=".$this->abt_id;
            $resultat=pmb_mysql_query($requete);
            if (pmb_mysql_num_rows($resultat)) {
                $r=pmb_mysql_fetch_object($resultat);
                $this->abt_id = $r->abt_id;
                $this->abt_name = $r->abt_name;
                $this->abt_name_opac = $r->abt_name_opac;
                $this->num_notice = $r->num_notice;
                $this->base_modele_name = $r->base_modele_name;
                $this->base_modele_id = $r->base_modele_id;
                $this->num_notice = $r->num_notice; //numro de la notice lie
                $this->duree_abonnement = $r->duree_abonnement; //Dure de l'abonnement
                $this->date_debut = $r->date_debut; //Date de dbut de validit du modle
                $this->date_fin = $r->date_fin; //Date de fin de validit du modle
                $this->fournisseur = $r->fournisseur;// id du fournisseur
                $this->destinataire = $r->destinataire;
                $this->cote = $r->cote;
                $this->typdoc_id = $r->typdoc_id;
                $this->exemp_auto = $r->exemp_auto;
                $this->location_id = $r->location_id;
                $this->section_id = $r->section_id;
                $this->lender_id = $r->lender_id;
                $this->statut_id = $r->statut_id;
                $this->codestat_id = $r->codestat_id;
                $this->type_antivol = $r->type_antivol;
                $this->abt_numeric = $r->abt_numeric;
                $this->prix = $r->prix;
                $this->abt_status = $r->abt_status;
                if (!empty($r->expl_custom_fields)) {
                    $this->expl_custom_fields = encoding_normalize::json_decode($r->expl_custom_fields, true);
                }
            } else {
                $this->error = true;
                $this->error_message = "Le modle demand n'existe pas";
            }
        }
    }
    
    public function set_perio($num_notice) {
        $this->num_notice = 0;
        $requete = "select niveau_biblio from notices where notice_id=".$num_notice;
        $resultat = pmb_mysql_query($requete);
        if (pmb_mysql_num_rows($resultat)) {
            if (pmb_mysql_result($resultat,0,0)=="s")
                $this->num_notice = $num_notice;
        } else {
            $this->error = true;
            $this->error_message = "La notice lie n'existe pas ou n'est pas un priodique";
        }
    }
    
    public function get_tpl_empr_list() {
        global $msg;
        global $abonnement_serialcirc_empr_list_empr, $abonnement_serialcirc_empr_list_group, $abonnement_serialcirc_empr_list_group_elt;
        
        $tpl_empr_list = '';
        $serialcirc_diff=new serialcirc_diff(0,$this->abt_id);
        foreach($serialcirc_diff->diffusion as $diff){
            if($diff['empr_type']==SERIALCIRC_EMPR_TYPE_empr){
                $tpl_empr=$abonnement_serialcirc_empr_list_empr;
                $name_elt=$serialcirc_diff->empr_info[ $diff['empr']['id_empr']]['empr_libelle'];
            }else{
                $name_elt=$diff['empr_name'];
                $group_list_list="";
                if(count($diff['group'])){
                    $tpl_empr=$abonnement_serialcirc_empr_list_group;
                    foreach($diff['group'] as $empr){
                        $group_list=$abonnement_serialcirc_empr_list_group_elt;
                        $resp="";
                        if($empr['responsable']){
                            $resp=$msg["serialcirc_group_responsable"];
                        }
                        $group_list=str_replace('!!empr_libelle!!',$empr['empr']['empr_libelle'].$resp, $group_list);
                        $group_list_list.=$group_list;
                    }
                    $tpl_empr=str_replace('!!empr_list!!', $group_list_list, $tpl_empr);
                }else {
                    $tpl_empr=$abonnement_serialcirc_empr_list_empr;
                }
            }
            $tpl_empr=str_replace('!!id_diff!!', $diff['id'], $tpl_empr);
            if (isset($diff['empr']['view_link'])) {
                $tpl_empr=str_replace('!!empr_view_link!!', $diff['empr']['view_link'], $tpl_empr);
            } else {
                // un groupe
                $tpl_empr=str_replace('!!empr_view_link!!', '', $tpl_empr);
            }
            $tpl_empr=str_replace('!!empr_name!!', $name_elt, $tpl_empr);
            $tpl_empr_list .= $tpl_empr;
        }
        return $tpl_empr_list;
    }
    
    public function show_abonnement() {
        global $abonnement_view,$serial_id;
        global $msg;
        global $pmb_gestion_devise;
        
        $perio=new serial_display($this->num_notice,1);
        $r=$abonnement_view;
        $r=str_replace("!!view_id_abonnement!!","catalog.php?categ=serials&sub=abon&serial_id=$serial_id&abt_id=$this->abt_id",$r);
        $r=str_replace("!!id_abonnement!!",$this->abt_id,$r);
        $r=str_replace("!!abonnement_header!!",$this->abt_name,$r);
        $r=str_replace("!!statut!!",abts_status::get_display($this->abt_status),$r);
        
        $modele=0;
        $modele_list="";
        $requete="select modele_id from abts_abts_modeles where abt_id='$this->abt_id'";
        $resultat=pmb_mysql_query($requete);
        while ($r_a=pmb_mysql_fetch_object($resultat)) {
            $modele_id=$r_a->modele_id;
            $modele_name=pmb_sql_value("select modele_name from abts_modeles where modele_id='$modele_id'");
            $num_periodicite=pmb_sql_value("select num_periodicite from abts_modeles where modele_id='$modele_id'");
            $periodicite=pmb_sql_value("SELECT libelle from abts_periodicites where periodicite_id='".$num_periodicite."'");
            if ($modele_list) $modele_list.=",";
            $modele_list.=" $modele_name";
            if($periodicite) $modele_list.=" ($periodicite)";
        }
        $r=str_replace("!!modele_lie!!",$modele_list,$r);
        $r=str_replace("!!duree_abonnement!!",$this->duree_abonnement,$r);
        $r=str_replace("!!date_debut!!",format_date($this->date_debut),$r);
        $r=str_replace("!!date_fin!!",format_date($this->date_fin),$r);
        
        $nombre_series = pmb_sql_value("SELECT SUM(nombre) FROM abts_grille_abt WHERE num_abt='$this->abt_id' AND type ='1'") ?? '';
        $r = str_replace("!!nombre_de_series!!", $nombre_series, $r);
        
        $nombre_horsseries = pmb_sql_value("SELECT SUM(nombre) FROM abts_grille_abt WHERE num_abt='$this->abt_id' AND type ='2'") ?? '';
        $r = str_replace("!!nombre_de_horsseries!!", $nombre_horsseries, $r);
        
        $prix='';
        $prix=$this->prix.'&nbsp'.$pmb_gestion_devise;
        $r=str_replace("!!prix!!",$prix,$r);
        
        $fournisseur_name = '';
        if($this->fournisseur) $fournisseur_name=$msg["abonnements_fournisseur"].": ".pmb_sql_value("SELECT raison_sociale from entites where id_entite = '".$this->fournisseur."' ");
        $r=str_replace("!!fournisseur!!",$fournisseur_name,$r);
        
        $aff_destinataire="";
        if($this->destinataire){
            $aff_destinataire="<tr>
				<td colspan='2'>".$this->destinataire."</td>
			</tr>";
        }
        $r=str_replace("!!commentaire!!",$aff_destinataire,$r);
        
        //Liste des destinataires
        $tpl_empr_list = $this->get_tpl_empr_list();
        $aff_empr_list="";
        if($tpl_empr_list){
            $aff_empr_list="
			<tr>
				<td colspan='2'>
					<h3>".$msg["serialcirc_diff_empr_list_title"]."</h3>
					$tpl_empr_list
				</td>
			</tr>";
        }
        
        $r=str_replace("!!serial_id!!", $serial_id, $r);
        $r=str_replace("!!serialcirc_empr_list!!", $aff_empr_list, $r);
        $r=str_replace("!!serialcirc_export_list_bt!!", "<input type='button' class='bouton' value='".$msg["serialcirc_export_list"]."'
				onClick=\"document.location='./edit.php?dest=TABLEAU&categ=serialcirc_diff&sub=export_empr&&num_abt=".$this->abt_id."'\"/>&nbsp;", $r);
        
        return $r;
    }
    
    /**
     * Liste des formulaire de modles (dpliables +,-)
     * @return string
     */
    protected function get_modele_list() {
        $modele_list="";
        $this->modele_list_dates = array();
        $requete="select a.modele_id,num,vol,tome,delais,critique, num_statut_general, date_debut, date_fin
				from abts_abts_modeles a join abts_modeles m on m.modele_id=a.modele_id
				where abt_id='$this->abt_id'";
        $resultat=pmb_mysql_query($requete);
        if (!$resultat) die($requete."<br /><br />".pmb_mysql_error());
        while ($r_a=pmb_mysql_fetch_object($resultat)) {
            $modele_id=$r_a->modele_id;
            $num=$r_a->num;
            $vol=$r_a->vol;
            $tome=$r_a->tome;
            $delais=$r_a->delais;
            $critique=$r_a->critique;
            $modele_name=pmb_sql_value("select modele_name from abts_modeles where modele_id='$modele_id'");
            $num_periodicite=pmb_sql_value("select num_periodicite from abts_modeles where modele_id='$modele_id'");
            $periodicite=pmb_sql_value("select libelle from abts_periodicites where periodicite_id ='".$num_periodicite."'");
            $num_statut=$r_a->num_statut_general;
            if($periodicite) $modele_name.=" ($periodicite)";
            // 				if(!$num_statut)$num_statut=$this->statut_id;
            $modele_list.=$this->gen_tpl_abt_modele($modele_id,$modele_name,$num,$vol,$tome,$delais,$critique,$num_statut);
            $this->modele_list_dates[] = array($r_a->date_debut,$r_a->date_fin);
        }
        return $modele_list;
    }
    
    protected function get_calendar() {
        global $serial_id;
        
        $calend ="";
        if (pmb_sql_value("select sum(nombre) from abts_grille_abt where num_abt='$this->abt_id'")) {
            $abts_calendar = new abts_calendar($this->abt_id, 'abonnement');
            $abts_calendar->set_num_serial($serial_id)
            ->set_date_debut($this->date_debut)
            ->set_date_fin($this->get_date_fin());
            $calend .= $abts_calendar->get_display();
        }
        return $calend;
    }
    
    /**
     * Vrifications sur les dates
     * @return string
     */
    protected function get_test_liste_modele() {
        global $msg;
        global $serial_id;
        global $act;
        
        if (!$this->abt_id) {
            //Checkbox des modles  associer  l'abonnement
            $resultat=pmb_mysql_query("select modele_id,modele_name from abts_modeles where num_notice='$serial_id'");
            //Confection du javascript pour tester au moins une slection de modle
            $test_liste_modele="if(";
            $cpt=0;
            while ($rp=pmb_mysql_fetch_object($resultat)) {
                if(	$cpt++ >0) {
                    $test_liste_modele.=" || ";
                }
                $test_liste_modele.=" (document.getElementById('modele[".$rp->modele_id."]').checked==true) ";
                
            }
            $test_liste_modele.=")
			{
				return true;
			}else {
				alert(\"$msg[abonnements_err_msg_select_model]\");
				return false;
			}";
        } else {
            $test_liste_modele = "
        	var d = form.date_debut.value.replace(/-/g,'');
        	var d_abo_debut = new Date(d.substr(0,4),d.substr(4,2),d.substr(6,2));
        	d = form.date_fin.value.replace(/-/g,'');
        	var d_abo_fin = new Date(d.substr(0,4),d.substr(4,2),d.substr(6,2));
        	var dates_modeles = new Array(";
            foreach($this->modele_list_dates as $mdates){
                $test_liste_modele .= "new Array('".$mdates[0]."','".$mdates[1]."'),";
            }
            $test_liste_modele = substr($test_liste_modele,0,strlen($test_liste_modele)-1);
            $test_liste_modele .= "
            );";
            
            $test_liste_modele .= "
            	for(var i= 0; i < dates_modeles.length; i++){
            		var t = dates_modeles[i][0].split(/[-]/);
            		var d_mod_debut = new Date(t[0],t[1],t[2]);
                
            		var t = dates_modeles[i][1].split(/[-]/);
            		var d_mod_fin = new Date(t[0],t[1],t[2]);
            ";
            if ($this->date_debut=='0000-00-00' && $this->date_fin=='0000-00-00') {
                $test_liste_modele .= "
                    if ((d_abo_debut < d_mod_debut)||(d_abo_fin > d_mod_fin)) {
            			alert(\"".$msg['abo_date_incorrecte']."\");
            			return false;
            		}
                ";
            } elseif($act == 'prolonge') {
                $test_liste_modele .= "
                    var d_prev = form.date_fin.value.replace(/-/g,'');
        			var d_abo_prev_fin = new Date(d_prev.substr(0,4),d_prev.substr(4,2),d_prev.substr(6,2));
        			d_abo_prev_fin.setMonth(d_abo_prev_fin.getMonth() + parseInt(document.getElementById('duree_abonnement').value,10));
        			if (d_abo_prev_fin > d_mod_fin) {
        				alert(\"".$msg['abo_date_prolonge_incorrecte']."\");
        				return false;
        			}
                ";
            } else {
                $test_liste_modele .= "
	                if (d_abo_fin > d_mod_fin) {
        				alert(\"".$msg['abo_date_fin_incorrecte']."\");
        				return false;
        			}
                ";
            }
            $test_liste_modele .= "
            }";
        }
        
        return $test_liste_modele;
    }
    
    public function get_date_debut() {
        if (!$this->date_debut || $this->date_debut == "0000-00-00") {
            return date("Y-m-d",time());
        } else {
            return $this->date_debut;
        }
    }
    public function get_date_fin($date_debut='') {
        if (empty($date_debut)) {
            $date_debut = $this->get_date_debut();
        }
        if (!$this->date_fin || $this->date_fin == "0000-00-00") {
            return pmb_sql_value("SELECT DATE_ADD('$date_debut', INTERVAL 1 YEAR)");
        } else {
            return $this->date_fin;
        }
    }
    
    protected function get_query_docs_selector($table) {
        return "SELECT * FROM $table order by 2";
    }
    
    protected function get_selected_user_preference($name, $property) {
        if ($this->abt_id) {
            return $this->{$property};
        }
        $defltvar="deflt_".$name;
        global ${$defltvar};
        return ${$defltvar};
    }
    
    public function get_instance_parametres_perso($prefix) {
        $p_perso=new parametres_perso($prefix);
        if (!$p_perso->no_special_fields) {
            if (!empty($this->expl_custom_fields)) {
                foreach ($p_perso->t_fields as $key => $t_field) {
                    if (!empty($this->expl_custom_fields[$t_field['NAME']])) {
                        $p_perso->values[$key] = $this->expl_custom_fields[$t_field['NAME']];
                    }
                }
            }
        }
        return $p_perso;
    }
    
    protected function get_expl_custom_fields_content_form() {
        $interface_content_form = new interface_entity_record_expl_content_form(static::class."_expl_custom_fields");
        $interface_content_form->set_grid_model('column_3');
        $content_form = '';
        $p_perso = $this->get_instance_parametres_perso("expl");
        if (!$p_perso->no_special_fields) {
            $perso_=$p_perso->show_editable_fields(0, true);
            $elements = $interface_content_form->add_custom_fields_elements($perso_['FIELDS']);
            $counter = 0;
            foreach ($elements as $element) {
                if(($counter == count($perso_["FIELDS"])-1) && ($counter%3 == 0)) {
                    $element_class = 'row';
                }else {
                    $element_class = 'colonne3';
                }
                $element->set_class($element_class);
                $content_form .= $element->get_display();
                $counter++;
            }
        }
        return $content_form;
    }
    
    public function get_expl_content_form() {
        global $msg;
        global $pmb_antivol;
        
        $interface_content_form = new interface_entity_record_expl_content_form(static::class."_expl");
        $interface_content_form->set_grid_model('column_3');
        //Cote
        $interface_content_form->add_element('cote', '296')
        ->add_input_node('text', $this->cote)
        ->set_class('saisie-20em');
        
        // select "type document
        $interface_content_form->add_element('typdoc_id', '294')
        ->add_query_node('select', $this->get_query_docs_selector('docs_type'), $this->get_selected_user_preference('docs_type', 'typdoc_id'));
        
        $interface_content_form->add_element('exemp_auto', 'exemplarisation_automatique')
        ->add_input_node('boolean', $this->exemp_auto);
        
        // select "localisation"
        $interface_content_form->add_element('location_id', '298')
        ->add_html_node(gen_liste ("select distinct idlocation, location_libelle from docs_location, docsloc_section where num_location=idlocation order by 2 ", "idlocation", "location_libelle", 'location_id', "calcule_section(this);", $this->location_id, "", "","","",0));
        
        // select "section"
        $interface_content_form->add_element('f_ex_section1', '295')
        ->add_html_node($this->do_selector());
        
        // select "owner"
        $interface_content_form->add_element('lender_id', '651')
        ->add_query_node('select', $this->get_query_docs_selector('lenders'), $this->get_selected_user_preference('lenders', 'lender_id'));
        
        // select "statut"
        $interface_content_form->add_element('statut_id', '297')
        ->add_query_node('select', $this->get_query_docs_selector('docs_statut'), $this->get_selected_user_preference('docs_statut', 'statut_id'));
        
        // select "code statistique"
        $interface_content_form->add_element('codestat_id', '299')
        ->add_query_node('select', $this->get_query_docs_selector('docs_codestat'), $this->get_selected_user_preference('docs_codestat', 'codestat_id'));
        
        //Prix
        $interface_content_form->add_element('prix', '4050')
        ->add_input_node('float', $this->prix);
        
        if($pmb_antivol>0) {// select "type_antivol"
                $antivol_options = array(
                    '0' => $msg["type_antivol_aucun"],
                    '1' => $msg["type_antivol_magnetique"],
                    '2' => $msg["type_antivol_autre"]
                );
                $interface_content_form->add_element('type_antivol', 'type_antivol')
                ->add_select_node($antivol_options, $this->type_antivol);
            
        }
        $content_form = $interface_content_form->get_display();
        $content_form .= $this->get_expl_custom_fields_content_form();
        return $content_form;
    }

    public function get_creation_content_form() {
        global $msg;
        global $serial_id;
        global $pmb_abt_label_perio;
        
        $interface_content_form = new interface_content_form(static::class);
        
        $abonnement_name = $this->abt_name;
        if (!$this->abt_id && $pmb_abt_label_perio) {
            $serial = new serial($serial_id);
            $abonnement_name = $serial->tit1;
        }
        $interface_content_form->add_element('abt_name', 'abonnements_nom_abonnement')
        ->add_input_node('text', $abonnement_name);
        
        $interface_content_form->add_element('abt_name_opac', 'abonnements_nom_opac_abonnement')
        ->add_input_node('text', $this->abt_name_opac)
        ->set_attributes(array('data-translation-fieldname' => 'abt_name_opac'));
        
        //Checkbox des modles  associer  l'abonnement
        $result = pmb_mysql_query("select modele_id,modele_name from abts_modeles where num_notice='$serial_id'");
        $modeles = "
        <fieldset>
            <legend class='abts-legend'>".$msg['abonnements_liste_modele']."</legend>
            <ul>";
        while ($rp=pmb_mysql_fetch_object($result)) {
            $modeles.="
            <li style='all:unset'>
                <input type='checkbox' value='$rp->modele_id' name='modele[$rp->modele_id]' id='modele_$rp->modele_id'/>
                <label for='modele_$rp->modele_id'>$rp->modele_name</label>
            </li>";
        }
        $modeles.="</fieldset>";
        $interface_content_form->add_element('abt_modeles')
        ->add_html_node($modeles);
        
        return $interface_content_form->get_display();
    }
    
    public function get_edition_content_form() {
        $interface_content_form = new interface_content_form(static::class);
        
        $interface_content_form->add_element('abt_name', 'abonnements_nom_abonnement')
        ->set_class('colonne2')
        ->add_input_node('text', $this->abt_name);
        
        //Dure d'abonnement
        if (!$this->duree_abonnement) {
            $this->duree_abonnement=12;
        }
        $interface_content_form->add_element('duree_abonnement', 'abonnements_duree_abonnement')
        ->set_class('colonne2')
        ->add_input_node('integer', $this->duree_abonnement);
        
        $interface_content_form->add_element('abt_name_opac', 'abonnements_nom_opac_abonnement')
        ->add_input_node('text', $this->abt_name_opac)
        ->set_attributes(array('data-translation-fieldname' => 'abt_name_opac'));
        
        //Date de dbut
        $interface_content_form->add_element('date_debut', 'abonnements_date_debut')
        ->set_class('colonne2')
        ->add_input_node('date', $this->get_date_debut());
        
        //Date de fin
        $date_fin = $this->get_date_fin();
        $interface_content_form->add_element('date_fin', 'abonnements_date_fin')
        ->set_class('colonne_suite')
        ->add_input_node('date', $date_fin);
        
        //Fournisseur
        $interface_content_form->add_element('lib_fou', 'abonnements_fournisseur')
        ->set_class('colonne2')
        ->add_authority_node(pmb_sql_value("SELECT raison_sociale from entites where id_entite = '".$this->fournisseur."'"), 'fournisseur')
        ->set_class('saisie-30emr')
        ->set_hidden_name('id_fou')
        ->set_hidden_value($this->fournisseur)
        ->set_openPopUpUrl("./select.php?what=fournisseur&caller=form_abonnement&param1=id_fou&param2=lib_fou&id_bibli=0");
        
        //Destinataire
        $interface_content_form->add_element('destinataire', 'abonnements_destinataire')
        ->set_class('colonne_suite')
        ->add_textarea_node($this->destinataire, 50, 6);
        
        $interface_content_form->add_element('abt_numeric')
        ->add_input_node('boolean', $this->abt_numeric)
        ->set_label_code('abt_numeric_checkbox')
        ->set_attributes(array('onclick' => 'expl_part_display()'));
        
        $content_form = $interface_content_form->get_display();
        
        //Donnees exemplaire
        $content_form .= "
        <div class='row'>
            <div id='expl_part'>
                ".$this->get_expl_content_form()."
            </div>
        </div>";
        
        $content_form .= "
        <div class='row'>
            ".$this->get_modele_list()."
        </div>";
        
        return $content_form;
    }
    
    public function get_content_form() {
        global $charset;
        global $serial_id;
        
        if (!$this->abt_id) {
            $content_form = $this->get_creation_content_form();
        } else {
            $content_form = $this->get_edition_content_form();
            // calendrier de rception s'il y a des enregistrement prsents dans la grille
            $content_form.=$this->get_calendar();
        }
        $content_form .= "<input type='hidden' name='num_notice' id='num_notice' value='".$this->num_notice."'/>";
        $content_form = str_replace("!!serial_id!!",$serial_id, $content_form);
        //Remplacement des valeurs
        $content_form = str_replace("!!abt_id!!",htmlentities($this->abt_id,ENT_QUOTES,$charset), $content_form);
        
        return $content_form;
    }
    
    public function get_form() {
        global $msg;
        global $creation_abonnement_js_form, $edition_abonnement_js_form;
        global $serial_id;
        
        $interface_form = new interface_catalog_abts_form('form_abonnement');
        $interface_form->set_serial_id($serial_id);
        //Notice mre
        $perio=new serial_display($this->num_notice,1);
        if (!$this->abt_id) {
            $interface_form->set_abt_status(1);
            $interface_form->set_label($perio->header." : ".$msg["abts_abonnements_modify_title"]);
            $js_script = $creation_abonnement_js_form;
            $js_script_end = "";
        }else{
            $interface_form->set_abt_status($this->abt_status);
            $interface_form->set_label($perio->header." : ".$msg["abts_abonnements_modify_title"]);
            $js_script = $edition_abonnement_js_form;
            $js_script_end = "<script type='text/javascript'>expl_part_display();</script>
	        <script type=\"text/javascript\" src='./javascript/select.js'></script>
    		<script type=\"text/javascript\" src='./javascript/ajax.js'></script>";
            $js= <<<ENDOFTEXT
			<script type="text/javascript">
			function duplique(obj,e) {
				if(!e) e=window.event;
				var tgt = e.target || e.srcElement; // IE doesn't use .target
				var strid = tgt.id;
				var type = tgt.tagName;
				e.cancelBubble = true;
				if (e.stopPropagation) e.stopPropagation();
				var pos=findPos(obj);
				var url="./catalog/serials/abonnement/abonnement_duplique.php?abonnement_id=!!abonnement_id!!&serial_id=!!serial_id!!";
				var notice_view=document.createElement("iframe");
				notice_view.setAttribute('id','frame_abts');
				notice_view.setAttribute('name','periodique');
				notice_view.src=url;
				var att=document.getElementById("att");
				notice_view.style.visibility="hidden";
				notice_view.style.display="block";
				notice_view=att.appendChild(notice_view);
				w=notice_view.clientWidth;
				h=notice_view.clientHeight;
				posx=(getWindowWidth()/2-(w/2))<0?0:(getWindowWidth()/2-(w/2))
				posy=(getWindowHeight()/2-(h/2))<0?0:(getWindowHeight()/2-(h/2));
				notice_view.style.left=posx+"px";
				notice_view.style.top=posy+"px";
				notice_view.style.visibility="visible";
			}
			
			function kill_frame_periodique() {
				var notice_view=document.getElementById("frame_abts");
				notice_view.parentNode.removeChild(notice_view);
			}
			</script>
ENDOFTEXT;
            $js=str_replace("!!serial_id!!",$serial_id,$js);
            $js=str_replace("!!abonnement_id!!",$this->abt_id,$js);
            $js_script_end .= $js;
            
            $interface_form->add_action_extension('gen', $msg['abonnement_generer_la_grille'], $interface_form->get_url_base().'&act=gen&abt_id='.$this->abt_id);
            $interface_form->add_action_extension('prolonge', $msg['abonnement_prolonger_abonnement'], $interface_form->get_url_base().'&act=prolonge&abt_id='.$this->abt_id);
            $interface_form->add_action_extension('raz', $msg['abonnement_raz_grille'], $interface_form->get_url_base().'&act=raz&abt_id='.$this->abt_id);
        }
        $interface_form->set_object_id($this->abt_id)
        ->set_confirm_delete_msg($msg['abonnements_confirm_suppr_abonnement'])
        ->set_content_form($this->get_content_form())
        ->set_table_name('abts_abts')
        ->set_field_focus('abt_name')
        ->set_duplicable(true);
        $form = $interface_form->get_display();
        
        $js_script = str_replace("!!test_liste_modele!!",$this->get_test_liste_modele(), $js_script);
        
        return $js_script.$form.$js_script_end;
    }
    
    public function show_form() {
        global $msg;
        global $serial_header;
        
        if ($this->abt_id) {
            $this->getData();
            $header = str_replace('!!page_title!!', $msg[4000].$msg[1003].$msg["abts_abonnements_modify_title"], $serial_header);
        } else {
            $header = str_replace('!!page_title!!', $msg[4000].$msg[1003].$msg["abts_abonnements_add_title"], $serial_header);
        }
        return $header.$this->get_form();
    }
    
    // ----------------------------------------------------------------------------
    //	fonction do_selector qui gnre des combo_box avec tout ce qu'il faut
    // ----------------------------------------------------------------------------
    public function do_selector() {
        global $charset;
        global $deflt_docs_section;
        global $deflt_docs_location;
        
        if (!$this->section_id) $this->section_id=$deflt_docs_section ;
        if (!$this->location_id) $this->location_id=$deflt_docs_location;
        
        $rqtloc = "SELECT idlocation FROM docs_location order by location_libelle";
        $resloc = pmb_mysql_query($rqtloc);
        $selector = '';
        while ($loc=pmb_mysql_fetch_object($resloc)) {
            $requete = "SELECT idsection, section_libelle FROM docs_section, docsloc_section where idsection=num_section and num_location='$loc->idlocation' order by section_libelle";
            $result = pmb_mysql_query($requete);
            $nbr_lignes = pmb_mysql_num_rows($result);
            if ($nbr_lignes) {
                if ($loc->idlocation==$this->location_id) {
                    $selector .= "<div id=\"docloc_section".$loc->idlocation."\" style=\"display:block\">\r\n";
                } else {
                    $selector .= "<div id=\"docloc_section".$loc->idlocation."\" style=\"display:none\">\r\n";
                }
                $selector .= "<select name='f_ex_section".$loc->idlocation."' id='f_ex_section".$loc->idlocation."'>";
                while($line = pmb_mysql_fetch_row($result)) {
                    $selector .= "<option value='$line[0]'";
                    $line[0] == $this->section_id ? $selector .= ' SELECTED>' : $selector .= '>';
                    $selector .= htmlentities($line[1],ENT_QUOTES, $charset).'</option>';
                }
                $selector .= '</select></div>';
            }
        }
        return $selector;
    }
    
    public function gen_tpl_abt_modele($id,$titre,$num,$vol,$tome,$delais,$delais_critique,$change_statut_id){
        global $msg;
        
        $id = intval($id);
        $requete="select * from abts_modeles where modele_id='$id'";
        $resultat=pmb_mysql_query($requete);
        if ($r_a=pmb_mysql_fetch_object($resultat)) {
            $tom_actif=$r_a->tom_actif;
            $vol_actif=$r_a->vol_actif;
            $num_depart=$r_a->num_depart;
            $vol_depart=$r_a->vol_depart;
            $tom_depart=$r_a->tom_depart;
        }
        if (empty($num)) {
            $num=$num_depart;
        }
        if (empty($vol)) {
            $vol=$vol_depart;
        }
        if (empty($tome)) {
            $tome=$tom_depart;
        }
        $interface_content_form = new interface_content_form(static::class."_modele");
        
        $interface_content_form->add_element('num['.$id.']', 'abonnements_periodique_numero_depart')
        ->add_input_node('integer', $num);
        if($vol_actif) {
            $interface_content_form->add_element('vol['.$id.']', 'abonnements_volume_numero_depart')
            ->set_class('colonne2')
            ->add_input_node('integer', $vol);
        }
		
        if($tom_actif) {
            $interface_content_form->add_element('tome['.$id.']', 'abonnements_tome_numero_depart')
            ->set_class('colonne_suite')
            ->add_input_node('integer', $tome);
        }
		
        $interface_content_form->add_element('empty_1')
        ->add_html_node('&nbsp;');
        
        $interface_content_form->add_element('delais['.$id.']', 'abonnements_delais_avant_retard')
        ->set_class('colonne2')
        ->add_input_node('integer', $delais);
        
        $interface_content_form->add_element('delais_critique['.$id.']', 'abonnements_delais_critique')
        ->set_class('colonne_suite')
        ->add_input_node('integer', $delais_critique);

        $contenu = $interface_content_form->get_display();
        
        // select !!change_statut!!
        $statut_form=str_replace('!!statut_check!!',
            "<input type='checkbox' ".(!$id || $change_statut_id ? "checked='checked'" : '')." value='1' name='change_statut_check[".$id."]' id='change_statut[".$id."]_check' onclick=\"gere_statut('change_statut[".$id."]');\"/>",
            $msg['catalog_change_statut_form']);
        
        $statut_form=str_replace('!!statut_list!!',
            do_selector('docs_statut', "change_statut[".$id."]", $change_statut_id),
            $statut_form);
        
        $contenu.= "
		<div class='row'>&nbsp;</div>
		<div class='row'>
			$statut_form
		</div>
		";
			
		return $this->gen_plus_form($id,$titre,$contenu);
    }
    
    public function gen_date($garder=0){
        global $include_path;
        
        if($this->abt_id) {
            if (!$garder) {
                $dummy = "delete FROM abts_grille_abt WHERE num_abt='$this->abt_id' and state='0'";
                pmb_mysql_query($dummy);
            }
            
            $date_debut = construitdateheuremysql($this->date_debut);
            $date_fin = construitdateheuremysql($this->date_fin);
            
            //Pour tous les modles utilis dans l'abonnement, on recopie les grilles modles dans la grille abonnement
            $requete="select modele_id from abts_abts_modeles where abt_id='$this->abt_id'";
            $resultat_a=pmb_mysql_query($requete);
            while ($r_a=pmb_mysql_fetch_object($resultat_a)) {
                $modele_id=$r_a->modele_id;
                
                $requete="select * from abts_grille_modele where num_modele='$modele_id'";
                $resultat=pmb_mysql_query($requete);
                while ($r_g=pmb_mysql_fetch_object($resultat)) {
                    
                    //Ne garder les bulletins compris entre les dates de dbut et fin d'abonnement
                    if( ( pmb_sql_value("SELECT DATEDIFF('$date_fin','$r_g->date_parution')")>= 0 ) &&
                        ( pmb_sql_value("SELECT DATEDIFF('$date_debut','$r_g->date_parution')")<= 0 ) ) {
                            for($i=1;$i<=$r_g->nombre_recu;$i++){
                                $requete = "INSERT INTO abts_grille_abt SET num_abt='$this->abt_id',
								date_parution ='$r_g->date_parution',
								modele_id='$modele_id',
								type = '$r_g->type_serie',
								numero='$r_g->numero',
								nombre='1',
								ordre='$i' ";
                                pmb_mysql_query($requete);
                            }
                        }
                }
            }
        }
    }
    
    public function update() {
        global $msg;
        global $include_path;
        global $act,$modele,$num,$vol,$tome,$delais,$delais_critique,$change_statut,$change_statut_check;
        
        if(!$this->abt_name) {
            return false;
        }
        // nettoyage des valeurs en entre
        $this->abt_name = clean_string($this->abt_name);
        $this->abt_name_opac = clean_string($this->abt_name_opac);
        // construction de la requte
        $requete = "SET abt_name='".addslashes($this->abt_name)."', ";
        $requete .= "abt_name_opac='".addslashes($this->abt_name_opac)."', ";
        $requete .= "num_notice='$this->num_notice', ";
        $requete .= "duree_abonnement='$this->duree_abonnement', ";
        $requete .= "date_debut='$this->date_debut', ";
        $requete .= "date_fin='$this->date_fin', ";
        $requete .= "fournisseur='$this->fournisseur', ";
        $requete .= "destinataire='".addslashes($this->destinataire)."', ";
        $requete .= "cote='".addslashes($this->cote)."', ";
        $requete .= "typdoc_id='$this->typdoc_id', ";
        $requete .= "exemp_auto='$this->exemp_auto', ";
        $requete .= "location_id='$this->location_id', ";
        $requete .= "section_id='$this->section_id', ";
        $requete .= "lender_id='$this->lender_id', ";
        $requete .= "statut_id='$this->statut_id', ";
        $requete .= "codestat_id='$this->codestat_id', ";
        $requete .= "prix='$this->prix', ";
        $requete .= "type_antivol='$this->type_antivol', ";
        $requete .= "abt_numeric='$this->abt_numeric', ";
        $requete .= "abt_status='$this->abt_status', ";
        $requete .= "expl_custom_fields='".addslashes(encoding_normalize::json_encode($this->expl_custom_fields))."' ";
        
        if($this->abt_id) {
            // Update: s'assurer que le nom d'abonnement n'existe pas dj
            $dummy = "SELECT * FROM abts_abts WHERE abt_name='".addslashes($this->abt_name)."' and num_notice='$this->num_notice' and abt_id!=$this->abt_id";
            $check = pmb_mysql_query($dummy);
            if(pmb_mysql_num_rows($check)) {
                require_once("$include_path/user_error.inc.php");
                warning($msg["abonnements_titre_creation_edition_abonnement"], $msg["abonnements_erreur_creation_doublon_abonnement"]." ($this->abt_name).");
                return FALSE;
            }
            
            // update
            $requete = 'UPDATE abts_abts '.$requete;
            $requete .= ' WHERE abt_id='.$this->abt_id.' LIMIT 1;';
            
            if(pmb_mysql_query($requete) ) {
                if($act=="gen") $this->gen_date();
                $requete="select modele_id from abts_modeles where num_notice='$this->num_notice'";
                $resultat=pmb_mysql_query($requete);
                while ($r=pmb_mysql_fetch_object($resultat)) {
                    $modele_id=$r->modele_id;
                    if(isset($change_statut_check[$modele_id]) && $change_statut_check[$modele_id])$num_statut=$change_statut[$modele_id];
                    else $num_statut=0;
                    
                    $num_value = isset($num[$modele_id]) ? intval($num[$modele_id]) : 0;
                    $vol_value = isset($vol[$modele_id]) ? intval($vol[$modele_id]) : 0;
                    $tome_value = isset($tome[$modele_id]) ? intval($tome[$modele_id]) : 0;
                    $delais_value = isset($delais[$modele_id]) ? intval($delais[$modele_id]) : 0;
                    $critique_value = isset($delais_critique[$modele_id]) ? intval($delais_critique[$modele_id]) : 0;
                    
                    $requete = "UPDATE abts_abts_modeles
                                SET num=$num_value,
                                    vol=$vol_value,
                                    tome=$tome_value,
                                    delais=$delais_value,
                                    critique=$critique_value,
                                    num_statut_general=$num_statut
                                WHERE modele_id=$modele_id
                                AND abt_id=$this->abt_id";
                    
                    pmb_mysql_query($requete);
                }
                //Traductions
                $translation = new translation($this->abt_id, 'abts_abts');
                $translation->update_small_text('abt_name_opac');
                return TRUE;
            }
            else {
                echo pmb_mysql_error();
                require_once("$include_path/user_error.inc.php");
                warning($msg["abonnements_titre_creation_edition_abonnement"], $msg["abonnements_titre_creation_edition_modele_impossible"]);
                return FALSE;
            }
        } else {
            // Cration: s'assurer que le modle n'existe pas dj
            $dummy = "SELECT * FROM abts_abts WHERE abt_name='".addslashes($this->abt_name)."' and num_notice='$this->num_notice'";
            $check = pmb_mysql_query($dummy);
            if(pmb_mysql_num_rows($check)) {
                require_once("$include_path/user_error.inc.php");
                warning($msg["abonnements_titre_creation_edition_abonnement"], $msg["abonnements_erreur_creation_doublon_abonnement"]." ($this->abt_name).");
                return FALSE;
            }
            $requete = 'INSERT INTO abts_abts '.$requete.';';
            if(pmb_mysql_query($requete)) {
                $this->abt_id=pmb_mysql_insert_id();
                $requete="select modele_id,num_periodicite from abts_modeles where num_notice='$this->num_notice'";
                $resultat=pmb_mysql_query($requete);
                while ($r=pmb_mysql_fetch_object($resultat)) {
                    $modele_id=$r->modele_id;
                    $num_periodicite=$r->num_periodicite;
                    if(isset($modele[$modele_id])){
                        $requete="select libelle, retard_periodicite,seuil_periodicite from abts_periodicites where periodicite_id ='".$num_periodicite."'";
                        $r_delais=pmb_mysql_query($requete);
                        if ($r_d=pmb_mysql_fetch_object($r_delais)) {
                            $periodicite=$r_d->libelle;
                            $delais=$r_d->seuil_periodicite;
                            $critique=$r_d->retard_periodicite;
                        }
                        if(!isset($critique)) $critique = 0; //retard_periodicite est a NULL par dfaut
                        if(isset($change_statut_check[$modele_id]) && $change_statut_check[$modele_id]) $num_statut=$change_statut[$modele_id];
                        else $num_statut=0;
                        $requete = "INSERT INTO abts_abts_modeles SET modele_id='$modele_id', abt_id='$this->abt_id', delais='$delais', critique='$critique', num_statut_general='$num_statut' ";
                        pmb_mysql_query($requete);
                    }
                }
                //Traductions
                $translation = new translation($this->abt_id, 'abts_abts');
                $translation->update_small_text('abt_name_opac');
                
                if($act=="gen") $this->gen_date();
                return TRUE;
            }
            else {
                echo pmb_mysql_error();
                require_once("$include_path/user_error.inc.php");
                warning($msg["abonnements_titre_creation_edition_abonnement"], $msg["abonnements_titre_creation_edition_modele_impossible"]);
                return FALSE;
            }
        }
    }
    
    public function delete(){
        global $msg;
        global $include_path;
        
        $serialcirl_diff = new serialcirc_diff();
        // l'abonnement a encore au moins un expl en circulation
        if($serialcirl_diff->expl_in_circ($this->abt_id)){
            return $msg['serialcirc_error_delete_abt'];
        }
        $dummy = "delete FROM abts_abts WHERE abt_id='$this->abt_id' ";
        pmb_mysql_query($dummy);
        
        $dummy = "delete FROM abts_grille_abt WHERE num_abt='$this->abt_id' ";
        pmb_mysql_query($dummy);
        
        $dummy = "delete FROM abts_abts_modeles WHERE abt_id='$this->abt_id' ";
        pmb_mysql_query($dummy);
        
        abts_pointage::delete_retard($this->abt_id);
        
        $serialcirl_diff->delete($this->abt_id);
        
        translation::delete($this->abt_id, 'abts_abts');
        return "";
    }
    
    public function set_properties_from_form() {
        global $deflt_docs_location, $deflt_docs_section;
        global $abt_name, $abt_name_opac, $num_notice, $duree_abonnement;
        global $id_fou, $destinataire;
        global $cote, $typdoc_id, $exemp_auto, $location_id, $lender_id, $statut_id, $codestat_id, $prix, $type_antivol, $abt_numeric, $abts_status;
        
        $formlocid="f_ex_section".$location_id ;
        global ${$formlocid};
        $section_id=${$formlocid} ;
        
        if (!$section_id) {
            $section_id=$deflt_docs_section ;
        }
        if (!$location_id) {
            $location_id=$deflt_docs_location;
        }
        if(!$abts_status) {
            $abts_status = 1;
        }
        
        $this->abt_name= stripslashes($abt_name ?? '');
        $this->abt_name_opac= stripslashes($abt_name_opac ?? '');
        $this->num_notice = intval($num_notice);
        $this->duree_abonnement = $duree_abonnement;
        $this->fournisseur = $id_fou;
        $this->destinataire = stripslashes($destinataire ?? '');
        $this->cote = stripslashes($cote ?? '');
        $this->typdoc_id = intval($typdoc_id);
        $this->exemp_auto = intval($exemp_auto);
        $this->location_id = intval($location_id);
        $this->section_id = intval($section_id);
        $this->lender_id = intval($lender_id);
        $this->statut_id = intval($statut_id);
        $this->codestat_id = intval($codestat_id);
        $this->prix = stripslashes($prix ?? '');
        $this->type_antivol = $type_antivol;
        $this->abt_numeric = $abt_numeric;
        $this->abt_status = $abts_status;
        $p_perso=new parametres_perso("expl");
        $this->expl_custom_fields = $p_perso->read_form_fields_perso();
    }
    
    public function proceed() {
        global $act, $current_module;
        global $serial_id,$msg,$date_debut,$date_fin;
        global $duree_abonnement,$date_debut,$date_fin;
        global $abt_id;
        global $nb_duplication;
        
        switch ($act) {
            case 'update':
                // mise  jour modle
                $this->set_properties_from_form();
                $this->date_debut= $date_debut;
                $this->date_fin= $date_fin;
                $this->update();
                print $this->show_form();
                break;
            case 'gen':
                // mise  jour modle
                $this->set_properties_from_form();
                $this->date_debut= $date_debut;
                $this->date_fin= $date_fin;
                $this->update();
                print $this->show_form();
                break;
            case 'prolonge':
                // mise  jour modle
                $this->set_properties_from_form();
                $this->date_debut= $date_fin; //Ce n'est pas une erreur mais cela sert pour $this->gen_date(1); qui suit... Date dbut est bien re-valoris juste aprs
                $this->date_fin= pmb_sql_value("SELECT DATE_ADD('$date_fin',INTERVAL $duree_abonnement month)");
                $this->gen_date(1);
                $this->date_debut= $date_debut;
                $this->update();
                print $this->show_form();
                break;
            case 'copy':
                
                $this->getData();
                $abt_id=$this->abt_id;
                $this->abt_name.="_1";
                for($i=0;$i<$nb_duplication;$i++){
                    //Cration nouvel abonnement
                    $this->abt_id='';
                    do {
                        $this->abt_name++;
                        $requete = "SELECT abt_name FROM abts_abts WHERE abt_name='".addslashes($this->abt_name)."' and num_notice='$this->num_notice'";
                        $resultat=pmb_mysql_query($requete);
                    }
                    while (pmb_mysql_fetch_object($resultat));
                    $this->update();
                    //recopie des modeles associs
                    $requete = "select * from abts_abts_modeles where abt_id='$abt_id'";
                    $resultat=pmb_mysql_query($requete);
                    while ($r_m=pmb_mysql_fetch_object($resultat)) {
                        $requete = "INSERT INTO abts_abts_modeles SET modele_id='$r_m->modele_id', abt_id='$this->abt_id',num='$r_m->num' ,vol='$r_m->vol',tome='$r_m->tome',delais='$r_m->delais', critique='$r_m->critique',num_statut_general='$r_m->num_statut_general'";
                        pmb_mysql_query($requete);
                    }
                    //recopie des infos du calendrier
                    $requete = "select * from abts_grille_abt where num_abt='$abt_id'";
                    $resultat=pmb_mysql_query($requete);
                    while ($r_g=pmb_mysql_fetch_object($resultat)) {
                        $requete = "INSERT INTO abts_grille_abt SET num_abt='$this->abt_id',
							date_parution ='$r_g->date_parution',
							modele_id='$r_g->modele_id',
							type = '$r_g->type',
							numero='$r_g->numero',
							nombre='$r_g->nombre',
							ordre='$r_g->ordre' ";
                        pmb_mysql_query($requete);
                    }
                }
                print "<div class='row'><div class='msg-perio'>".$msg['maj_encours']."</div></div>";
                $id_form = md5(microtime());
                $retour = "./catalog.php?categ=serials&sub=view&serial_id=$serial_id&view=abon";
                print "<form class='form-$current_module' name=\"dummy\" method=\"post\" action=\"$retour\" style=\"display:none\">
					<input type=\"hidden\" name=\"id_form\" value=\"$id_form\">
					</form>
					<script type=\"text/javascript\">document.dummy.submit();</script>
					</div>";
                break;
            case 'raz':
                if($this->abt_id) {
                    $dummy = "delete FROM abts_grille_abt WHERE num_abt='".$this->abt_id."'";
                    pmb_mysql_query($dummy);
                }
                print $this->show_form();
                break;
            case 'del':
                if($msg_error=$this->delete())	{
                    $retour = "./circ.php?categ=serialcirc";
                    error_message('', $msg_error, 1, $retour);
                }else{
                    print "<div class='row'><div class='msg-perio'>".$msg['maj_encours']."</div></div>";
                    $id_form = md5(microtime());
                    $retour = "./catalog.php?categ=serials&sub=view&serial_id=$serial_id&view=abon";
                    print "<form class='form-$current_module' name=\"dummy\" method=\"post\" action=\"$retour\" style=\"display:none\">
						<input type=\"hidden\" name=\"id_form\" value=\"$id_form\">
						</form>
						<script type=\"text/javascript\">document.dummy.submit();</script>
						</div>";
                }
                break;
            default:
                print $this->show_form();
                break;
        }
    }
    
    public function gen_plus_form($id,$titre,$contenu) {
        return "
    	<div class='row'></div>
    	<div id='$id' class='notice-parent'>
            ".get_expandBase_button($id)."
    		<span class='notice-heada'>
    			$titre
    		</span>
    	</div>
    	<div id='$id"."Child' class='notice-child' startOpen='Yes' style='margin-bottom:6px;display:none;width:94%'>
    		$contenu
    	</div>
    	";
    }
}
