<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: import_belgique.inc.php,v 1.16.6.1 2024/12/20 15:54:27 dbellamy Exp $

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) die("no access");

global $class_path;
global $action, $imp_elv, $imp_prof, $Sep_Champs, $type_import;

require_once $class_path."/emprunteur.class.php";
require_once $class_path."/import/import_empr.class.php";

//import_belgique - Version modifie par A.-M Cubat en avril 2006
//Ecole N.-D. de la Sagesse - Avenue Van Overbeke, 10 - B-1083 Bruxelles (Belgique)


//Diffrence majeure entre l'import "Bretagne" et l'import "Belgique" : l'import des professeurs

//Dans la version import_bretagne, les lves taient "imports" en groupe (cration automatique des groupes, insertion automatique dans le bon groupe)
//Les profs taient "imports" individuellement, le nombre de champs imports dans leur fiche "lecteur" tait rduit, leur numro de lecteur tait tir au sort.

//Dans la version import_belgique, non seulement les groupes "lves", mais aussi les groupes "professeurs" sont crs automatiquement
//Il n'est plus ncessaire de crer "manuellement" un ou plusieurs groupes de professeurs en rditant la fiche de chaque membre du personnel.
//C'est donc un avantage majeur, qui apporte un net gain de temps au niveau de l'encodage. Imaginez la situation s'il y a une centaine de professeurs.

//Merci aux concepteurs de import_bretagne, ce sont eux qui ont mis au point l'import des lves avec cration automatique des groupes
//Je n'ai aucun mrite, je n'ai rien invent - j'ai modifi un programme existant que j'aurais t incapable de rdiger moi-mme.
//J'y ai simplement ajout la possibilit de crer galement des groupes de professeurs.


//import_belgique permet donc d'avoir pour les professeurs exactement les mmes champs que pour les lves.
//Vous n'aurez donc qu'un seul modle de fichier de lecteurs en Excel, ce qui est plus pratique.

//La structure du fichier texte doit tre la suivante : 11 champs (pour tout le monde)
//Numro identifiant/Nom/Prnom/Rue/Complment de rue/Code postal/Commune/Tlphone/Date de naissance/Classe/Sexe

//La liste de ces 11 champs figurera peut-tre  la premire ligne de votre fichier Excel (c'est souvent plus simple, ne vous privez pa de cette facilit)
//Mais si c'est le cas, il faut absolument la supprimer avant de convertir le fichier. La fiche du premier lecteur doit se trouver  la premire ligne.
//Sinon, vous crez un lecteur dont le nom est "nom", dont le prnom est "prnom", et dont l'anne de naissance est "anne" au lieu d'une date !

//Pas question de changer l'ordre des champs, ni d'en supprimer
//Vous n'tes pas oblig de complter ces 11 champs, mais n'oubliez pas de laisser dans ce cas des colonnes vides dans Excel.
//Evitez toutefois de laisser le champ "sexe" vide pour la fiche du premier lecteur (car c'est le dernier champ de la premire ligne).
//Excel risque de "croire" qu'il y a moins de 11 colonnes  convertir (le nombre de cellules compltes  la premire ligne est dterminant  cet gard).

//Le fichier Excel doit tre converti en format .csv avant l'import dans PMB - c'est un type de fichier texte avec le point-virgule comme sparateur de champ.
//Vrifiez que chaque ligne du fichier .csv se termine bien par un point-virgule, sinon vous perdrez le dernier caractre du dernier champ de chaque ligne.

//Contenu des champs
//Pour le Sexe, vous mettez "M" ou "F" (lves ou professeurs, peu importe)
//SI vous voulez crer des groupes (d'lves ou de professeurs), il faut bien sr complter la colonne "Classe" pour tout le monde.

//Si le champ "Classe" reste vide, ce lecteur sera encod dans la base mais ne fera partie d'aucun groupe, et risque donc de passer "inaperu" dans certains cas.
//Si vous voulez crer plusieurs groupes de professeurs, il suffit d'avoir des libells diffrents (Profs - Profs1 - Profs2 ...) - comme pour les lves et leurs classes..
//Standardisez l'orthographe - "Profs 1" n'est pas la mme chose que "Profs1" (avec ou sans espace intermdiaire) - cela crerait 2 groupes diffrents.

//Au moment d'importer, slectionnez le fichier .csv et choisissez entre "import des lves" et "import des professeurs".
//Le programme cre automatiquement les groupes (dans un cas comme dans l'autre), et insre aussi chacun dans le groupe correspondant..
//Il attribue le bon code statistique  chaque lecteur et le place galement dans la bonne catgorie.


//La suite du commentaire concerne les adaptations ventuelles  faire pour les codes statistiques et pour les catgories - en fonction de votre configuration.

//J'ai attribu  tous les lves et tous les professeurs le code statistique "cole".
//J'ai mis les lves dans la catgorie "lves", les professeurs dans la catgorie "professeurs".
//Vous pouvez bien sr changer ces paramtres, j'explique comment procder.

//Pour attribuer un code statistique ou une catgorie  un lecteur, il faut connatre la clef primaire (le "id") du code ou de la catgorie.
//Donc, il  faut aller voir dans les tables empr_codestat et empr_categ si vous voulez changer ceci.
//Clic droit de souris sur l'icne PHP - choisir Administration - PHPMyAdmin - administration BDD.

//Voici comment les tables se prsentent chez nous, cela vous aidera  faire les modifications qui seront  probablement ncessaires chez vous.

//Je n'ai pas supprim de clefs primaires dans les tables empr_codestat et empr_categ, j'ai chang les libells mais j'ai gard les clefs primaires d'origine.

//Dans la table empr_codestat, j'ai gard idcode = 2 mais j'ai remplac le libell "communaut de communes" par le libell "cole".
//Dans la table empr_categ, j'ai gard id_categ_empr = 1 mais j'ai remplac le libell "enfants"  par le libell "lves".
//Dans la table empr_categ, j'ai gard id_categ_empr = 2 mais j'ai remplac le libell "retraits"  par le libell "professeurs".

//Si vous voulez d'autres valeurs, c'est facile, il suffit de changer 4 lignes dans ce programme.
//Voici les lignes qui correspondent aux codes de notre configuration.

//Chez nous, les lves ont le code statistique 2 (cole), et sont dans la catgorie 1  (lves)
//Import_eleves  - cet lve n'est pas enregistr).
//$req_insert .= "'$tab[6]', '$tab[7]', '$tab[8]', 1, 2, '$date_auj', '$sexe', ";
//Iimport_eleves (cet lve est dj  enregistr)
// $req_update .= "empr_tel1 = '$tab[7]', empr_year = '$tab[8]', empr_categ = '1', empr_codestat = '2', empr_modif = '$date_auj', empr_sexe = '$sexe', ";

//Chez nous, les profs ont le code statistique 2 (cole), et sont dans la catgorie 2  (professeurs)
//Import_profs  - ce prof n'est pas enregistr)
//$req_insert .= "'$tab[6]', '$tab[7]', '$tab[8]', 2, 2, '$date_auj', '$sexe', ";
//Import_profs  - ce prof est dj enregistr)
//$req_update .= "empr_tel1 = '$tab[7]', empr_year = '$tab[8]', empr_categ = '2', empr_codestat = '2', empr_modif = '$date_auj', empr_sexe = '$sexe', ";

//Attention ! Comme je le disais, cette version est conue en fonction des n de clefs primaires de la configuration actuelle de mon cole.
//Si vous avez d'autres libells, ou les mmes libells mais lis  d'autres n de clefs primaires, il faudra modifier les valeurs (les id)

//Chercher les commentaires suivants : Cet lve est dj enregistr - n'est pas enregistr - Cet prof est dj enregistr - n'est pas enregistr
//Vous trouverez facilement les 4 lignes  modifier - ce sont celles reprises ci-dessus et qui commencent par $req_insert ou par $req_update
//Un bref commentaire  ces endroits-l vous rappelle les codes que j'ai employs et vous permet de reprer aisment les lignes  changer.

//A vous de remplacer les valeurs qui s'y trouvent (1 ou 2 dans le cas prsent) par celles que vous trouverez dans vos tables empr_categ et empr_codestat.
//PHPMyAdmin vous permettra de savoir quelles clefs primaires correspondent aux libells des catgories et des codes statistiques que vous avez slectionns.

//Bonne chance !

//Explications de A.-M. Cubat


function show_import_choix_fichier() {

	global $msg;
	global $current_module ;

print "
<form class='form-$current_module' name='form1' ENCTYPE=\"multipart/form-data\" method='post' action=\"./admin.php?categ=empr&sub=implec&action=1\">
<h3>Choix du fichier</h3>
<div class='form-contenu'>
	<div class='row'>
		<label class='etiquette' for='form_import_lec'>".$msg["import_lec_fichier"]."</label>
        <input name='import_lec' accept='text/plain' type='file' class='saisie-80em' size='40'>
		</div>
	<div class='row'>
        <label class='etiquette' for='form_import_lec'>". $msg["import_lec_separateur"]."</label>
        <select name='Sep_Champs' >
            <option value=';'>;</option>
            <option value='.'>.</option>
        </select>
    </div>
    <br />
	<div class='row'>
        <input type=radio name='type_import' value='nouveau_lect' checked>
        <label class='etiquette' for='form_import_lec'>Nouveaux lecteurs</label>
        (ajoute ou modifie les lecteurs prsents dans le fichier)
        <br />
        <input type=radio name='type_import' value='maj_complete'>
        <label class='etiquette' for='form_import_lec'>Mise  jour complte</label>
        (supprime les lecteurs non prsents dans le fichier et qui n'ont pas de prt en cours)
    </div>
    <div class='row'></div>

	</div>
<div class='row'>
	<input name='imp_elv' type='submit' class='bouton' value='Import des lves'/>
	<input name='imp_prof' value='Import des professeurs' type='submit' class='bouton'/>
</div>
</form>";
}

function import_eleves($separateur, $type_import){

    //La structure du fichier texte doit tre la suivante :
    //Numro identifiant/Nom/Prnom/Rue/Complment de rue/Code postal/Commune/Tlphone/Date de naissance/Classe/Sexe

    global $lang;
    $cpt_insert = 0;
    $cpt_maj = 0;

    $eleve_abrege = array("Numro identifiant","Nom","Prnom");
    $date_auj = date("Y-m-d", time());
    $date_an_proch = date("Y-m-d", time()+3600*24*30.42*12);

    //Upload du fichier
    if (!($_FILES['import_lec']['tmp_name'])) {
        print "Cliquez sur Pr&eacute;c&eacute;dent et choisissez un fichier";
    } elseif (!(move_uploaded_file($_FILES['import_lec']['tmp_name'], "./temp/".basename($_FILES['import_lec']['tmp_name'])))) {
        print "Le fichier n'a pas pu tre tlcharg. Voici plus d'informations :<br />";
        print_r($_FILES)."<p>";
    }
    $fichier = @fopen( "./temp/".basename($_FILES['import_lec']['tmp_name']), "r" );

    if ($fichier) {

        if ($type_import == 'maj_complete') {
            //Vide la table empr_groupe
            pmb_mysql_query("DELETE FROM empr_groupe");
            //Supprime les lves qui n'ont pas de prts en cours
            $req_select_verif_pret = "SELECT id_empr FROM empr left join pret on id_empr=pret_idempr WHERE pret_idempr is null and empr_cb NOT LIKE 'E%'";
            $select_verif_pret = pmb_mysql_query($req_select_verif_pret);
            while (($verif_pret = pmb_mysql_fetch_array($select_verif_pret))) {
            	//pour tous les emprunteurs qui n'ont pas de pret en cours
                emprunteur::del_empr($verif_pret["id_empr"]);
            }
        }

        while (!feof($fichier)) {
            $buffer = fgets($fichier, 4096);
            $buffer = import_empr::get_encoded_buffer($buffer);
            $buffer = pmb_mysql_escape_string($buffer);
            $tab = explode($separateur, $buffer);

            //Gestion du sexe
            switch ($tab[10][0]) {
                case 'M':
                    $sexe = 1;
                    break;
                case 'F':
                    $sexe = 2;
                    break;
                default:
                    $sexe = 0;
                    break;
            }

            // Traitement de l'lve
            $id_empr = 0;
            $select = pmb_mysql_query("SELECT id_empr FROM empr WHERE empr_cb = '".$tab[0]."'");
            $nb_enreg = pmb_mysql_num_rows($select);

            //Test si un numro id est fourni
            if (!$tab[0] || $tab[0] == "") {
                print("<b> Elve non pris en compte car \"Numro identifiant\" non renseign : </b><br />");
                for ($i=0;$i<3;$i++) {
                    print($eleve_abrege[$i]." : ".$tab[$i].", ");
                }
                print("<br />");
                $nb_enreg = 2;
            }
            if($nb_enreg == 1) {
                $row = pmb_mysql_fetch_assoc($select);
                $id_empr = $row['id_empr'];
            }

            $login = import_empr::cre_login($tab[1],$tab[2]);

            switch ($nb_enreg) {

                case 0:
                	//Cet lve n'est pas enregistr
                    $req_insert = "INSERT INTO empr(empr_cb, empr_nom, empr_prenom, empr_adr1, empr_adr2, empr_cp, empr_ville, ";
                    $req_insert .= "empr_tel1, empr_year, empr_categ, empr_codestat, empr_creation, empr_sexe,  ";
                    $req_insert .= "empr_login, empr_password, empr_date_adhesion, empr_date_expiration) ";
                    $req_insert .= "VALUES ('$tab[0]','$tab[1]','$tab[2]','$tab[3]', '$tab[4]', '$tab[5]', ";
	               //Vrifier dans la table empr_categ si id_categ_empr 1 = lves    Vrifier dans la table empr_codestat si idcode 2 = cole    Sinon, changer les valeurs
                    $req_insert .= "'$tab[6]', '$tab[7]', '$tab[8]', 1, 2, '$date_auj', '$sexe', ";
                    $req_insert .= "'$login', '$tab[8]', '$date_auj', '$date_an_proch')";
                    $insert = pmb_mysql_query($req_insert);

                    if (!$insert) {

                        print("<b>Echec de la cration de l'lve suivant (Erreur : ".pmb_mysql_error().") : </b><br />");
                        for ($i=0;$i<3;$i++) {
                            print($eleve_abrege[$i]." : ".$tab[$i].", ");
                        }
                        print("<br />");

                    } else {

                        $id_empr = pmb_mysql_insert_id();

                        //Chiffrement du mot de passe
                        //On verifie que le mot de passe lecteur correspond aux regles de saisie definies
                        //Si non, encodage dans l'ancien format
                        $old_hash = false;
                        $check_password_rules = emprunteur::check_password_rules((int) $id_empr, $tab[8], [], $lang);
                        if( !$check_password_rules['result'] ) {
                            $old_hash = true;
                        }
                        emprunteur::update_digest($login,$tab[8]);
                    	emprunteur::hash_password($login,$tab[8], $old_hash);

                        $cpt_insert ++;
                    }
                    import_empr::gestion_groupe($tab[9], $tab[0]);
                    break;

                case 1:
                	//Cet lve est dj enregistr
                    $req_update = "UPDATE empr SET empr_nom = '$tab[1]', empr_prenom = '$tab[2]', empr_adr1 = '$tab[3]', ";
                    $req_update .= "empr_adr2 = '$tab[4]', empr_cp = '$tab[5]', empr_ville = '$tab[6]', ";
					//Vrifier dans la table empr_categ si id_categ_empr 1 = lves    Vrifier dans la table empr_codestat si idcode 2 = cole    Sinon, changer les valeurs
                    $req_update .= "empr_tel1 = '$tab[7]', empr_year = '$tab[8]', empr_categ = '1', empr_codestat = '2', empr_modif = '$date_auj', empr_sexe = '$sexe', ";
                    $req_update .= "empr_login = '$login', empr_password= '$tab[8]', ";
                    $req_update .= "empr_date_adhesion = '$date_auj', empr_date_expiration = '$date_an_proch' ";
                    $req_update .= "WHERE empr_cb = '$tab[0]'";
                    $update = pmb_mysql_query($req_update);

                    if (!$update) {

                        print("<b>Echec de la modification de l'lve suivant (Erreur : ".pmb_mysql_error().") : </b><br />");
                        for ($i=0;$i<3;$i++) {
                            print($eleve_abrege[$i]." : ".$tab[$i].", ");
                        }
                        print("<br />");

                    } else {

                        //Chiffrement du mot de passe
                        //On verifie que le mot de passe lecteur correspond aux regles de saisie definies
                        //Si non, encodage dans l'ancien format
                        $old_hash = false;
                        $check_password_rules = emprunteur::check_password_rules((int) $id_empr, $tab[8], [], $lang);
                        if( !$check_password_rules['result'] ) {
                            $old_hash = true;
                        }
                        emprunteur::update_digest($login,$tab[8]);
                        emprunteur::hash_password($login,$tab[8], $old_hash);

                        $cpt_maj ++;
                    }
                    import_empr::gestion_groupe($tab[9], $tab[0]);
                    break;
                case 2:
                    break;
                default:
                    print("<b>Echec pour l'lve suivant (Erreur : ".pmb_mysql_error().") : </b><br />");
                    for ($i=0;$i<3;$i++) {
                        print($eleve_abrege[$i]." : ".$tab[$i].", ");
                    }
                    print("<br />");
                    break;
            }
        }

        //Affichage des insert et update
        print("<br />_____________________<br />");
        if ($cpt_insert) print($cpt_insert." Elves crs. <br />");
        if ($cpt_maj) print($cpt_maj." Elves modifis. <br />");
        fclose($fichier);
    }

}

function import_profs($separateur, $type_import){

    //La structure du fichier texte doit tre la suivante :
    //Numro identifiant/Nom/Prnom/Rue/Complment de rue/Code postal/Commune/Tlphone/Date de naissance/Classe/Sexe

    global $lang;
    $cpt_insert = 0;
    $cpt_maj = 0;

    $prof_abrege = array("Numro identifiant","Nom","Prnom");
    $date_auj = date("Y-m-d", time());
    $date_an_proch = date("Y-m-d", time()+3600*24*30.42*12);

    //Upload du fichier
    if (!($_FILES['import_lec']['tmp_name'])) {
        print "Cliquez sur Pr&eacute;c&eacute;dent et choisissez un fichier";
    } elseif (!(move_uploaded_file($_FILES['import_lec']['tmp_name'], "./temp/".basename($_FILES['import_lec']['tmp_name'])))) {
        print "Le fichier n'a pas pu tre tlcharg. Voici plus d'informations :<br />";
        print_r($_FILES)."<p>";
    }
    $fichier = @fopen( "./temp/".basename($_FILES['import_lec']['tmp_name']), "r" );

    if ($fichier) {

        if ($type_import == 'maj_complete') {
            //Vide la table empr_groupe
            pmb_mysql_query("DELETE FROM empr_groupe");
            //Supprime les profs qui n'ont pas de prts en cours
            $req_select_verif_pret = "SELECT id_empr FROM empr left join pret on id_empr=pret_idempr WHERE pret_idempr is null and empr_cb NOT LIKE 'E%'";
            $select_verif_pret = pmb_mysql_query($req_select_verif_pret);
            while (($verif_pret = pmb_mysql_fetch_array($select_verif_pret))) {
            	//pour tous les emprunteurs qui n'ont pas de pret en cours
                emprunteur::del_empr($verif_pret["id_empr"]);
            }
        }

        while (!feof($fichier)) {
            $buffer = fgets($fichier, 4096);
            $buffer = import_empr::get_encoded_buffer($buffer);
            $buffer = pmb_mysql_escape_string($buffer);
            $tab = explode($separateur, $buffer);

            //Gestion du sexe
            switch ($tab[10][0]) {
                case 'M':
                    $sexe = 1;
                    break;
                case 'F':
                    $sexe = 2;
                    break;
                default:
                    $sexe = 0;
                    break;
            }

            // Traitement du prof
            $id_empr = 0;
            $select = pmb_mysql_query("SELECT id_empr FROM empr WHERE empr_cb = '".$tab[0]."'");
            $nb_enreg = pmb_mysql_num_rows($select);
            //Test si un numro id est fourni
            if (!$tab[0] || $tab[0] == "") {
                print("<b> Prof non pris en compte car \"Numro identifiant\" non renseign : </b><br />");
                for ($i=0;$i<3;$i++) {
                    print($prof_abrege[$i]." : ".$tab[$i].", ");
                }
                print("<br />");
                $nb_enreg = 2;
            }
            if($nb_enreg == 1) {
                $row = pmb_mysql_fetch_assoc($select);
                $id_empr = $row['id_empr'];
            }

            $login = import_empr::cre_login($tab[1],$tab[2]);

            switch ($nb_enreg) {

                case 0:
                	//Ce prof n'est pas enregistre
                    $req_insert = "INSERT INTO empr(empr_cb, empr_nom, empr_prenom, empr_adr1, empr_adr2, empr_cp, empr_ville, ";
                    $req_insert .= "empr_tel1, empr_year, empr_categ, empr_codestat, empr_creation, empr_sexe,  ";
                    $req_insert .= "empr_login, empr_password, empr_date_adhesion, empr_date_expiration) ";
                    $req_insert .= "VALUES ('$tab[0]','$tab[1]','$tab[2]','$tab[3]', '$tab[4]', '$tab[5]', ";
					//Verifier dans la table empr_categ si id_categ_empr 2 = profs    Verifier dans la table empr_codestat si idcode 2 = ecole    Sinon, changer les valeurs
                    $req_insert .= "'$tab[6]', '$tab[7]', '$tab[8]', 2, 2, '$date_auj', '$sexe', ";
                    $req_insert .= "'$login', '$tab[8]', '$date_auj', '$date_an_proch')";
                    $insert = pmb_mysql_query($req_insert);

                    if (!$insert) {

                        print("<b>Echec de la cration du prof suivant (Erreur : ".pmb_mysql_error().") : </b><br />");
                        for ($i=0;$i<3;$i++) {
                            print($prof_abrege[$i]." : ".$tab[$i].", ");
                        }
                        print("<br />");

                    } else {

                        $id_empr = pmb_mysql_insert_id();

                        //Chiffrement du mot de passe
                        //On verifie que le mot de passe lecteur correspond aux regles de saisie definies
                        //Si non, encodage dans l'ancien format
                        $old_hash = false;
                        $check_password_rules = emprunteur::check_password_rules((int) $id_empr, $tab[8], [], $lang);
                        if( !$check_password_rules['result'] ) {
                            $old_hash = true;
                        }
                    	emprunteur::update_digest($login,$tab[8]);
                    	emprunteur::hash_password($login,$tab[8], $old_hash);
                        $cpt_insert ++;
                    }
                    import_empr::gestion_groupe($tab[9], $tab[0]);
                    break;

                case 1:
                	//Ce prof est dja enregistr
                    $req_update = "UPDATE empr SET empr_nom = '$tab[1]', empr_prenom = '$tab[2]', empr_adr1 = '$tab[3]', ";
                    $req_update .= "empr_adr2 = '$tab[4]', empr_cp = '$tab[5]', empr_ville = '$tab[6]', ";
	//Vrifier dans la table empr_categ si id_categ_empr 2 = profs    Vrifier dans la table empr_codestat si idcode 2 = cole    Sinon, changer les valeurs
                    $req_update .= "empr_tel1 = '$tab[7]', empr_year = '$tab[8]', empr_categ = '2', empr_codestat = '2', empr_modif = '$date_auj', empr_sexe = '$sexe', ";
                    $req_update .= "empr_login = '$login', empr_password= '$tab[8]', ";
                    $req_update .= "empr_date_adhesion = '$date_auj', empr_date_expiration = '$date_an_proch' ";
                    $req_update .= "WHERE empr_cb = '$tab[0]'";
                    $update = pmb_mysql_query($req_update);

                    if (!$update) {

                        print("<b>Echec de la modification du prof suivant (Erreur : ".pmb_mysql_error().") : </b><br />");
                        for ($i=0;$i<3;$i++) {
                            print($prof_abrege[$i]." : ".$tab[$i].", ");
                        }
                        print("<br />");

                    } else {

                        //Chiffrement du mot de passe
                        //On verifie que le mot de passe lecteur correspond aux regles de saisie definies
                        //Si non, encodage dans l'ancien format
                        $old_hash = false;
                        $check_password_rules = emprunteur::check_password_rules((int) $id_empr, $tab[8], [], $lang);
                        if( !$check_password_rules['result'] ) {
                            $old_hash = true;
                        }
                        emprunteur::update_digest($login,$tab[8]);
                        emprunteur::hash_password($login,$tab[8], $old_hash);

                        $cpt_maj ++;
                    }
                    import_empr::gestion_groupe($tab[9], $tab[0]);
                    break;
                case 2:
                    break;
                default:
                    print("<b>Echec pour le prof suivant (Erreur : ".pmb_mysql_error().") : </b><br />");
                    for ($i=0;$i<3;$i++) {
                        print($prof_abrege[$i]." : ".$tab[$i].", ");
                    }
                    print("<br />");
                    break;
            }
        }

        //Affichage des insert et update
        print("<br />_____________________<br />");
        if ($cpt_insert) print($cpt_insert." Prof crs. <br />");
        if ($cpt_maj) print($cpt_maj." Profs modifis. <br />");
        fclose($fichier);
    }

}




switch($action) {
    case 1:
        if ($imp_elv){
            import_eleves($Sep_Champs, $type_import);
        }
        elseif ($imp_prof) {
            import_profs($Sep_Champs, $type_import);
        }
        else {
            show_import_choix_fichier();
        }
        break;
    case 2:
        break;
    default:
        show_import_choix_fichier();
        break;
}
