<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: lastfm.class.php,v 1.15.4.1.2.2.2.1 2025/07/18 07:16:35 dbellamy Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

global $class_path;

require_once $class_path."/connecteurs.class.php" ;
require_once $class_path."/curl.class.php" ;

class lastfm extends connector {

	//proprits internes
	public $api;
	public $enrichpage;	//page d'enrichissement pour enrichissement paginable

    /**
     *
     * {@inheritDoc}
     * @see connector::get_id()
     */
    public function get_id()
    {
    	return "lastfm";
    }

    public function source_get_property_form($source_id) {
        global $charset, $api_key, $pmb_url_base, $token, $secret_key, $token_saved;

    	$params=$this->get_source_params($source_id);
		if ($params["PARAMETERS"]) {
			//Affichage du formulaire avec $params["PARAMETERS"]
			$vars=unserialize($params["PARAMETERS"]);
			foreach ($vars as $key=>$val) {
				global ${$key};
				${$key}=$val;
			}
		}
		if($source_id!=0){
			$url = $pmb_url_base."admin.php?categ=connecteurs&sub=in&act=add_source&id=15&source_id=".$source_id;
		}else{
		    $url = htmlentities($this->msg['lastfm_no_source'], ENT_QUOTES, $charset);
		}

		$form="
		<div class='row'>&nbsp;</div>
		<div class='row'>
			<div class='colonne3'>
				<label for='api_key'>".htmlentities($this->msg["lastfm_api_key"], ENT_QUOTES, $charset)."</label>
			</div>
			<div class='colonne_suite'>
				<input type='text' class='saisie-50em' name='api_key' value='".$api_key."'/>
			</div>
		</div>
		<div class='row'>
			<div class='colonne3'>
				<label for='secret_key'>".htmlentities($this->msg["lastfm_secret_key"], ENT_QUOTES, $charset)."</label>
			</div>
			<div class='colonne_suite'>
				<input type='text' class='saisie-50em' name='secret_key' value='".$secret_key."'/>
			</div>
		</div>
		<div class='row'>&nbsp;</div>
		<div class='row'>
			<div class='colonne3'>
				<label for='callback_url'>".htmlentities($this->msg["lastfm_callback_url"], ENT_QUOTES, $charset)."</label>
			</div>
			<div class='colonne_suite'>
				<span>".$url."</span>
			</div>
		</div>
		<div class='row'>
			<div class='colonne3'>
				<label for='token'>".htmlentities($this->msg["lastfm_token"], ENT_QUOTES, $charset)."</label>
			</div>
			<div class='colonne_suite'>";
		if($token != ""){
			$form.="
				<span>".htmlentities($this->msg['lastfm_ws_allow_in_progress'], ENT_QUOTES, $charset)."</span>
				<input type='hidden' name='token_saved' value='".$token."'/>";
		}else if($token_saved!=""){
			$form.="
				<span>".htmlentities($this->msg['lastfm_ws_allowed'], ENT_QUOTES, $charset)."</span>
				<input type='hidden' name='token_saved' value='".$token_saved."'/>";
		}else if($api_key != ""){
			$form.="
				<a href='http://www.last.fm/api/auth/?api_key=".$api_key."'>".htmlentities($this->msg['lastfm_link_allow_ws'], ENT_QUOTES, $charset)."</a>";
		}else{
			$form.="
				<span>".htmlentities($this->msg['lastfm_allow_need_api_key'], ENT_QUOTES, $charset)."</span>";
		}
		$form.="
			</div>
		</div>
		<div class='row'>&nbsp;</div>

		<div class='row'>&nbsp;</div>
		";
		return $form;
    }

    public function make_serialized_source_properties($source_id) {
    	global $api_key,$secret_key,$token_saved;
    	$t=array();
  		$t["api_key"]=$api_key;
  		$t["secret_key"]=$secret_key;
  		$t["token_saved"]=$token_saved;
    	$this->sources[$source_id]["PARAMETERS"]=serialize($t);
	}

	/**
	 *
	 * {@inheritDoc}
	 * @see connector::enrichment_is_allow()
	 */
	public function enrichment_is_allow()
	{
	    return connector::ENRICHMENT_YES;
	}

	public function getTypeOfEnrichment($source_id){
		$type['type'] = array(
			"bio",
			array(
				"code" => "similar_artists",
				"label" => "Artistes Similaires"
			),
			array(
				"code" => "pictures",
				"label" => "Photos"
			)
		);
		$type['source_id'] = $source_id;
		return $type;
	}

}
