<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: factures.inc.php,v 1.48.8.1 2026/02/13 11:32:02 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) die("no access");

global $class_path, $include_path, $id_bibli, $id, $id_fac;

if(!isset($id)) {
	$id = 0; 
}
$id = intval($id);

// gestion des factures
require_once("$class_path/entites.class.php");
require_once("$class_path/actes.class.php");
require_once("$class_path/liens_actes.class.php");
require_once("$include_path/templates/actes.tpl.php");
require_once("$include_path/templates/factures.tpl.php");
require_once($class_path.'/accounting/accounting_invoices_controller.class.php');

//Affiche la liste des factures pour un etablissement
function show_list_fac($id_bibli, $id_exercice = 0) {
	global $accounting_invoices_ui_user_input;
	global $accounting_invoices_ui_status;
	
	$filters = array();
	$filters['user_input'] = stripslashes($accounting_invoices_ui_user_input ?? "");
	$filters['status'] = $accounting_invoices_ui_status;
	
	$list_accounting_invoices_ui = new list_accounting_invoices_ui($filters);
	print $list_accounting_invoices_ui->get_display_list();		
}

//Affiche le formulaire de cration de facture depuis une commande
function show_from_cde($id_bibli, $id_cde) {
    $accounting_invoice = new accounting_invoice();
    $accounting_invoice->num_entite = $id_bibli;
    print $accounting_invoice->get_form($id_bibli, $id_cde);
}

//Affiche le formulaire de modification de facture
function show_form_fac($id_bibli, $id_fac) {
    $accounting_invoice = new accounting_invoice($id_fac);
    $accounting_invoice->num_entite = $id_bibli;
    print $accounting_invoice->get_form($id_bibli);
}

//Supprime la facture
function sup_fac($id_fac, $id_cde) {
	$cde = new actes($id_cde);
	$cde->statut = ($cde->statut & (~STA_ACT_FAC)); //Statut commande = factur->non factur
	$cde->statut = ($cde->statut & (~STA_ACT_PAY)); //Statut commande = pay->non pay
	$cde->update_statut();

	actes::delete($id_fac);
	liens_actes::delete($id_fac);
}

accounting_invoices_controller::set_id_bibli($id_bibli);
accounting_invoices_controller::set_id_acte($id_fac);
accounting_invoices_controller::proceed($id);
