<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SEOSubpageType.php,v 1.3.2.2 2026/01/09 15:16:01 rtigero Exp $

namespace Pmb\SEO\Models;

use Pmb\Common\Helper\Helper;
use Pmb\Common\Models\Model;
use Pmb\Common\Helper\Portal;
use Pmb\SEO\Orm\SEOSubpageTypeOrm;

class SEOSubpageType extends Model
{
    protected $ormName = "Pmb\SEO\Orm\SEOSubpageTypeOrm";

    public const DEFAULT_INDEXABLE = false;
    public const DEFAULT_FOLLOWABLE = false;

    public $idSubpageType = 0;
    public $type = 0;
    public $indexable = false;
    public $followable = false;
    public $numPageType = 0;

    public $customized = false;

    /*
    * Retourne les donnees necessaires pour la vue
    * @return array
    */
    public static function getData() {
        $portal = new Portal();
        $subPages = $portal::SUB_PAGES;

        // Recuperer les donnees des types de page pour heriter des valeurs indexable/followable
        $pageTypesData = SEOPageType::getData();
        $pageTypes = $pageTypesData['pageTypes'];

        $data = [
            'pageSubTypes' => [],
            'pageSubTypesLabel' => []
        ];

        // Indexer les sous-types existants en BDD par leur type
        $SEOSubpageTypesDb = [];
        foreach(SEOSubpageTypeOrm::findAll() as $orm) {
            $SEOSubpageTypesDb[$orm->type] = $orm;
        }

        foreach($subPages as $subType) {
            // Si le sous-type existe en BDD, on utilise ses valeurs
            if(isset($SEOSubpageTypesDb[$subType])) {
                $SEOSubpageType = new SEOSubpageType($SEOSubpageTypesDb[$subType]->{SEOSubpageTypeOrm::$idTableName});
                $SEOSubpageType->customized = true;
            } else {
                // Sinon on utilise les valeurs du type de page parent
                $pageType = $portal::getTypeFromSubType($subType);

                $parentIndexable = isset($pageTypes[$pageType]) ? $pageTypes[$pageType]['indexable'] : self::DEFAULT_INDEXABLE;
                $parentFollowable = isset($pageTypes[$pageType]) ? $pageTypes[$pageType]['followable'] : self::DEFAULT_FOLLOWABLE;

                $SEOSubpageType = new SEOSubpageType();
                $SEOSubpageType->type = $subType;
                $SEOSubpageType->indexable = $parentIndexable;
                $SEOSubpageType->followable = $parentFollowable;
            }

            $data['pageSubTypes'][$subType] = Helper::toArray($SEOSubpageType);
            $data['pageSubTypesLabel'][$subType] = $portal::getLabel($subType);
        }

        return $data;
    }

    /*
    * Set les donnees a partir d'un objet
    * @param object $data
    * @return void
    */
    public function setFromForm(object $data)
    {
        $this->type = $data->type;
        $this->indexable = intval($data->indexable);
        $this->followable = intval($data->followable);
    }

    /*
    * Cree un nouvel objet en base
    * @return void
    */
    public function create()
    {
        $orm = new $this->ormName($this->id);
        $orm->type = $this->type;
        $orm->indexable = $this->indexable;
        $orm->followable = $this->followable;
        $orm->num_page_type = $this->numPageType;
        $orm->save();

        $this->id = $orm->{$this->ormName::$idTableName};
    }

    /*
    * Supprime tous les objets en base
    * @return void
    */
    public static function deleteAll()
    {
        $SEOSubpageTypes = SEOSubpageTypeOrm::findAll();

        foreach ($SEOSubpageTypes as $SEOSubpageType) {
            $SEOSubpageType->delete();
        }
    }
}