<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SEOSitemapEntrySection.php,v 1.7.2.2 2026/01/09 15:16:01 rtigero Exp $

namespace Pmb\SEO\Models\Entries;

use cms_editorial_data;
use cms_section;
use Pmb\SEO\Models\SEOSitemapEntry;

class SEOSitemapEntrySection extends SEOSitemapEntry
{
    public const TYPE = "section";

    public $type = self::TYPE;

    protected function initDefaultSettings(): void
    {
        $this->settings = [
            "numSection" => 0,
            "page" => "",
            "variable" => "",
            "depth" => 0,
            "name" => "",
            "parentSection" => 0
        ];
    }

    public static function getData(): array
    {
        global $msg;
        $section = new \cms_section();
        $cmsPages = array(
            array(
                "value" => "0",
                "label" => $msg["authority_marc_list_empty_filter"]
            )
        );
        $query = 'select id_page, page_name from cms_pages';
        $result = pmb_mysql_query($query);
        while ($row = pmb_mysql_fetch_assoc($result)) {
            $cmsPages[] = array(
                "value" => $row["id_page"],
                "label" => $row["page_name"]
            );
        }
        $cmsVars = array(
            array(
                "value" => "",
                "label" => $msg["authority_marc_list_empty_filter"],
                "numPage" => ""
            )
        );
        //Oui on a un id mais on doit enregistrer le label, c'est fait comme ca dans cms_editorial_types
        $query = 'select var_name, var_num_page from cms_vars';
        $result = pmb_mysql_query($query);
        while ($row = pmb_mysql_fetch_assoc($result)) {
            $cmsVars[] = array(
                "value" => $row["var_name"],
                "label" => $row["var_name"],
                "numPage" => $row["var_num_page"]
            );
        }
        $res = array(
            "sectionsOptions" => $section->get_parent_selector(),
            "pagesOptions" => $cmsPages,
            "varsOptions" => $cmsVars
        );
        return $res;
    }

    /**
     * Rcupre les sous-rubriques et en fait des entries enfants pour l'entry
     */
    protected function initCmsChildren(): void
    {
        $parentSection = new cms_section($this->settings['numSection']);
        $childs = $parentSection->get_children(false);
        $order = 0;
        foreach ($childs as $child) {
            $this->addCmsChild($child, $order);
            $order++;
        }
    }

    /**
     * Ajoute un enfant dans l'entry  partir de donnes d'une rubrique
     *
     * @param cms_editorial_data $child
     * @param int $order
     */
    protected function addCmsChild(cms_editorial_data $child, int $order = 0): void
    {
        $childEntry = new self();
        $childEntry->setPropertiesFromCMS($child);
        $childEntry->settings['parentSection'] = $this->settings['numSection'];
        $childEntry->numParent = $this->id;
        $childEntry->sitemapOrder = $order;

        //A l'init, on reprend le paramtrage du parent
        $childEntry->inSitemap = $this->inSitemap;
        $childEntry->priority = $this->priority;
        $childEntry->frequencyUpdate = $this->frequencyUpdate;

        $childEntry->create();
        $this->childs[] = $childEntry;
    }

    public function initChildren(): void
    {
        parent::initChildren();
        if ($this->id && empty($this->childs)) {
            $this->initCmsChildren();
        }
    }

    public function check($data): array
    {
        global $msg;
        if (0 == $data->id) {
            //Vrification que la rubrique n'est pas dj dans le sitemap en ajout
            $checkSectionAlreadyExists = $this->ormName::find("JSON_EXTRACT(settings, '$.numSection')", intval($data->settings->numSection));
            if (!empty($checkSectionAlreadyExists)) {
                return ['error' => true, 'errorMessage' => $msg["seo_section_already_exists"]];
            }
        }
        return ['error' => false];
    }

    public function getEntryUrl(): string
    {
        global $opac_url_base;
        $entryURL = "";
        if ($this->settings['page']) {
            $entryURL = $opac_url_base . "index.php?lvl=cmspage&pageid=" . $this->settings['page'];
            if ($this->settings['variable']) {
                $entryURL .= "&" . $this->settings['variable'] . "=" . $this->settings['numSection'];
            }
        }
        return $entryURL;
    }

    public function resetEntryHierarchy(int $depth = 0, int $maxDepth = 0): void
    {
        if (0 == $depth) {
            $maxDepth = intval($this->settings['depth'] ?? 0);
        }

        if ($depth < $maxDepth) {
            //On rcupre les enfants en base
            $this->fetchChildren();
            //On rcupre la hirarchie des rubriques enfants pour la rubrique actuelle
            $parentSection = new cms_section($this->settings['numSection']);
            $cmsChilds = $parentSection->get_children(false);
            for ($i = 0; $i < count($this->childs); $i++) {
                $child = $this->childs[$i];
                //On essaie de rcuprer la rubrique correspondante
                $currentChild = null;
                foreach ($cmsChilds as $cmsChild) {
                    if ($cmsChild->get_id() == $child->settings['numSection']) {
                        $currentChild = $cmsChild;
                        break;
                    }
                }

                if (is_null($currentChild)) {
                    //L'enfant n'existe plus, on le supprime en recalculant l'ordre des autres enfants
                    //Et on s'arrte l
                    $child->delete(true);
                    array_splice($this->childs, $i, 1);
                    $i--;
                    //MAJ de l'order pour les enfants suivants (il est fait en base mais pas dans ce tableau)
                    for ($j = $i; $j < count($this->childs); $j++) {
                        $this->childs[$j]->sitemapOrder--;
                    }
                    continue;
                }

                //La rubrique est toujours l, on met  jour les proprits CMS
                $child->setPropertiesFromCMS($currentChild);
                $child->update();

                //On lance le reset pour la hirarchie de l'enfant
                $child->resetEntryHierarchy($depth + 1, $maxDepth);
            }

            //Maintenant on regarde si de nouvelles rubriques ont t ajoutes
            foreach ($cmsChilds as $cmsChild) {
                $exists = false;
                foreach ($this->childs as $child) {
                    if ($child->settings['numSection'] == $cmsChild->get_id()) {
                        $exists = true;
                        break;
                    }
                }
                if (!$exists) {
                    // Nouvelle rubrique, on l'ajoute
                    $this->addCmsChild($cmsChild, count($this->childs));
                }
            }
        }
    }

    /**
     * Remplit les settings avec les donnes de la rubrique
     * @param cms_editorial_data $cmsData
     */
    protected function setPropertiesFromCMS(cms_editorial_data $cmsData): void
    {
        $cmsData->get_fields_type();
        $this->settings['numSection'] = $cmsData->get_id();
        $this->settings['name'] = $cmsData->get_title();
        $this->settings['page'] = $cmsData->get_num_page();
        $this->settings['variable'] = $cmsData->get_var_name();
    }

    public function getLastMod(): string
    {
        if (! isset($this->settings["numSection"])) {
            return parent::getLastMod();
        }

        $cmsSection = new cms_section($this->settings["numSection"]);
        $lastModificationDate = $cmsSection->last_update_date;
        $dt = new \DateTime($lastModificationDate);
        return $dt->format('Y-m-d');
    }
}
