<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: OcrRouterRest.php,v 1.1.2.1 2025/10/21 08:22:46 qvarin Exp $

namespace Pmb\REST;
use Pmb\Common\Helper\Helper;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class OcrRouterRest extends RouterRest
{
    /**
     *
     * @const string
     */
    protected const CONTROLLER = "\\Pmb\\Ocr\\Controller\\ApiController";

    /**
     *
     * @var bool
     */
    public const ALLOW_OPAC = false;

    /**
     *
     * {@inheritdoc}
     * @see \Pmb\REST\RouterRest::generateRoutes()
     */
    protected function generateRoutes()
    {
        $this->post('config/save');
    }

    /**
     *
     * @param RouteRest $route
     * @return mixed
     */
    protected function call(RouteRest $route)
    {
        global $data;

        $className = static::CONTROLLER;
        $data = \encoding_normalize::json_decode(stripslashes($data ?? "{}"));
        if (empty($data) || !is_object($data)) {
            $data = new \stdClass();
        }

        $callback = [
            new $className($data),
            $route->getMethod()
        ];
        if (is_callable($callback)) {
            return call_user_func_array($callback, $route->getArguments());
        }
    }
}
