<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: EmbeddingsRouterRest.php,v 1.1.2.1 2026/02/06 09:24:11 qvarin Exp $

namespace Pmb\REST;

class EmbeddingsRouterRest extends RouterRest
{
    protected const CONTROLLER = "\\Pmb\\AI\\Controller\\EmbeddingsController";

    protected function generateRoutes()
    {
        $this->post('save/form');
    }

    /**
     *
     * @param RouteRest $route
     * @return mixed
     */
    protected function call(RouteRest $route)
    {
        global $data;

        try {
            $data = \encoding_normalize::json_decode(stripslashes($data ?? ''));
            if (empty($data) || !is_object($data)) {
                $data = new \stdClass();
            }
        } catch (\Exception $_) {
            $data = new \stdClass();
        }

        $this->fetchRequirements();
        $className = static::CONTROLLER;
        $callback = [ new $className($data), $route->getMethod() ];

        if (is_callable($callback)) {
            return call_user_func_array($callback, $route->getArguments());
        }
    }
}