<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: DocnumsRouterRest.php,v 1.9.2.2 2025/06/12 09:13:54 rtigero Exp $

namespace Pmb\REST;

use Pmb\Common\Helper\Helper;

class DocnumsRouterRest extends RouterRest
{

	/**
	 *
	 * @const string
	 */
	protected const CONTROLLER = "\\Pmb\\Docnums\\Controller\\DocnumsController";

	/**
	 *
	 * {@inheritdoc}
	 * @see \Pmb\REST\RouterRest::generateRoutes()
	 */
	protected function generateRoutes()
	{
		//POST
		$this->post('{controller}/save', 'save');
		$this->post('{controller}/delete', 'delete');
		$this->post('{controller}/import/{numCollection}', 'import')->with('numCollection', static::LIMIT_NUMBER);
		$this->post('{controller}/associate/{type}/{numNotice}', 'associate')->with('numNotice', static::LIMIT_NUMBER);

		//GET
		$this->get('{controller}/form/{numDocnum}/{numCollection}', 'getForm')->with('numDocnum', static::LIMIT_NUMBER);
		$this->get('{controller}/explnum/{idExplnum}', 'getExplnum')->with('idExplnum', static::LIMIT_NUMBER);
		$this->get('{controller}/delete/{idExplnum}', 'delete')->with('idExplnum', static::LIMIT_NUMBER);
		$this->get('{controller}/explnums/{numCollection}/{page}', 'getPaginateExplnums')->with('numCollection', static::LIMIT_NUMBER);

		$this->get('{controller}/list/{idNotice}', 'fetchDocnums')->with('idNotice', static::LIMIT_NUMBER);
		$this->get('{controller}/profiles/{numLicence}', 'getExplnumLicenceProfiles')->with('numLicence', static::LIMIT_NUMBER);
	}

	/**
	 *
	 * @param RouteRest $route
	 * @return mixed
	 */
	protected function call(RouteRest $route)
	{
		global $data;

		$data = \encoding_normalize::json_decode(stripslashes($data ?? ''));
		if (empty($data) || !is_object($data)) {
			$data = new \stdClass();
		}

		$args = $route->getArguments();
		$className = $this->foundController($route);
		if (false === $className) {
			$className = static::CONTROLLER;
		} elseif (count($args) > 0) {
			array_splice($args, 0, 1);
		}

		$callback = [
			new $className($data),
			$route->getMethod(),
		];
		if (is_callable($callback)) {
			return call_user_func_array($callback, $args);
		}
	}

	private function foundController(RouteRest $route)
	{
		$args = $route->getArguments();
		$controller = $args[0] ?? "";

		$namespace = "Pmb\\Docnums\\Controller\\" . Helper::pascalize("{$controller}_controller");
		if (class_exists($namespace)) {
			return $namespace;
		}
		return false;
	}
}
