<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: StepImport.php,v 1.5.2.2 2025/06/27 14:21:06 rtigero Exp $

namespace Pmb\ImportExport\Models\Steps\StepImport;

use Pmb\ImportExport\Models\Profiles\ProfileImport;
use Pmb\ImportExport\Models\Steps\Step;

class StepImport extends Step
{
    public function execute($sourceData = array())
    {
        $profile = new ProfileImport($this->stepSettings->profile);
        $profile->setStore($this->source->getRDFTransformer()->getStore());
        $profile->applyProfile();
    }

    public static function getImportProfiles()
    {
        $result = array();
        $profileImport = new ProfileImport();
        $list = $profileImport->getList();
        foreach ($list as $profile) {
            $result[] = array(
                'value' => $profile->id,
                'label' => $profile->profileName
            );
        }
        return $result;
    }
}
