<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: StepExportFile.php,v 1.3.2.2 2025/06/27 14:20:56 rtigero Exp $

namespace Pmb\ImportExport\Models\Steps\StepExport\StepExportFile;

use Pmb\Common\Helper\GlobalContext;
use Pmb\ImportExport\Models\Ontology\OntologyPMB;
use Pmb\ImportExport\Models\Ontology\Store;
use Pmb\ImportExport\Models\Steps\StepExport\StepExport;
use Pmb\ImportExport\Models\Steps\StepExport\StepExportFile\Builders\BuilderInterface;
use Pmb\ImportExport\Models\Steps\StepExport\StepExportFile\Builders\RDFBuilder;
use Pmb\ImportExport\Models\Steps\StepExport\StepExportFile\Builders\XMLBuilder;

class StepExportFile extends StepExport
{

    protected BuilderInterface $builder;
    protected $file = null;
    protected Store $store;

    public function execute($sourceData = array())
    {
        $this->store = $this->source->getRDFTransformer()->getStore();
        $this->file = fopen(GlobalContext::get("base_path") . "/temp/" . $this->baseParameters->filename, 'w+');
        $this->getBuilder();
        $this->builder->build();
        fclose($this->file);
    }

    private function getBuilder()
    {
        switch ($this->source->getOutFormat()) {
            case 'xml':
                $this->builder = new XMLBuilder($this->file, $this->store->getOntology(), $this->store->getGraphData(), $this->baseParameters);
                break;
            case 'rdf':
            case 'pmbrdf':
                $this->builder = new RDFBuilder($this->file, $this->store);
                break;
            case 'json':
                break;
            case 'csv':
                break;
            case 'txt':
                break;
        }
    }
}
