<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: Step.php,v 1.13.2.2 2025/06/27 14:21:06 rtigero Exp $

namespace Pmb\ImportExport\Models\Steps;

use Pmb\Common\Helper\Helper;
use Pmb\Common\Helper\ParserMessage;
use Pmb\ImportExport\Models\ImportExportParserDirectory;
use Pmb\ImportExport\Models\ImportExportRoot;
use Pmb\ImportExport\Models\Sources\Source;
use stdClass;

class Step extends ImportExportRoot implements StepInterface
{
    use ParserMessage;

    protected static $stepsTypes = null;

    public $id = 0;
    public $stepName = '';
    public $stepComment = '';
    public $stepType = '';
    public $stepSettings = null;
    public $stepOrder = 0;
    public $numScenario = 0;

    /**
     * @var Source
     */
    protected Source $source;
    protected $baseParameters = null;

    protected $ormName = "Pmb\ImportExport\Orm\StepOrm";
    protected $caller = null;

    /**
     * Constructeur
     *
     * @param integer $id : id step
     * @param object $caller : object appellant
     * @param boolean $runMode : mode execution
     */
    public function __construct(int $id = 0, $caller = null, bool $runMode = false)
    {
        parent::__construct($id);
        $this->caller = $caller;

        if ($id && $runMode) {
            $this->instantiateSource();
        }
    }

    /**
     * Instanciation source
     *
     * @return void
     */
    protected function instantiateSource()
    {
        $sourceId = $this->stepSettings->source ?? 0;
        if ($sourceId && !is_null($this->caller) && method_exists($this->caller, 'getSourceById')) {
            $this->source = $this->caller->getSourceById($sourceId);
        }
    }

    public function setFromForm(object $data)
    {
        $this->stepName = $data->stepName ?? '';
        $this->stepComment = $data->stepComment ?? '';
        $this->stepType = $data->stepType ?? '';
        $this->stepOrder = $data->stepOrder ?? 0;
        $this->stepSettings = $data->stepSettings ?? null;
    }

    public function save()
    {
        $orm = new $this->ormName($this->id);

        $orm->step_name = $this->stepName;
        $orm->step_comment = $this->stepComment;
        $orm->step_type = $this->stepType;
        $orm->step_settings = \encoding_normalize::json_encode($this->stepSettings);
        $orm->step_order = $this->stepOrder;
        $orm->num_scenario = $this->numScenario;
        $orm->save();
        if (!$this->id) {
            $this->id = $orm->id_step;
        }
        return $orm;
    }

    public function remove()
    {
        $orm = new $this->ormName($this->id);
        $orm->delete();
    }

    public function duplicate()
    {
        $newStep = clone $this;

        $newStep->id = 0;
        $newStep->stepName .= " - copy";
        $newStep->save();

        return $newStep;
    }

    public function execute($sourcesData = array()) {}

    public function setSource(Source $source)
    {
        $this->source = $source;
    }

    public function setBaseParameters($parameters)
    {
        $this->baseParameters = $parameters;
    }

    /**
     * Retourne la liste des types d'etapes
     *
     * @return []
     */
    public static function getStepsTypes()
    {
        if (!is_null(static::$stepsTypes)) {
            return static::$stepsTypes;
        }
        static::$stepsTypes = [];
        $parser = ImportExportParserDirectory::getInstance();
        $manifests = $parser->getManifests("Pmb/ImportExport/Models/Steps");


        foreach ($manifests as $manifest) {
            if (!empty($manifest->type)) {
                $messages = $manifest->namespace::getMessages();
                static::$stepsTypes[] = array(
                    'type' => $manifest->type,
                    'namespace' => $manifest->namespace,
                    'settings' => $manifest->settings,
                    'msg' =>  $messages,
                );
            }
        }
        return static::$stepsTypes;
    }

    /**
     * Fournit les parametres de contexte  la source
     * @param array $sourcesData
     */
    protected function setSourceContextParameters($sourcesData)
    {
        foreach ($sourcesData as $sourceData) {
            if ($sourceData->id == $this->source->id && isset($sourceData->contextParameters)) {
                $this->source->setContextParameters(Helper::toArray($sourceData->contextParameters));
                return;
            }
        }
    }

    public function import(stdClass $data, int $numScenario, array $sourcesIds)
    {
        $this->stepName = $data->stepName ?? '';
        $this->stepComment = $data->stepComment ?? '';
        $this->stepType = $data->stepType ?? '';
        $this->stepSettings = $data->stepSettings ?? null;
        $this->stepOrder = $data->stepOrder ?? 0;
        $this->numScenario = $numScenario;

        //On met l'id de la source importe
        if (isset($this->stepSettings->source) && array_key_exists($this->stepSettings->source, $sourcesIds)) {
            $this->stepSettings->source = $sourcesIds[$this->stepSettings->source];
        }

        $this->save();
    }
}
