<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: FileSystemLocal.php,v 1.11.2.2 2025/06/27 14:20:55 rtigero Exp $
namespace Pmb\ImportExport\Models\Sources\SourceFile\FileSystem\FileSystemLocal;

use Pmb\Common\Helper\GlobalContext;
use Pmb\ImportExport\Models\Sources\SourceFile\FileSystem\FileSystem;

class FileSystemLocal extends FileSystem
{

    protected $filePath = "";

    protected function getFilePath()
    {
        if (empty($this->filePath) && isset($this->contextParameters["file"])) {

            $fileName = "importexport_file_" . intval(microtime(true)) . ".tmp";
            $tempFile = GlobalContext::get("base_path") . "/temp/" . $fileName;

            $binaryString = "";
            $fileContent = $this->contextParameters["file"];
            if(is_countable($fileContent)) {
                for($i = 0; $i < count($fileContent); $i++) {
                    $binaryString = $binaryString.pack("C*", $fileContent[$i]);
                }
            }
            file_put_contents($tempFile, $binaryString);
            $this->filePath = $tempFile;
        }
        return $this->filePath;
    }

    public function disconnect()
    {
        parent::disconnect();
        @unlink($this->filePath);
    }

    /**
     * Retourne la liste des encodages pour un selecteur
     *
     * @return array
     */
    public static function getEncodingsList()
    {
        $result = array();
        $encodings = mb_list_encodings();
        sort($encodings);
        foreach ($encodings as $encoding) {

            $result[] = [
                "value" => $encoding,
                "label" => $encoding
            ];
        }
        return $result;
    }
}
