<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: RDFTransformerJSON.php,v 1.1.2.2 2025/06/27 14:20:58 rtigero Exp $

namespace Pmb\ImportExport\Models\RDFTransformers\RDFTransformerJSON;

use encoding_normalize;
use Pmb\ImportExport\Models\RDFTransformers\RDFTransformer;

class RDFTransformerJSON extends RDFTransformer
{

    public const JSON_TYPE = 'json';

    protected $bnodesIndex = 1;

    protected $currentEntity = "";

    public function toTriples($entity)
    {
        $parsedEntity = encoding_normalize::json_decode($entity, true);
        $this->currentEntity = static::JSON_TYPE . '_' . $this->entityId;
        $this->addEntity($this->currentEntity, $this->currentEntity);
        $this->generateTriples($parsedEntity);
        $this->storeTriples();
    }

    protected function generateTriples($entity, $parent = null, $parentNode = null)
    {
        foreach ($entity as $k => $v) {
            $subject = $this->getPrefix() . static::JSON_TYPE . '_' . $this->entityId;
            $predicate = is_numeric($k) ? $parent . "_row_" . $k : $k;
            if (is_array($v)) {
                $bnode = '_:' . $this->entityId . '-' . $this->bnodesIndex;
                $this->bnodesIndex++;
                $this->triples[] = $subject . " " . $this->getPrefix() . $predicate . " " . $bnode;
                $this->addProperty($predicate, $predicate, array($this->getPrefix() . static::JSON_TYPE), array(), array("pmb:parent" => ! empty($parent) ? $this->getPrefix() . $parent : $this->getPrefix() . static::JSON_TYPE));
                $this->generateTriples($v, $predicate, $bnode);
            } else {
                if (! empty($parentNode)) {
                    $subject = $parentNode;
                }
                $object = $v;
                $this->triples[] = $subject . " " . $this->getPrefix() . $predicate . " \"" . $object . "\"";
                $this->addProperty($predicate, $predicate, array($this->getPrefix() . static::JSON_TYPE), array(static::LITERAL_TYPE), array("pmb:parent" => ! empty($parent) ? $this->getPrefix() . $parent : $this->getPrefix() . static::JSON_TYPE));
            }
        }
    }
}
