<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: RDFTransformerAgnostic.php,v 1.3.2.2 2025/06/27 14:20:59 rtigero Exp $

namespace Pmb\ImportExport\Models\RDFTransformers\RDFTransformerAgnostic;

use Pmb\Common\Helper\GlobalContext;
use Pmb\ImportExport\Models\RDFTransformers\RDFTransformer;

class RDFTransformerAgnostic extends RDFTransformer
{

    private $tempFileName = "";

    public function __construct($sourceId)
    {
        $this->tempFileName = GlobalContext::get("base_path") . "/temp/entityRdf.xml";
        parent::__construct($sourceId);
    }

    public function toTriples($entity)
    {
        file_put_contents($this->tempFileName, $entity);
        //Permet de ne pas surcharger la memoire sur de grosses synchros
        $this->store->reset_after_save();
        $this->store->query('LOAD <file:///' . realpath($this->tempFileName) . '> into <' . $this->store->getGraph() . '>');
    }
}
