<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: Explnum.php,v 1.12.2.3 2025/10/21 08:22:46 qvarin Exp $

namespace Pmb\Docnums\Models;

use DateTime;
use docs_location;
use event_explnum;
use events_handler;
use explnum_licence;
use lender;
use Pmb\Common\Library\CSRF\CollectionCSRF;
use Pmb\Digitalsignature\Models\DocnumCertifier;
use Pmb\Docnums\Orm\ExplnumCollectionsOrm;
use Pmb\Ocr\Models\OcrExplnumsModel;
use upload_folder;

class Explnum extends \explnum
{
    public $explnumCollections = null;
    public $collectionId = 0;

    public function __construct($id = 0)
    {
        $this->explnum_id = intval($id);
        $this->fetch_data();
    }

    public function fetch_data()
    {
        $this->explnumCollections = new ExplnumCollection($this->explnum_id);

        $this->explnum_nom = $this->explnumCollections->explnumCollectionsExplnumsNom;
        $this->explnum_mimetype = $this->explnumCollections->explnumCollectionsExplnumsMimetype;
        $this->explnum_url = $this->explnumCollections->explnumCollectionsExplnumsUrl;

        $this->explnum_repertoire = $this->explnumCollections->explnumCollectionsExplnumsRepertoire;
        $this->init_repertoire();

        $this->explnum_data = $this->explnumCollections->explnumCollectionsExplnumsData;
        $this->explnum_vignette = $this->explnumCollections->explnumCollectionsExplnumsVignette;
        $this->explnum_statut = $this->explnumCollections->explnumCollectionsExplnumsStatut;
        $this->explnum_index = '';
        $this->explnum_path = $this->explnumCollections->explnumCollectionsExplnumsPath;
        $this->explnum_nomfichier = $this->explnumCollections->explnumCollectionsExplnumsNomfichier;
        $this->explnum_extfichier = $this->explnumCollections->explnumCollectionsExplnumsExtfichier;
        $this->explnum_location = '';
        $this->explnum_docnum_statut = $this->explnumCollections->explnumCollectionsExplnumsDocnumStatut;
        $this->explnum_signature = $this->explnumCollections->explnumCollectionsExplnumsSignature;
        $this->lenders = [];

        $this->explnum_create_date = $this->explnumCollections->explnumCollectionsExplnumsCreateDate;
        $this->explnum_update_date = $this->explnumCollections->explnumCollectionsExplnumsUpdateDate;
        $this->explnum_file_size = $this->explnumCollections->explnumCollectionsExplnumsFileSize;
        $this->unzipped_files = array();
    }

    protected function init_repertoire()
    {
        $req = "SELECT repertoire_id, repertoire_nom, repertoire_path FROM upload_repertoire WHERE repertoire_id=" . $this->explnum_repertoire;
        $res = pmb_mysql_query($req);
        if (pmb_mysql_num_rows($res)) {
            $item = pmb_mysql_fetch_object($res);
            $this->explnum_rep_nom = $item->repertoire_nom;
            $this->explnum_rep_path = $item->repertoire_path;
            $this->explnum_repertoire = $item->repertoire_id;
        } else {
            $this->explnum_rep_nom = '';
            $this->explnum_rep_path = '';
            $this->explnum_repertoire = 0;
        }
    }

    public function mise_a_jour($f_notice, $f_bulletin, $f_nom, $f_url, $retour, $conservervignette, $f_statut_chk, $f_explnum_statut, $book_lender_id = array(), $forcage = 0, $f_url_vignette = '')
    {
        global $id_rep, $path, $explnum_collection, $msg;

        $explnum_collection = intval($explnum_collection);
        if (!ExplnumCollectionsOrm::exist($explnum_collection)) {
            error_message($msg['docnum_explnum_collection_not_exist'], $msg['docnum_explnum_collection_not_exist'], 1);
            return;
        }

        $collection = new Collection(intval($explnum_collection));
        $this->collectionId = $collection->idExplnumCollection;

        $id_rep = $collection->uploadFolderId;

        $uploadFolder = new \upload_folder($id_rep);
        $filepath = $uploadFolder->repertoire_nom ?? '';

        if ($filepath) {
            if ($uploadFolder->isHashing()) {
                $filepath .= "/";
            } else {
                $filepath .= ($this->explnum_path === '' ? "/" : $this->explnum_path);
            }
        }

        $path = $filepath;

        parent::mise_a_jour($f_notice, $f_bulletin, $f_nom, $f_url, $retour, $conservervignette, $f_statut_chk, $f_explnum_statut, $book_lender_id, $forcage, $f_url_vignette);
    }

    public function save()
    {
        global $pmb_digital_signature_activate, $sign_data_cert, $ck_sign, $is_sign, $pmb_diarization_docnum, $explnum_collection;

        if (empty($this->params["erreur"])) {
            // $update = false;

            $this->explnumCollections->explnumCollectionsExplnumsNom = $this->explnum_nom;
            $this->explnumCollections->explnumCollectionsExplnumsUrl = $this->explnum_url;
            $this->explnumCollections->explnumCollectionsExplnumsMimetype = $this->explnum_mimetype;
            $this->explnumCollections->explnumCollectionsExplnumsData = $this->explnum_data;
            $this->explnumCollections->explnumCollectionsExplnumsNomfichier = $this->explnum_nomfichier;
            $this->explnumCollections->explnumCollectionsExplnumsExtfichier = $this->explnum_extfichier;
            $this->explnumCollections->explnumCollectionsExplnumsVignette = $this->explnum_vignette;
            $this->explnumCollections->explnumCollectionsExplnumsStatut = $this->explnum_statut;
            $this->explnumCollections->explnumCollectionsExplnumsRepertoire = $this->explnum_repertoire;
            $this->explnumCollections->explnumCollectionsExplnumsPath = $this->explnum_path;
            $this->explnumCollections->explnumCollectionsExplnumsSignature = $this->gen_signature();
            $this->explnumCollections->explnumCollectionsExplnumsFileSize = $this->explnum_file_size;
            $this->explnumCollections->explnumCollectionsExplnumsNumCollection = intval($explnum_collection);

            $date = new DateTime();
            $date = $date->format('Y-m-d H:i:s');

            if (empty($this->explnum_id)) {
                $this->explnumCollections->explnumCollectionsExplnumsCreateDate = $date;
            }
            $this->explnumCollections->explnumCollectionsExplnumsUpdateDate = $date;

            $this->explnumCollections->save();

            // On rcupre les donnes de l'exemplaire
            $this->explnum_id = $this->explnumCollections->idExplnumCollectionsExplnums;
            $this->fetch_data();

            if (empty($this->infos_docnum['from_contrib']) || $this->infos_docnum['from_contrib'] !== true) {
                //$this->save_lenders();
                //$this->save_locations();

                //$this->get_p_perso();
                //$this->p_perso->rec_fields_perso($this->explnum_id);
            }

            // traitement des droits acces user_docnum
            // if ($gestion_acces_active == 1 && $gestion_acces_empr_docnum == 1) {
            //     $ac = new acces();
            //     $dom_3 = $ac->setDomain(3);
            //     if ($update) {
            //         $dom_3->storeUserRights(1, $this->explnum_id, $res_prf, $chk_rights, $prf_rad, $r_rad);
            //     } else {
            //         $dom_3->storeUserRights(0, $this->explnum_id, $res_prf, $chk_rights, $prf_rad, $r_rad);
            //     }
            // }

            // Segmentation du document
            if ($pmb_diarization_docnum) {
                $this->diarization_docnum();
            }

            // On vient des contributions, on a deja sauvegarder le regime de licence
            if (isset($this->infos_docnum["from_contrib"]) && $this->infos_docnum["from_contrib"]) {
                return true;
            }

            //\explnum_licence::save_explnum_licence_profiles($this->explnum_id);

            if ($pmb_digital_signature_activate && $ck_sign && !isset($is_sign) && $is_sign != $this->explnum_id) {
                $is_sign = $this->explnum_id;
                $docSign = new DocnumCertifier($this);
                $docSign->sign($sign_data_cert);
            }

            $this->params["retour"] = "./catalog.php?categ=docnum_collections";

            if ($this->collectionId) {
                $this->params["retour"] .= "&id=" . $this->collectionId;
            }

            return true;
        } else {
            return false;
        }
    }

    /*
     * Effacement de l'exemplaire numrique
     *
     * @param boolean $keepFile Conserver ou non le fichier dans le repertoire d'upload
     */
    public function delete($keepFile = false)
    {
        global $msg;

        // Suppression des fichiers de signature
        $docNumCertifier = new DocnumCertifier($this);
        $check = $docNumCertifier->checkSignExists();
        if ($check) {
            return print return_error_message($msg["540"], $msg["digital_signature_already_signed_docnum_del"], 1, "./catalog.php?categ=isbd&id=" . $this->explnum_notice);
        }

        // Suppression du fichier
        if (! $keepFile && $this->isEnUpload()) {
            $uploadFolder = new \upload_folder($this->explnum_repertoire);
            $path = str_replace("//", "/", $this->explnum_rep_path . $this->explnum_path . $this->explnum_nomfichier);
            $path = $uploadFolder->encoder_chaine($path);

            if (file_exists($path)) {
                unlink($path);
            }
        }

        // Suppression du ducument numrique
        $this->explnumCollections->delete();

        // audit::delete_audit(AUDIT_EXPLNUM, $this->explnum_id);

        // on oublie pas la localisation associ
        // $requete = "delete from explnum_location where num_explnum = " . $this->explnum_id;
        // pmb_mysql_query($requete);

        // Suppression des segments et locuteurs
        // $requete = "delete from explnum_speakers where explnum_speaker_explnum_num = " . $this->explnum_id;
        // pmb_mysql_query($requete);

        // $requete = "delete from explnum_segments where explnum_segment_explnum_num = " . $this->explnum_id;
        // pmb_mysql_query($requete);

        // Nettoyage demande de numrisation
        // $requete = "delete from scan_request_explnum where scan_request_explnum_num_explnum = " . $this->explnum_id;
        // pmb_mysql_query($requete);

        // $requete = "delete from caddie_content using caddie, caddie_content where caddie_id=idcaddie and type='EXPLNUM' and object_id='" . $this->explnum_id . "' ";
        // pmb_mysql_query($requete);

        // Nettoyage indexation concepts
        // $index_concept = new index_concept($this->explnum_id, TYPE_EXPLNUM);
        // $index_concept->delete();

        // Nettoyage des rgimes de licence
        // explnum_licence::delete_explnum_licence_profiles($this->explnum_id);

        // Supression des champs perso
        // $this->get_p_perso();
        // $this->p_perso->delete_values($this->explnum_id);
    }

    /*
     * Construction du formulaire
     */
    public function fill_form(&$form, $action, $suppr = '')
    {
        global $charset;
        global $msg, $lang;
        global $pmb_scan_pmbws_client_url, $pmb_scan_pmbws_url;
        global $pmb_indexation_docnum, $pmb_explnum_statut;
        global $b_mimetype;
        global $pmb_docnum_in_directory_allow, $pmb_docnum_in_database_allow;
        global $explnum_id;
        global $pmb_diarization_docnum;
        global $base_path;
        global $thesaurus_concepts_active;
        global $pmb_type_audit, $collectionId;

        if ($collectionId) {
            $this->collectionId = $collectionId;
        }

        $form = str_replace('!!action!!', $action, $form);
        $form = str_replace('!!explnum_id!!', $this->explnum_id, $form);
        $form = str_replace('!!nom!!', htmlentities($this->explnum_nom, ENT_QUOTES, $charset), $form);
        $form = str_replace('!!url!!', htmlentities($this->explnum_url, ENT_QUOTES, $charset), $form);
        if ($this->explnum_id && $this->explnum_nomfichier && $this->explnum_mimetype != 'URL') {
            $form = str_replace('!!disabled_url!!', "disabled='disabled' placeholder='" . htmlentities($msg['explnum_url_associated_already'], ENT_QUOTES, $charset) . "'", $form);
        } else {
            $form = str_replace('!!disabled_url!!', "", $form);
        }

        // Gestion de l'interface de segmentation
        if ($pmb_diarization_docnum) {
            $checkbox = "<div id='el0Child_7' class='row' movable='yes' title=\"" . htmlentities($msg['diarize_explnum'], ENT_QUOTES, $charset) . "\">
				 		<input type='checkbox' id='ck_diarization' value='1' name='ck_diarization' /><label for='ck_diarization'>" . $msg['diarize_explnum'] . "</label>
				 	</div>
				 ";
            $form = str_replace('!!ck_diarization!!', $checkbox, $form);
        } else {
            $form = str_replace("!!ck_diarization!!", "", $form);
        }

        // Gestion du scanner
        if (($pmb_scan_pmbws_client_url) && ($pmb_scan_pmbws_url)) {
            $scan_addon = "
				<script>function afterscan(format) {
					if (document.explnum.f_fichier) {
						sitxt=document.createElement('span');
						sitxt.setAttribute('id','scanned_image_txt');
						sitxt.className='erreur';
						document.explnum.f_fichier.parentNode.replaceChild(sitxt,document.explnum.f_fichier);
					}
					document.getElementById('scanned_image_txt').innerHTML='" . $msg["scan_image_recorded"] . "';
					document.getElementById('scanned_image_ext').value=format;
				}</script>
				<input type='button' value='" . $msg["scan_button"] . "' onClick='openPopUp(\"" . $pmb_scan_pmbws_client_url . "?scanfield=scanned_image&urlbase=" . rawurlencode($pmb_scan_pmbws_url) . "&scanform=explnum&callbackimage=afterscan&lang=$lang&charset=$charset\",\"scanWindow\",900,700,0,0,\"scrollbars=yes, resizable=yes\")' class='bouton'/>
				<input type='hidden' name='scanned_image_ext' id='scanned_image_ext' value=''/>
				<input type='hidden' name='scanned_image' value=''/>
				<input type='hidden' id='scanned_texte' name='scanned_texte' value=''/>";
            $form = str_replace('<!-- !!scan_button!! -->', $scan_addon, $form);
        }

        // Ajout du bouton d'association s'il y a des segments en base
        $associer = "";
        $fct = "";
        if ($this->explnum_id) {
            $nb = 0;
            $query = "select count(*) as nb from explnum_segments where explnum_segment_explnum_num = " . $this->explnum_id;
            $result = pmb_mysql_query($query);
            if ($result && pmb_mysql_num_rows($result)) {
                $nb = pmb_mysql_fetch_object($result)->nb;
            }
            if ($nb > 0) {
                $associer = "<input type='button' class='bouton' value=\"" . $msg['associate_speakers'] . "\" name='associate_speakers' id='associate_speakers' onClick=\"document.location = '" . $base_path . "/catalog.php?categ=explnum_associate&explnum_id=" . $this->explnum_id . "';\" />";

                if ($pmb_diarization_docnum) {
                    // On ajoute une confirmation pour une deuxime segmentation => perte des associations
                    $fct = "<script type='text/javascript'>
							function conf_diarize_again() {
								if (document.getElementById('ck_diarization').checked) {
									conf = confirm('" . addslashes($msg['explnum_associate_conf_diarize_again']) . "');
									if (!conf) {
										document.getElementById('ck_diarization').checked = false;
									}
								}
							}

							document.getElementById('ck_diarization').addEventListener('change', conf_diarize_again, false);
						</script>";
                }
            }
        }
        $form = str_replace("!!associate_speakers!!", $associer, $form);
        $form = str_replace("!!fct_conf_diarize_again!!", $fct, $form);

        // Champs persos
        // $this->get_p_perso();

        // $perso = '';
        // if (!$this->p_perso->no_special_fields) {
        //     $perso_ = $this->p_perso->show_editable_fields($this->explnum_id);
        //     for ($i = 0; $i < count($perso_["FIELDS"]); $i++) {
        //         if (($i == count($perso_["FIELDS"]) - 1) && ($i % 2 == 0))
        //             $element_class = 'row';
        //         else
        //             $element_class = 'colonne2';
        //         $p = $perso_["FIELDS"][$i];
        //         $perso .= "<div id='el0Child_8_" . $p["ID"] . "' class='" . $element_class . "' movable='yes' title=\"" . htmlentities($p["TITRE"], ENT_QUOTES, $charset) . "\">
        // 						<label for='" . $p["NAME"] . "' class='etiquette'>" . $p["TITRE"] . " </label>" . $p["COMMENT_DISPLAY"] . "
        // 						<div class='row'>" . $p["AFF"] . "</div>
        // 					</div>\n";
        //     }
        //     $perso = $perso_["CHECK_SCRIPTS"] . "\n" . $perso;
        // } else {
        //     $perso = "\n<script>function check_form() { return true; }</script>\n";
        // }
        // $form = str_replace("!!champs_perso!!", $perso, $form);

        // $form = str_replace("!!rights_form!!", $this->get_rights_form(), $form);

        // Ajout du bouton supprimer si modification
        if ($this->explnum_id && $suppr) {
            $supprimer = "
					<script type=\"text/javascript\">
					    function confirm_delete() {
		        			result = confirm(\"{$msg["confirmdelete_explnum"]} ?\");
		        			if(result)
		            			document.location = \"$suppr\";
		    			}
					</script>
					<input type='button' class='bouton' value=\"{$msg['63']}\" name='del_ex' id='del_ex' onClick=\"confirm_delete();\" />
					";
        } else {
            $supprimer = "";
        }
        $form = str_replace('!!supprimer!!', $supprimer, $form);

        // Gestion du statut de notice
        if ($pmb_explnum_statut == '1') {
            $explnum_statut_form = "&nbsp;<input type='checkbox' id='f_statut_chk' name='f_statut_chk' value='1' ";
            if ($this->explnum_statut == '1')
                $explnum_statut_form .= "checked='checked' ";
            $explnum_statut_form .= "/>&nbsp;<label class='etiquette' for='f_statut_chk'>" . htmlentities($msg['explnum_statut_msg'], ENT_QUOTES, $charset) . "</label>";
            $form = str_replace('<!-- explnum_statut -->', $explnum_statut_form, $form);
        }

        // Conserver la vignette
        if ($this->explnum_vignette)
            $form = str_replace('!!vignette_existante!!', "&nbsp;<input type='checkbox' checked='checked' name='conservervignette' id='conservervignette' value='1'>&nbsp;<label for='conservervignette'>" . $msg['explnum_conservervignette'] . "</label>", $form);
        else
            $form = str_replace('!!vignette_existante!!', '', $form);
        global $_mimetypes_bymimetype_;
        create_tableau_mimetype();
        $selector_mimetype = "<label class='etiquette'>" . htmlentities($msg['explnum_mime_label'], ENT_QUOTES, $charset) . "</label>&nbsp;<select id='mime_vign' name='mime_vign' >
			<option value=''>" . htmlentities($msg['explnum_no_mimetype'], ENT_QUOTES, $charset) . "</option>
			";
        foreach ($_mimetypes_bymimetype_ as $key => $val) {
            $selected = "";
            // if($this->explnum_mimetype == $key)
            // $selected = "selected";
            $selector_mimetype .= "<option value='" . $key . "' $selected >" . htmlentities($key, ENT_QUOTES, $charset) . "</option>";
        }
        $selector_mimetype .= "</select>";
        $form = str_replace('!!mimetype_list!!', $selector_mimetype, $form);

        // Intgration de la gestion de l'interface de l'upload
        if ($pmb_docnum_in_directory_allow) {
            $div_up = "<div class='row'>";
            if ($pmb_docnum_in_database_allow)
                $div_up .= "<input type='radio' name='up_place' id='base' value='0' !!check_base!!/> <label for='base'>" . $msg['upload_repertoire_sql'] . "</label>";

            $div_up .= "	<input type='radio' name='up_place' id='upload' value='1' !!check_up!! />
								<label for='upload'>" . $msg['docnum_collections_upload_label'] . " </label>
							</div>";
            $form = str_replace('!!div_upload!!', $div_up, $form);

            if ($this->isEnBase()) {
                $form = str_replace('!!check_base!!', "checked='checked'", $form);
                $form = str_replace('!!check_up!!', '', $form);
            } else {
                $form = str_replace('!!check_base!!', '', $form);
                $form = str_replace('!!check_up!!', "checked='checked'", $form);
            }
        } else {
            $form = str_replace('!!div_upload!!', '', $form);
        }

        // Ajout du selecteur de localisation
        // $liste_id = array();
        // if ($explnum_id) {
        //     if (!$this->explnum_location) {
        //         $requete = "select idlocation from docs_location";
        //         $res = pmb_mysql_query($requete);
        //         $i = 0;
        //         while ($row = pmb_mysql_fetch_array($res)) {
        //             $liste_id[$i] = $row["idlocation"];
        //             $i++;
        //         }
        //     } else {
        //         $liste_id = $this->explnum_location;
        //     }
        // } else {
        //     global $deflt_explnum_location;
        //     $liste_id[0] = $deflt_explnum_location;
        // }

        // $docloc = new \docs_location();
        // $selector_location = $docloc->gen_multiple_combo($liste_id);

        // $form = str_replace('!!location_explnum!!', "<div class='row'><label class='etiquette'>" . htmlentities($msg['empr_location'], ENT_QUOTES, $charset) . "</label></div>" . $selector_location, $form);

        // $form = str_replace('!!lenders!!', lender::gen_multiple_combo_box($this->lenders), $form);

        // statut
        $select_statut = gen_liste_multiple("select id_explnum_statut, gestion_libelle from explnum_statut order by 2", "id_explnum_statut", "gestion_libelle", "id_explnum_statut", "f_explnum_statut", "", $this->explnum_docnum_statut, "", "", "", "", 0);
        $form = str_replace('!!statut_list!!', $select_statut, $form);

        global $pmb_ocr_active;
        if ($pmb_ocr_active) {
            $checkbox = "
            <div id='el0Child_9' class='row' movable='yes' title=\"" . htmlentities($msg['docnum_ocr'], ENT_QUOTES, $charset) . "\">
                <input type='checkbox' id='ck_ocr' value='1' name='ck_ocr' onchange='check_ocr(event);' /><label for='ck_ocr'>" . $msg['docnum_ocr'] . "</label>
            </div>
            <script>
                function check_ocr(event) {
                    const f_fichier = document.getElementById('f_fichier');
                    const uploaded_mimetype = '" . $this->explnum_mimetype . "';

                    let check_mimetype = uploaded_mimetype;
                    if (f_fichier.files.length != 0) {
                        check_mimetype = f_fichier.files.item(0).type;
                    }

                    if (check_mimetype != 'application/pdf') {
                        event.target.checked = false;
                        alert('" . $msg['docnum_ocr_pdf_required'] . "');
                    }
                }
            </script>";
        } else {
            $checkbox = "";
        }
        $form = str_replace('!!ck_ocr_pdf!!', $checkbox, $form);

        $checkbox = "<div id='el0Child_10' class='row' movable='yes' title=\"" . htmlentities($msg['docnum_compress'], ENT_QUOTES, $charset) . "\">
					<input type='checkbox' id='ck_compress' value='1' name='ck_compress' onchange='check_compress(event);' /><label for='ck_compress'>" . $msg['docnum_compress'] . "</label>
				</div>
				<script>
					function check_compress(event) {
						const f_fichier = document.getElementById('f_fichier');
						const uploaded_mimetype = '" . $this->explnum_mimetype . "';

						let check_mimetype = uploaded_mimetype;
						if (f_fichier.files.length != 0) {
							check_mimetype = f_fichier.files.item(0).type;
						}

						const mimetype_required = [
							'application/pdf',
							'image/jpeg',
							'image/jpg',
							'image/png',
							'image/x-png',
							'image/webp'
						];

						if (false == mimetype_required.includes(check_mimetype)) {
							event.target.checked = false;
							alert('" . $msg['docnum_compress_required'] . "');
						}
					}
				</script>
			";
        $form = str_replace('!!ck_compress_docnums!!', $checkbox, $form);

        // $explnum_licence_selector = \explnum_licence::get_licence_selector(\explnum_licence::get_explnum_licence_profiles($this->explnum_id));
        // if ($explnum_licence_selector) {
        //     $explnum_licence_selector = "
        // 				<div id='el0Child_5' class='row' movable='yes' title=\"" . htmlentities($msg['admin_menu_noti_licence'], ENT_QUOTES, $charset) . "\">
        // 					<div class='row'>
        // 					    <label class='etiquette'>" . $msg['admin_menu_noti_licence'] . "</label>
        // 			    	</div>
        // 				    <div class='row'>
        // 				    " . $explnum_licence_selector . "
        // 				    </div>
        // 				    <div class='row'>&nbsp;</div>
        // 				</div>";
        // }

        // $form = str_replace('!!explnum_licence_selectors!!', $explnum_licence_selector, $form);

        // Indexation concept
        // if ($thesaurus_concepts_active == 1) {
        //     $index_concept = new index_concept($this->explnum_id, TYPE_EXPLNUM);
        //     $form = str_replace('!!index_concept_form!!', $index_concept->get_form('explnum'), $form);
        // } else {
        //     $form = str_replace('!!index_concept_form!!', "", $form);
        // }

        // if ($pmb_type_audit && $this->explnum_id) {
        //     $form = str_replace('!!link_audit!!', audit::get_dialog_button($this->explnum_id, AUDIT_EXPLNUM), $form);
        // } else {
        //     $form = str_replace('!!link_audit!!', '', $form);
        // }

        $form = str_replace('!!sign_docnum!!', $this->get_form_cert(), $form);

        // Selecteur de collection
        $form = str_replace('<!-- explnum_collection -->', $this->genCollectionSelector(), $form);

        $collectionCSRF = new CollectionCSRF();
        $tokens = json_encode($collectionCSRF->getArrayTokens());

        $form = str_replace('!!tokens_csrf!!', $tokens, $form);

        // On replace tous les pattern !!...!! inutils
        $form = preg_replace('/!![^!]+!!/', '', $form);

        // TODO : a revoir petit hack qui fait le caf qui enlve les lenders :)
        $form = str_replace("id='el0Child_5'", "id='el0Child_5' style='opacity: 0; height: 0;'", $form);

        $form = str_replace("history.go(-1);", "document.location = './catalog.php?categ=docnum_collections';", $form);
    }

    private function genCollectionSelector()
    {
        global $msg, $charset;

        $collection = new Collection();
        $collections = $collection->getList(null, false, 'name ASC');

        $options = '';
        foreach ($collections as $collection) {
            $selected = ($collection->id == $this->collectionId) ? 'selected="selected"' : '';
            $options .= "<option value='" . $collection->id . "' " . $selected . ">" . $collection->name . "</option>";
        }

        $collectionLabel = htmlentities($msg['docnum_collections_label'], ENT_QUOTES, $charset);
        $defaultSelected = ($this->explnum_id == 0) ? 'selected="selected"' : '';

        return <<<HTML
            <div id="el0Child_11" class="row" movable="yes" title="{$collectionLabel}">
                <div class="row">
                    <label class="etiquette" for="explnum_collection">{$collectionLabel}</label>
                </div>
                <div class="row">
                    <select name='explnum_collection' id='explnum_collection' required>
                        <option value='' disabled {$defaultSelected}>{$msg['docnum_add_docunum_selector']}</option>
                        {$options}
                    </select>
                </div>
            </div>
        HTML;
    }

    public function importFromFile(array $file)
    {
        $currentDate = date("Y-m-d H:i:s");

        $this->explnum_file_size = $file["size"];
        $this->explnum_create_date = $currentDate;
        $this->explnum_update_date = $currentDate;
        move_uploaded_file($file["tmp_name"], "./temp/" . $file["name"]);
        $this->get_file_from_temp("./temp/" . $file["name"], $file["name"], true);
        $this->update(false);
        $this->explnum_id = $this->explnumCollections->idExplnumCollectionsExplnums;
    }

    /*
    * Mise  jour de l'exemplaire numrique
    */
    public function update($with_print = true)
    {
        global $pmb_explnum_statut;
        global $id_rep, $up_place;
        global $mime_vign;

        /**
         * Publication d'un venement avant la mise  jour
         */
        $evt_handler = events_handler::get_instance();
        $event = new event_explnum("explnum", "before_update");
        $event->set_explnum($this);
        $evt_handler->send($event);

        if (empty($this->params["erreur"])) {
            $this->explnum_nom = stripslashes($this->infos_docnum["nom"]);
            $this->explnum_url = stripslashes($this->infos_docnum["url"] ?? '');
            if ($this->params["maj_mimetype"]) {
                $this->explnum_mimetype = stripslashes($this->infos_docnum["mime"]);
            }
            if ($this->params["maj_data"]) {
                if (!isset($this->params["is_upload"]) || !$this->params["is_upload"]) {
                    $this->explnum_data = (isset($this->infos_docnum["contenu"]) ? $this->infos_docnum["contenu"] : '');
                } else {
                    $this->explnum_data = '';
                }
                $this->explnum_nomfichier = $this->infos_docnum["userfile_name"];
                $this->explnum_extfichier = $this->infos_docnum["userfile_ext"];
            }
            if ($this->params["maj_vignette"] && (!isset($this->params["conservervignette"]) || !$this->params["conservervignette"])) {
                $this->explnum_vignette = $this->infos_docnum["contenu_vignette"];
            }
            if ($pmb_explnum_statut == '1') {
                $this->explnum_statut = $this->params["statut"];
            }
            $this->explnum_repertoire = (($up_place) ? $id_rep : 0);
            $this->explnum_path = $this->infos_docnum["path"];
            $this->explnum_docnum_statut = ((isset($this->params["explnum_statut"]) && $this->params["explnum_statut"]) ? $this->params["explnum_statut"] : 1);
            if ($this->params["maj_data"]) {
                $this->explnum_file_size = $this->get_file_size(true);
            }
        }
        $saved = $this->save();
        if ($saved) {

            // OCR
            global $ck_ocr;
            if ($ck_ocr && OcrExplnumsModel::isOcrByServer()) {
                if ($this->explnum_repertoire) {
                    $this->ocr_pdf(self::OCR_TYPE_FILE, $this->get_is_file());
                } else {
                    $this->ocr_pdf(self::OCR_TYPE_BINARY, $this->explnum_data);
                }
            }

            // // Indexation du document
            // global $pmb_indexation_docnum;
            // if ($pmb_indexation_docnum) {
            //     $vign_index = $this->indexer_docnum();
            //     if (! $mime_vign && (!isset($this->params["conservervignette"]) || !$this->params["conservervignette"]) && (!isset($this->infos_docnum["vignette_name"]) || !$this->infos_docnum["vignette_name"])) {
            //         if ($vign_index) {
            //             $this->update_explnum_vignette($vign_index);
            //         } else {
            //             if ($this->params["maj_vignette"] && $this->infos_docnum["contenu_vignette"]) {
            //                 $contenu_vignette = $this->infos_docnum["contenu_vignette"];
            //             } else {
            //                 $contenu_vignette = construire_vignette("", "", $this->infos_docnum["url"]);
            //             }
            //             if ($contenu_vignette) {
            //                 $this->update_explnum_vignette($contenu_vignette);
            //             }
            //         }
            //     }
            /*} else*/
            if (! $mime_vign && (!isset($this->params["conservervignette"]) || !$this->params["conservervignette"]) && (!isset($this->infos_docnum["vignette_name"]) || !$this->infos_docnum["vignette_name"]) && $this->infos_docnum["url"]) { // Si pas d'indexation et que je ne force pas la vignette en fonction du mimetype et si j'ai une url
                if ($this->params["maj_vignette"] && $this->infos_docnum["contenu_vignette"]) {
                    $contenu_vignette = $this->infos_docnum["contenu_vignette"];
                } else {
                    $contenu_vignette = construire_vignette("", "", $this->infos_docnum["url"]);
                }
                if ($contenu_vignette) {
                    $this->update_explnum_vignette($contenu_vignette);
                }
            }

            /**
             * Publication d'un venement aprs la mise  jour
             */
            $evt_handler = events_handler::get_instance();
            $event = new event_explnum("explnum", "after_update");
            $event->set_explnum($this);
            $evt_handler->send($event);
            if ($event->get_error_message()) {
                print $event->get_error_message();
                return;
            }

            if($with_print && isset($this->params["retour"]) && !empty($this->params["retour"])) {
                print <<<HTML
                    <script>
                        document.location = "{$this->params["retour"]}";
                    </script>
                HTML;
            }
        }
    }

    protected function update_explnum_vignette($explnum_vignette)
    {
        $query = "update explnum_collections_explnums set explnum_collections_explnums_vignette='" . addslashes($explnum_vignette) . "' where id_explnum_collections_explnums='" . $this->explnum_id . "'";
        pmb_mysql_query($query);
    }

    public function get_file_from_temp($filename, $name, $upload_place)
    {
        global $ck_index;
        global $id_rep, $up_place;
        global $pmb_indexation_docnum_default;

        $up_place = $upload_place;

        create_tableau_mimetype();
        if (!isset($ck_index)) {
            $ck_index = $pmb_indexation_docnum_default;
        }
        // Initialisation des tableaux d'infos
        $this->infos_docnum = $this->params = array();
        $this->infos_docnum["mime"] = trouve_mimetype($filename, extension_fichier($name));
        $this->infos_docnum["nom"] = substr($name, 0, strrpos($name, "."));
        if (! $this->infos_docnum["nom"]) {
            $this->infos_docnum["nom"] = $name;
        }
        $this->infos_docnum["notice"] = $this->explnum_notice;
        $this->infos_docnum["bull"] = $this->explnum_bulletin;
        $this->infos_docnum["url"] = "";
        $this->infos_docnum["fic"] = false;
        if ($this->infos_docnum["mime"] != 'text/plain') {
            $this->infos_docnum["contenu_vignette"] = construire_vignette('', substr($filename, strrpos($filename, "/")));
        }
        $this->infos_docnum["userfile_name"] = static::clean_explnum_file_name($name);
        $this->infos_docnum["userfile_ext"] = extension_fichier($name);

        if ($up_place && $id_rep != 0) {
            $upfolder = new upload_folder($id_rep);
            $chemin_hasher = "/";
            if ($upfolder->isHashing()) {
                $rep = $upfolder->hachage($this->infos_docnum["userfile_name"]);
                @mkdir($rep);
                $chemin_hasher = $upfolder->formate_path_to_nom($rep);
                $file_name = $rep . $this->infos_docnum["userfile_name"];
                $chemin = $upfolder->formate_path_to_save($chemin_hasher);
            } else {
                $file_name = $upfolder->get_path($this->infos_docnum["userfile_name"]) . $this->infos_docnum["userfile_name"];
                $chemin = $upfolder->formate_path_to_save("/");
            }
            $this->infos_docnum["path"] = $chemin;
            $file_name = $upfolder->encoder_chaine($file_name);
            if (! $this->explnum_nomfichier) { // Si je suis en cration de fichier numrique
                $nom_tmp = $this->infos_docnum["userfile_name"];
                $continue = true;
                $compte = 1;
                do {
                    $query = "select id_explnum_collections_explnums, explnum_collections_explnums_num_collection from explnum_collections_explnums where explnum_collections_explnums_nomfichier = '" . addslashes($nom_tmp) . "' AND explnum_collections_explnums_repertoire='" . $id_rep . "' AND explnum_collections_explnums_path='" . addslashes($this->infos_docnum["path"]) . "'";
                    $result = pmb_mysql_query($query);
                    if (pmb_mysql_num_rows($result) && (pmb_mysql_result($result, 0, 1) != $this->collectionId)) { // Si j'ai dj un document numrique avec ce fichier pour une autre notice je dois le renommer pour ne pas perdre l'ancien
                        if (preg_match("/^(.+)(\..+)$/i", $this->infos_docnum["userfile_name"], $matches)) {
                            $nom_tmp = $matches[1] . "_" . $compte . $matches[2];
                        } else {
                            $nom_tmp = $this->infos_docnum["userfile_name"] . "_" . $compte;
                        }
                        $compte++;
                    } else {
                        if (pmb_mysql_num_rows($result)) { // J'ai dj ce fichier pour cette collection
                            // Je dois enlever l'ancien document numrique pour ne pas l'avoir en double
                            $old_docnum = new static(pmb_mysql_result($result, 0, 0));
                            $old_docnum->delete();
                        } else {
                        }
                        $continue = false;
                    }
                } while ($continue);
                if ($compte != 1) {
                    $this->infos_docnum["userfile_name"] = $nom_tmp;
                    if ($upfolder->isHashing()) {
                        $file_name = $rep . $this->infos_docnum["userfile_name"];
                    } else {
                        $file_name = $upfolder->get_path($this->infos_docnum["userfile_name"]) . $this->infos_docnum["userfile_name"];
                    }
                    $file_name = $upfolder->encoder_chaine($file_name);
                } else {
                }
            } else {
            }
            if (copy($filename, $file_name)) {
                unlink($filename);
            }
            #Pour avoir une vignette si le prcdent calcul n'a pas fonctionn car le fichier n'est pas dans le rpertoire temp de PMB
            if (($this->infos_docnum["mime"] != 'text/plain') && (!$this->infos_docnum["contenu_vignette"])) {
                $this->infos_docnum["contenu_vignette"] = construire_vignette('', $file_name);
            }
        } else {
            // enregistrement en base
            $this->infos_docnum["contenu"] = file_get_contents($filename);
        }

        $this->params["maj_mimetype"] = true;
        $this->params["maj_data"] = true;
        $this->params["maj_vignette"] = true;
    }

    public function createNoticeExplnum(int $entityId, string $type, $settings)
    {
        $explnum = new parent();
        $properties = get_object_vars($this);
        foreach ($properties as $property => $value) {
            if (property_exists($explnum, $property)) {
                $explnum->$property = $value;
            }
        }
        $explnum->explnum_id = 0;
        switch ($type) {
            case "notice":
                $explnum->explnum_notice = $entityId;
                break;
            case "bulletin":
                $explnum->explnum_bulletin = $entityId;
                break;
            default:
                break;
        }

        //Gestion des propritaires
        global $book_lender_id;

        if (isset($settings->lenders) && is_array($settings->lenders) && ! empty($settings->lenders)) {
            $book_lender_id = $settings->lenders;
        } else {
            global $deflt_explnum_lenders;
            $book_lender_id = [$deflt_explnum_lenders];
        }

        //Gestion des localisations
        global $loc_selector;

        if (isset($settings->docsLocation) && is_array($settings->docsLocation) && ! empty($settings->docsLocation)) {
            $loc_selector = $settings->docsLocation;
        } else {
            global $deflt_explnum_location;
            $loc_selector = [$deflt_explnum_location];
        }

        //Gestion des licences
        global $explnum_licence_profiles;

        if (isset($settings->licenceProfiles) && is_array($settings->licenceProfiles) && ! empty($settings->licenceProfiles)) {
            $explnum_licence_profiles = $settings->licenceProfiles;
        }

        $explnum->save();

        //Gestion de l'indexation
        if (isset($settings->indexDocnums) && true == $settings->indexDocnums) {
            global $ck_index;
            $ck_index = true;
            $explnum->indexer_docnum();
        }

        return $explnum;
    }

    public static function getLenders()
    {
        return lender::get_lenders_list();
    }

    public static function getDocsLocation()
    {
        return docs_location::get_docs_location_list();
    }

    public static function getExplnumLicences()
    {
        return explnum_licence::get_explnum_licences();
    }

    public static function getExplnumLicenceProfiles(int $licenceId)
    {
        $licence = new explnum_licence($licenceId);
        $profiles = array();
        foreach($licence->get_profiles() as $profile) {
            $profiles[] = array(
                "idProfile" => $profile->get_id(),
                "label" => $profile->get_label(),
                "logoUrl" => $profile->get_logo_url()
            );
        }
        return $profiles;
    }
}
