<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: CollectionsController.php,v 1.5.2.2 2025/06/12 09:13:53 rtigero Exp $

namespace Pmb\Docnums\Controller;

use Pmb\Common\Controller\Controller;
use Pmb\Docnums\Models\Collection;
use Pmb\Docnums\Models\Explnum;
use Pmb\Docnums\Orm\ExplnumCollectionsExplnumsOrm;

class CollectionsController extends Controller
{
    public function save()
    {
        $collection = new Collection($this->data->id ?? 0);
        $collection->setFromForm($this->data);
        $collection->save();
        $this->ajaxJsonResponse($collection);
    }

    public function delete()
    {
        if ($this->data->id) {
            $collection = new Collection($this->data->id);
            $delete = $collection->delete();
            if ($delete) {
                $this->ajaxJsonResponse(true);
            }
        }
    }

    public function getPaginateExplnums(int $numCollection, int $page)
    {
        $result = ExplnumCollectionsExplnumsOrm::paginationWhere(
            $page - 1,
            8,
            ["explnum_collections_explnums_num_collection" => $numCollection],
            "explnum_collections_explnums_nom ASC"
        );

        foreach ($result["instances"] as &$explnum) {
            $explnum = new Explnum($explnum->id_explnum_collections_explnums);

            // On vide les props avec des blob pour viter les soucis de caractre et on en a pas besoin
            $explnum->explnum_vignette = "";
            $explnum->explnum_data = "";
            $explnum->explnumCollections->explnumCollectionsExplnumsData = "";
            $explnum->explnumCollections->explnumCollectionsExplnumsVignette = "";
        }

        $this->ajaxJsonResponse($result);
    }
}
