<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: CaptchaController.php,v 1.2.2.2 2026/01/27 09:06:12 gneveu Exp $

namespace Pmb\Common\Opac\Controller;

use AltchaOrg\Altcha\Altcha;
use AltchaOrg\Altcha\ChallengeOptions;
use AltchaOrg\Altcha\Hasher\Algorithm;

use Pmb\Common\Controller\Controller as ControllerBase;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class CaptchaController extends ControllerBase
{
    public const MAX_NUMBER = 50000;

    public function home()
    {
        global $opac_empr_password_salt;
        if ('' == $opac_empr_password_salt) {
            password::gen_salt_base();
        }

        $altcha = new Altcha($opac_empr_password_salt);
        $option = new ChallengeOptions(
            Algorithm::SHA256,
            self::MAX_NUMBER,
            (new \DateTimeImmutable())->add(new \DateInterval('PT60S'))
        );

        $challenge = $altcha->createChallenge($option);
        $this->ajaxJsonResponse($challenge);
    }
}
