<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: CaptchaModel.php,v 1.1.2.2 2026/01/27 09:06:14 gneveu Exp $

namespace Pmb\Common\Models;

use AltchaOrg\Altcha\Altcha;

class CaptchaModel extends Model
{
    public static function getCaptchaHtml()
    {
        global $opac_url_base, $include_path;

        if(file_exists($include_path . '/altcha/altcha.html')) {
            $template = file_get_contents($include_path . '/altcha/altcha.html');
            $url = $opac_url_base . 'rest.php/captcha/challenge';
            return str_replace('!!opac_url!!', $url, $template);
        }
        return "";
    }

    public static function verify($captcha)
    {
        global $opac_empr_password_salt;
        $altcha = new Altcha($opac_empr_password_salt);
        return $altcha->verifySolution($captcha);
    }
}
