<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AnimationStatusModel.php,v 1.11.6.1.2.2 2026/02/12 16:00:58 qvarin Exp $
namespace Pmb\Animations\Models;

use Pmb\Animations\Orm\AnimationOrm;
use Pmb\Common\Models\Model;
use Pmb\Animations\Orm\AnimationStatusOrm;

class AnimationStatusModel extends Model
{

    protected $ormName = "\Pmb\Animations\Orm\AnimationStatusOrm";

    public $hasAnimations = false;

    public $idStatus;

    public $label;

    public $color;

    public $animations;

    public static function getAnimationStatusList(bool $sort = true): array
    {
        $animationStatus = AnimationStatusOrm::findAll();
        $animationStatus = self::toArray($animationStatus);

        if ($sort) {
            usort($animationStatus, function ($a, $b) {
                return strcmp(strtolower($a['label']), strtolower($b['label']));
            });
        }

        return $animationStatus;
    }

    public static function delete($id)
    {
        if ($id != 1) {
            $animationStatus = AnimationStatusOrm::findById($id);
            if (empty(AnimationOrm::find('num_status', $id))) {
                $animationStatus->delete();
                return true;
            }
        }
        return false;
    }

    public static function save(object $data)
    {
        if (! empty($data->id)) {
            $status = new AnimationStatusOrm($data->id);
        } else {
            $status = new AnimationStatusOrm();
        }
        if (! empty($data->label)) {
            $result = AnimationStatusOrm::find('label', $data->label);
            if ((count($result) == 1 && $status->{AnimationStatusOrm::$idTableName} === $result[0]->{AnimationStatusOrm::$idTableName}) || empty($result)) {
                $status->label = $data->label;
                $status->color = $data->color ?? '';
                $status->save();
            }
        }
    }

    public function getEditAddData()
    {
        $this->hasAnimations = $this->hasAnimations();
        return $this;
    }

    public function hasAnimations()
    {
        $query = "select 1 from anim_animations where num_status = " . $this->id;
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result) > 0) {
            return true;
        }
        return false;
    }

    public static function checkExistStatus($label)
    {
        if (! empty(AnimationStatusOrm::find('label', $label))) {
            return true;
        }
        return false;
    }
}