<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AiSharedListDocnumModel.php,v 1.1.2.3.4.2.2.2 2025/12/02 12:33:55 gneveu Exp $

namespace Pmb\AI\Models;

use Pmb\AI\Orm\AiSharedListDocnumOrm;
use Pmb\Common\Models\Model;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class AiSharedListDocnumModel extends Model
{
    public const TYPE_EXPLNUM_ID = "docnum";

    protected $ormName = "Pmb\AI\Orm\AiSharedListDocnumOrm";

    public $idAiSharedListDocnum = 0;
    public $nameAiSharedListDocnum = "";
    public $contentAiSharedListDocnum = "";
    public $mimetypeAiSharedListDocnum = "";
    public $extfileAiSharedListDocnum = "";
    public $pathAiSharedListDocnum = "";
    public $hashNameAiSharedListDocnum = "";
    public $hashBinaryAiSharedListDocnum = "";
    public $numListAiSharedListDocnum = 0;
    public $flagAiSharedListDocnum = 0;
    public $embeddingsAiSharedListDocnum = null;

    public function __construct(int $id = 0)
    {
        $this->id = intval($id);
        $this->fetchData();
    }

    public function save()
    {
        $orm = new $this->ormName();

        $orm->id_ai_shared_list_docnum = $this->idAiSharedListDocnum;
        $orm->name_ai_shared_list_docnum = $this->nameAiSharedListDocnum;
        $orm->content_ai_shared_list_docnum = $this->get_content();
        $orm->mimetype_ai_shared_list_docnum = $this->mimetypeAiSharedListDocnum;
        $orm->extfile_ai_shared_list_docnum = $this->extfileAiSharedListDocnum;
        $orm->path_ai_shared_list_docnum = $this->pathAiSharedListDocnum;
        $orm->hash_name_ai_shared_list_docnum = $this->hashNameAiSharedListDocnum;
        $orm->hash_binary_ai_shared_list_docnum = $this->hashBinaryAiSharedListDocnum;
        $orm->num_list_ai_shared_list_docnum = $this->numListAiSharedListDocnum;
        $orm->flag_ai_shared_list_docnum = $this->flagAiSharedListDocnum;
        $orm->embeddings_ai_shared_list_docnum = $this->embeddingsAiSharedListDocnum ?? null;

        $orm->save();
    }

    private function get_content()
    {
        global $base_path, $class_path;

        if (!empty($this->contentAiSharedListDocnum)) {
            return $this->contentAiSharedListDocnum;
        }

        if (empty($this->mimetypeAiSharedListDocnum)) {
            return "";
        }

        $path = $base_path;
        if (!defined('GESTION')) {
            $path = $base_path . "/../";
        }

        $parse = new \XMLlist("$path/catalog/explnum/index_docnum/index_doc.xml");
        $parse->analyser();

        $className = $parse->table[$this->mimetypeAiSharedListDocnum];
        if (empty($className)) {
            return "";
        }

        require_once($path . "/catalog/explnum/index_docnum/" . $className . ".class.php");

        $filename = $this->pathAiSharedListDocnum . $this->hashNameAiSharedListDocnum;
        $class = new $className($filename, $this->mimetypeAiSharedListDocnum, $this->extfileAiSharedListDocnum);

        $this->contentAiSharedListDocnum = $class->get_text($filename);

        return $this->contentAiSharedListDocnum;
    }

    /**
     * Compte le nombre de enregistrements qui ne sont pas indexs.
     *
     * @param int $idList L'id de la liste
     * @return int Le nombre d'enregistrements non indexs
     */
    public static function countNotIndexedDocnum(int $idList)
    {
        $docnums = AiSharedListDocnumOrm::finds([
            'num_list_ai_shared_list_docnum' => $idList,
            'flag_ai_shared_list_docnum' => 0
        ]);

        return count($docnums);
    }

    /**
     * Rcupre les docnums en fonction de l'id d'une liste.
     *
     * @param int $idList L'id de la liste
     * @param int $limit Le nombre maximum d'enregistrements  rcuprer
     * @return AiSharedListDocnumOrm[]
     */
    public static function getDocnumsByListId(int $idList, $limit = 0)
    {
        return AiSharedListDocnumOrm::finds([
            'num_list_ai_shared_list_docnum' => $idList,
            'flag_ai_shared_list_docnum' => 0
        ], '', 'AND', $limit);
    }

    /**
     * Rcupre tous les docnums en fonction de l'id d'une liste.
     *
     * @param int $idList L'id de la liste
     * @return AiSharedListDocnumOrm[]
     */
    public static function fetchAllDocnumsByListId(int $idList)
    {
        return AiSharedListDocnumOrm::finds([
            'num_list_ai_shared_list_docnum' => $idList
        ]);
    }

    public static function getEntityDataAi(int $idList, int $limit = 0)
    {
        $return = [
            "count" => 0,
            "countIndexed" => 0,
            "entities" => []
        ];

        $docnums = self::getDocnumsByListId($idList, $limit);
        foreach ($docnums as $docnum) {
            $content = $docnum->content_ai_shared_list_docnum;
            if (!empty($content)) {
                $return["entities"][] = [
                    'object_id' => $docnum->id_ai_shared_list_docnum,
                    'object_type' => TYPE_SHARED_LIST_EXPLNUM,
                    'content' => $content
                ];
            }
        }

        $return["count"] = pmb_mysql_result(pmb_mysql_query("SELECT cunt(*) as count FROM ai_shared_list_docnum"), 0, 0);
        $return["countIndexed"] = pmb_mysql_result(pmb_mysql_query("SELECT count(*) as count FROM ai_shared_list_docnum WHERE flag_ai_shared_list_docnum != 0"), 0, 0);

        return $return;
    }

    /**
     * Marque le champ 'flag_ai_shared_list_docnum'  1 pour spcifier qu'un enregistrement est index
     *
     * @param int $idList L'id de la liste.
     * @param int $limit Le nombre maximum d'enregistrements  mettre  jour
     * @param int $flag La valeur du flag  dfinir
     * @return void
     */
    public static function setDocnumFlag(int $idList, $limit = 0, int $flag = 0)
    {
        $docnums = self::getDocnumsByListId($idList, $limit);
        if (empty($docnums)) {
            return;
        }

        foreach ($docnums as $docnum) {
            $docnum->flag_ai_shared_list_docnum = $flag;
            $docnum->save();
        }
    }

    /**
     * Calcule l'espace de stockage utilis par un lecteur
     * Parcourt toutes les listes partages (opac_liste_lecture) du lecteur
     * et calcule la taille totale des fichiers (ai_shared_list_docnum) associs
     *
     * @param int $id_empr ID du lecteur
     * @return int Taille totale en octets
     */
    public static function calculate_storage($id_empr)
    {
        $total_size = 0;

        // Requte pour rcuprer toutes les listes partages du lecteur
        $query = "SELECT id_liste FROM opac_liste_lecture WHERE num_empr = ".intval($id_empr);
        $result = pmb_mysql_query($query);

        // Parcours de chaque liste partage
        while ($row = pmb_mysql_fetch_assoc($result)) {
            $list_id = $row['id_liste'];

            // Requte pour rcuprer les fichiers de cette liste
            $query_files = "
                SELECT path_ai_shared_list_docnum, hash_name_ai_shared_list_docnum
                FROM ai_shared_list_docnum
                WHERE num_list_ai_shared_list_docnum = ".intval($list_id);
            $result_files = pmb_mysql_query($query_files);

            // Parcours de chaque fichier et calcul de la taille
            while ($file = pmb_mysql_fetch_assoc($result_files)) {
                // Construction du chemin complet du fichier
                $file_path = $file['path_ai_shared_list_docnum'] . $file['hash_name_ai_shared_list_docnum'];

                // Si le fichier existe, rcupre sa taille
                if (file_exists($file_path)) {
                    $total_size += filesize($file_path);
                }
            }
        }

        return $total_size;
    }

    /**
     * Supprime tous les fichiers associs aux listes partages d'un lecteur
     *
     * @param int $id_empr ID du lecteur
     * @return void
     */
    public static function deleteByReaderId($id_empr)
    {
        $id_empr = intval($id_empr);

        // Rcupration de toutes les listes partages du lecteur
        $query = "SELECT id_liste FROM opac_liste_lecture WHERE num_empr = ".$id_empr;
        $result = pmb_mysql_query($query);

        // Parcours de chaque liste partage
        while ($row = pmb_mysql_fetch_assoc($result)) {
            $list_id = intval($row['id_liste']);

            // Rcupration des fichiers de cette liste
            $query_files = "
                SELECT id_ai_shared_list_docnum, path_ai_shared_list_docnum, hash_name_ai_shared_list_docnum
                FROM ai_shared_list_docnum
                WHERE num_list_ai_shared_list_docnum = ".$list_id;
            $result_files = pmb_mysql_query($query_files);

            // Parcours et suppression de chaque fichier
            while ($file = pmb_mysql_fetch_assoc($result_files)) {
                $file_id = intval($file['id_ai_shared_list_docnum']);
                $file_path = $file['path_ai_shared_list_docnum'] . $file['hash_name_ai_shared_list_docnum'];

                // Suppression du fichier physique
                if (file_exists($file_path)) {
                    if (@unlink($file_path)) {
                        // Suppression du fichier russi
                        // Maintenant supprimer l'enregistrement en BDD
                        $query_delete = "DELETE FROM ai_shared_list_docnum WHERE id_ai_shared_list_docnum = ".$file_id;
                        pmb_mysql_query($query_delete);
                    }
                } else {
                    // Fichier n'existe pas sur le disque, mais on le supprime quand mme de la BDD
                    $query_delete = "DELETE FROM ai_shared_list_docnum WHERE id_ai_shared_list_docnum = ".$file_id;
                    pmb_mysql_query($query_delete);
                }
            }
        }
    }
}
