<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AiModel.php,v 1.7.2.3.4.6.2.3 2026/02/06 09:24:11 qvarin Exp $

namespace Pmb\AI\Models;

use InvalidArgumentException;
use Pmb\AI\Library\Indexation\DocnumIndexation;
use Pmb\AI\Library\Indexation\RecordIndexation;
use Pmb\AI\Library\Utils;
use Pmb\Common\Models\Model;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class AiModel extends Model
{

    /**
     * Retourne les entites de la base de donnees  indexer
     *
     * @param int $type
     * @param int $limit
     * @return array
     */
    public static function getEntitiesDataAi($type, $limit)
    {
        switch ($type) {
            case TYPE_NOTICE:
                $recordIndexation = new RecordIndexation();
                return $recordIndexation->getIndexationEntities($limit);

            case TYPE_EXPLNUM:
                $docnumIndexation = new DocnumIndexation();
                return $docnumIndexation->getIndexationEntities($limit);

            default:
                throw new InvalidArgumentException("[getEntitiesDataAi] Unknown type");
        }
    }

     /**
      * Change la recherche semantic active
      *
      * @param integer $id
      * @return void
      */
    public static function setActiveSemanticSearch(int $id)
    {
        $query = "
            UPDATE ai_settings
            SET active_ai_settings = 0
        ";
        pmb_mysql_query($query);

        $query = "
            UPDATE ai_settings
            SET active_ai_settings = 1
            WHERE id_ai_setting = " . intval($id) . "
        ";
        pmb_mysql_query($query);
    }

    /**
     * Retourne les MetaData d'une notice
     *
     * @param integer $id
     * @return string
     */
    public static function getMetaDataRecord(int $id)
    {
        global $msg;

        $recordData = new \record_datas($id);
        $metaData = $msg['isbd_editeur'] . " : " . AiModel::getPublisherRecord($recordData->get_publishers()) . "\n";
        $metaData .= $msg['authors'] . " : " . AiModel::getResponsabilitesRecord($recordData->get_responsabilites()["auteurs"]) . "\n";
        $metaData .= $msg['252'] . " : " . $recordData->get_year() . "\n";
        $metaData .= $msg['type_doc_sort'] . " : " . $recordData->get_tdoc() . "\n";

        return $metaData;
    }

    /**
     * Retourne les ISBD d'une listes editeurs
     *
     * @param \editeur[] $publishers
     * @return string
     */
    private static function getPublisherRecord($publishers)
    {
        $return = "";
        if(empty($publishers)) {
            return $return;
        }

        foreach ($publishers as $publisher) {
            $return .= $publisher->isbd_entry . " ";
        }
        return $return;
    }

    /**
     * Retourne les ISBD d'une listes auteurs
     *
     * @param \auteur[] $authors
     * @return string
     */
    private static function getResponsabilitesRecord($authors)
    {
        $return = "";
        if(empty($authors)) {
            return $return;
        }

        foreach ($authors as $author) {
            $return .= $author["auteur_isbd"] . " ";
        }
        return $return;
    }

    /**
     * Retourne les categories d'une notice pour les ajouter au rsum a indexer
     * Pour l'instant on le gre comme cela
     *
     * @param int $id
     * @return string
     */
    private static function getCategoriesNotice(int $id)
    {
        $query = "select index_categorie from categories join notices_categories on categories.num_noeud = notices_categories.num_noeud where notcateg_notice = " . $id;
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            $categories = "";
            while ($row = pmb_mysql_fetch_assoc($result)) {
                $categories .= $row["index_categorie"] . " ";
            }
            pmb_mysql_free_result($result);
            return $categories;
        }
        return "";
    }
}
