<?php

// +-------------------------------------------------+
// � 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SearcherSharedList.php,v 1.1.2.7.4.6.2.2 2025/12/02 15:07:43 gneveu Exp $

namespace Pmb\AI\Library\searcher;

if (stristr($_SERVER['REQUEST_URI'], '/'.basename(__FILE__))) {
    die("no access");
}

use Pmb\AI\Models\AiSessionSemanticModel;
use filter_results;
use Pmb\AI\Orm\AiSharedListOrm;
use Pmb\AI\Library\Source\Source;
use Pmb\AI\Library\Source\SharedList;

class SearcherSharedList extends SearcherRecord
{
    protected $sharedListId;

    public function __construct($user_query, int $sharedListId)
    {
        $this->sharedListId = $sharedListId;
        parent::__construct($user_query);
    }

    /**
     * Retourne la source
     *
     * @return Source|null
     */
    protected function get_source()
    {
        if ($this->source === null) {
            $aiSettings = AiSharedListOrm::fetchActiveAiSettings();
            if (!empty($aiSettings)) {
                $this->source = new SharedList($aiSettings);
            }
        }
        return $this->source;
    }

    /**
     * Permet d'interroger l'API
     *
     * @return array
     */
    protected function ask() {
        if (empty($this->userQuery) && isset($_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"])) {
            $this->userQuery = $_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["user_query"];
        }

        // Rcuprer le sessionId de retry s'il existe (retry en cours)
        $sessionId = $_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["retry_session_id"] ?? null;

        $source = $this->get_source();
        $source->setSharedListId($this->sharedListId);

        // Appeler l'API avec le sessionId pour le RetryManager
        $result = $source->search($this->userQuery, null, $sessionId);

        if ($result['object'] === SharedList::OBJECT_RETRY_AFTER) {
            global $id_liste;

            $_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["retry"] = true;

            // Stocker le sessionId pour les prochains retries
            if (!empty($result['data']['session_id'])) {
                $_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["retry_session_id"] = $result['data']['session_id'];
            }

            $location = "./index.php?lvl=show_list&sub=view&id_liste=" . intval($id_liste) . "&wait=1";
            $location .= "&retry_after=" . intval($result['data']['retry-after']);
            $location .= "&ai_session=" . intval($_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["ai_session"]);
            $location .= "&retry_query=" . intval($_SESSION["nb_queries"]);

            // Passer le sessionId du retry pour les tentatives suivantes
            if (!empty($result['data']['session_id'])) {
                $location .= "&retry_session_id=" . urlencode($result['data']['session_id']);
            }

            // Signaler s'il y a une erreur de max retries
            if (!empty($result['data']['error']) && $result['data']['error'] === 'max_retries_exceeded') {
                $location .= "&error=max_retries";
            }

            $location .= "#ai_search";

            header("Location: ". $location, true, 301);
            exit;
        }

        return $result['data'];
    }

    /**
     * Retourne les resultats en cache dfinis dans l'historique
     *
     * @return null
     */
    protected function _get_in_cache()
    {
        return null;
    }

    /**
     * Applique les facettes
     *
     * @return void
     */
    protected function _apply_facette_result()
    {
        // Il n'y a pas de facettes dans les listes de lectures
    }

    /**
     * Sauvegarde les resultats dans l'historique
     *
     * @return void
     */
    protected function _set_in_cache()
    {
        global $ai_session, $ai_session_index_question;

        // Pour information, on est passer dans la fonction rec_history(),
        // Dans la classe opac_css/classes/liste_lecture.class.php

        if (!empty($ai_session)) {
            $session = new AiSessionSemanticModel($ai_session);

            // On sauvegarde les identifients pour le text generation
            $_SESSION["ai_search_index_{$ai_session}_{$ai_session_index_question}"] = $this->api_result;

            // On sauvegarde le rsultat dans la table
            $session->addResults($ai_session_index_question, $this->api_result);
        }
    }

    /**
     * Rcupre les resultats
     *
     * @return array|false
     */
    protected function _get_objects()
    {
        $this->pert = array();
        $this->objects = array();

        if (! $this->searched) {

            if (!($this->get_source() instanceof SharedList)) {
                return false;
            }

            if (null == $this->api_result) {
                $this->api_result = $this->ask();
            }

            if (empty($this->objects)) {
                foreach ($this->api_result as $result) {
                    if ($result["object_type"] === TYPE_SHARED_LIST_EXPLNUM) {
                        // ici, on ajout 'docnum_' devant l'identifiant pour ne pas le supprimer dans la fonction _filter_results
                        $id = 'docnum_' . $result["object_id"];
                    } elseif ($result['object_type'] === TYPE_EXPLNUM) {
                        // On tranforme en notice
                        $id = $this->getNoticeIdByExplnum($result['object_id']);
                    } else {
                        $id = $result["object_id"];
                    }

                    $this->objects[] = $id;
                    $this->pert[$id] = intval($result["score"] * 100);
                }
            }

            $this->searched = true;
        }

        return $this->objects;
    }

    /**
     * Filtre les resultats
     *
     * @return void
     */
    protected function _filter_results()
    {
        if (!empty($this->objects)) {

            // On recupere seulement les identifiants de notices
            $objects = array_filter($this->objects, function ($id) {
                return strpos($id, 'docnum_') === false;
            });

            $filter = new filter_results(implode(',', $objects));
            $idsAllowed = explode(',', $filter->get_results());

            // On supprime les identifiants de notices non autoriss
            $this->objects = array_filter($this->objects, function ($id) use ($idsAllowed) {
                if (strpos($id, 'docnum_') === 0) {
                    return true;
                }
                return in_array($id, $idsAllowed);
            });
            $this->pert = array_filter($this->pert, function ($id) use ($idsAllowed) {
                if (strpos($id, 'docnum_') === 0) {
                    return true;
                }
                return in_array($id, $idsAllowed);
            }, ARRAY_FILTER_USE_KEY);
        }
    }


    /**
     * Valide la source
     *
     * @return bool
     */
    protected function validSource()
    {
        return ($this->get_source() instanceof SharedList);
    }
}