<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SearcherRecord.php,v 1.2.6.1.2.2 2026/02/03 13:35:08 qvarin Exp $

namespace Pmb\AI\Library\searcher;

if (stristr($_SERVER['REQUEST_URI'], '/'.basename(__FILE__))) {
    die("no access");
}

use sort;
use search;
use searcher;
use filter_results;
use Pmb\AI\Library\Source\Semantic;
use Pmb\AI\Library\Source\Source;
use Pmb\AI\Orm\AISettingsOrm;

class SearcherRecord extends SearcherRoot
{
    /**
     * Cl primaire de la table
     */
    public const PRIMARY_KEY = "notice_id";

    /**
     * Nombre d'exemplaires
     *
     * @var integer
     */
    public $nbExplnum = 0;

    /**
     * Retourne la source
     *
     * @return Source|null
     */
    protected function get_source()
    {
        if ($this->source === null) {
            $aiSettings = AISettingsOrm::fetchActiveAiSettings();
            if (!empty($aiSettings)) {
                $this->source = new Semantic($aiSettings);
            }
        }
        return $this->source;
    }

    /**
     * Permet d'interroger l'API
     *
     * @return array
     */
    protected function ask() {
        if (empty($this->userQuery) && isset($_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"])) {
            $this->userQuery = $_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["user_query"];
        }

        if (empty($this->userQuery)) {
            return [];
        }

        // Rcuprer le sessionId de retry s'il existe (retry en cours)
        $sessionId = $_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["retry_session_id"] ?? null;

        // Appeler l'API avec le sessionId pour le RetryManager
        $result = $this->get_source()->search($this->userQuery, null, $sessionId);

        if ($result['object'] === Semantic::OBJECT_RETRY_AFTER) {
            $_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["retry"] = true;

            // Stocker le sessionId pour les prochains retries
            if (!empty($result['data']['session_id'])) {
                $_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["retry_session_id"] = $result['data']['session_id'];
            }

            // Dterminer le type de redirection selon l'erreur
            $location = "./index.php?search_type_asked=ai_search&wait=1";
            $location .= "&retry_after=" . intval($result['data']['retry-after']);
            $location .= "&ai_session=" . intval($_SESSION["ai_search_history_{$_SESSION["nb_queries"]}"]["ai_session"]);
            $location .= "&retry_query=" . intval($_SESSION["nb_queries"]);

            // Passer le sessionId du retry pour les tentatives suivantes
            if (!empty($result['data']['session_id'])) {
                $location .= "&retry_session_id=" . urlencode($result['data']['session_id']);
            }

            // Signaler s'il y a une erreur de max retries
            if (!empty($result['data']['error']) && $result['data']['error'] === 'max_retries_exceeded') {
                $location .= "&error=max_retries";
            }

            $location .= "#ai_search";

            header("Location: ". $location, true, 301);
            exit;
        }

        return $result['data'];
    }

    /**
     * Retourne l'instance du tri
     *
     * @return sort
     */
    protected function _get_sort_instance()
    {
        return new sort("notices", "session");
    }

    /**
     * Retourne l'instance de recherche
     *
     * @return search
     */
    protected function _get_search_instance()
    {
        return new search("search_fields");
    }

    /**
     * Filtre les resultats
     *
     * @return void
     */
    protected function _filter_results()
    {
        if (!empty($this->objects)) {
            $filter = new filter_results(implode(',', $this->objects));
            $idsAllowed = explode(',', $filter->get_results());

            $this->objects = array_filter($this->objects, function ($id) use ($idsAllowed) {
                return in_array($id, $idsAllowed);
            });
            $this->pert = array_filter($this->pert, function ($id) use ($idsAllowed) {
                return in_array($id, $idsAllowed);
            }, ARRAY_FILTER_USE_KEY);
        }
    }

    /**
     * Retourne le nombre d'exemplaires
     *
     * @param integer $limit_one
     * @return integer
     */
    public function get_nb_explnums($limit_one = 1)
    {
        if (! $this->objects) {
            $this->get_result();
        }

        $this->nbExplnum = 0;
        if ($this->objects != "") {
            $this->nbExplnum = searcher::get_nb_explnums_from_notices_ids(
                implode(',', $this->objects),
                $limit_one
            );
        }
        return $this->nbExplnum;
    }

    /**
     * Valide la source
     *
     * @return bool
     */
    protected function validSource()
    {
        return ($this->get_source() instanceof Semantic);
    }
}
