<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AgentUtils.php,v 1.1.2.4.2.1 2025/12/12 14:33:18 gneveu Exp $

namespace Pmb\AI\Library\Services;

if (stristr($_SERVER['REQUEST_URI'], '/'.basename(__FILE__))) {
    die("no access");
}

trait AgentUtils
{
    public const CURL_TIMEOUT = 30;
    /**
     * Post request
     *
     * @param string $url
     * @param array $headers
     * @param string|array $data
     * @return \CurlResponse|false
     */
    protected function post(string $url, $headers = [], $data = "")
    {
        $curl = new \Curl();
        $curl->timeout = self::CURL_TIMEOUT;
        $curl->headers = $headers;
        return $curl->post($url, $data);
    }

    /**
     * Get request
     *
     * @param string $url
     * @param array $headers
     * @param string|array $data
     * @return \CurlResponse|false
     */
    protected function get(string $url, $headers = [], $data = [])
    {
        $curl = new \Curl();
        $curl->timeout = self::CURL_TIMEOUT;
        $curl->headers = $headers;
        return $curl->get($url, $data);
    }
}
