<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ParseMarkdown.php,v 1.1.2.1 2026/02/03 13:35:09 qvarin Exp $

namespace Pmb\AI\Library;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
	die("no access");
}

use Parsedown;
use record_datas;

class ParseMarkdown extends Parsedown
{
    public const ALLOWED_TIPS_TAGS = ['<br>'];

    public const ALLOWED_TAGS = [
        '<a>',
        '<br>',
        '<p>',
        '<ol>',
        '<ul>',
        '<li>',
        '<strong>',
        '<em>',
    ];

    public function __construct()
    {
        global $opac_url_base, $cms_url_base_cms_build;

        $this->setSafeMode(true);

        // Comme les images ne sont pas autorisee dans ALLOWED_TAGS, je ne met pas de data:image/...
        $this->safeLinksWhitelist = [
            'http://', // Peut-tre dangereux, mais on ne peut pas lister les sites qu'on autorise
            'https://', // Peut-tre dangereux, mais on ne peut pas lister les sites qu'on autorise
            $opac_url_base,
            $cms_url_base_cms_build,
        ];

        if (defined('GESTION')) {
            global $pmb_url_base, $pmb_opac_url;
            $this->safeLinksWhitelist[] = $pmb_url_base;
            $this->safeLinksWhitelist[] = $pmb_opac_url;
        }
    }

    /**
     * Parse le texte markdown
     *
     * @param string $text
     * @return string
     */
    public function text($text): string
    {
        try {
            $text = parent::text($text);
            $text = strip_tags($text ?? '', implode('', self::ALLOWED_TAGS));
        } catch (\Exception $e) {
            trigger_error($e->getMessage(), E_USER_WARNING);
            $text = '';
        }

        return $text;
    }

    /**
     * Parse le texte pour transformer les references #1 en lien vers la notice
     * et le markdown en html
     *
     * @param string $text
     * @param array $askResult
     * @return string
     */
    public function parseText(string $text, array $askResult): string
    {
        $text = $this->text($text);
        return preg_replace_callback("(#(\d+))", function ($matches) use ($askResult) {
            global $charset;

            [$pattern, $num] = $matches;

            $noticeId = intval($askResult[$num - 1]["object_id"] ?? 0);
            if (empty($noticeId)) {
                return "";
            }

            $notice = new record_datas($noticeId);
            return "<a class='ai_semantic_link' href='". $notice->get_permalink() ."' target='_blank' title='" . htmlentities($notice->get_tit1(), ENT_QUOTES, $charset) . "'>
                        " . htmlentities($pattern, ENT_QUOTES, $charset) . " : " . htmlentities($notice->get_tit1(), ENT_QUOTES, $charset) . "
                    </a>";
        }, $text);
    }

    /**
     * Parse les conseils
     *
     * @param string $tips
     * @return string
     */
    public static function parseTips(string $tips): string
    {
        $tips = nl2br($tips);
        $tips = strip_tags($tips, implode('', self::ALLOWED_TIPS_TAGS));
        return $tips;
    }

    /**
     * Parse les recherche booleennes
     *
     * @param string $boolean
     * @return string
     */
    public static function parseBoolean(string $boolean): string
    {
        global $opac_multi_search_operator;

        $boolean = str_replace(
            [' AND ', ' OR ', ' SAUF '],
            [
                $opac_multi_search_operator == 'or' ? ' + ' : ' ',
                $opac_multi_search_operator == 'or' ? ' ' : ' + ',
                ' - ',
            ],
            $boolean
        );
        return $boolean;
    }
}