<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: RecordIndexation.php,v 1.1.2.1 2026/02/06 09:24:11 qvarin Exp $

namespace Pmb\AI\Library\Indexation;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
	die("no access");
}

use Pmb\AI\Models\EmbeddingsTemplateModel;

class RecordIndexation implements AiIndexation
{
    /**
     * Retourne les entites indexer
     *
     * @param integer $limit
     * @return array
     */
    public function getIndexationEntities(int $limit): array
    {
        $resultIndexation = [];
        $resultIndexation["entities"] = [];
        $resultIndexation["count"] = pmb_mysql_result(pmb_mysql_query("SELECT count(*) as count FROM notices WHERE n_resume != ''"),0,0);
        $resultIndexation["countIndexed"] = pmb_mysql_result(pmb_mysql_query("SELECT count(*) as count FROM notices WHERE embeddings IS NOT NULL"),0,0);

        $query = "SELECT notice_id FROM notices WHERE embeddings IS NULL AND n_resume != '' LIMIT $limit";
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_assoc($result)) {
                $row["notice_id"] = intval($row["notice_id"]);
                $resultIndexation["entities"][] = [
                    'object_id' => $row["notice_id"],
                    'object_type' => TYPE_NOTICE,
                    'content' => $this->fetchContentEntitie($row["notice_id"])
                ];
            }

            pmb_mysql_free_result($result);
        }

        return $resultIndexation;
    }

    /**
     * Retourne le contenu d'une entite a indexer
     *
     * @param integer $id
     * @return string
     */
    public function fetchContentEntitie(int $id): string
    {
        $embeddingsTemplateModel = EmbeddingsTemplateModel::getInstance(TYPE_NOTICE);
        return $embeddingsTemplateModel->render($id);
    }
}
