<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: DocnumIndexation.php,v 1.1.2.1 2026/02/06 09:24:11 qvarin Exp $

namespace Pmb\AI\Library\Indexation;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
	die("no access");
}

namespace Pmb\AI\Library\Indexation;

use Pmb\AI\Models\EmbeddingsTemplateModel;

class DocnumIndexation implements AiIndexation
{
    /**
     * Retourne les entites indexer
     *
     * @param integer $limit
     * @return array
     */
    public function getIndexationEntities(int $limit): array
    {
        $resultIndexation = [];
        $resultIndexation["entities"] = [];
        $resultIndexation["count"] = pmb_mysql_result(pmb_mysql_query("SELECT count(*) as count FROM explnum WHERE explnum_index_sew != ''"),0,0);
        $resultIndexation["countIndexed"] = pmb_mysql_result(pmb_mysql_query("SELECT count(*) as count FROM explnum WHERE explnum_embeddings != '' AND explnum_index_sew != ''"),0,0);

        $query = "SELECT explnum_id FROM explnum WHERE explnum_embeddings IS NULL AND explnum_index_sew != '' LIMIT $limit";
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_assoc($result)) {
                $row["explnum_id"] = intval($row["explnum_id"]);
                $resultIndexation["entities"][] = [
                    'object_id' => $row["explnum_id"],
                    'object_type' => TYPE_EXPLNUM,
                    'content' => $this->fetchContentEntitie($row["explnum_id"])
                ];
            }

            pmb_mysql_free_result($result);
        }

        return $resultIndexation;
    }

    /**
     * Retourne le contenu d'une entite a indexer
     *
     * @param integer $id
     * @return string
     */
    public function fetchContentEntitie(int $id): string
    {
        $embeddingsTemplateModel = EmbeddingsTemplateModel::getInstance(TYPE_EXPLNUM);
        return $embeddingsTemplateModel->render($id);
    }
}