<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SharedListsController.php,v 1.1.2.1 2024/06/17 12:04:37 jparis Exp $

namespace Pmb\AI\Controller;

use encoding_normalize;
use Pmb\AI\Models\AiModel;
use Pmb\AI\Models\SemanticSearchModel;
use Pmb\AI\Models\SharedListModel;
use Pmb\AI\Orm\AISettingsOrm;
use Pmb\AI\Orm\AiSharedListOrm;
use Pmb\AI\Views\SemanticSearchView;
use Pmb\AI\Views\SharedListView;
use Pmb\Common\Controller\Controller;
use Pmb\Common\Orm\EmprCategOrm;
use Pmb\Common\Orm\SearchPersoOrm;
use Pmb\Common\Orm\UploadFolderOrm;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class SharedListsController extends Controller
{
    /* La ligne `public  = "list";` dclare une proprit publique appele `` et lui
    attribue la valeur "list". Cette proprit est utilise pour dterminer l'action par dfaut 
    effectuer par la mthode `proceed()` si aucun paramtre d'action n'est fourni. Dans ce cas,
    l'action par dfaut est dfinie sur "liste". */
    public $action = "list";

    /**
     * La fonction "proceed" dtermine l'action  entreprendre en fonction du paramtre fourni et
     * excute la mthode correspondante.
     *
     * @param action Le paramtre action est utilis pour dterminer l'action spcifique qui doit
     * tre effectue. Il peut avoir trois valeurs possibles :  modifier ,  ajouter  ou 
     * enregistrer .
     */

    public function proceed($action = "")
    {
        $this->action = $action;
        switch ($action) {
            case "save":
                $this->saveAction();
            default:
                $this->formAction();
        }
    }


    /**
     * La fonction setData dfinit la valeur de la proprit data dans une classe PHP.
     *
     * @param data Le paramtre "data" est une variable qui reprsente les donnes que vous souhaitez
     * dfinir pour l'objet. Il peut s'agir de n'importe quel type de donnes, tel qu'une chane, un
     * entier, un tableau ou un objet.
     */

    public function setData($data)
    {
        $this->data = $data;
    }

    public function formAction()
    {
        global $pmb_url_base;

        $emprCategOrm = new EmprCategOrm();
        $uploadFolder = new UploadFolderOrm();

        $sharedListView = new SharedListView("AI/sharedList", [
            "sharedlistsdata" => SharedListModel::getSharedListData(),
            "emprcategory" => $emprCategOrm->getEmprCategList(),
            "uploadfolder" => $uploadFolder->getUploadForlderList(),
            "url_webservice" => $pmb_url_base . "rest.php/Ai/"
        ]);
        print $sharedListView->render();
    }


    /* La fonction `saveAction()` est responsable de la sauvegarde des donnes reues lors de la
    soumission du formulaire. */

    public function saveAction()
    {
        try {
            $aiSharedListOrm = new AiSharedListOrm();
            $aiSharedListOrm->id_ai_shared_list = SharedListModel::ID_CONFIG_SHARED_LIST;
            $aiSharedListOrm->settings_ai_shared_list = encoding_normalize::json_encode($this->data);
            $aiSharedListOrm->save();
            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}
