<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: EmbeddingsController.php,v 1.1.2.1 2026/02/06 09:24:11 qvarin Exp $

namespace Pmb\AI\Controller;

use Pmb\AI\Models\EmbeddingsTemplateModel;
use Pmb\Common\Controller\Controller;
use Pmb\Common\Views\VueJsView;
use record_datas;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class EmbeddingsController extends Controller
{
    public function proceed()
    {
        $this->form();
    }

    private function form()
    {
        global $pmb_url_base;

        $vueJsView = new VueJsView('AI/embeddings', [
            'url_webservice' => $pmb_url_base . 'rest.php/Embeddings/',
            'templates' => EmbeddingsTemplateModel::fetchTemplates()
        ]);

        print $vueJsView->render();
    }

    public function saveForm()
    {
        if (empty($this->data)) {
            $this->ajaxError('template_record is required !', 400);
        }
        if (!is_string($this->data->template_record)) {
            $this->ajaxError('template_record must be a string', 400);
        }
        if (empty(trim($this->data->template_record))) {
            $this->ajaxError('template_record cannot be empty', 400);
        }

        try {
            $embeddingsTemplateModel = EmbeddingsTemplateModel::getInstance(TYPE_NOTICE);
            $embeddingsTemplateModel->setTemplate($this->data->template_record);
            $embeddingsTemplateModel->save();

            $this->ajaxJsonResponse(['success' => true]);
        } catch(\Exception $e) {
            trigger_error($e->getMessage(), E_USER_WARNING);
            $this->ajaxError('An error occurred while saving the template', 500);
        }
    }
}
